#ifdef   __18CXX
#include <p18cxxx.h>
#endif

#ifdef   __XC
#include <xc.h>
#define  rom   const
#define  memcpypgm2ram(a, b, c)  memcpy(a, b, c)
#endif

#include "hardwareprofile.h"
#include "buttons.h"

#define TRIS_(p, m)            TRIS ## p ## bits.TRIS ## p ## m
#define LAT_(p, m)             LAT ## p ## bits.LAT ## p ## m
#define PORT_(p, m)            PORT ## p ## bits.R ## p ## m

// C18
#if defined(__18CXX)
#define IOIN(x)                x(TRIS_) = 1
#define IOOUT(x)               x(TRIS_) = 0
#define SET(x)                 x(LAT_) = 1
#define CLR(x)                 x(LAT_) = 0
#define GET(x)                 x(PORT_)

// XC, HTC18
#else
#define IOIN(x)                TRIS_(x) = 1
#define IOOUT(x)               TRIS_(x) = 0
#define SET(x)                 LAT_(x) = 1
#define CLR(x)                 LAT_(x) = 0
#define GET(x)                 PORT_(x)
#endif


unsigned char Btn, BtnType;

//============================================================================
//                                                                  GetButtons
// Lekrdezi a nyomgombok llapott s parancsokat rendel hozz
// Kln parancskd tartozik a rvid lenyoms utni felengedshez, a hossz lenyomshoz
//   a hossz lenyomskori ismtlshez s a hossz lenyoms utni felengedshez.
//
// Rvid gombnyoms felengedsekor a kvetkezt kapjuk:
// - 1 db BUTTONCMDDOWN (lenyomskor)
// - 1 db BUTTONCMDSHORT (felengedskor)
//
// Hossz gombnyomskor a kvetkezt kapjuk:
// - 1 db BUTTONCMDDOWN (lenyomskor)
// - 1 db BUTTONCMDLONG (amikor elrte a hossz lenyoms kezdett, azaz BTNREPEATSTARTSPEED lekrdezs ta)
// - N db BUTTONCMDREPEAT (lenyomva tarts alatt ezt ismtli minden BTNREPEATSPEED-edik lekrdezsnl)
// - 1 db BUTTONCMDUP (felengedskor)
//
// kimenet:
// - Btn = nyomogomb kdja (lsd BTNCODE)
// - BtnType = lenyoms mdja (lsd BTNTYPECODE)
void GetButtons(void)
{
  static unsigned char BtnPressed = 0;  // elz lekrdezskor lenyomott gomb kdja
  static unsigned char BtnCount = 0;    // billenty ismtls szmll

  // potik kivlasztsa gombok lekrdezse
  CLR(BTN_SELS);
  IOOUT(BTN_SELS);
  Btn = BTNCODE_NONE;
  if (!GET(BTN_SEL1)) Btn = BTNCODE_SEL1;
  if (!GET(BTN_SEL2)) Btn = BTNCODE_SEL2;
  if (!GET(BTN_SEL3)) Btn = BTNCODE_SEL3;
  if (!GET(BTN_SEL4)) Btn = BTNCODE_SEL4;
  if (!GET(BTN_SEL5)) Btn = BTNCODE_SEL5;
  if (!GET(BTN_SEL6)) Btn = BTNCODE_SEL6;
  if (!GET(BTN_SEL7)) Btn = BTNCODE_SEL7;
  if (!GET(BTN_SEL8)) Btn = BTNCODE_SEL8;
  IOIN(BTN_SELS);

  // programvlaszt, sszellts vlaszt, csatornavlaszt, bankvlaszt gombok kezelse
  CLR(BTN_PRGS);
  IOOUT(BTN_PRGS);
  if (!GET(BTN_PRG_MINUS))    Btn = BTNCODE_PRG_MINUS;    // Prg-
  if (!GET(BTN_PRG_PLUS))     Btn = BTNCODE_PRG_PLUS;     // Prg+
  if (!GET(BTN_CHN_MINUS))    Btn = BTNCODE_CHN_MINUS;    // Chn-
  if (!GET(BTN_CHN_PLUS))     Btn = BTNCODE_CHN_PLUS;     // Chn+
  if (!GET(BTN_PRESET_MINUS)) Btn = BTNCODE_PRESET_MINUS; // Preset-
  if (!GET(BTN_PRESET_PLUS))  Btn = BTNCODE_PRESET_PLUS;  // Preset+
  if (!GET(BTN_MIDI_RESET))   Btn = BTNCODE_MIDI_RESET;   // System Reset
  if (!GET(BTN_BANK))         Btn = BTNCODE_BANK;         // BankSel
  IOIN(BTN_PRGS);

  if (Btn)
  { // van gomb lenyomva
    if (Btn == BtnPressed)
    { // ugyanaz van lenyomva, mint az elz mintavtelnl
      BtnCount++;
      if (BtnCount == BTNREPEATSTARTSPEED)
        BtnType = BUTTONCMDLONG;
      else if (BtnCount >= (BTNREPEATSTARTSPEED + BTNREPEATSPEED))
      { // folyamatos ismtls
        BtnCount = BTNREPEATSTARTSPEED; // ismtlsi kezdet idpontja
        BtnType = BUTTONCMDREPEAT;
      }
      else
        Btn = BTNCODE_NONE;             // kztes idpontokban ne adjon parancsot
    }
    else
    { // vagy most lett lenyomva, vagy elzleg msik volt lenyomva
      BtnPressed = Btn;                 // ezutn ennek az ismtlst kell figyelni
      BtnType = BUTTONCMDDOWN;          // lenyoms pillanata
      BtnCount = 0;                     // gombnyomsi id szmll = 0
    }
  }
  else
  { // nincs gomb lenyomva
    if(BtnPressed)
    { // most lett felengedve
      if (BtnCount < BTNREPEATSTARTSPEED)// csak rvid ideig volt lenyomva? ( < BTNREPEATSTARTSPEED )
        BtnType = BUTTONCMDSHORT;       // BUTTONxCMDSHORT
      else                              // sokig volt lenyomva? ( >= BTNREPEATSTARTSPEED )
        BtnType = BUTTONCMDUP;          // BUTTONxCMDUP
      Btn = BtnPressed;
      BtnPressed = 0;                   // kvetkez lekrdezshez
      BtnCount = 0;                     // gombnyomsi id szmll = 0
    }
  }
}

