#ifndef __HARDWAREPROFILE_H
#define __HARDWAREPROFILE_H

#define SystemClock 48000000
#define CpuClock    48000000

// USB
#define self_power        1
#define USB_BUS_SENSE     1

#ifdef   __18CXX

// LCD kijelz
#define LCDE(f)     f(A, 4)
#define LCDRW(f)    f(B, 5)
#define LCDRS(f)    f(B, 4)
#define LCDDT4(f)   f(B, 0)
#define LCDDT5(f)   f(B, 1)
#define LCDDT6(f)   f(B, 2)
#define LCDDT7(f)   f(B, 3)

// nyomgombok (KEYROW1 = select gombok, KEYROW2 = program gombok)
#define BTN_SELS(f) f(C, 0)
#define BTN_SEL1(f) f(D, 0)
#define BTN_SEL2(f) f(D, 1)
#define BTN_SEL3(f) f(D, 2)
#define BTN_SEL4(f) f(D, 3)
#define BTN_SEL5(f) f(D, 4)
#define BTN_SEL6(f) f(D, 5)
#define BTN_SEL7(f) f(D, 6)
#define BTN_SEL8(f) f(D, 7)

#define BTN_PRGS(f)         f(C, 1)
#define BTN_PRG_MINUS(f)    f(D, 0)
#define BTN_PRG_PLUS(f)     f(D, 1)
#define BTN_CHN_MINUS(f)    f(D, 2)
#define BTN_CHN_PLUS(f)     f(D, 3)
#define BTN_MIDI_RESET(f)   f(D, 4)
#define BTN_BANK(f)         f(D, 5)
#define BTN_PRESET_MINUS(f) f(D, 6)
#define BTN_PRESET_PLUS(f)  f(D, 7)

// UART I/O (MIDI IN, MIDI OUT)
#define UARTRX(f)   f(C, 7)
#define UARTTX(f)   f(C, 6)

// SPI debugger (opcionlis, csak a fejlesztshez kell)
#define SPIDEBUGCLK(f) f(B, 6)
#define SPIDEBUGDT(f)  f(B, 7)

// szabadon maradt lb (B6, B7 a programozlbak, de msra is hasznlhat mg
#define FREEPIN1(f) f(C, 2)
// #define FREEPIN2(f) f(B, 6)
// #define FREEPIN3(f) f(B, 7)

// Boot loader gomb
#define BOOTLOADER(f)  f(B, 4)

#else   // #ifdef   __18CXX

// LCD kijelz
#define LCDE          A, 4
#define LCDRW         B, 5
#define LCDRS         B, 4
#define LCDDT4        B, 0
#define LCDDT5        B, 1
#define LCDDT6        B, 2
#define LCDDT7        B, 3

// nyomgombok (KEYROW1 = select gombok, KEYROW2 = program gombok)
#define BTN_SELS      C, 0
#define BTN_SEL1      D, 0
#define BTN_SEL2      D, 1
#define BTN_SEL3      D, 2
#define BTN_SEL4      D, 3
#define BTN_SEL5      D, 4
#define BTN_SEL6      D, 5
#define BTN_SEL7      D, 6
#define BTN_SEL8      D, 7

#define BTN_PRGS              C, 1
#define BTN_PRG_MINUS         D, 0
#define BTN_PRG_PLUS          D, 1
#define BTN_CHN_MINUS         D, 2
#define BTN_CHN_PLUS          D, 3
#define BTN_MIDI_RESET        D, 4
#define BTN_BANK              D, 5
#define BTN_PRESET_MINUS      D, 6
#define BTN_PRESET_PLUS       D, 7

// UART I/O (MIDI IN, MIDI OUT)
#define UARTRX        C, 7
#define UARTTX        C, 6

// SPI debugger (opcionlis, csak a fejlesztshez kell)
#define SPIDEBUGCLK      B, 6
#define SPIDEBUGDT       B, 7

// szabadon maradt lb (B6, B7 a programozlbak, de msra is hasznlhat mg
#define FREEPIN1      C, 2
// #define FREEPIN2      B, 6
// #define FREEPIN3      B, 7

// Boot loader gomb
#define BOOTLOADER       B, 4

#endif  // #ifdef   __18CXX

#endif  // #ifndef  __HARDWAREPROFILE_H
