/****************************************************************************/
/*                                                                          */
/*                ACS-2602 - Kis Szkop                                      */
/*                                                                          */
/****************************************************************************/
/*  Target Chip: Xilinx XC2S200-PQ208 (Spartan-II)                          */
/*--------------------------------------------------------------------------*/
/* Mintavevo, tarolo resz                                                   */
/*--------------------------------------------------------------------------*/
/* History:                                                                 */
/*  2007.03.09: elso verzio                                                 */
/*  2007.03.10: mindenfele atszegezes, 100 es 66 MHz, mintavevo kiotlese    */
/*  2007.03.19: trigger irasa                                               */
/*  2007.03.22: SDRAM cimszamlalo fixen 11 biten jar korbe, se start, se max*/
/*  2007.03.23: triggerpont szamitasi hiba, javitva, drop regiszter 16bites */
/*  2007.03.23: SDRAM iras atrakva store modulba                            */
/*  2007.03.26: trigger funkciok atrakva trigger.v-be                       */
/*  2007.06.30: mintaveteli ido allitas felbontasa 10ns az eddigi 20 helyett*/
/*  2007.06.30: tarolasnal kivalaszthato a memoria  ACQ_EXT                 */
/*  2008.02.07: csak egy komment javitasa az 55. sorban                     */
/*  2008.04.15: rosszul rakta la a mintakat <100MS/s sebssegnel             */
/*  2008.04.15: min-max mod hozzaadasa                                      */
/*  2008.04.21: peakdetect atnevezese minmax-ra                             */
/*  2009.03.20: Chip V3.0, pretrigger es tarolas hossza mintakban szamolando*/
/*              block helyett, ezert store es trigger jelentos atirasa      */
/****************************************************************************/

module acquire(
    CLK100, CH1IN, CH2IN, daclock, extin,
    CLK66, regrd, regwr, rega, regdi, regdo, irq,
    sdwr, sddone, sdbase, sdbufa, brd, shot
);

input           CLK100;
input   [7:0]   CH1IN;
input   [7:0]   CH2IN;
output          daclock;
input           extin;          /* External trigger input                   */

input           CLK66;
input           regrd, regwr;
input   [7:0]   rega;
input   [7:0]   regdi;
output  [7:0]   regdo;
output          irq;

output          sdwr;           /* SD RAM write                             */
input           sddone;         /* SD RAM transfer done                     */
output  [12:0]  sdbase;         /* SD RAM base address                      */
input   [6:0]   sdbufa;         /* SD RAM buffer address                    */
output  [31:0]  brd;            /* Data to SD RAM                           */
output          shot;           /* Felfuto el a triggert jelzi              */

/****************************************************************************/
/*  Belso regiszterek - jelek                                               */
/****************************************************************************/

wire    [15:0]  dch1, dch2;
wire            c1ri, c2ri;
wire            new16;
wire            en, run, busy, wword;
wire    [19:0]  wraddr;         /* Az aktualis irasi cim (byte address)     */
wire            exttrig;

    assign regdo = 8'hzz;

    assign daclock = CLK100;

    trigger u_trigger(
        .CLK66(CLK66), .irq(irq),
        .regrd(regrd), .regwr(regwr), .rega(rega), .regdi(regdi), .regdo(regdo),
        .ext(exttrig), .newdata(new16), .dch1(dch1[7:0]), .dch2(dch2[7:0]),
        .st_en(en), .st_run(run), .st_busy(busy), .wword(wword), .wraddr(wraddr), .shot(shot)
    );
    
    convrate u_convrate(
        .CLK100(CLK100), .IN1(CH1IN), .IN2(CH2IN), .extin(extin),
        .CLK66(CLK66), .dout1(dch1), .d1ri(c1ri), .dout2(dch2), .d2ri(c2ri), 
        .extout(exttrig), .new(new16)
    );
    
    store u_store(
        .CLK66(CLK66), 
        .regrd(regrd), .regwr(regwr), .rega(rega), .regdi(regdi), .regdo(regdo),
        .new(new16), .ch1(dch1), .ch1ri(c1ri), .ch2(dch2), .ch2ri(c2ri), 
        .en(en), .run(run), .busy(busy), .wword(wword), .wraddr(wraddr),
        .sdwr(sdwr), .sddone(sddone), .sdbase(sdbase), .sdbufa(sdbufa), .brd(brd)
    );
endmodule

`define EHI     10

/*
 *  Fogadja a CLK100-hoz szinkronizalt 2 * 100Mbyte/s bejovo adatot, 
 *  es csinal belole a CLK66-hez szinkronizalt 2 * 50 Mword/s adaott
 *  Ha 'new' kimenet egyben van, akkor dout1, dout2-rol elveheto 16-16 bit
 *  Ezen felul a peak-detect megsegitesere mindket csatornahoz kiszamolja, hogy a
 *  ket minta kozul melyik a nagyobb. Ezt chxri neven adja ki (rise, azaz a masodik
 *  minta nagyobb, mint az elso.)  
 */
module  convrate(
    CLK100, IN1, IN2, extin,
    CLK66, dout1, d1ri, dout2, d2ri, extout, new
);

input           CLK100;
input   [7:0]   IN1;
input   [7:0]   IN2;
input           extin;

input           CLK66;
output  [15:0]  dout1;
output          d1ri;
output  [15:0]  dout2;
output          d2ri;
output          extout;
output          new;

reg     [1:0]   bcnt = 0;
reg     [7:0]   s11, s12, s13, s14;
reg     [7:0]   s21, s22, s23, s24;
reg     [31:0]  d32_1, d32_2;
reg             new32 = 0;

reg     [15:0]  ch1, ch1n;
reg     [15:0]  ch2, ch2n;
reg             ch1ri, ch2ri;
reg             new = 0;
reg             newd = 0;
reg     [1:0]   nn;
reg   [`EHI:0]  extdelay;
reg     [1:0]   extx;
reg             ext2, extout;


    always @ (posedge CLK100) begin
        
        extdelay <= {extdelay[`EHI-1:0], extin};
        
        s11 <= s12; s12 <= s13; s13 <= s14; s14 <= IN1;
        s21 <= s22; s22 <= s23; s23 <= s24; s24 <= IN2;
        bcnt <= bcnt + 1;
        if(bcnt == 0) begin
            extx  <= {extdelay[`EHI-2], extdelay[`EHI]};
            d32_1 <= ~{s14, s13, s12, s11};
            d32_2 <= ~{s24, s23, s22, s21};
            new32 <= ~new32;
        end
    end

    /*
     *  A 100 megas resz osszegyujt 4 mintat, es aztan megnegalja a 'new32'-t.
     *  Ezt a new32-t mi mintavetelezzuk 66 megaval. Ha el van rajta, akkor
     *  letaroljuk a 32 bit adatot. A 'new' 40 ns-onkent valtozik, 15ns-onkent
     *  mintavetelezzuk. Az el detektalasa min. 15 max 30 ns, igy nem veszitunk
     *  adatot. Garanalt, hogy ket el kozott minimum 2 CLK66 eltelik, neha 3.
     *  Ez azt jelenti, hogy 4 byte-ra van 2 vagy 3 orajelunk. Pont igy akartuk.
     *
     *  Ezert aztan ha uj adat van, akkor elvesszuk a 32 bitet, es jelezzuk
     *  hogy uj adat van. Ezt a jelzest ket orajelig tartjuk, es a masodiknal
     *  az adaton shift-elunk 16 bitet, igy a tovabbi logikak szamara egyszeruen
     *  16 bites adatot jonnek.
     */
    always @ (posedge CLK66) begin
        nn <= {nn[0], new32};
        if(nn[0] != nn[1]) begin
            ch1   <= d32_1[15:0];       //  [15:8] = 2.minta    [7:0] = 1.minta
            ch1n  <= d32_1[31:16];      // [31:24] = 4.minta  [23:16] = 3.minta
            ch1ri <= d32_1[15:8] > d32_1[7:0];  // masodik minta nagyobb, mint az elso
            
            ch2   <= d32_2[15:0];
            ch2n  <= d32_2[31:16];
            ch2ri <= d32_2[15:8] > d32_2[7:0];
            
            extout <= extx[0];
            ext2   <= extx[1];
            newd  <= 1;
            new   <= 1;
        end
        else begin
            new  <= newd;
            newd <= 0;
            ch1 <= ch1n;
            ch1ri <= ch1n[15:8] > ch1n[7:0];
            ch2 <= ch2n;
            ch2ri <= ch2n[15:8] > ch2n[7:0];
            extout <= ext2;
        end
    end
    
    assign dout1 = ch1;
    assign d1ri  = ch1ri;
    assign dout2 = ch2;
    assign d2ri  = ch2ri;
endmodule

        
module  store(
    CLK66, regrd, regwr, rega, regdi, regdo,
    ch1, ch1ri, ch2, ch2ri, new, en, run, busy, wword, wraddr,
    sdwr, sddone, sdbase, sdbufa, brd
);

input           CLK66;          /* 66 MHz                                   */

input           regrd, regwr;
input   [7:0]   rega;
input   [7:0]   regdi;
output  [7:0]   regdo;

input   [15:0]  ch1;            /* 2 minta a CH1 A/D-rol, LSB a regebbi     */
input           ch1ri;          /* A jel emelkedik (MSB > LSB)              */
input   [15:0]  ch2;            /* 2 minta a CH2 A/D-rol, LSB a regebbi     */
input           ch2ri;          /* A jel emelkedik (MSB > LSB)              */
input           new;            /* Uj adat van az IN1, IN2 porton           */

input           en;             /* Amig ez 0, reset-ben tartja az egeszet   */
input           run;            /* Amig 1, tarol                            */
output          busy;
output          wword;          /* Minden letarolt szo 1 pulzus             */
output  [19:0]  wraddr;         /* Az eppen aktualis irasi cim (byte) (2/wword) */

output          sdwr;           /* SD RAM write                             */
input           sddone;         /* SD RAM transfer done                     */
output  [12:0]  sdbase;         /* SD RAM base address                      */
input   [6:0]   sdbufa;         /* SD RAM buffer address                    */
output  [31:0]  brd;            /* Data to SD RAM                           */

/* ---- Internal registers  ----------------------------------------------- */

reg             wt, write, fullsp, minmax;
reg             initmm2, drceq0, drceq1;

reg     [8:0]   waddr = 0;      /* Buffer write address                     */
reg             wah;
reg     [19:0]  wraddr = 0;
reg             bwrite = 0;
reg             bwdone = 0;
reg     [1:0]   endst = 0;
reg             busy = 0;
reg             lrun = 0;

reg     [15:0]  drc = 0;
reg     [15:0]  wdata1, wdata2;
reg     [7:0]   min1, max1, min2, max2;
wire    [7:0]   b32a;
reg     [15:0]  drop = 0;       /* sfreq = 100MHz / drop, [drop != 0]       */
reg     [7:0]   extreg = 0;     /* memoria valasztas, 100Msps valasztas     */
reg     [1:0]   state = 0;      /* SDRAM iras merre jar                     */
reg     [10:0]  sdwra;          /* SDRAM irasi cim 2k * 0.5k = 1M/channel   */
reg             addrh = 0;      /* SDRAM cim legfelso bit (ch sel)          */
reg             sdwr = 0;
wire    [31:0]  bd1, bd2;


    assign regdo = 8'hzz;
    assign wword = write;

    always @ (posedge CLK66) begin
        if(regwr && (rega == `ACQ_DROPL))
            drop[7:0] <= regdi;
        if(regwr && (rega == `ACQ_DROPH))
            drop[15:8] <= regdi;
        if(regwr && (rega == `ACQ_EXT))
            extreg <= regdi;
    end

    always @ (posedge CLK66) begin
        write <= 0;
        if(!run) begin
            drc    <= drop;
            fullsp <= (drop == 0);
            minmax <= extreg[`ACQ_MINMAX];
            wt     <= 0;
            initmm2<= 1;
            drceq0 <= 0;
            drceq1 <= (drop == 1);
        end
        else if(new) begin
            if(fullsp) begin                // 100 MS/s
                wdata1 <= ch1;
                wdata2 <= ch2;
                write  <= 1;
            end
            else if(! minmax) begin
                /*
                 *  Drop mode: minden letarolt minta elott eldob 'drop' szamu mintat
                 */
                if(drceq0) begin
                    wdata1 <= {ch1[7:0], wdata1[15:8]};
                    wdata2 <= {ch2[7:0], wdata2[15:8]};
                    drc    <= drop - 1;
                    drceq0 <= (drop == 1);
                    drceq1 <= (drop == 2);
                    write  <= wt;
                    wt     <= ~wt;
                end
                else if(drceq1) begin
                    wdata1 <= {ch1[15:8], wdata1[15:8]};
                    wdata2 <= {ch2[15:8], wdata2[15:8]};
                    drc    <= drop;
                    drceq0 <= 0;
                    drceq1 <= (drop == 1);
                    write  <= wt;
                    wt     <= ~wt;
                end
                else begin
                    drc <= drc - 2;
                    drceq0 <= (drc == 2);
                    drceq1 <= (drc == 3);
                end
            end
            else begin
                /*
                 *  Min-max mode: 'drop' szamu mintabol szamol min/max-ot es
                 *  azt teszi le ke byte-on [15:8] max, [7:0] min
                 */
                if(initmm2) begin
                    /*
                     * mindket mintat felhasznalva inicializalja a min/max valtozokat
                     */
                    if(ch1ri) begin
                        max1 <= ch1[15:8];
                        min1 <= ch1[7:0];
                    end
                    else begin
                        max1 <= ch1[7:0];
                        min1 <= ch1[15:8];
                    end
                    
                    if(ch2ri) begin
                        max2 <= ch2[15:8];
                        min2 <= ch2[7:0];
                    end
                    else begin
                        max2 <= ch2[7:0];
                        min2 <= ch2[15:8];
                    end
                    
                    initmm2 <= (drop == 2);
                    drc     <= drop - 2;
                    drceq0  <= (drop == 2);
                    drceq1  <= (drop == 3);
                end
                
                if(drceq0) begin
                    /*
                     *  Ha drc == 0, akkor mindket most erkezett minta mar egy uj
                     *  min/max-hoz tartozik, ezert a jelenlegi min/max ertekeket
                     *  ki kell irni. (Az uj szamitas inicializalasat az 'initmm2'
                     *  jelzi)
                     */
                    wdata1[7:0]  <= min1;
                    wdata1[15:8] <= max1;
                    wdata2[7:0]  <= min2;
                    wdata2[15:8] <= max2;
                    write <= 1;
                end
                else if(drceq1) begin
                    /*
                     *  Ha drc == 1, akkor a regebbi minta (chx[7:0]) a folyamatban
                     *  levo min/max szamitas utolso adata, az ujabb minta 
                     *  (chx[15:8]) a kovetkezo min/max par elso adata.
                     *  Ebbol adodoan egyreszt a regebbi adatot felhasznalva ki
                     *  kell szamolni a vegso min/max erteket es ki kell irni,
                     *  masreszt az uj adattal inicializalni kell a kovetkezo min/max
                     *  szamitast.
                     */
                    if(ch1[7:0] < min1)
                        wdata1[7:0] <= ch1[7:0];
                    else
                        wdata1[7:0] <= min1;
                    
                    if(ch1[7:0] > max1)
                        wdata1[15:8] <= ch1[7:0];
                    else
                        wdata1[15:8] <= max1;

                    if(ch2[7:0] < min2)
                        wdata2[7:0] <= ch2[7:0];
                    else
                        wdata2[7:0] <= min2;
                    
                    if(ch2[7:0] > max2)
                        wdata2[15:8] <= ch2[7:0];
                    else
                        wdata2[15:8] <= max2;
                    write <= 1;
                        
                    min1 <= ch1[15:8];
                    max1 <= ch1[15:8];
                    min2 <= ch2[15:8];
                    max2 <= ch2[15:8];
            
                    drc     <= drop - 1;
                    drceq0  <= 0;
                    drceq1  <= 0;
                    initmm2 <= 0;
                end
                else begin
                    /*
                     *  Ebben az esetben mindket mintat at kell tolni a komparatorokon
                     *  es ki kell szamolni az uj min/max ertekeket.
                     */
                    if(ch1ri) begin             // [15:8] > [7:0] 
                        if(ch1[7:0] < min1)
                            min1 <= ch1[7:0];
                        if(ch1[15:8] > max1)
                            max1 <= ch1[15:8];
                    end
                    else begin                  // [7:0] > [15:8]
                        if(ch1[15:8] < min1)
                            min1 <= ch1[15:8];
                        if(ch1[7:0] > max1)
                            max1 <= ch1[7:0];
                    end
                    
                    if(ch2ri) begin             // [15:8] > [7:0] 
                        if(ch2[7:0] < min2)
                            min2 <= ch2[7:0];
                        if(ch2[15:8] > max2)
                            max2 <= ch2[15:8];
                    end
                    else begin                  // [7:0] > [15:8]
                        if(ch2[15:8] < min2)
                            min2 <= ch2[15:8];
                        if(ch2[7:0] > max2)
                            max2 <= ch2[7:0];
                    end
                    
                    drc     <= drc - 2;
                    drceq0  <= (drc == 2);
                    drceq1  <= (drc == 3);
                    initmm2 <= (drc == 2);
                end
            end
        end
    end
    
    always @ (posedge CLK66) begin
        if(! en) begin
            waddr  <= 0;
            wraddr <= 0;
            bwrite  <= 0;
            busy   <= 0;
            endst  <= 0;
        end
        else begin
            if(write && run) begin
                waddr  <= waddr + 1;
                wraddr <= wraddr + 2;
            end
            
            busy <= 1;
            lrun <= run;
            
            if(endst == 0) begin
                if(lrun == 1 && run == 0)
                    endst <= 1;
            end
            else if(endst == 1 && !bwrite) begin
                if(waddr[7:0] != 0) begin
                    bwrite <= 1;
                    wah   <= waddr[8];
                    endst <= 2;
                end
                else
                    busy <= 0;
            end
            else if(endst == 2 && !bwrite)
                busy <= 0;
            
                        
            if(bwrite && bwdone)
                bwrite <= 0;
            else if(write && run && waddr[7:0] == 255) begin
                wah <= waddr[8];
                bwrite <= 1;
            end
        end
    end
    
    assign b32a   = {wah, sdbufa};
    
    buffer16_32  buf1(
        .clk16(CLK66), .addr16(waddr), .wr16(write), .din16(wdata1),
        .clk32(CLK66), .addr32(b32a),  .wr32(1'b0),  .dout32(bd1)
    );
    
    buffer16_32  buf2(
        .clk16(CLK66), .addr16(waddr), .wr16(write), .din16(wdata2),
        .clk32(CLK66), .addr32(b32a),  .wr32(1'b0),  .dout32(bd2)
    );
    
    /*
     *  SDRAM iras
     */
    assign sdbase = {addrh, extreg[`ACQ_EXTMEMSEL], sdwra};
    assign brd    = (addrh) ? bd2 : bd1;

    always @ (posedge CLK66) begin
        sdwr   <= 0;
        bwdone <= 0;
        
        if(state == 0) begin
            if(!en) begin
                sdwra <= 0;
            end
            else begin
                state <= 1;
            end
        end
        else if(state == 1) begin
            if(bwrite) begin                // osszejott 512 byte / csatorna
                addrh <= 0;
                sdwr  <= 1;             // kiirjuk a CH1 cuccat
                state <= 2;
            end
            else if(!en)
                state <= 0;
        end
        else if(state == 2 && sddone) begin
            addrh <= 1;                 // a CH1 kesz
            sdwr  <= 1;                 // most kiirjuk a CH2 cuccat
            state <= 3;
        end
        else if(state == 3 && sddone) begin
            sdwra <= sdwra + 1;         // egy block kesz
            state <= 0;
            bwdone <= 1;
        end
    end
endmodule

