/****************************************************************************/
/*                                                                          */
/*                ACS-2602 - Kis Szkop                                      */
/*                                                                          */
/****************************************************************************/
/*  Target Chip: Xilinx XC2S200 - PQ208 (Spartan-II)                        */
/*--------------------------------------------------------------------------*/
/*  BitBlitter                                                              */
/*--------------------------------------------------------------------------*/
/* History:                                                                 */
/*  2004.11.15: elso verzio                                                 */
/*  2004.11.17: nagyon lassu volt, teljes atdolgozas a Newvuk alapjan,      */
/*              plusz tovabbi pipe line-ok es regiszterek berakasa          */
/* ---------------------------- ELSO HW TEST ------------------------------ */
/*  2004.11.17: Kiirt egy 'c' betut!!!                                      */
/*  2004.11.17: destination address horizontalis step hiba, fixalva         */
/*  2004.11.18: csokkeno cimes masolas hibak                                */
/*  2005:01:25:  rettenetes hiba volt a 315. sorban                         */
/*  2005.10.06: csokkeno cimes masolas kiszedese                            */
/*--------------------------------------------------------------------------*/
/*  2007.03.13: kiindulas az acs-2004 bekescsabai blitter.v-bol             */
/*  2007.03.14: cel fixen 40 byte szeles, src, dst address 17 bites         */
/*  2007.07.26: extra read hiba, kijavitva                                  */
/****************************************************************************/

/*
 *  Mode regiszter bitek
 */
`define BLT_IRQEN   7
`define BLT_NOSTEP  6           /* A source 1 pixel magas                   */
`define BLT_CMODE   1:0         /* Masolas modja, overwrite, and, or, xor   */

`define BLT_OWR     0           /* A BLT_CMODE mezo ertekei                 */
`define BLT_CLR     1
`define BLT_SET     2
`define BLT_INV     3

/*
 * A BLT_XBITS regiszter kiosztasa
 */
`define BLT_UDSTH   7           /* Destination address legfelso bit (PAGE)  */
`define BLT_UDSTB   6:4         /* Destination address legalso 3 bit        */
`define BLT_USRCH   3           /* Source address legfelso bit (RAM PAGE)   */
`define BLT_USRCB   2:0         /* Source address legalso 3 bit             */

/*
 *  A state regiszter allapotai
 */
`define BS_IDLE     0
`define BS_RDSRC    1
`define BS_RDDST    2
`define BS_WRDST    3
`define BS_BITS     1:0


module  blitter(memclk,
            regrd, regwr, regdin, regdout, rega, irq,
            ramaddr, ramdtow, ramdin, ramrdreq, ramwrreq, ramack, ramdon
);

input           memclk;
input           regrd;          /* CPU wants to read an internal register   */
input           regwr;          /* CPU register write                       */
input   [7:0]   regdin;         /* CPU register write data                  */
output  [7:0]   regdout;        /* CPU register read data *** TriState ***  */
input   [7:0]   rega;           /* CPU register rd/wr address               */
output          irq;            /* Activ high interrupt request output      */

output          ramrdreq;       /* RAM read request                         */
output          ramwrreq;       /* RAM write request                        */
output  [16:0]  ramaddr;        /* RAM address                              */
output  [7:0]   ramdtow;        /* RAM data to write                        */
input   [7:0]   ramdin;         /* Read RAM data                            */
input           ramack;         /* RAM access acknowledge                   */
input           ramdon;         /* RAM transfer done                        */

/****************************************************************************/
/*  Belso regiszterek - jelek                                               */
/****************************************************************************/

reg             ramrdreq;
reg             ramwrreq;

reg     [15:0]  usrca;          /* Forras blokk kezdeti cim 18:3 bitek      */
wire    [2:0]   usrcb;          /* Forras blokk kezdeti cim 2:0 bitek       */
reg     [15:0]  udsta;          /* Cel blokk kezdeti cim 18:3 bitek         */
wire    [2:0]   udstb;          /* Cel blokk kezdeti cim 2:0 bitek          */
reg     [7:0]   uheig;          /* Objektum magassaga pixelben  max. 255    */
reg     [8:0]   uwidth;         /* Objektum szelessege pixelben max. 511    */
reg     [7:0]   umode;          /* Mode regiszter                           */
reg     [7:0]   uxbits;         /* Extra cimbitek                           */
reg     [5:0]   swid;           /* Forras block szelessege byte-ban         */

reg             irqf;           /* Interrupt                                */
reg     [18:0]  source;
reg     [18:0]  dest;
reg     [8:0]   rdcnt;          /* Ennyi bitet kell meg felolvasni          */
reg     [8:0]   wrcnt;          /* Ennyi bitet kell meg kiirni              */
reg     [2:0]   shiftnum;
wire    [3:0]   rt1;
wire    [3:0]   _rbits;
wire    [3:0]   wt1;
wire    [3:0]   _wbits;

reg     [3:0]   rbits;
reg     [3:0]   wbits;

reg     [7:0]   A;
reg     [7:0]   B;
reg     [7:0]   orig;

wire    [7:0]   mski;
wire    [7:0]   mask;
wire    [7:0]   wdata;
wire    [7:0]   ramdtow;

wire            run;

reg [`BS_BITS]  state = `BS_IDLE;
reg             firstr = 1;
wire    [15:0]  nusrca;
wire    [15:0]  nudsta;
reg             endf;
reg             lastw;
reg             lastr;
reg             extrard;

    assign irq = irqf & umode[`BLT_IRQEN];

    assign ramaddr = (state == `BS_RDSRC) ? ({uxbits[`BLT_USRCH], source[18:3]}) :
                                            ({uxbits[`BLT_UDSTH], dest[18:3]});
    
    assign wdata = ({B, A} >> shiftnum);
    
    assign ramdtow = (orig & ~mask) | (mask & 
                        ((umode[`BLT_CMODE] == `BLT_OWR) ? wdata :
                         (umode[`BLT_CMODE] == `BLT_CLR) ? (orig & ~wdata) :
                         (umode[`BLT_CMODE] == `BLT_SET) ? (orig |  wdata) :
                                                          (orig ^  wdata)));

    assign mski = (wbits == 1) ? 8'b10000000 :
                  (wbits == 2) ? 8'b11000000 :
                  (wbits == 3) ? 8'b11100000 :
                  (wbits == 4) ? 8'b11110000 :
                  (wbits == 5) ? 8'b11111000 :
                  (wbits == 6) ? 8'b11111100 :
                  (wbits == 7) ? 8'b11111110 :
                  (wbits == 8) ? 8'b11111111 : 8'hxx;

    assign mask = {8'h00, mski} >> dest[2:0];

    /*
     *  Source es destination cim also 3 bitjei
     */
    assign usrcb = uxbits[`BLT_USRCB];
    assign udstb = uxbits[`BLT_UDSTB];
    
    assign nusrca = usrca + (umode[`BLT_NOSTEP] ? 0 : swid);
    assign nudsta = udsta + 40;
    
    /*
     *  rt1, wt1 azt mondja meg, hogy az adott poziciotol a byte
     *  szeleig hany bit van (1-8)
     */
    assign rt1 = (4'd8 - {1'b0, source[2:0]});
    assign _rbits = ({5'b0, rt1} < rdcnt) ? rt1 : rdcnt[3:0];
    assign wt1 = (4'd8 - {1'b0, dest[2:0]});
    assign _wbits = ({5'b0, wt1} < wrcnt) ? wt1 : wrcnt[3:0];
    
    assign run = state != `BS_IDLE;
    
    assign regdout = (regrd && (rega == `BLT_MODE)) ?
                                {irqf, 6'b0, run} : 8'hzz;
    
    always @ (posedge memclk) begin
        
        if(ramack) begin
            ramrdreq <= 0;
            ramwrreq <= 0;
        end
        
        if(regrd && (rega == `BLT_MODE)) begin
            irqf <= 0;
        end
        
        /*
         *  Barmelyik fontosabb regiszter megvaltozik, akkor ket orajelen
         *  keresztul szamolja a rbits, wbits, lastr, lastw ertekeit.
         *  Ez nem baj, mert a valtozasokat mindig legalabb 3 orajelnyi
         *  RAM ciklus koveti.
         */
        wbits <= _wbits;
        rbits <= _rbits;
        
        lastr <= (rdcnt - rbits) == 0;
        lastw <= (wrcnt - wbits) == 0;

        /*
         *  Ezeket elmeletileg a masolas kezdetekor es csak egyszer kellene
         *  beallitani, de mivel a forras vektorok nem valtoznak,
         *  itt kevesebb helyet foglalnak
         */
        shiftnum <= ({1'b0, udstb} - {1'b0, usrcb});
        extrard  <= ({1'b0, udstb} - {1'b0, usrcb}) >> 3;
        
        /*
         *  A state machine
         */
        if(state == `BS_IDLE) begin
            if(regwr && (rega == `BLT_SAL))
                usrca[7:0] <= regdin;
            
            if(regwr && (rega == `BLT_SAH))
                usrca[15:8] <= regdin;
        
            if(regwr && (rega == `BLT_DAL))
                udsta[7:0] <= regdin;
            
            if(regwr && (rega == `BLT_DAH))
                udsta[15:8] <= regdin;

            if(regwr && (rega == `BLT_SWID))
                swid <= regdin;
    
            if(regwr && (rega == `BLT_WIDL))
                uwidth[7:0] <= regdin;
                
            if(regwr && (rega == `BLT_WIDH))
                uwidth[8] <= regdin[0];
            
            if(regwr && (rega == `BLT_HEIG))
                uheig <= regdin;
                
            if(regwr && (rega == `BLT_XBITS))
                uxbits <= regdin;

            if(regwr && (rega == `BLT_MODE)) begin
                umode    <= regdin;
                source   <= {usrca, usrcb};
                rdcnt    <= uwidth;
                dest     <= {udsta, udstb};
                wrcnt    <= uwidth;
                endf     <= uheig == 1;
                ramrdreq <= 1;
                firstr   <= 1;
                state    <= `BS_RDSRC;
            end
        end
        else if(state == `BS_RDSRC && ramdon) begin
            if(extrard && firstr)
                B <= ramdin;
            else
                A <= ramdin;
                
            if(!lastr && extrard && firstr) begin   // sor elso byte es extra
                ramrdreq <= 1;                      // es nem csak 1 byte a sor
            end
            else begin
                if((wbits == 8) && (umode[`BLT_CMODE] == `BLT_OWR)) begin
                    ramwrreq <= 1;
                    state <= `BS_WRDST;
                end
                else begin
                    ramrdreq <= 1;
                    state <= `BS_RDDST;
                end
            end
            
            if(lastr) begin
                /*
                 * Ez volt az utolso olvasas a sorbol
                 */
                source <= {nusrca, usrcb}; // kovetkezo sor eleje
                usrca  <= nusrca;
                rdcnt  <= uwidth;           // teljes szelesseg
                firstr <= 1;                // ez lesz az elso olvasas a sorbol
            end
            else begin
                source  <= ((source[18:3] + 1) << 3);
                rdcnt   <= rdcnt - rbits;
                firstr  <= 0;
            end
        end
        else if(state == `BS_RDDST && ramdon) begin
            orig     <= ramdin;
            ramwrreq <= 1;
            state    <= `BS_WRDST;
        end
        else if(state == `BS_WRDST && ramdon) begin
            B <= A;
        
            if(lastw) begin
                /*
                 * Ez volt az utolso iras a sorban
                 */
                dest   <= {nudsta, udstb};
                udsta  <=  nudsta;
                wrcnt  <= uwidth;
                uheig  <= uheig - 1;
                endf   <= uheig == 2;
                
                if(endf) begin
                    irqf <= 1;
                    state <= `BS_IDLE;
                end
                else begin
                    ramrdreq <= 1;
                    state <= `BS_RDSRC;
                end
            end
            else begin
                dest  <= ((dest[18:3] + 1) << 3);
                wrcnt <= wrcnt - wbits;
                ramrdreq <= 1;
                
                if(firstr)              // az utolso olvasas is megvolt
                    state <= `BS_RDDST; // ez egy extra iras
                else
                    state <= `BS_RDSRC;
            end
        end
    end
endmodule

