/****************************************************************************/
/*                                                                          */
/*                ACS-2602 - Kis Szkop                                      */
/*                                                                          */
/****************************************************************************/
/*  Target Chip: Xilinx XC2S200-5PQ208 (Spartan-II)                         */
/*--------------------------------------------------------------------------*/
/* LCD frissites                                                            */
/*--------------------------------------------------------------------------*/
/* History:                                                                 */
/*  2007.01.04: elso verzio (xc2s30-ra)                                     */
/*  2007.01.05: cimszamitas atirasa, layer mask hozzadasa                   */
/*  2007.03.08: elso teszt xc2s150-en, megy, kis atirkalas                  */
/*  2007.03.10: orajel szamitas atirasa 66 megara                           */
/*  2007.03.24: 1/2, 1/3 fcnt beleirasa                                     */
/*  2007.07.12: IRQ, l1brig, mode regiszter hozzaaasa                       */
/****************************************************************************/

module lcdrefresh(
    CLK66,
    regwr, regrd, rega, regdi, regdo, irq,
    ramrd, ramaddr, ramdata, ramack, ramdon,
    cp, frame, load, dispon, data
);

input           CLK66;

input           regwr;
input           regrd;
input   [7:0]   rega;
input   [7:0]   regdi;
output  [7:0]   regdo;
output          irq;
 
output          ramrd;
 reg            ramrd = 0;
output  [16:0]  ramaddr;
input   [7:0]   ramdata;
input           ramack;
input           ramdon;

output          cp;
 reg            cp;
output          frame;
 reg            frame;
output          load;
 reg            load;
output  [3:0]   data;
 reg    [3:0]   data;
output          dispon;
 reg            dispon = 0;

/* ---- Internal signals -------------------------------------------------- */

reg     [7:0]   clkdiv = 0;     /* 66MHz -> 1.351MHz (1/740ns) divider      */
reg     [6:0]   nibcnt = 0;     /* Nibble counter (80/line)                 */
reg     [7:0]   dline = 0;      /* line counter (240/frame)                 */
reg     [6:0]   state = 0;      /* Olvasas allapota, minden bit egy layer   */
reg     [15:0]  address;
reg             fcnt2 = 0;      /* Minden frame utan atbillen               */
reg     [1:0]   fcnt3 = 0;
reg             start = 0;      /* Indul a mandula!                         */
reg             pendreq = 0;    /* van varakozo ram request                 */
reg     [7:0]   rdata;          /* Az ossze-orolt adatok                    */
reg     [5:0]   lmask = 0;      /* Layer read mask                          */
reg     [5:0]   umask = 0;      /* User layer select L6, L5, L4, L3, L2, L1 */
reg             rampage = 0;
reg             irq = 0;        /* Interrupt                                */
reg     [5:0]   ldmask = 0;     /* Loaded mask                              */
reg     [1:0]   l1brig = 1;     /* Layer 1 brightness                       */
reg             inverse = 0;

wire            L6m, L5m, L4m, L3m, L2m;


    assign ramaddr = {rampage, address};
    
    assign L6m = umask[5] & fcnt2;
    assign L5m = umask[4];
    assign L4m = umask[3] & fcnt2;
    assign L3m = umask[2];
    assign L2m = umask[1] & ((l1brig == 0) ? (fcnt3 == 0) :
                             (l1brig == 1) ? fcnt2 : 1);
    
    assign regdo = (regrd && rega == `LCD_MASK) ? ldmask :
                   (regrd && rega == `LCD_MODE) ? {irq, 7'b0} : 8'hzz;
    
    always @ (posedge CLK66) begin
        if(regwr && rega == `LCD_MASK) begin
            umask  <= regdi[5:0];
        end
        if(regwr && rega == `LCD_MODE) begin
            dispon <= !regdi[7];
            rampage <= regdi[6];
            inverse <= regdi[5];
            l1brig  <= regdi[1:0];
        end
    end
    
    /*
     *  Csinalja az LCD CP jelet, es a 'start' regiszterben jelzi az orajel
     *  felfutast
     */
    always @ (posedge CLK66) begin
        start <= 0;
        if(clkdiv == 48) begin
            clkdiv <= 0;
            cp     <= 0;
            start  <= 1;
        end
        else begin
            clkdiv <= clkdiv + 1;
            if(clkdiv == 24)
                cp <= 1;
        end
    end
    
    always @ (posedge CLK66) begin
        if(regrd && rega == `LCD_MODE)
            irq <= 0;
            
        if(start) begin
            state   <= 1;
            pendreq <= 0;
            
            if(nibcnt[0] == 0) begin
                ramrd <= umask[0];
                rdata <= 0;
            end
        end
        else if(state[5:0] && (!ramrd || ramack)) begin
            //
            // vege egy olvasasnak vagy nem is volt olvasas
            //
            state <= {state[5:0], 1'b0};
            
            if(nibcnt[0] == 0) begin
                if(state[5])    // utolso olvasas utan visszaall az elejere
                    address <= address - (5*9600);
                else
                    address <= address + 9600;
                ramrd <= (lmask & state[5:0]) ? 1 : 0;
            end
        end
    
        if(ramdon)
            rdata <= rdata | ramdata;
            
        if(ramack && !ramdon)
            pendreq <= 1;
        else if(ramdon && !ramack)
            pendreq <= 0;
        
        if(state[6] && !pendreq) begin
            state <= 0;
            
            /*
             *  LCD CP lefuto el utan vagyunk. min. 4 max 16 CLK66 orajellel
             */
            if(nibcnt[0] == 0)
                data <= inverse ? ~rdata[7:4] : rdata[7:4];
            else
                data <= inverse ? ~rdata[3:0] : rdata[3:0];
            
            if(nibcnt == 79) begin
                nibcnt <= 0;
                load   <= 1;
                
                if(dline == 0)
                    frame <= 1;
                else
                    frame <= 0;
                
                if(dline == 239) begin
                    dline <= 0;
                    fcnt2 <= ~fcnt2;
                    fcnt3 <= fcnt3 + 1;
                    lmask <= {1'b0, L6m, L5m, L4m, L3m, L2m};
                    ldmask <= umask;
                    irq    <= dispon;
                    address <= 0;
                end
                else begin
                    dline <= dline + 1;
                    address <= address + 1;
                end
            end
            else begin
                nibcnt <= nibcnt + 1;
                if(nibcnt[0])
                    address <= address + 1; 
                load <= 0;
            end
        end
    end
endmodule

