;----------------------------------------------------------------
;#define PSC_MOTOR_CONTROL
#define THREE_PHASE_MOTOR_CONTROL
;----------------------------------------------------------------

	list      p=16f690           ; list directive to define processor
	#include <p16f690.inc>        ; processor specific variable definitions

;	errorlevel  -302              ; suppress message 302 from list file


;	__CONFIG   _CP_OFF & _CPD_OFF & _BOR_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _FCMEN_OFF & _IESO_OFF 
	__CONFIG   _CP_OFF & _CPD_OFF & _BOR_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _HS_OSC & _FCMEN_OFF & _IESO_OFF 

;----------------------------------------------------------------
	include		<MC_16F690.inc>
;----------------------------------------------------------------

;---------------------------------------------------------------------------------------
;OSCILLATOR FREQUENCY
#define OSCILLATOR	D'20000000'
#define MAX_PWM_DUTY	0x9C
;---------------------------------------------------------------------------------------
;TIMER0 PRESCALER
#define	TIMER0_PRESCALE	D'128'
;---------------------------------------------------------------------------------------
;NUMBER OF ENTRIES IN THE SINE TABLE, OR THE SAMPLING FREQUENCY
#define	SINE_TABLE_ENTRIES	0x13
;---------------------------------------------------------------------------------------
;SEQUENCE_FLAGS flags definition for PWM algorithm
#define	PWM_FIRST		0	
#define	PWM_SECOND		1	
#define	PWM_THIRD		2	
#define	PWM_NEW_CYCLE		3
;---------------------------------------------------------------------------------------
;BIT DEFINITION OF OFFSET_FLAGS for sine wave generation
#define	MOTOR_FREQ_COUNTER	0
#define OFFSET1_FLAG		1
#define OFFSET2_FLAG		2
#define OFFSET3_FLAG		3
;---------------------------------------------------------------------------------------
;PORT AND BIT DEFINITIONS					

#define FWD_KEY			PORTA,3
#define REV_KEY			PORTC,5

#define DEBOUNCE_COUNT 0x80

;BIT DEFINITION OF FLAGS3
#define RUN_STOP		0
#define DIR_FWD			1
#define DIR_REV			2

#define KEY_RS			4
#define KEY_FR			5
#define KEY_PRESSED		6
#define KEY_TEST		7

;BIT DEFINITION OF FLAGS2
#define	FREQ_REF		0
#define	MOTOR_CUR		1
#define	HEATSINK_TEMP		2
#define	OVER_CURRENT		3
#define	OVER_TEMPARATURE	4

#define	DELAY_COUNT1		0XFF
#define	DELAY_COUNT2		0XFF

#define	PWM_PORT_H 	PORTC
#define	PWM1_PIN	0	
#define	PWM3_PIN	1	
#define	PWM5_PIN	2	

#define	PWM_PORT_L 	PORTB
#define	PWM0_PIN	4	
#define	PWM2_PIN	5	
#define	PWM4_PIN	6	
	
;Define maximum allowed motor current here
;The value should be 26d/Amp with 0.05Ohm shunt 
;resistor and 10 amplifying ratio.
#define	MAX_MOTOR_CURRENT	0x80	;5 Amps
;Define maximum allowed heatsink temparature here
#define	MAX_HEATSINK_TEMP	0x80
;----------------------------------------------------------------
#define	PORT_RELAY		PORTB
#define	RELAY_BIT		7

#define	HARDWARE_OC_COUNT	0x5
;---------------------------------------------------------------------------------------
	
;---------------------------------------------------------------------------------------
INT_VAR		UDATA_SHR	0x70   
w_temp		RES     1		; variable used for context saving 
status_temp	RES     1		; variable used for context saving
pclath_temp	RES	1		; variable used for context saving


;	UDATA 20h

OFFSET_FLAGS		equ 0x22	;FLAGS REGISTERS USED TO INDICATE DIFFERENT STATUS
SEQUENCE_FLAGS		equ 0x23	;FLAGS REGISTERS USED TO INDICATE DIFFERENT STATUS
FLAGS2			equ 0x24	;FLAGS REGISTERS USED TO INDICATE DIFFERENT STATUS
TEMP_LOC		equ 0x25	;GENERAL PURPOSE TEMPORARY LOCATION
TEMP_LOC_1		equ 0x26	;GENERAL PURPOSE TEMPORARY LOCATION
TEMP_LOC_2		equ 0x27	;GENERAL PURPOSE TEMPORARY LOCATION
TEMP_LOC_3		equ 0x28
NO_1_LSB		equ 0x29	;NUMERATOR(LSB) AND QUOTIENT(LSB) OR MULTIPLIER(LSB)
RESULT_LSB		equ 0x2A	;RESULT OF MULTIPLICATION(LSB)/REMAINDER(LSB)
RESULT_MSB		equ 0x2B	;RESULT OF MULTIPLICATION(MSB)/REMAINDER(MSB)
VDC_COUNT		equ 0x2C	;DIGITAL COUNT OF DC BUS VOLTAGE
NEW_FREQ		equ 0x2D	;NEW REFERENCE FREQUENCY INPUT
MOTOR_FREQUENCY		equ 0x2E	;TEMPORAY LOCATION FOR HOLDING DEC_COUNTER OR ACC_COUNTER
TABLE_OFFSET1		equ 0x2F	;PHASE1 OFFSET TO THE SINE TABLE
TABLE_OFFSET2		equ 0x30	;PHASE2 OFFSET TO THE SINE TABLE
TABLE_OFFSET3		equ 0x31	;PHASE3 OFFSET TO THE SINE TABLE
SINE_TABLE_RAM		equ 0X32	;SINE TABLE, 0x14 bytes

PWM_PR_CH1		equ 0x51	;Priority definition on channels
PWM_PR_CH2		equ 0x52
PWM_PR_CH3		equ 0x53	
PWM1_DS			equ 0x54	;Duty cycle buffers	
PWM2_DS			equ 0x55	
PWM3_DS			equ 0x56	
PWM4_DS			equ 0x57	
OC_COUNT		equ 0x58	;Count for over current

DEBOUNCE_COUNTER 	equ 0x59

SZAMOLO			equ 0x5A
SZAMOLO1		equ 0x5B
TEMP_LOC1		equ 0x5C

FLAGS3			equ 0x5D

pwm_temp		equ 0x5E
ICH_TMP			equ 0x5F

;***********************************************************************

;Macro	
MULT    MACRO   BIT		;MACRO FOR UNSIGNEDMULTIPLICATION
	btfsc   NO_1_LSB,BIT
	addwf   RESULT_MSB,F
	RRF     RESULT_MSB,F
	RRF     RESULT_LSB,F
	ENDM			;END OF MACRO FOR MULTIPLICATION
	
;----------------------------------------------------------------
STARTUP	CODE	0X00		;RESET VECTOR ADDRESS 
	goto	START				
	
	CODE	0X04		;INTERRUPT VECTOR LOCATION
	goto	ISR_INT		;goto INTERRUPT SERVICE ROUTINE

;****************************************************************
PROG	CODE
START
;****************************************************************
;INITIALIZATION OF THE PORTS AND TIMERS
	

	bsf	STATUS,RP0
	bsf	OSCCON,6	;INTERNAL OSCILLATOR SELECTION
	bsf	OSCCON,5
	bsf	OSCCON,4

	movlw	0X03
	movwf 	TRISB		;RB0-1 AND CONFIGURED AS INPUT 

	bcf 	STATUS,RP0	
	clrf 	PORTC
	
	bsf 	STATUS,RP1	;BANK2 SELECTION
	clrf 	ANSEL
	clrf	ANSELH
	bsf	ANSEL,0		;AN0 CONFIGURED AS ANALOG INPUT
	bsf	ANSEL,1		;AN1 CONFIGURED AS ANALOG INPUT
	bsf 	ANSEL,2		;AN2 CONFIGURED AS ANALOG INPUT
	bsf 	ANSELH,0	;AN8 CONFIGURED AS ANALOG INPUT
	bsf	ANSELH,1	;AN9 CONFIGURED AS ANALOG INPUT	

	bsf 	STATUS,RP0	;BANK2 SELECTION
	bcf	STATUS,RP1

	movlw	b'11111000'
	movwf	TRISC		;RC0-RC2 CONFIGURED AS OUTPUT, RC3-RC7 AS INPUT
	movlw	b'10000000'
	movwf	TRISB		;RB4-RB6 CONFIGURED AS OUTPUT, RB7 AS INPUT
	clrf	TRISA		
	comf	TRISA,F		;RA0-RA7 CONFIGURED AS INPUT
	bcf	STATUS,RP0

	movlw	b'00000111'	;Turn off PWM1,3,5 PWMs(active low) at the beginning of the cycle
	movwf	PWM_PORT_H	;& turn on PWM0,2,4
	movlw   b'00000000'
	movwf	PWM_PORT_L

	clrf	PWM_PR_CH1	
 	bsf 	PWM_PR_CH1,0
	clrf	PWM_PR_CH2	
	bsf 	PWM_PR_CH2,1
	clrf	PWM_PR_CH3	
	bsf 	PWM_PR_CH3,2
	clrf	PWM1_DS	
	clrf	PWM2_DS
	clrf	PWM3_DS	
	clrf	PWM4_DS	

	movlw	0x20	
	movwf	PWM1_DS	
	movwf	PWM2_DS
	movwf	PWM3_DS
	movwf	PWM4_DS	

	clrf	OFFSET_FLAGS	;CLEAR ALL FLAGS
	clrf	FLAGS2		;CLEAR ALL FLAGS
	
	call	STOP_MOTOR	;STOP MOTOR

	call	COPY_TABLE_TO_RAM	;COPY SINE TABLE FROM PROGRAM MEMORY TO RAM FOR FASTER ACCESS
;******************************************************************
;INITIALIZE ADC REGISTERS
;******************************************************************
	bcf	STATUS,RP0
	movlw	0X25		;CONFIGURE FOR 32TOSC AND 
	movwf	ADCON0		;CHANNEL FOR CONVERSION - AN9 , RC7 (FREQUNENCY)
	bsf	STATUS,RP0	
	movlw	0x70		;CONFIGURE ADCLOCK for RC clock
	movwf	ADCON1
	bcf	STATUS,RP0

;******************************************************************
;TIMER1 INITIALIZATION WITH PRESCALER - USED FOR SETTING THE PWM TIMING
;******************************************************************

	movlw	b'00100001'	;LOAD THE T1CON WITH CONTROL WORD
	movwf	T1CON		;FOR TMR1 ON AND PRESCALAR IS 1:4, INTERNAL CLOCK

;******************************************************************
;TIMER0 INITIALIZATION WITH PRESCALER - USED FOR ACCELERATION,DECELERATION AND ADC TRIGGER FOR FREQ. CONV.
;******************************************************************
	bsf	STATUS,RP0
	movlw	b'10000110'	;prescale 1:128
	movwf	OPTION_REG
	bcf	STATUS,RP0

	clrf	INTCON		;DISABLE ALL INTERRUPTS AND FLAGS ASSOCIATED WITH
	clrf	PIR1		;DISABLE ALL INTERRUPT FLAGS
	bsf	STATUS,RP0
	clrf	PIE1		;DISABLE ALL INTERRUPTS

	movlw	0X03		;SET #POR AND #BOR FLAGS
	movwf	PCON

	bcf	STATUS,RP0
;---------
;WAIT_HERE
;	btfss	KEY_PORT,FWD_REV_KEY
;	goto	WAIT_HERE
;***********************************************************************
;	call	BIG_DELAY

;Very important, turning on this bit will turn on DC bus to the IRAMS 
	bsf		PORT_RELAY,RELAY_BIT		;	PORTB,7


;	call	BIG_DELAY
;***********************************************************************

;	call	RUN_MOTOR_AGAIN
	movlw	0xA0
	movwf	NEW_FREQ
	call	UPDATE_PWM_DUTYCYCLES		;YES, UPDATE THE PWM DUTY CYCLE WITH NEW VALUE
	call	PRIORATIZE_PWMS
	call	UPDATE_TABLE_OFFSET		;UPDATE 3 OFFSETS
	call	CALCULATE_NEW_SPEED

	bcf	STATUS,RP0
	bsf	INTCON,INTE				;ENABLE RB PORT CHANGE INTERRUPT FOR RB4
	bsf	INTCON,PEIE				;PERIPHERAL INTERRUPTS ENABLE
	bsf	INTCON,GIE				;GLOBAL INTERRUPT ENABLE

;******************************************************************
;MAIN LOOP, THE PROGRAM WILL BE LOOPING
;******************************************************************
MAIN_LOOP

	call	MOTOR_STARTING

	btfss	OFFSET_FLAGS,MOTOR_FREQ_COUNTER	
	goto	BYPASS			
	bcf	OFFSET_FLAGS,MOTOR_FREQ_COUNTER		;CLEAR TMR1 OV FLAG
	call	UPDATE_PWM_DUTYCYCLES		;YES, UPDATE THE PWM DUTY CYCLE WITH NEW VALUE
	call	PRIORATIZE_PWMS
	call	UPDATE_TABLE_OFFSET		;UPDATE 3 OFFSETS
	call	CALCULATE_NEW_SPEED

	btfss	ADCON0, GO			;If AD Conversion is complete
	bsf	ADCON0, GO		;then start a new conversion
BYPASS

	btfsc	PIR1,ADIF			;ADC CONVERSION COMPLETE INTERRUPT?
	call	AD_CONV_COMPLETE	;YES - CONVERSON RESULT 'F - MOTOR FREQUENCY'

;	call	KEY_CHECK				;Check keys change
;	call	PROCESS_KEY_PRESSED
	goto	MAIN_LOOP			;GO BACK TO MAIN LOOP

MOTOR_STARTING

	btfsc	FLAGS3,RUN_STOP
	goto	CHECK_DIRECTION

	bcf	FLAGS3,DIR_FWD
	btfss	FWD_KEY
	bsf	FLAGS3,DIR_FWD

	bcf	FLAGS3,DIR_REV
	btfss	REV_KEY
	bsf	FLAGS3,DIR_REV

	btfsc 	FLAGS3,DIR_FWD
 	call	RUN_MOTOR_AGAIN

	btfsc	FLAGS3,DIR_REV
	call	RUN_MOTOR_AGAIN

	btfsc	FLAGS3,RUN_STOP
	call 	DELAY	
	
	return

CHECK_DIRECTION

	bcf	FLAGS3,KEY_TEST
	btfss	FWD_KEY
	bsf	FLAGS3,KEY_TEST
	btfss	REV_KEY
	bsf	FLAGS3,KEY_TEST

	btfss	FLAGS3,KEY_TEST
	call	STOP_MOTOR

	btfsc	FLAGS3,DIR_FWD
	call	FWD_CHECK
	
	btfsc	FLAGS3,DIR_REV
	call	REV_CHECK

	btfsc	FLAGS3,KEY_TEST
	call	STOP_MOTOR	

	return

FWD_CHECK

	bcf	FLAGS3,KEY_TEST
	btfss	REV_KEY
	bsf	FLAGS3,KEY_TEST

	return

REV_CHECK

	bcf	FLAGS3,KEY_TEST
	btfss	FWD_KEY
	bsf	FLAGS3,KEY_TEST

	return


;******************************************************************
;INTERRUPT SERVICE ROUTINE
;******************************************************************
ISR_INT

	movwf   w_temp            ; save off current W register contents
	movf	STATUS,w          ; move status register into W register
	movwf	status_temp       ; save off contents of STATUS register
	movf	PCLATH,w          ; move pclath register into W register
	movwf	pclath_temp       ; save off contents of PCLATH register

	bcf	STATUS,RP0
	btfsc	PIR1,TMR1IF			;TIMER1 OVERFLOW INTERRUPT?	
	goto	TIMER1_OVERFLOW		;YES - INTERRUPT FOR UPDATING TMR1 REGISTERS BASED ON POT SETTING
	btfsc	INTCON,T0IF			;TIMER0 OVERFLOW INTERRUPT?	
	goto	TIMER0_OVERFLOW		;YES - INTERRUPT FOR UPDATING TMR1 REGISTERS BASED ON POT SETTING
	btfsc	INTCON,INTF			;RB INTERRUPT?
	goto	CHECK_FAULT			;YES - OVER CURRENT FAULT
	
POPUP		
	movf    pclath_temp,w     ; retrieve copy of PCLATH register
	movwf	PCLATH            ; restore pre-isr PCLATH register contents
	movf    status_temp,w     ; retrieve copy of STATUS register
	movwf	STATUS            ; restore pre-isr STATUS register contents
	swapf   w_temp,f
	swapf   w_temp,w          ; restore pre-isr W register contents
	retfie                    ; return from interrupt


;******************************************************************
TIMER1_OVERFLOW					;TMR1 OVERFLOW ISR
	bcf	PIR1,TMR1IF			;CLEAR TMR1IF
;---
	btfss	SEQUENCE_FLAGS,PWM_FIRST
	goto	TAKE_CARE_PWM_SECOND

	btfsc	PWM_PR_CH1,0
	bsf	PWM_PORT_H,PWM1_PIN	;PWM1 is active low
	btfsc	PWM_PR_CH1,1
	bsf	PWM_PORT_H,PWM3_PIN	;PWM3 is active low
	btfsc	PWM_PR_CH1,2
	bsf	PWM_PORT_H,PWM5_PIN	;PWM5 is active low
	btfsc	PWM_PR_CH1,0
	bcf	PWM_PORT_L,PWM0_PIN	;PWM0 is active low
	btfsc	PWM_PR_CH1,1
	bcf	PWM_PORT_L,PWM2_PIN	;PWM2 is active low
	btfsc	PWM_PR_CH1,2
	bcf	PWM_PORT_L,PWM4_PIN	;PWM4 is active low	
	bcf	SEQUENCE_FLAGS,PWM_FIRST
	movlw	0xFF
	movwf	TMR1H
	bsf	SEQUENCE_FLAGS,PWM_SECOND
	comf	PWM2_DS,W	
	movwf	TMR1L
	btfss	STATUS,Z
	goto	POPUP
;---
TAKE_CARE_PWM_SECOND
	btfss	SEQUENCE_FLAGS,PWM_SECOND
	goto	TAKE_CARE_PWM_THIRD

	btfsc	PWM_PR_CH2,0
	bsf	PWM_PORT_H,PWM1_PIN	;PWM1 is active low
	btfsc	PWM_PR_CH2,1
	bsf	PWM_PORT_H,PWM3_PIN	;PWM3 is active low
	btfsc	PWM_PR_CH2,2
	bsf	PWM_PORT_H,PWM5_PIN	;PWM5 is active low
	btfsc	PWM_PR_CH2,0
	bcf	PWM_PORT_L,PWM0_PIN	;PWM0 is active low
	btfsc	PWM_PR_CH2,1
	bcf	PWM_PORT_L,PWM2_PIN	;PWM2 is active low
	btfsc	PWM_PR_CH2,2
	bcf	PWM_PORT_L,PWM4_PIN	;PWM4 is active low	
	bcf	SEQUENCE_FLAGS,PWM_SECOND
	movlw	0xFF
	movwf	TMR1H
	bsf	SEQUENCE_FLAGS,PWM_THIRD
	comf	PWM3_DS,W	
	movwf	TMR1L
	btfss	STATUS,Z
	goto	POPUP
;---
TAKE_CARE_PWM_THIRD
	btfss	SEQUENCE_FLAGS,PWM_THIRD
	goto	TAKE_CARE_FOR_NEXT_CYCLE
	btfsc	PWM_PR_CH3,0
	bsf	PWM_PORT_H,PWM1_PIN	;PWM1 is active low
	btfsc	PWM_PR_CH3,1
	bsf	PWM_PORT_H,PWM3_PIN	;PWM3 is active low
	btfsc	PWM_PR_CH3,2
	bsf	PWM_PORT_H,PWM5_PIN	;PWM5 is active low
	btfsc	PWM_PR_CH3,0
	bcf	PWM_PORT_L,PWM0_PIN	;PWM0 is active low
	btfsc	PWM_PR_CH3,1
	bcf	PWM_PORT_L,PWM2_PIN	;PWM2 is active low
	btfsc	PWM_PR_CH3,2
	bcf	PWM_PORT_L,PWM4_PIN	;PWM4 is active low	
	bcf	SEQUENCE_FLAGS,PWM_THIRD
	movlw	0xFF
	movwf	TMR1H
	bsf	SEQUENCE_FLAGS,PWM_NEW_CYCLE
	comf	PWM4_DS,W	
	movwf	TMR1L
	btfss	STATUS,Z
	goto	POPUP
;---
TAKE_CARE_FOR_NEXT_CYCLE
	btfss	SEQUENCE_FLAGS,PWM_NEW_CYCLE
	goto	POPUP

	movlw	b'00000111'	;Turn off all PWMs(active low)
	movwf	PWM_PORT_H
	movlw	b'01110000'	;Turn off all PWMs(active low)
	movwf	PWM_PORT_L

	movlw	0xFF
	movwf	TMR1H
	comf	PWM1_DS,W	
	movwf	TMR1L
	bcf	SEQUENCE_FLAGS,PWM_NEW_CYCLE
	bsf	SEQUENCE_FLAGS,PWM_FIRST
	clrf 	TEMP_LOC1
	comf	TEMP_LOC1,F
	bcf	TEMP_LOC1,PWM0_PIN
	bcf	TEMP_LOC1,PWM2_PIN
	bcf	TEMP_LOC1,PWM4_PIN
	movf	TEMP_LOC1,W		;Turn on PWM1,3,5 PWMs(active low) at the beginning of the cycle
	xorwf	PWM_PORT_H
	goto	POPUP

;******************************************************************
TIMER0_OVERFLOW					;TMR0 overflow ISR
	movf	MOTOR_FREQUENCY,W		;Load the Lower byte of SpeedCommand to TMR0L
	movwf	TMR0
;	decfsz	SZAMOLO1,F
;	goto 	$+3
;	bsf 	SZAMOLO1,3
;	NOP
	bsf	OFFSET_FLAGS,MOTOR_FREQ_COUNTER
	bcf	INTCON,T0IF			;Clear T0IF
	
	movlw	HARDWARE_OC_COUNT		;Over current count from the comparator
	movwf	OC_COUNT

	goto	POPUP

;******************************************************************
CHECK_FAULT
	bcf		INTCON,INTF	
	decfsz	OC_COUNT,F
	goto	POPUP
	call	STOP_MOTOR			;STOP MOTOR
	goto	POPUP
	
;*****************************************************************
AD_CONV_COMPLETE				;ADC INTERRUPT
	bcf	PIR1,ADIF			;ADIF FLAG IS CLEARED FOR NEXT INTERRUPT
;	btfsc	FLAGS2,FREQ_REF		;IS THE CONVERSION RESULT is FREQUENCY REF?
;	goto	CONV_IS_FREQ
;	btfsc	FLAGS2,MOTOR_CUR		;IS THE CONVERSION RESULT is Motor current?
;	goto	CONV_IS_MOTOR_CURRENT		;YES - READ RESULT AS MOTOR_CURRENT
;	btfsc	FLAGS2,HEATSINK_TEMP	;IS THE CONVERSION RESULT is Motor current?
;	goto	CONV_IS_HS_TEMP		;YES - READ RESULT AS MOTOR_CURRENT
;	bsf		FLAGS2,FREQ_REF	
;	bcf		ADCON0,3
;	bcf		ADCON0,4
;	return
;
CONV_IS_FREQ
;	bcf		FLAGS2,FREQ_REF	
;	bsf		FLAGS2,MOTOR_CUR
;	bsf		ADCON0,3		;Channle1 is selected for next conversion
;	bcf		ADCON0,4
;
	movf	ADRESH,W			;READ AD CONVERSION RESULT
	movwf	NEW_FREQ 			;CHECK FOR LOWER AND UPPER ALLOWED LIMIT OF FREQ.
	sublw	0X30				;MINIMUM FREQUENCY SET TO 5HZ (SCALING FACTOR X4) 
	btfss	STATUS,C			;IS POT SETTING FOR FREQ, MORE THAT LOWER SET LIMIT?
	goto	CHECK_UPPER_LIMIT_FREQUENCY	;YES - NOW CHECK UPPER LIMIT
	movlw	0X30				;NO - SET FREQ. TO LOWER ALLOWED LIMIT - 5HZ (X4)
	movwf	NEW_FREQ
	return

CHECK_UPPER_LIMIT_FREQUENCY	
	movlw	0XD0						
	subwf	NEW_FREQ,W			
	btfss	STATUS,C			;IS POT SETTING MORE THAN ALLOWED UPPER LIMIT OF FREQ?
	return						;NO - RETURN FROM INTERRUPT
	movlw	0XD0				;YES - SET FREQ TO UPPER ALLOWED LIMIT - 60HZ (X4)
	movwf	NEW_FREQ	
	return

;CONV_IS_MOTOR_CURRENT
;	bsf		FLAGS2,HEATSINK_TEMP	
;	bcf		FLAGS2,MOTOR_CUR
;	bcf		ADCON0,3		;Channle2 is selected for next conversion
;	bsf		ADCON0,4

;	movf	ADRES,W				;READ AD CONVERSION RESULT
;	sublw	MAX_MOTOR_CURRENT	;Max current limit
;	btfss	STATUS,C			;IS current > SET LIMIT?
;	bsf		FLAGS2,OVER_CURRENT	;Yes, Take action
;	return
;CONV_IS_HS_TEMP
;	bsf		FLAGS2,FREQ_REF
;	bcf		FLAGS2,HEATSINK_TEMP	
;	bcf		ADCON0,3			;Channle0 is selected for next conversion
;	bcf		ADCON0,4

;	movf	ADRES,W				;READ AD CONVERSION RESULT
;	sublw	MAX_HEATSINK_TEMP			;Max temp limit
;	btfsc	STATUS,C			;IS temp > SET LIMIT?
;	return
;	bsf		FLAGS,OVER_TEMPARATURE	;Yes, Take action
;	call	STOP_MOTOR
;	return



;*************************************************************************
;THIS ROUTINE WILL UPDATE THE PWM DUTY CYCLE ACCORDING TO THE 
;OFFSET TO THE TABLE 
;THIS ROUTINE SCALES THE PWM VALUE FROM THE TABLE BASED ON THE FREQUENCY TO KEEP V/F
;CONSTANT AND LOADS THEM IN APPROPRIATE  REGISTER DEPENDING ON SETTING
;*************************************************************************
UPDATE_PWM_DUTYCYCLES				
	movlw	LOW	SINE_TABLE_RAM
	movwf	FSR				;BASE ADDRESS OF SINE TABLE IN RAM IS LOADED TO FSR
	movf	TABLE_OFFSET1,W			;TABLE_OFFSET1 IS COPIED TO WREG
	addwf	FSR,F				;ADRESS TO BE READ=SINE TABLE BASE ADRESS + TABLE_OFFSET1
	BANKISEL	SINE_TABLE_RAM
	movf	INDF,W				;COPY SINE TABLE VALUE, POINTED BY FSR, TO WREG
	btfsc	STATUS,Z			;CHECK IS VALUE READ ZERO?
	goto	PWM1_IS_0			;YES, goto PWM1_IS_0
	movwf	NO_1_LSB			;NO, SINE TABEL VALUE X SET_FREQ TO SCALE TABLE VALUE BASED ON FREQUENCY SETTING
	call	MUL_8X8				;CALL ROUTINE FOR UNSIGNED 8x8 BIT MULTIPLICATION
	movf	RESULT_MSB,W			;8 MSB OF 16 BIT RESULT IS STORED
	movwf	TEMP_LOC_1			;AT TEMP_LOC - THIS REPRESENT PWM DUTY CYCLE VALUE FOR PHASE 1
	goto	UPDATE_PWM2			;GO FOR UPDATING PWM DUTY CYCLE FOR 2ND PHASE
PWM1_IS_0
	clrf	TEMP_LOC_1			;CLEAR PWM DUTY CYCLE VALUE FOR PHASE 1

UPDATE_PWM2
	movlw	LOW	(SINE_TABLE_RAM)
	movwf	FSR				;BASE ADDRESS OF SINE TABLE IN RAM IS LOADED TO FSR
	movf	TABLE_OFFSET2,W			;TABLE_OFFSET2 IS COPIED TO WREG
	addwf	FSR,F				;ADRESS TO BE READ=SINE TABLE BASE ADRESS + TABLE_OFFSET2
	BANKISEL	SINE_TABLE_RAM
	movf	INDF,W				;COPY SINE TABLE VALUE, POINTED BY FSR, TO WREG
	btfsc	STATUS,Z			;CHECK IS VALUE READ ZERO?
	goto	PWM2_IS_0			;YES, goto PWM2_IS_0
	movwf	NO_1_LSB			;NO, SINE TABEL VALUE X SET_FREQ TO SCALE TABLE VALUE BASED ON FREQUENCY SETTING
	call	MUL_8X8				;CALL ROUTINE FOR UNSIGNED 8x8 BIT MULTIPLICATION
	movf	RESULT_MSB,W			;8 MSB OF 16 BIT RESULT IS STORED
	movwf	TEMP_LOC_2			;AT TEMP_LOC_1 - THIS REPRESENT PWM DUTY CYCLE VALUE FOR PHASE 2
	goto	UPDATE_PWM3			;GO FOR UPDATING PWM DUTY CYCLE FOR 3RD PHASE

PWM2_IS_0
	clrf	TEMP_LOC_2			;CLEAR PWM DUTY CYCLE VALUE FOR PHASE 2
	
UPDATE_PWM3
	movlw	LOW	SINE_TABLE_RAM
	movwf	FSR				;BASE ADDRESS OF SINE TABLE IN RAM IS LOADED TO FSR
	BANKSEL	TABLE_OFFSET3
	movf	TABLE_OFFSET3,W			;TABLE_OFFSET3 IS COPIED TO WREG
	addwf	FSR,F				;ADRESS TO BE READ=SINE TABLE BASE ADRESS + TABLE_OFFSET3
	BANKISEL	SINE_TABLE_RAM
	movf	INDF,W				;COPY SINE TABLE VALUE, POINTED BY FSR, TO WREG
	btfsc	STATUS,Z			;CHECK IS VALUE READ ZERO?
	goto	PWM3_IS_0			;YES, goto PWM3_IS_0
	movwf	NO_1_LSB			;NO, SINE TABEL VALUE X SET_FREQ TO SCALE TABLE VALUE BASED ON FREQUENCY SETTING
	call	MUL_8X8				;CALL ROUTINE FOR UNSIGNED 8x8 BIT MULTIPLICATION
	movf	RESULT_MSB,W			;8 MSB OF 16 BIT RESULT IS STORED
	movwf	TEMP_LOC_3			;AT TEMP_LOC_2 - THIS REPRESENT PWM DUTY CYCLE VALUE FOR PHASE 3
	goto	SET_PWM12			;GO FOR CHECKING DIRECTION OF MOTOR ROTATION REEQUIRED

PWM3_IS_0
	clrf	TEMP_LOC_3			;CLEAR PWM DUTY CYCLE VALUE FOR PHASE 3

SET_PWM12
	movf	TEMP_LOC_1,W
	movwf	PWM1_DS
	movf	TEMP_LOC_2,W			;CCPR1L AND CCPR2L RESPECTIVELY FOR 
	movwf	PWM2_DS
	movf	TEMP_LOC_3,W		
	movwf	PWM3_DS

;	movlw	0x1F
;	movwf	PWM1_DS
;	movlw	0x3F			;CCPR1L AND CCPR2L RESPECTIVELY FOR 
;	movwf	PWM2_DS
;	movlw	0x5F
;	movwf	PWM3_DS


	RETURN
		
		
;*******************************************************************************
;THIS ROUTINE UPDATES THE OFFSET POINTERS TO THE TABLE AFTER EVERY ACCESS
;*******************************************************************************
UPDATE_TABLE_OFFSET
	bcf	STATUS,RP0
	btfss	OFFSET_FLAGS,OFFSET1_FLAG		;IF SET INCR. ON TABLE
	goto	DECREMENT_OFFSET1
	movlw	(SINE_TABLE_ENTRIES-1)		;CHECK FOR THE LAST VALUE ON THE TABLE
	SUBWF	TABLE_OFFSET1,W
	btfsc	STATUS,C	
	goto	CLEAR_OFFSET1_FLAG
	INCF	TABLE_OFFSET1,F			;INCREMENT OFFSET1
	goto	UPDATE_OFFSET2
CLEAR_OFFSET1_FLAG
	bcf	OFFSET_FLAGS,OFFSET1_FLAG
DECREMENT_OFFSET1
	DECFSZ	TABLE_OFFSET1,F			;DECREMENT OFFSET1
	goto	UPDATE_OFFSET2
	bsf	OFFSET_FLAGS,OFFSET1_FLAG

UPDATE_OFFSET2
	btfss	OFFSET_FLAGS,OFFSET2_FLAG		;IF SET INCR. ON TABLE
	goto	DECREMENT_OFFSET2
	movlw	(SINE_TABLE_ENTRIES-1)		;CHECK FOR THE LAST VALUE ON THE TABLE
	SUBWF	TABLE_OFFSET2,W
	btfsc	STATUS,C
	goto	CLEAR_OFFSET2_FLAG
	INCF	TABLE_OFFSET2,F			;INCREMENT OFFSET2
	goto	UPDATE_OFFSET3
CLEAR_OFFSET2_FLAG
	bcf	OFFSET_FLAGS,OFFSET2_FLAG
DECREMENT_OFFSET2
	DECFSZ	TABLE_OFFSET2,F			;DECREMENT OFFSET2
	goto	UPDATE_OFFSET3
	bsf	OFFSET_FLAGS,OFFSET2_FLAG

UPDATE_OFFSET3
	btfss	OFFSET_FLAGS,OFFSET3_FLAG		;IF SET INCR. ON TABLE
	goto	DECREMENT_OFFSET3
	movlw	(SINE_TABLE_ENTRIES-1)		;CHECK FOR THE LAST VALUE ON THE TABLE
	SUBWF	TABLE_OFFSET3,W
	btfsc	STATUS,C
	goto	CLEAR_OFFSET3_FLAG
	INCF	TABLE_OFFSET3,F			;INCREMENT OFFSET3
	RETURN	
CLEAR_OFFSET3_FLAG
	bcf	OFFSET_FLAGS,OFFSET3_FLAG
DECREMENT_OFFSET3
	DECFSZ	TABLE_OFFSET3,F			;DECREMENT OFFSET3
	RETURN
	bsf	OFFSET_FLAGS,OFFSET3_FLAG
	RETURN	


;*******************************************************************************

CALCULATE_NEW_SPEED
	movf	NEW_FREQ,W
	movwf	MOTOR_FREQUENCY
	movlw	0x22			
	addwf	MOTOR_FREQUENCY,F
	bcf	STATUS,C
	rrf	MOTOR_FREQUENCY,F
	bcf	STATUS,C
	rrf	MOTOR_FREQUENCY,F
	movlw	0xB5			
	addwf	MOTOR_FREQUENCY,F
	return	

;*************************************************************************
;PWMs are arranged from low duty cycle to high duty cycle 
;Original duty cycles are input to routine on PWMx_DS
;Output on PWM_PRx and PWM_PR_CHx 
PRIORATIZE_PWMS

	movlw	0x1
	movwf	PWM_PR_CH1
	movlw	0x2
	movwf	PWM_PR_CH2	
	movlw	0x4
	movwf	PWM_PR_CH3

;	goto	CALCULATE_TIMER_RELOAD

	movf	PWM1_DS,W
	subwf	PWM2_DS,W
	btfss	STATUS,C
	goto	INTCHG_1_2
	goto	CHECK_2_3
INTCHG_1_2
;interchange duty cycles in 1 and 2
	movf	PWM1_DS,W
	movwf	ICH_TMP
	movf	PWM2_DS,W
	movwf	PWM1_DS
	movf	ICH_TMP,W
	movwf	PWM2_DS
;interchange the PWM outputs
	movf	PWM_PR_CH1,W
	movwf	ICH_TMP
	movf	PWM_PR_CH2,W
	movwf	PWM_PR_CH1
	movf	ICH_TMP,W
	movwf	PWM_PR_CH2

CHECK_2_3
;interchange duty cycles in 2 and 3
	movf	PWM2_DS,W
	subwf	PWM3_DS,W
	btfss	STATUS,C
	goto	INTCHG_2_3
	goto	CHECK_1_2_AGN
INTCHG_2_3
	movf	PWM2_DS,W
	movwf	ICH_TMP
	movf	PWM3_DS,W
	movwf	PWM2_DS
	movf	ICH_TMP,W
	movwf	PWM3_DS
;interchange the PWM outputs pins
	movf	PWM_PR_CH2,W
	movwf	ICH_TMP
	movf	PWM_PR_CH3,W
	movwf	PWM_PR_CH2
	movf	ICH_TMP,W
	movwf	PWM_PR_CH3

CHECK_1_2_AGN
;interchange duty cycles in 1 and 2
	movf	PWM1_DS,W
	subwf	PWM2_DS,W
	btfss	STATUS,C
	goto	INTCHG_1_2_AGN
	goto	CALCULATE_TIMER_RELOAD
INTCHG_1_2_AGN
	movf	PWM1_DS,W
	movwf	ICH_TMP
	movf	PWM2_DS,W
	movwf	PWM1_DS
	movf	ICH_TMP,W
	movwf	PWM2_DS
;interchange the PWM outputs pins
	movf	PWM_PR_CH1,W
	movwf	ICH_TMP
	movf	PWM_PR_CH2,W
	movwf	PWM_PR_CH1
	movf	ICH_TMP,W
	movwf	PWM_PR_CH2

CALCULATE_TIMER_RELOAD
	movlw	MAX_PWM_DUTY			;Corresponding to 8KHz count with Timer1 prescale 1:4
	movwf	PWM4_DS	
	movf	PWM3_DS,W	
	subwf	PWM4_DS,F
	movf	PWM2_DS,W	
	subwf	PWM3_DS,F
	movf	PWM1_DS,W	
	subwf	PWM2_DS,F

	RETURN	


;*******************************************************************************
;This routine checks for the keys status. 2 keys are checked, Run/Stop and 
;Forward(FWD)/Reverse(REV)  
;*******************************************************************************
;KEY_CHECK
;	btfss	KEY_PORT,RUN_STOP_KEY			;Is key pressed "RUN/STOP"?
;	goto	CHECK_FWD_REV_KEY
;	btfsc	FLAGS3,DEBOUNCE
;	return
;	call	KEY_DEBOUNCE
;	btfss	FLAGS3,DEBOUNCE
;	return
;	bsf	FLAGS3,KEY_RS
;	return
;	
;CHECK_FWD_REV_KEY
;	btfss	KEY_PORT,FWD_REV_KEY			;Is key pressed "RUN/STOP"?
;	goto	SET_KEYS
;	btfsc	FLAGS3,DEBOUNCE
;	return
;	call	KEY_DEBOUNCE
;	btfss	FLAGS3,DEBOUNCE
;	return
;	bsf	FLAGS3,KEY_FR
;	return

;SET_KEYS
;	btfss	FLAGS3,DEBOUNCE
;	return
;	bcf		FLAGS3,DEBOUNCE
;	bsf		FLAGS3,KEY_PRESSED	
;	btfss	FLAGS3,KEY_RS
;	goto	ITS_FWD_REV	
;	btfss	FLAGS3,RUN_STOP			;Toggle RUN_STOP bit
;	goto	$+3
;	bcf		FLAGS3,RUN_STOP
;	return
;	bsf		FLAGS3,RUN_STOP
;	return

;ITS_FWD_REV	
;	btfss	FLAGS3,FWD_REV			;Toggle RUN_STOP bit
;	goto	$+3
;	bcf		FLAGS3,FWD_REV
;	return
;	bsf		FLAGS3,FWD_REV
;	return

;*******************************************************************************
;KEY_DEBOUNCE
;	decfsz	DEBOUNCE_COUNTER,F		;Key debounce time checked
;	return
;	bsf		FLAGS3,DEBOUNCE
;	movlw	DEBOUNCE_COUNT
;	movwf	DEBOUNCE_COUNTER
;	return
;*******************************************************************************
;This routine takes action for the keys pressed
;If SW1(RUN/STOP) Key is pressed, the state toggles between RUN and STOP
;If SW2(FWD/REV) Key is pressed, the state toggles between FORWARD and REVERSE
;PROCESS_KEY_PRESSED
;	btfss	FLAGS3,KEY_PRESSED			;Is there a key press waiting?
;	return
;	btfss	FLAGS3,KEY_RS				;Is it RUN/STOP?
;	goto	CHECK_FWD_REV
;	btfss	FLAGS3,RUN_STOP				;Yes,Was the previous state a Stop?
;	goto	STOP_MOTOR_NOW
;	call	RUN_MOTOR_AGAIN				;Yes, Then RUN the motor 
;	bcf	FLAGS3,KEY_PRESSED			;Clear the Flag
;	bcf	FLAGS3,KEY_RS
;	bsf		LED_PORT,RUN_STOP_LED		;Turn on LED to indicate motor running	
;	return

;STOP_MOTOR_NOW							
;	call	STOP_MOTOR					;Was the previous state a RUN?, Then stop the motor
;	bcf		FLAGS3,KEY_PRESSED
;	bcf		FLAGS3,KEY_RS
;	bcf		LED_PORT,RUN_STOP_LED		;Clear Flags and indicate motor stopped on LED
;	return


;CHECK_FWD_REV
;	btfss	FLAGS3,KEY_FR				;Is the Key pressed = FWD/REV?
;	return
;
;	btg		LED_PORT,FWD_REV_LED		;Yes,
;	bcf		LED_PORT,RUN_STOP_LED	
;	call	STOP_MOTOR					;Stop the motor before reversing

;	call	BIG_DELAY					;Delay between reversing the direction
;	call	BIG_DELAY

;	call	RUN_MOTOR_AGAIN				;Run the motor in Reverse direction
;	bcf	FLAGS3,KEY_PRESSED			;Clear Flags
;	bcf	FLAGS3,KEY_FR
;	bsf		LED_PORT,RUN_STOP_LED	
;	return


;*******************************************************************************
;THIS ROUTINE STOPS THE MOTOR BY DRIVING THE PWMS TO 0% DUTY CYCLE. ALSO DISABLE
;SELECT INTERRUPT TO MAINTAIN STOP CONDITION OF MOTOR
;*******************************************************************************
STOP_MOTOR
	movlw	b'00000111'	;Turn off PWM1,3,5 PWMs(active low) at the beginning of the cycle
	movwf	PWM_PORT_H	;& turn on PWM0,2,4
	movlw	b'01110000'
	movwf	PWM_PORT_L
	bsf	STATUS,RP0	
	bcf	PIE1,TMR1IE
	bcf	PIE1,ADIE
	bcf	STATUS,RP0
	bcf	INTCON,T0IE
	bcf	OFFSET_FLAGS,MOTOR_FREQ_COUNTER
	clrf	TABLE_OFFSET1
	clrf	TABLE_OFFSET2
	clrf	TABLE_OFFSET3
	bcf	FLAGS3,RUN_STOP

;	bcf		PORT_RELAY,RELAY_BIT
	RETURN
;*******************************************************************************
;THIS ROUTINE STARTS MOTOR FROM PREVIOUS STOP WITH MOTOR PARAMETERS INITIALIZED
;*******************************************************************************
RUN_MOTOR_AGAIN
	call	INIT_MOTOR_PARAMETERS
	bsf	STATUS,RP0
	bsf	PIE1,TMR1IE
	bcf	STATUS,RP0
	bsf	INTCON,T0IE
	bsf	FLAGS3,RUN_STOP
	RETURN

;*******************************************************************************
;THIS ROUTINE INITIALIZES THE PARAMETERS REQUIRED FOR MOTOR INITIALIZATION.
;*******************************************************************************
INIT_MOTOR_PARAMETERS
#ifdef PSC_MOTOR_CONTROL

	movlw	0X012				;INITIALIZE THE TABLE OFFSET TO 3 REGISTERS
	movwf	TABLE_OFFSET1			;TO FORM 0-180-90 DEGREES

	movlw	0X00
	movwf	TABLE_OFFSET2
	
	movlw	0X08
	movwf	TABLE_OFFSET3
	
	bcf	OFFSET_FLAGS,OFFSET1_FLAG		;OFFSET FLAGS INITIALIZATION
	bsf	OFFSET_FLAGS,OFFSET2_FLAG

	btfsc	FLAGS3,FWD_REV	
	goto	INIT_MOT_REV
	bsf	OFFSET_FLAGS,OFFSET3_FLAG		;Offset3 initialized  
	goto	INIT_MOT_FREQ
INIT_MOT_REV
	bcf		OFFSET_FLAGS,OFFSET3_FLAG
#endif
#ifndef PSC_MOTOR_CONTROL		; THREE_PHASE_MOTOR_CONTROL
	movlw	0x09			;Initialize the table offset to 3 registers
	movwf	TABLE_OFFSET1		;to form 0-120-240 degrees
	bsf	OFFSET_FLAGS,OFFSET1_FLAG	;Offset flags initialization

	btfsc	FLAGS3,DIR_FWD	
	goto	INIT_MOT_REV

	movlw	0x03
	movwf	TABLE_OFFSET2
	bcf	OFFSET_FLAGS,OFFSET2_FLAG

	movlw	0x0F
	movwf	TABLE_OFFSET3
	bcf	OFFSET_FLAGS,OFFSET3_FLAG
	goto	INIT_MOT_FREQ

INIT_MOT_REV
	movlw	0x0F
	movwf	TABLE_OFFSET2
	bcf	OFFSET_FLAGS,OFFSET2_FLAG

	movlw	0x03
	movwf	TABLE_OFFSET3
	bcf	OFFSET_FLAGS,OFFSET3_FLAG

#endif

INIT_MOT_FREQ
	movlw	0XB1
	movwf	TMR0
	bsf		OFFSET_FLAGS,MOTOR_FREQ_COUNTER
	RETURN

;*******************************************************************************
;ROUTINE FOR 8*8 BIT MULTIPLICAION
;*******************************************************************************
MUL_8X8   
	clrf    RESULT_MSB
	clrf    RESULT_LSB
	movf    NEW_FREQ,W	        	;MOVE THE MULTIPLICAND TO W REG.
	bcf     STATUS,C    			;CLEAR THE CARRY BIT IN THE STATUS REG.
	MULT    0
	MULT    1
	MULT    2
	MULT    3
	MULT    4
	MULT    5
	MULT    6
	MULT    7
	RETLW   0

;*******************************************************************************
;UPON INITIALIZATION THE SINE TABLE CONTENTS ARE COPIED TO THE RAM FROM 
;PROGRAM MEMORY 
;*******************************************************************************
COPY_TABLE_TO_RAM
	BANKSEL		SINE_TABLE_RAM
	BANKISEL	SINE_TABLE_RAM
	movlw	LOW SINE_TABLE_RAM
	movwf	FSR
	movlw	SINE_TABLE_ENTRIES
	movwf	TEMP_LOC
	clrf	TEMP_LOC_1
COPY_AGAIN
	movlw	HIGH	SINE_TABLE
	movwf	PCLATH	
	movf	TEMP_LOC_1,W
	call	SINE_TABLE
	movwf	INDF
	INCF	TEMP_LOC_1,F
	INCF	FSR,F
	DECFSZ	TEMP_LOC,F
	goto	COPY_AGAIN

	movlw	LOW	SINE_TABLE_RAM		;FSR POINTS TO THE STARTING OF THE TABLE
	movwf	FSR
	RETURN		

;*******************************************************************************
;GENERAL PURPOSE DELAY ROUTINE - PRESENT DELAY TIME ~38msec
;*******************************************************************************
DELAY
	movlw	DELAY_COUNT1
	movwf	TEMP_LOC
DEC_TEMP_LOC
	movlw	DELAY_COUNT2
	movwf	TEMP_LOC_1
DEC_TEMP_LOC_1
	DECFSZ	TEMP_LOC_1,F
	goto	DEC_TEMP_LOC_1
	DECFSZ	TEMP_LOC,F
	goto	DEC_TEMP_LOC
	RETURN	

B_DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	return

BIG_DELAY
	call	B_DELAY
	call	B_DELAY
	call	B_DELAY
	call	B_DELAY
	return

;*******************************************************************************
;EQUATION USED FOR CALCULATION OF SINE TABLE ENTRIES = (SIN(ANGLE)+1)*FF/2
;Sine table has value corresponding to every 10 electrical degrees
;*******************************************************************************
TABLE	CODE	0X0005
SINE_TABLE
	addwf	PCL,F

	RETLW	.2	
	RETLW	.4	
	RETLW	.8		
	RETLW	.16		
	RETLW	.24		
	RETLW	.34		
	RETLW	.50		
	RETLW	.64		
	RETLW	.80		
	RETLW	.96		
	RETLW	.112	
	RETLW	.128	
	RETLW	.144	
	RETLW	.156	
	RETLW	.168	
	RETLW	.178	
	RETLW	.184	
	RETLW	.188	
	RETLW	.190	

	END
