VERSION 5.00
Begin VB.UserControl VRLogSlider 
   ClientHeight    =   5025
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   915
   FillColor       =   &H00FFFFFF&
   FontTransparent =   0   'False
   ForwardFocus    =   -1  'True
   ScaleHeight     =   5025
   ScaleWidth      =   915
   Begin VB.PictureBox imgSlider 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   135
      Left            =   0
      Picture         =   "VRLogSlider.ctx":0000
      ScaleHeight     =   135
      ScaleWidth      =   285
      TabIndex        =   4
      Top             =   2760
      Width           =   285
   End
   Begin VB.TextBox txtDummy 
      Height          =   315
      Left            =   4560
      TabIndex        =   0
      Text            =   "Dummy hide focus"
      Top             =   6840
      Width           =   1515
   End
   Begin VB.PictureBox picTicks 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H8000000A&
      BorderStyle     =   0  'None
      ClipControls    =   0   'False
      FillStyle       =   0  'Solid
      FontTransparent =   0   'False
      ForeColor       =   &H80000006&
      Height          =   4785
      Left            =   240
      ScaleHeight     =   4785
      ScaleWidth      =   180
      TabIndex        =   3
      Top             =   120
      Width           =   180
   End
   Begin VB.Shape Axis 
      BackColor       =   &H80000010&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H80000010&
      BorderStyle     =   0  'Transparent
      FillColor       =   &H00808080&
      FillStyle       =   0  'Solid
      Height          =   4815
      Left            =   135
      Top             =   120
      Width           =   75
   End
   Begin VB.Label lblMin 
      Alignment       =   2  'Center
      Caption         =   "Label1"
      Height          =   195
      Left            =   360
      TabIndex        =   1
      Top             =   4800
      Width           =   615
   End
   Begin VB.Label lblMax 
      Alignment       =   2  'Center
      Caption         =   "Label2"
      Height          =   195
      Left            =   360
      TabIndex        =   2
      Top             =   15
      Width           =   615
   End
   Begin VB.Shape AxisHighlight 
      BackStyle       =   1  'Opaque
      BorderColor     =   &H80000005&
      BorderStyle     =   0  'Transparent
      FillColor       =   &H00FFFFFF&
      FillStyle       =   0  'Solid
      Height          =   4815
      Left            =   120
      Top             =   120
      Width           =   105
   End
End
Attribute VB_Name = "VRLogSlider"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' NOTE that the axis and value properties are constant unity scaling.
' The scaling property adjusts the displayed values only not the core properties.

Private minVal As Double        'this is the scaled local units
Private maxVal As Double        'this is the scaled local units
Private flgLogAxis As Boolean
Private dblCurValue As Double   'this is the scaled local units
Private dblScale As Double      'scaling in and out for user

Public Event ValChange(ByVal newVal As Double)      'this is any change
Public Event UserCursorMove(ByVal newVal As Double) 'this is when user moves cursor

Public Property Let MinValue(ByVal Value As Double)
    minVal = Value * dblScale
    lblMin = minVal
    DrawTicks picTicks, minVal, maxVal
    PutSliderAtValue dblCurValue
End Property

Public Property Get MinValue() As Double
    MinValue = minVal / dblScale
End Property



Public Property Let MaxValue(ByVal Value As Double)
    maxVal = Value * dblScale
    lblMax = maxVal
    DrawTicks picTicks, minVal, maxVal
    PutSliderAtValue dblCurValue
End Property

Public Property Get MaxValue() As Double
    MaxValue = maxVal / dblScale
End Property



Public Property Let logAxis(ByVal flg As Boolean)
    flgLogAxis = flg
    DrawTicks picTicks, minVal, maxVal
    PutSliderAtValue dblCurValue
End Property

Public Property Get logAxis() As Boolean
    logAxis = flgLogAxis
End Property

Public Property Let Value(ByVal newVal As Double)
    PutSliderAtValue newVal * dblScale
End Property

Public Property Get Value() As Double
    Value = dblCurValue / dblScale
End Property


Public Property Let ScaleFactor(ByVal val As Double)
    minVal = minVal / dblScale          'reset to core units
    maxVal = maxVal / dblScale
    dblCurValue = dblCurValue / dblScale
    
    dblScale = val
    
    minVal = minVal * dblScale          'rescale axis and current position
    maxVal = maxVal * dblScale
    DrawTicks picTicks, minVal, maxVal
    PutSliderAtValue dblCurValue * dblScale
End Property

Public Property Get ScaleFactor() As Double
    ScaleFactor = dblScale
End Property

Private Sub picTicks_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    PutSliderAtX picTicks.Top + Y
End Sub

Private Sub picTicks_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        PutSliderAtX picTicks.Top + Y
    End If
End Sub

'Private Sub txtCurValue_KeyDown(KeyCode As Integer, Shift As Integer)
'    On Error GoTo errHandler
'
'    If KeyCode = vbKeyReturn Then
'        PutSliderAtValue CDbl(txtCurValue.Text)
'        RaiseEvent UserCursorMove(dblCurValue / dblScale)
'    End If
'errHandler:
'End Sub

Private Sub PutSliderAtValue(newVal As Double)
    Dim X As Double
    On Error GoTo errHandler
    
    dblCurValue = newVal
    X = dblCurValue
    If X < minVal Then X = minVal
    If X > maxVal Then X = maxVal
    
    If flgLogAxis Then
        PositionSlider ((Axis.Top + Axis.Height) - ((log10(X) - log10(minVal)) / _
                            (log10(maxVal) - log10(minVal)) * Axis.Height))
    Else
        PositionSlider ((Axis.Top + Axis.Height) - ((X - minVal) / _
                            (maxVal - minVal) * Axis.Height))
    End If
errHandler:
End Sub


Private Sub UserControl_Initialize()
    flgLogAxis = True
    dblScale = 1
    minVal = 0.1
    maxVal = 240
    lblMin = minVal
    lblMax = maxVal
End Sub



Private Sub usercontrol_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    PutSliderAtX Y
End Sub


Private Sub usercontrol_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If Button = 1 Then
        PutSliderAtX Y
    End If
End Sub


Private Sub imgSlider_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If Button = 1 Then
        PutSliderAtX imgSlider.Top + Y
    End If
End Sub


Private Sub PutSliderAtX(X)
    PositionSlider X
    If flgLogAxis Then
        dblCurValue = 10 ^ (log10(minVal) + (((Axis.Height + Axis.Top) - X) / _
                        Axis.Height * (log10(maxVal) - log10(minVal))))
    Else
        dblCurValue = minVal + (((Axis.Height + Axis.Top) - X) / _
                        Axis.Height * (maxVal - minVal))
    End If

    RaiseEvent UserCursorMove(dblCurValue / dblScale)
    
End Sub

Private Sub PositionSlider(X)       'position at x twip in Form
    If X < Axis.Top Then X = Axis.Top
    If X > Axis.Top + Axis.Height Then X = Axis.Top + Axis.Height
    
    imgSlider.Top = X - imgSlider.Height / 2 + 5
    'txtCurValue.Top = X - txtCurValue.Height / 2
    'txtCurValue = MyFormat(dblCurValue, 4)
    RaiseEvent ValChange(dblCurValue / dblScale)
    
End Sub

Private Sub UserControl_Resize()
    UserControl.Width = 800
    Axis.Height = UserControl.Height - 200
    AxisHighlight.Height = Axis.Height
    picTicks.Height = Axis.Height + 20
    DrawTicks picTicks, minVal, maxVal
    lblMax.Top = Axis.Top - lblMax.Height / 2
    lblMin.Top = Axis.Top + Axis.Height - lblMin.Height / 2
    PutSliderAtValue dblCurValue
End Sub


Private Sub DrawTicks(pic As PictureBox, Xmin As Double, Xmax As Double)
    Dim i, j, X
    pic.Cls
    For i = Int(log10(Xmin) + 0.5) To Int(log10(Xmax) + 0.5)
        For j = 10 ^ i To 10 ^ (i + 1) Step 10 ^ i
            X = (log10(j) - log10(Xmin)) / (log10(Xmax) - log10(Xmin)) * (pic.ScaleHeight - 15)
            pic.Line (0, (picTicks.Height - X))-(pic.ScaleWidth / 2, picTicks.Height - X)
        Next j
        
        X = (i - log10(Xmin)) / (log10(Xmax) - log10(Xmin)) * (pic.ScaleHeight - 15)
        pic.Line (0, picTicks.Height - X)-(pic.ScaleWidth, picTicks.Height - X)
    Next i
End Sub


Private Function MyFormat(num, nSig) As String
'format to nsig significant digits
'Create either general or 0.000E+00 to suit num value

Dim strForm, i

strForm = "0."
'If flgEuro Then strForm = "0," 'euro decimal separator
For i = 2 To nSig
    strForm = strForm & "0"
Next
strForm = strForm & "E+00"

If num = 0 Then
    MyFormat = "0"
ElseIf Abs(num) >= 10 ^ nSig Or Abs(num) < 10 ^ -(nSig - 2) Then
    MyFormat = Format(num, strForm)
Else
    MyFormat = Round(num, nSig - 1 - Int(Log(Abs(num)) / Log(10)))
End If
    
End Function



Private Function log10(N)
    log10 = Log(N) / Log(10)
End Function


