VERSION 5.00
Object = "{852E65AD-72F8-11CF-840E-444553540000}#1.1#0"; "MIDIIO32.OCX"
Object = "{A6BACF28-53A3-4B27-A3A4-8EFDDB7F09D6}#1.0#0"; "fsled.ocx"
Begin VB.Form BCF 
   BackColor       =   &H00400000&
   Caption         =   "BCF2000 Control"
   ClientHeight    =   2850
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4515
   Icon            =   "BCF2000.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   2850
   ScaleWidth      =   4515
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Pannel_Inc 
      Height          =   495
      Left            =   2640
      Picture         =   "BCF2000.frx":030A
      Style           =   1  'Graphical
      TabIndex        =   8
      ToolTipText     =   "Next Channels"
      Top             =   1680
      Width           =   495
   End
   Begin VB.CommandButton Pannel_Dec 
      Height          =   495
      Left            =   1440
      Picture         =   "BCF2000.frx":0614
      Style           =   1  'Graphical
      TabIndex        =   7
      ToolTipText     =   "Previous Channels"
      Top             =   1680
      Width           =   495
   End
   Begin VB.TextBox Text3 
      Height          =   495
      Left            =   1440
      TabIndex        =   6
      Text            =   "Text3"
      Top             =   1200
      Width           =   1695
   End
   Begin FreeStylerLed.Led Led1 
      Height          =   255
      Index           =   0
      Left            =   3120
      Top             =   4080
      Width           =   255
      _ExtentX        =   450
      _ExtentY        =   450
      Value           =   0   'False
   End
   Begin VB.CommandButton Exit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   1200
      TabIndex        =   3
      Top             =   4080
      Width           =   1215
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Clear Desk"
      Height          =   495
      Left            =   1200
      TabIndex        =   2
      Top             =   4800
      Width           =   1215
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00FFFF80&
      Height          =   375
      Left            =   1440
      TabIndex        =   1
      Text            =   "Text2"
      Top             =   360
      Width           =   2295
   End
   Begin MidiioLib.MIDIOutput MIDIOutput1 
      Left            =   1320
      Top             =   5640
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      DeviceID        =   -1
      VolumeLeft      =   65535
      VolumeRight     =   65535
   End
   Begin MidiioLib.MIDIInput MIDIInput1 
      Left            =   720
      Top             =   5640
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      MessageEventEnable=   -1  'True
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   360
      TabIndex        =   0
      Text            =   "0"
      Top             =   360
      Width           =   855
   End
   Begin FreeStylerLed.Led Led1 
      Height          =   255
      Index           =   1
      Left            =   3120
      Top             =   4800
      Width           =   255
      _ExtentX        =   450
      _ExtentY        =   450
      Value           =   0   'False
   End
   Begin VB.Label Label2 
      BackColor       =   &H00400000&
      Caption         =   "BCF Function"
      ForeColor       =   &H8000000E&
      Height          =   615
      Left            =   1440
      TabIndex        =   9
      Top             =   960
      Width           =   1335
   End
   Begin VB.Label Label1 
      Caption         =   "Foot Switch 2"
      Height          =   255
      Left            =   2760
      TabIndex        =   5
      Top             =   5040
      Width           =   1095
   End
   Begin VB.Label F 
      Caption         =   "Foot Switch 1"
      Height          =   255
      Left            =   2760
      TabIndex        =   4
      Top             =   4320
      Width           =   1095
   End
End
Attribute VB_Name = "BCF"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim encoder_group As Integer
Dim fader_group As Integer

Dim Led(32) As Boolean
Dim Encoder(32) As Integer
Dim BCF_flag(10) As Boolean
Dim BCF_Status_Text(8) As String

Private Sub exit_Click()
    Unload Me
End Sub

Private Sub Form_Load()
                                   
                                  ' Status
BCF_Status_Text(0) = " Not Connected"  ' 0
BCF_Status_Text(1) = " Main Desk"      ' 1
BCF_Status_Text(2) = " Playback Desk"  ' 2
BCF_Status_Text(3) = " Chase Desk"     ' 3
BCF_Status_Text(4) = " Channel Set"    ' 4
BCF_Status_Text(5) = " Submix Set"     ' 5
BCF_Status_Text(6) = " User Config"    ' 6

'For i = 0 To 6
'    BCF_Mode.AddItem BCF_Status_Text(i)
'Next i
Call Redraw

End Sub

Private Sub Redraw()

Pannel_Dec.Enabled = True
Pannel_Inc.Enabled = True

Text3.Text = BCF_Status_Text(BCF_Status)
If BCF_Status = 1 Then Pannel_Dec.Enabled = False
If BCF_Status = 6 Then Pannel_Inc.Enabled = False

End Sub
Public Sub Connect_BCF()
Dim i As Integer, xx As Integer, yy As Integer, xxx As Integer
    Dim BCF_ok1, BCF_ok2 As Boolean
   
    
    ' Connect Midi Output
    '
    BCF_ok1 = False
    BCF_ok2 = False
    
    yy = 0
    For i = -1 To MIDIOutput1.DeviceCount - 1
        MIDIOutput1.DeviceID = i
        If Left$(MIDIOutput1.ProductName, 7) = "BCF2000" Then
            yy = i + 0
            BCF_ok1 = True
            OutputName = MIDIOutput1.ProductName
        End If
                
    Next
    '
    ' Connect Midi Input
    '
    outputport = yy
    
    '
    xx = 0
    For i = 0 To MIDIInput1.DeviceCount - 1
        MIDIInput1.DeviceID = i
        
        If Left$(MIDIInput1.ProductName, 7) = "BCF2000" Then
            xx = i + 1
            BCF_ok2 = True
            InputName = MIDIInput1.ProductName
        End If
    Next
    '
    ' Select first in list or last driver used
    '
    inputport = xx
    'ComboMidiIn.ListIndex = xx
    If BCF_ok1 = True And BCF_ok2 = True Then
        Text2 = " BCF2000 Connection Made "
        BCF_configure.Text1 = " Connection Made"
        BCF_Status = 1
        Call Redraw
        xxx = ChooseMIDI
        fader_group = 0
        encoder_group = 0
    Else
        Text2 = " No BCF2000 Found"
        BCF_configure.Text1 = " No BCF2000 Found"
        BCF_Status = 0
        Call Redraw
    End If

    

End Sub

Public Sub BCF_Encoder(Index As Integer, Level As Integer)

        If MIDIOutput1.State = MIDISTATE_OPEN Then
            MIDIOutput1.Message = 176
            MIDIOutput1.Data1 = 1 + Index
            MIDIOutput1.Data2 = (Level / 2)
            MIDIOutput1.Action = MIDIOUT_SEND
            'Text1.Text = Form1.Text1.Text & " Out- " & Hex$(Form1.MIDIOutput1.Message) & " " & Hex$(Form1.MIDIOutput1.Data1) & " " & Hex$(Form1.MIDIOutput1.Data2) & vbCrLf
    End If
End Sub

Public Sub BCF_Button(ByVal Index As Integer, Status As Boolean)

     If fader_group = 0 And Index >= 0 And Index < 16 Then
        If Status = True Then
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 127)
        Else
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 0)
        End If
    End If
    
    If fader_group = 1 And Index >= 16 And Index <= 32 Then
        If Status = True Then
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 127)
        Else
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 0)
        End If
    End If
    
    If fader_group = 2 And Index >= 32 And Index <= 48 Then
        If Status = True Then
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 127)
        Else
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 0)
        End If
    End If
    
    If fader_group = 3 And Index >= 48 And Index < 64 Then
        If Status = True Then
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 127)
        Else
            Call Midi_Tx(65 + (Index - (fader_group * 8)), 0)
        End If
    End If

End Sub
Public Sub BCF_Fader(ByVal Index As Integer, ByVal Level As Integer)

    If fader_group = 0 And Index >= 0 And Index <= 7 Then
        If BCF_flag(Index - (fader_group * 8)) = False Then
            Call Midi_Tx(81 + (Index - (fader_group * 8)), Level \ 2)
        End If
        BCF_flag(Index - (fader_group * 8)) = False
    End If
    
    If fader_group = 1 And Index >= 8 And Index <= 15 Then
        If BCF_flag(Index - (fader_group * 8)) = False Then
            Call Midi_Tx(81 + (Index - (fader_group * 8)), Level \ 2)
        End If
        BCF_flag(Index - (fader_group * 8)) = False
    End If
    
    If fader_group = 2 And Index >= 16 And Index <= 23 Then
        If BCF_flag(Index - (fader_group * 8)) = False Then
            Call Midi_Tx(81 + (Index - (fader_group * 8)), Level \ 2)
        End If
        BCF_flag(Index - (fader_group * 8)) = False
    End If
    
    If fader_group = 3 And Index >= 24 And Index < 32 Then
        If BCF_flag(Index - (fader_group * 8)) = False Then
            Call Midi_Tx(81 + (Index - (fader_group * 8)), Level \ 2)
        End If
        BCF_flag(Index - (fader_group * 8)) = False
    End If
End Sub

'Private Sub Fader_Midi_Out()
'    If BCF_flag(Index) = False Then
             'call midi_tx(81+index,
'            If MIDIOutput1.State = MIDISTATE_OPEN Then
'                MIDIOutput1.Message = 176
'                MIDIOutput1.Data1 = 81 + Index
'                MIDIOutput1.Data2 = 128 - Scroller1(Index).Value
'                MIDIOutput1.Action = MIDIOUT_SEND
               'Text1.Text = Form1.Text1.Text & " Out- " & Hex$(Form1.MIDIOutput1.Message) & " " & Hex$(Form1.MIDIOutput1.Data1) & " " & Hex$(Form1.MIDIOutput1.Data2) & vbCrLf
'            End If
            
'    End If
    
'    BCF_flag(Index) = False
    
'End Sub

Private Sub MIDIInput1_Error(ErrorCode As Integer, ErrorMessage As String)
   If (ErrorCode <> 0) And (ErrorCode <> 8) Then
      MsgBox ErrorMessage
      BCF_Status = 0
      Call Redraw
    End If
End Sub

Private Sub MIDIInput1_Message()
    Dim InMessage As Integer
    Dim Indata1 As Integer
    Dim Indata2 As Integer
    Dim xx As Integer, yy As Integer, zz As Integer
    Dim xcol As Long, rst As String

    ' Process all notes on input queue
    Do While MIDIInput1.MessageCount > 0
        DoEvents
        InMessage = MIDIInput1.Message
        Indata1 = MIDIInput1.Data1
        Indata2 = MIDIInput1.Data2
        DoEvents
        
        MIDIInput1.Action = MIDIIN_REMOVE
        DoEvents
        yy = InMessage And &HF ' yy = channel
        
        DoEvents
        If BCF_Status = 1 Then
            ' Code for Main Desk *************************************************************
           
            Select Case Indata1
            'Rotary Encoders - Value
            Case 1 To 32
            
                'Encoder(InData1 - 1) = 128 - val(InData2)
            
                'RotaryEncoder1(InData1 - 1).Value = (128 - val(InData2)) * 5
                'If InData1 > (encoder_group * 8) And InData1 < ((encoder_group + 1) * 8) Then
                'RotaryEncoder1((InData1 - 1) - (encoder_group * 8)).Value = Encoder(InData1 - 1) * 5
                'End If
                 
            'Rotary Encoders - Pushed
            Case 33 To 64
            
                If Indata2 < 64 Then
                    Text1.Text = val(Indata1 - 33) & " Off"
                Else
                    Text1.Text = val(Indata1 - 33) & " On"
                End If
                   
            ' Push Buttons - Push
            Case 65 To 80
                If Indata2 < 64 Then
                
                    Text1.Text = val(Indata1 - 65) & " Off"
                Else
                    Text1.Text = val(Indata1 - 65) & " On"
                End If
                       
            ' Faders
            Case 81 To 88
            
                    Main_Faders(Indata1 - 81 + (fader_group * 8)) = (val(Indata2)) * 2
            
                    BCF_flag(Indata1 - 81) = True
                    Call Hoofdblad.Redraw
                    'Scroller1(InData1 - 81).Value = 128 - val(InData2)
            'End If
            
            ' 4 Push Buttons - Push
            ' Change Fader Group !
            Case 89 To 92
            
                If Indata2 < 64 Then
                    
                    Text1.Text = val(Indata1 - 89) & " Off"
                Else
                    fader_group = Indata1 - 89
                    For i = 0 To 3  ' Clear other buttons
                        If i <> Indata1 - 89 Then
                            Call Midi_Tx(i + 89, 0)
                        End If
                    Next i
                    ' setup faders with new values
                    For i = 0 To 7
                        Call Midi_Tx(81 + i, (Main_Faders(i + (fader_group * 8)) / 2) - 1)
                    Next i
                        
                    Text1.Text = val(Indata1 - 89) & " On"
                End If
            'End If
        
            ' Foot switches
            Case 93, 94
            
                If Indata2 < 64 Then
                
                    Text1.Text = val(Indata1 - 93) & " Off"
                Else
                
                    Text1.Text = val(Indata1 - 93) & " On"
                End If
                    
            End Select
        End If
        
        If BCF_Status = 2 Then
            ' Code for Playback Desk *************************************************************
           
            Select Case Indata1
            'Rotary Encoders - Value
            Case 1 To 32
            
                'Encoder(InData1 - 1) = 128 - val(InData2)
            
                'RotaryEncoder1(InData1 - 1).Value = (128 - val(InData2)) * 5
                'If InData1 > (encoder_group * 8) And InData1 < ((encoder_group + 1) * 8) Then
                'RotaryEncoder1((InData1 - 1) - (encoder_group * 8)).Value = Encoder(InData1 - 1) * 5
                'End If
                 
            'Rotary Encoders - Pushed
            Case 33 To 64
            
                If Indata2 < 64 Then
                    Text1.Text = val(Indata1 - 33) & " Off"
                Else
                    Text1.Text = val(Indata1 - 33) & " On"
                End If
                   
            ' Push Buttons - Push
            Case 65 To 80
                If Indata2 < 64 Then
                    Button_Status(Indata1 - 65) = False
                    Text1.Text = val(Indata1 - 65) & " Off"
                    If Button(Indata1 - 65).Function = 2 Then ' Setup Chase
                        Call Playdesk.Chase_Select(Button(Indata1 - 65).Number, 0)
                    End If
                Else
                    Button_Status(Indata1 - 65) = True
                    Text1.Text = val(Indata1 - 65) & " On"
                    If Button(Indata1 - 65).Function = 2 Then ' Setup Chase
                        Call Playdesk.Chase_Select(Button(Indata1 - 65).Number, 255)
                    End If
                End If
                Call Playdesk.Redraw
                Call Playdesk.setup_Output
                
            ' Faders
            Case 81 To 88
                    J = (Indata1 - 81) + (fader_group * 8)
                    Sub_Faders(J) = (val(Indata2)) * 2
                    
                    If Fader(J).Function = 2 Then ' Setup Chase
                        If val(Indata2) > 5 Then           ' Setup Chase
                            Call Playdesk.Chase_Select(Fader(J).Number, val(Indata2) * 2)
                        Else
                            Call Playdesk.Chase_Select(Fader(J).Number, 0)
                        End If
                    End If
                    BCF_flag(Indata1 - 81) = True
                    
                    Call Playdesk.Redraw
                    Call Playdesk.setup_Output
                    
                        
            ' 4 Push Buttons - Push
            ' Change Fader Group !
            Case 89 To 92
                
                If Indata2 < 64 Then
                    
                    Text1.Text = val(Indata1 - 89) & " Off"
                Else
                    fader_group = Indata1 - 89
                    For i = 0 To 3  ' Clear other buttons
                        If i <> Indata1 - 89 Then
                            Call Midi_Tx(i + 89, 0)
                        End If
                    Next i
                    ' setup faders with new values
                    For i = 0 To 7
                        Call Midi_Tx(81 + i, (Sub_Faders(i + (fader_group * 8)) / 2) - 1)
                    Next i
                        
                    Text1.Text = val(Indata1 - 89) & " On"
                End If
            Case 91 To 92
                If Indata2 < 64 Then
                    
                    Text1.Text = val(Indata1 - 89) & " Off"
                Else
                    Text1.Text = val(Indata1 - 89) & " On"
                End If
            
        
            ' Foot switches
            Case 93, 94
            
                If Indata2 < 64 Then
                
                    Text1.Text = val(Indata1 - 93) & " Off"
                Else
                
                    Text1.Text = val(Indata1 - 93) & " On"
                End If
                    
            End Select
        End If
        DoEvents
endinputloop: 'Do nothing - messy code!
    DoEvents
    Loop
End Sub

Public Sub Midi_Tx(Indata1 As Integer, Indata2 As Integer)
        ' Send Midi output to BCF
        
        If MIDIOutput1.State = MIDISTATE_OPEN Then
                MIDIOutput1.Message = 176
                MIDIOutput1.Data1 = Indata1
                MIDIOutput1.Data2 = Indata2
                MIDIOutput1.Action = MIDIOUT_SEND
         
        End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim xx As Integer

    If Me.MIDIInput1.State <> MIDISTATE_CLOSED Then
        MIDIInput1.Action = MIDIIN_STOP
        MIDIInput1.Action = MIDIIN_CLOSE
    End If
    If Me.MIDIOutput1.State <> MIDISTATE_CLOSED Then
        MIDIOutput1.Action = MIDIOUT_CLOSE
    End If
    'close all sub forms
'    For xx = Forms.Count - 1 To 1 Step -1
'        Unload Forms(xx)
'    Next xx
End Sub

Private Sub Pannel_Dec_Click()
    If BCF_Status > 1 Then
        BCF_Status = BCF_Status - 1
    End If
    
    Select Case BCF_Status
    Case Is = 1
        For i = 0 To 7
            Call Midi_Tx(81 + i, (Main_Faders(i + (fader_group * 8)) / 2) - 1)
        Next i
    Case Is = 2
        For i = 0 To 7
            Call Midi_Tx(81 + i, (Sub_Faders(i + (fader_group * 8)) / 2) - 1)
        Next i
    End Select

Call Redraw
    
End Sub

Private Sub Pannel_Inc_Click()
    If BCF_Status < 6 Then
        BCF_Status = BCF_Status + 1
    End If
    
    Select Case BCF_Status
    Case Is = 1
        For i = 0 To 7
            Call Midi_Tx(81 + i, (Main_Faders(i + (fader_group * 8)) / 2) - 1)
        Next i
    Case Is = 2
        For i = 0 To 7
            Call Midi_Tx(81 + i, (Sub_Faders(i + (fader_group * 8)) / 2) - 1)
        Next i
    End Select
    
    Call Redraw
End Sub
