Attribute VB_Name = "FileIO"
Declare Function GetSystemDirectory Lib "kernel32" _
    Alias "GetSystemDirectoryA" _
    (ByVal lpBuffer As String, _
     ByVal nSize As Long) As Long

Declare Function GetWindowsDirectory Lib "kernel32" _
    Alias "GetWindowsDirectoryA" _
    (ByVal lpBuffer As String, _
     ByVal nSize As Long) As Long

Public Function GetWindowsDir() As String
    Dim sDir As String * 255
    Dim iReturn As Integer
    Dim lSize As Long
    
    sDir = Space$(255)
    lSize = Len(sDir)
    iReturn = GetWindowsDirectory(sDir, lSize)
    
    GetWindowsDir = Left$(sDir, InStr(1, sDir, Chr$(0)) - 1)

End Function
Public Function GetSystemDir() As String
    Dim sDir As String * 255
    Dim iReturn As Integer
    Dim lSize As Long
    
    sDir = Space$(255)
    lSize = Len(sDir)
    iReturn = GetSystemDirectory(sDir, lSize)
    
    
    GetSystemDir = Left$(sDir, InStr(1, sDir, Chr$(0)) - 1)

End Function

Function FindNode(ByRef start As Long, String_In, Tag As String) As String
    '  return Text between start and finish of XML marks
    ' Return Null if not found
    
Dim strStartTag As String, strCloseTag As String
Dim Start_Pos As Long, End_Pos As Long

If start = 0 Then start = 1
strStartTag = "<" & Tag & ">"
strCloseTag = "</" & Tag & ">"

Start_Pos = InStr(start, String_In, strStartTag)
End_Pos = InStr(start, String_In, strCloseTag)
If Start_Pos > 0 And End_Pos > 0 Then
FindNode = Mid$(String_In, (Start_Pos + Len(strStartTag)), End_Pos - Start_Pos - Len(strStartTag))
Else
    FindNode = vbNullString
End If
    start = End_Pos + Len(strCloseTag)
End Function

Function FindNodeValue(ByRef start As Long, String_In, Tag As String) As Long
    '  return Number between start and finish of XML marks
    ' Return 0 if not found
    
Dim strStartTag As String, strCloseTag, string_temp As String
Dim Start_Pos As Long, End_Pos As Long

If start = 0 Then start = 1
strStartTag = "<" & Tag & ">"
strCloseTag = "</" & Tag & ">"

Start_Pos = InStr(start, String_In, strStartTag)
End_Pos = InStr(start, String_In, strCloseTag)
If Start_Pos > 0 And End_Pos > 0 Then
    string_temp = Mid$(String_In, (Start_Pos + Len(strStartTag)), End_Pos - Start_Pos - Len(strStartTag))
    If IsNumeric(string_temp) Then
        FindNodeValue = val(string_temp)
    Else
        FindNodeValue = 0
    End If
Else
    FindNodeValue = 0
End If
    start = End_Pos + Len(strCloseTag)
End Function

Function FindNodeData(ByRef start As Long, String_In As String, Tag As String, ByRef Data2 As Integer) As Integer
    '  return Number between start and finish of XML marks
    ' Return 0 if not found
    
Dim strStartTag As String, strCloseTag, string_temp As String
Dim Start_Pos As Long, End_Pos As Long, Split As Long

strStartTag = "<" & Tag & ">"
strCloseTag = "</" & Tag & ">"

Start_Pos = InStr(start, String_In, strStartTag)
End_Pos = InStr(start, String_In, strCloseTag)
If Start_Pos > 0 And End_Pos > 0 Then
    string_temp = Mid$(String_In, (Start_Pos + Len(strStartTag)), End_Pos - Start_Pos - Len(strStartTag))
    Split = InStr(string_temp, ":")
    start = End_Pos + Len(strCloseTag)
    
    If Split > 0 Then
        FindNodeData = val(Left$(string_temp, Split))
        'MsgBox right$(string_temp, Len(string_temp) - Split)
        Data2 = val(Right$(string_temp, Len(string_temp) - Split))
    Else
        FindNodeData = 0
        Data2 = 0
    End If
Else
    FindNodeData = 0
    Data2 = 0
End If

End Function

Public Function PsyVal(sdata As String, DefaultValue As Long) _
  As Long

'sData: = string data to convert
'DefaultValue = Number to return if conversion fails

'e.g., PsyVal("100", 150) = 100
'      PsyVal("100a", 150) = 150

Dim nSize As Long, nCount As Long
Dim multip As Integer
Dim nResult As Long, ntemp As Long

    PsyVal = DefaultValue
    If Len(sdata) = 0 Then Exit Function
    nResult = 0
    nCount = 1
    If Mid$(sdata, nCount, 1) = "-" Then
        multip = -1
        sdata = Right$(sdata, Len(sdata) - 1)
    Else
        If Mid$(sdata, nCount, 1) = "+" Then
            sdata = Right$(sdata, Len(sdata) - 1)
        End If
        multip = 1
    End If
    nSize = Len(sdata)
    Do
        On Error GoTo MayOverFlow
        If IsNumeric(Mid$(sdata, 1, 1)) Then
            If Mid$(sdata, 1, 1) <> 0 Then
                ntemp = val(Mid$(sdata, 1, 1))
                While nSize > 1
                    ntemp = ntemp * 10
                    nSize = nSize - 1
                Wend
                nResult = nResult + ntemp
            End If
            sdata = Right$(sdata, Len(sdata) - 1)
            nSize = Len(sdata)
        Else
            Exit Function
        End If
    Loop Until nSize = 0
    PsyVal = nResult * multip
    Exit Function

MayOverFlow:
    'donothing. Value already set

End Function

Sub ColorToRGB(ByVal Color As String, ByRef r As Integer, _
  ByRef g As Integer, ByRef b As Integer)

On Error GoTo Solution
Dim SStr As String
Dim sR As String, sB As String, sG As String
SStr = "000000" & Hex(Color)
SStr = Right(SStr, 6)
sB = "&H" & Mid(SStr, 1, 2): b = CInt(Format(sB))
sG = "&H" & Mid(SStr, 3, 2): g = CInt(Format(sG))
sR = "&H" & Mid(SStr, 5, 2): r = CInt(Format(sR))

Solution:
    If Err.Number <> 0 Then
        r = -1
        g = -1
        b = -1
    End If
End Sub
