int read_write_int(int addr, int value) {
  int r = (int)EEPROM.read(addr);
  if (r == 0)
    EEPROM.write(addr, value);
  else
    value = r;
  
  return value;
}

float read_write_float(int addr, float value) {
  float r = read_big_variable(addr) / 100.00;
  if (r == 0)
    write_float(addr, value);
  else
    value = r;
  
  return value;
}

long read_write_long(int addr, long value) {
  long r = read_big_variable(addr);
  if (r == 0)
    write_big_variable(addr, value);
  else
    value = r;
  
  return value;
}

bool read_write_bool(int addr, bool value) {
  int r = (int)EEPROM.read(addr);
  if (r == 0)
    write_bool(addr, value);
  else
    value = (bool)(r-1);
  
  return value;
}

void write_float(int address, float variable) {
  
  write_big_variable(address, variable*100);
  
}

void write_bool(int address, bool variable) {
  
  EEPROM.write(address, ((int)variable) + 1);
    
}

// FUNCTIONS TO WRITE AND READ LONG VARIABLES FROM EEPROM //

void write_big_variable(int address, long variable) {
  long n = pow(2, 23);
  
  for (int j = 0; j<3; j++) {
    int value = 0;
    int n1 = 128;
    
    for (int i = 0; i < 8; i++) {
      if (variable >= n) {
        value += n1;
        variable -= n;
      }
      
      n /= 2;
      n1 /= 2;
    }
    
    EEPROM.write(address+j, value);
  }
  
}

long read_big_variable(int address) {
  
  long value = 0;
  long n = pow(2, 23);
  
  for (int j = 0; j<3; j++) {
    int n1 = 128;
    int variable = (int)EEPROM.read(address+j);
    
    for (int i = 0; i<8; i++) {
      if (variable >= n1) {
        value += n;
        variable -= n1;
      }
      
      n /= 2;
      n1 /= 2;
    }
  }
  
  return value;
  
}
