// ALL FUNCTIONS USED WHEN YOU PRESS A BUTTON WHILE IN SETTINGS //

// 3 BUTTON //
void subtract() { 
  
  switch (menuPos1) {
    
    case 0: // LIGHT
    
      switch (menuPos2) {
        
        case 0: // MODE
          newAutoMode = !newAutoMode;
          break;
          
        case 1: // DAWN START
          switch (blinkPos) {  
            case 0: // HOUR
              set_variable(&newHourDawn, 23);
              break;
            case 1: // MIN
              set_variable(&newMinDawn, 59);
              break;
          }
          break;
          
        case 2: // DAWN DURATION
          switch (blinkPos) {
            case 0: // HOUR
              newDawnDuration -= 3600;
              if (newDawnDuration < 0)
                newDawnDuration += 86400;
              break;
            case 1: // MIN
              {
              int value_ = newDawnDuration%3600;
              newDawnDuration -= value_;
              value_ -= 60;
              if (value_ < 0)
                value_ += 3600;
              newDawnDuration += value_;
              }
              break;
            case 2: // SEC
              {
              int value_ = newDawnDuration%60;
              newDawnDuration -= value_;
              value_--;
              if (value_ < 0)
                value_ += 60;
              newDawnDuration += value_;
              }
              break;
          }
          break;
          
        case 3: // DUSK START
          switch (blinkPos) {
            case 0: // HOUR
              set_variable(&newHourDusk, 23);
              break;
            case 1: // MIN
              set_variable(&newMinDusk, 59);
              break;
          }
          break;
          
        case 4: // DUSK DURATION
          switch (blinkPos) {
            case 0: // HOUR
              newDuskDuration -= 3600;
              if (newDuskDuration < 0)
               newDuskDuration += 86400;
              break;
            case 1: // MIN
              {
              int value_ = newDuskDuration%3600;
              newDuskDuration -= value_;
              value_ -= 60;
              if (value_ < 0)
                value_ += 3600;
              newDuskDuration += value_;
              }
              break;
            case 2: // SEC
              {
              int value_ = newDuskDuration%60;
              newDuskDuration -= value_;
              value_--;
              if (value_ < 0)
                value_ += 60;
              newDuskDuration += value_;
              }
              break;
          }
          break;
          
      }
      
    case 1: // TEMPERATURE
      
      switch (menuPos2) {
        
        case 0: // SET TEMPERATURE
          newRequiredTemp = constrain(newRequiredTemp-0.25, 0, 50);
          break;
        case 1: // TEMPERATURE DIFFERENCE
          newTempDiff = constrain(newTempDiff-0.25, 0, 9.75);
          break;
        case 2: // ALERT
          newTemperatureAlert = !newTemperatureAlert;
          break;
        case 3: // TEMPERATURE UNITS
          newTemperatureUnit--;
          if (newTemperatureUnit < 0)
            newTemperatureUnit = 2;
          break;
      }
      break;
      
   case 2: // CLOCK
     
     switch (menuPos2) {
       
       case 0: // SET TIME
         switch (blinkPos) {
           case 0: // HOUR
             set_variable(&newHour, 23);
             break;
           case 1: // MIN
             set_variable(&newMinute, 59);
             break;
           case 2: // SEC
             set_variable(&newSecond, 59);
             break;
         }
         break;
         
       case 1: // SET DATE
         switch (blinkPos) {
           case 0: // YEAR
             newYear = constrain(newYear-1, 1000, 9999);
             break;
           case 1: // MONTH
             newMonth--;
             if (newMonth < 1)
               newMonth += 12;
             break;
           case 2: // DAY
             {
             int monthLength = monthsLengths[newMonth];
             if (newMonth == 2 && (newYear%4 == 0 && newYear%100 != 0) || newYear%400 == 0) // if month is February and is leap-year
               monthLength++;
             
             newDay--;
             if (newDay < 1)
               newDay += monthLength;
             }
             break;
         }
         break;
         
       case 2: // SUMMER TIME
         newSummerTime = !newSummerTime;
         break;
         
       case 3: // SET DAY OF WEEK
         newDow--;
         if (newDow == 0)
           newDow = 7;
         break;
         
     }
     break;
     
   case 3: // DISPLAY
     switch (menuPos2) {
       
       case 0: // AUTO OFF DELAY
         newAutoOffDelay = constrain(newAutoOffDelay - 1, 0, 59);
         break;
         
       case 1: // AUTO OFF
         newAutoOff = !newAutoOff;
         break;
         
     }
     break;
             
  }
  
  which_setting();
  
}

// 4 BUTTON //
void add() {
 
  switch (menuPos1) {
    
    case 0: // LIGHT
      switch (menuPos2) {
        
        case 0: // MODE
          newAutoMode = !newAutoMode;
          break;
        case 1: // DAWN START
          if (blinkPos == 0) // HOUR
            newHourDawn = (newHourDawn + 1)%24;
          else // MIN
            newMinDawn = (newMinDawn + 1)%60;
          break;
        case 2: // DAWN DURATION
          switch (blinkPos) {
            
            case 0: // HOUR
              newDawnDuration = (newDawnDuration + 3600) % 86400;
              break;
            case 1: // MIN
              {
              int value_ = newDawnDuration%3600;
              newDawnDuration -= value_;
              newDawnDuration += (value_ + 60)%3600;
              }
              break;
            case 2: // SEC
              {
              int value_ = newDawnDuration%60;
              newDawnDuration -= value_;
              newDawnDuration += (value_ + 1)%60;
              }
              break;
            
          }
          break;
        case 3: // DUSK START
          if (blinkPos == 0) // HOUR
            newHourDusk = (newHourDusk + 1)%24;
          else // MIN
            newMinDusk = (newMinDusk + 1)%60;
          break;
        case 4: // DUSK DURATION
          switch (blinkPos) {
            
            case 0: // HOUR
              newDuskDuration = (newDuskDuration + 3600) % 86400;
              break;
            case 1: // MIN
              {
              int value_ = newDuskDuration%3600;
              newDuskDuration -= value_;
              newDuskDuration += (value_ + 60)%3600;
              }
              break;
            case 2: // SEC
              {
              int value_ = newDuskDuration%60;
              newDuskDuration -= value_;
              newDuskDuration += (value_ + 1)%60;
              }
              break;
            
          }
          break;
          
      }
      break;
      
    case 1: // TEMPERATURE
      
      switch (menuPos2) {
        
        case 0: // SET TEMPERATURE
          newRequiredTemp = constrain(newRequiredTemp+0.25, 0, 50);
          break;
        case 1: // TEMPERATURE DIFFERENCE
          newTempDiff = constrain(newTempDiff+0.25, 0, 9.75);
          break;
        case 2: // ALERT
          newTemperatureAlert = !newTemperatureAlert;
          break;
        case 3: // TEMPERATURE UNITS
          newTemperatureUnit = (newTemperatureUnit + 1)%3;
          break;
          
      }
      break;
      
    case 2: // CLOCK
     
     switch (menuPos2) {
       
       case 0: // SET TIME
         switch (blinkPos) {
           case 0: // HOUR
             newHour = (newHour + 1)%24;
             break;
           case 1: // MIN
             newMinute = (newMinute + 1)%60;
             break;
           case 2: // SEC
             newSecond = (newSecond + 1)%60;
             break;
         }
         break;
         
       case 1: // SET DATE
         switch (blinkPos) {
           case 0: // YEAR
             newYear = constrain(newYear+1, 1000, 9999);
             break;
           case 1: // MONTH
             newMonth++;
             if (newMonth > 12)
               newMonth -= 12;
             break;
           case 2: // DAY
             {
             int monthLength = monthsLengths[newMonth];
             if (newMonth == 2 && (newYear%4 == 0 && newYear%100 != 0) || newYear%400 == 0) // if month is February and is leap-year
               monthLength++;
             
             newDay++;
             if (newDay > monthLength)
               newDay -= monthLength;
             }
             break;
         }
         break;
         
       case 2: // SUMMER TIME
         newSummerTime = !newSummerTime;
         break;
         
       case 3: // SET DAY OF WEEK
         newDow++;
         if (newDow > 7)
           newDow = 1;
         break;
         
     }
     break;
     
   case 3: // DISPLAY
     switch (menuPos2) {
       
       case 0: // AUTO OFF DELAY
         newAutoOffDelay = constrain(newAutoOffDelay + 1, 0, 59);
         break;
         
       case 1: // AUTO OFF
         newAutoOff = !newAutoOff;
         break;
         
     }
     break;
      
  }
  
  which_setting();
  
}

// 1 BUTTON //
void ok() {
  
  switch (menuPos1) {
    
    case 0: // LIGHT
      switch (menuPos2) {
        
        case 0: // MODE
          autoMode = newAutoMode;
          write_bool(17, autoMode);
          break;
        case 1: // DAWN START
          if (showMode+1 == blinkPos) {
            phase = 255;
            hourDawn = newHourDawn;
            minDawn = newMinDawn;
            EEPROM.write(7, hourDawn);
            EEPROM.write(8, minDawn);
          }
          break;
        case 2: // DAWN DURATION
          if (showMode+1 == blinkPos) {
            phase = 255;
            dawnDuration = newDawnDuration;
            write_big_variable(11, dawnDuration);
          }
          break;
        case 3: // DUSK START
          if (showMode+1 == blinkPos) {
            phase = 255;
            hourDusk = newHourDusk;
            minDusk = newMinDusk;
            EEPROM.write(9, hourDusk);
            EEPROM.write(10, minDusk);
          }
          break;
        case 4: // DUSK DURATION
          if (showMode+1 == blinkPos) {
            phase = 255;
            duskDuration = newDuskDuration;
            write_big_variable(14, duskDuration);
          }
          break;
          
      }
      break;
      
    case 1: // TEMPERATURE
      switch (menuPos2) {
        
        case 0: // SET TEMPERATURE
          requiredTemp = newRequiredTemp;
          write_float(0, requiredTemp);
          break;
        case 1: // MAX DIFFERENCE
          tempDiff = newTempDiff;
          write_float(3, tempDiff);
          break;
        case 2: // ALERT
          temperatureAlert = newTemperatureAlert;
          write_bool(6, temperatureAlert);
          break;
        case 3: // TEMPERATURE UNITS
          temperatureUnit = newTemperatureUnit;
          EEPROM.write(19, temperatureUnit);
          break;
          
      }
      break;
      
    case 2: // CLOCK
      switch (menuPos2) {
        
        case 0: // SET TIME
          rtc.setTime(newHour, newMinute, newSecond);
          phase = 255;
          break;
        case 1: // SET DATE
          rtc.setDate(newDay, newMonth, newYear);
          break;
        case 2: // SUMMER TIME
          if (summerTime && !newSummerTime) {
            if (newHour == 0) {
              newHour = 23;
              rtc.setDate(newDay-1, newMonth, newYear);
            }
            else
              newHour--;
          }
          else if (!summerTime && newSummerTime) {
            if (newHour == 23) {
              newHour = 0;
              rtc.setDate(newDay+1, newMonth, newYear);
            }
            else
              newHour++;
          }
          
          phase = 255;
          summerTime = newSummerTime;
          write_bool(18, summerTime);
          rtc.setTime(newHour, newMinute, seconds);
          break;
        case 3: // SET DAY OF WEEK
         rtc.setDOW(newDow);
         break;
        
      }
      break;
      
    case 3: // DISPLAY
     switch (menuPos2) {
       
       case 0: // AUTO OFF DELAY
         autoOffDelay = newAutoOffDelay;
         EEPROM.write(20, autoOffDelay);
         break;
         
       case 1: // AUTO OFF
         autoOff = newAutoOff;
         write_bool(21, newAutoOff);
         break;
         
     }
     break;
      
  }
  
  menu = 2;
  if (showMode+1 > blinkPos) {
    blinkPos++;
    visible = false;
    menu = 3;
    which_setting();
  }
          
  if (menu == 2)
    sub_menu();
  else
    which_setting();
  
}

void cancel() {
    
  switch (menuPos1) {
    
    case 0: // LIGHT
      switch (menuPos2) {
        
        case 0: // MODE
          newAutoMode = autoMode;
          break;
        case 1: // DAWN START
          newHourDawn = hourDawn;
          newMinDawn = minDawn;
          break;
        case 2: // DAWN DURATION
          newDawnDuration = dawnDuration;
          break;
        case 3: // DUSK START
          newHourDusk = hourDusk;
          newMinDusk = minDusk;
          break;
        case 4: // DUSK DURATION
          newDuskDuration = duskDuration;
          break;
          
      }
      break;
      
    case 1: // TEMPERATURE
      switch (menuPos2) {
        
        case 0: // SET TEMPERATURE
          newRequiredTemp = requiredTemp;
          break;
        case 1: // MAX DIFFERENCE
          newTempDiff = tempDiff;
          break;
        case 2: // ALERT
          newTemperatureAlert = temperatureAlert;
          break;
        case 3: // TEMPERATURE UNITS
          newTemperatureUnit = temperatureUnit;
          break;
      }
      break;
      
    case 2: // CLOCK
      if (menuPos2 == 2)
        newSummerTime = summerTime;
      break;
      
    case 3: // DISPLAY
      switch (menuPos2) {
       
        case 0: // AUTO OFF DELAY
          newAutoOffDelay = autoOffDelay;
          break;
         
        case 1: // AUTO OFF
          newAutoOff = autoOff;
          break;
         
      }
      break;
      
  }
  
  sub_menu();
  
}

void button_click(byte button, bool state) {
  
  buttonsPos[button] = state;
  lcd.backlight();
  backlightTimer = (seconds + autoOffDelay)%60;
  
}

void set_variable(byte *var, byte maximalValue) {
  
  if (*var == 0)
    *var = maximalValue;
  else
    --*var;
    
}
