void which_setting() {
  
  show_title();
  
  switch (menuPos1) {
    
    ///////////
    // LIGHT //
    ///////////
    case 0:
    
      switch (menuPos2) {
        case 0:
          display_bool(newAutoMode, "Auto", "Off");
          break;
        case 1:
          hour_min(newHourDawn, newMinDawn);
          break;
        case 2:
          hour_min_sec(newDawnDuration/3600, newDawnDuration%3600 / 60, newDawnDuration%60);
          break;
        case 3:
          hour_min(newHourDusk, newMinDusk);
          break;
        case 4:
          hour_min_sec(newDuskDuration/3600, newDuskDuration%3600 / 60, newDuskDuration%60);
          break;
      }
      if (menuPos2 > 0)
        blink = true;
      break;
    
    /////////////////
    // TEMPERATURE //
    /////////////////
    case 1:
      
      switch (menuPos2) {
        case 0:
          temp(temp_units_conversion(newRequiredTemp, true));
          break;
        case 1:
          temp(temp_units_conversion(newTempDiff, false));
          break;
        case 2:
          display_bool(newTemperatureAlert, "On", "Off");
          break;
        case 3:
          switch (newTemperatureUnit) {
            case 0:
              lcd.setCursor(4, 1);
              lcd.print("Celsius");
              break;
            case 1:
              lcd.setCursor(3, 1);
              lcd.print("Fahrenheit");
              break;
            case 2:
              lcd.setCursor(5, 1);
              lcd.print("Kelvin");
              break;
          }
          break;
      }
      break;
      
    ///////////
    // CLOCK //
    ///////////
    case 2:
      
      switch (menuPos2) {
        case 0:
          hour_min_sec(newHour, newMinute, newSecond);
          break;
        case 1:
          date_show(newDay, newMonth, newYear);
          break;
        case 2:
          display_bool(newSummerTime, "On", "Off");
          break;
        case 3:
          lcd.setCursor(8 - dows[newDow-1].length()/2, 1);
          lcd.print(dows[newDow-1]);
          break;
      }
      if (menuPos2 < 2)
        blink = true;
      break;
    
    /////////////
    // DISPLAY //
    /////////////
    case 3:
      
      switch (menuPos2) {
        case 0:
          lcd.setCursor(7, 1);
          lcd.print(newAutoOffDelay);
          lcd.print("s");
          break;
        case 1:
          display_bool(newAutoOff, "On", "Off");
          break;
      }
      break;
    
  }
  
}

void show_title() {
  lcd.clear();
  lcd.setCursor(8 - subMenu[menuPos1][menuPos2].length()/2, 0);
  lcd.print(subMenu[menuPos1][menuPos2]);
}

void print_degrees() {
  lcd.print(char(0));
  switch (temperatureUnit) {
    case 0:
      lcd.print("C");
      break;
    case 1:
      lcd.print("F");
      break;
    case 2:
      lcd.print("K");
      break;
  }
}

float temp_units_conversion(float t, bool baseDiff) {
  float temp = t; // Now is in Celsius
  switch (temperatureUnit) {
    case 1: // Fahrenheit
      temp = temp*9/5;
      if (baseDiff)
        temp += 32;
      break;
    case 2: // Kevin
      if (baseDiff)
        temp += 273.15;
      break;
  }
  
  return temp;
}

void update_date_variables() {
  
  newSecond = 0;
  newMinute = t.min;
  newHour = t.hour;
  newDay = t.date;
  newMonth = t.mon;
  newYear = t.year;
  newDow = t.dow;
  
}

void temp(float t) {
  lcd.setCursor(8 - 3, 1);
  lcd.print(t);
  print_degrees();
}

void blink_time() {
  if (blink) {
    visible = !visible;
    if (visible)
      blinkTimer = millis() + BLINK_ON;
    else
      blinkTimer = millis() + BLINK_OFF;
  }
  else
    visible = true;
}

void hour_min(byte newHour, byte newMin) {
  showMode = 0;
  blink_time();
  
  lcd.setCursor(5, 1);
  
  if (blinkPos == 0 && !visible)
    lcd.print("  ");
  else {
    if (newHour < 10)
      lcd.print("0");
    lcd.print(newHour);
  }
  
  lcd.print(":");
  
  if (blinkPos == 1 && !visible)
    lcd.print("  ");
  else {
    if (newMin < 10)
      lcd.print("0");
    lcd.print(newMin);
  }
  
}

void hour_min_sec(byte newHour, byte newMin, byte newSec) {
  showMode = 1;
  blink_time();
  
  lcd.setCursor(4, 1);
  
  if (blinkPos == 0 && !visible)
    lcd.print("  ");
  else {
    if (newHour < 10)
      lcd.print("0");
    lcd.print(newHour);
  }
  
  lcd.print(":");
  
  if (blinkPos == 1 && !visible)
    lcd.print("  ");
  else {
    if (newMin < 10)
      lcd.print("0");
    lcd.print(newMin);
  }
  
  lcd.print(":");
  
  if (blinkPos == 2 && !visible)
    lcd.print("  ");
  else {
    if (newSec < 10)
      lcd.print("0");
    lcd.print(newSec);
  }
  
}

void date_show(byte d, byte m, int y) {
  showMode = 1;
  blink_time();
  
  lcd.setCursor(3, 1);
  
  if (blinkPos == 0 && !visible)
    lcd.print("    ");
  else {
    lcd.print(y);
  }
  
  lcd.print(".");
  
  if (blinkPos == 1 && !visible)
    lcd.print("  ");
  else {
    if (m < 10)
      lcd.print("0");
    lcd.print(m);
  }
  
  lcd.print(".");
  
  if (blinkPos == 2 && !visible)
    lcd.print("  ");
  else {
    if (d < 10)
      lcd.print("0");
    lcd.print(d);
  }
  
}

void display_bool(bool state, String option1, String option2) {
  
  lcd.setCursor(8 - option1.length()/2, 1);
  if (state)
    lcd.print(option1);
  else
    lcd.print(option2);
    
}
