void show_time() {
  if (time) {
    lcd.setCursor(2,0);
    lcd.print(rtc.getDOWStr(FORMAT_SHORT));
    lcd.print(" ");
    lcd.print(rtc.getTimeStr());
  }
  else {
    lcd.setCursor(3,0);
    lcd.print(rtc.getDateStr());
  }
}

void display_led_power() {
  
  switch (phase) {
    case 0:
      if (autoMode) {
        lcd.setCursor(4, 0);
        lcd.print("To dawn:");
      }
      else {
        lcd.setCursor(2, 0);
        lcd.print("Leds are off");
      }
      break;
    case 1:
      lcd.setCursor(4, 0);
      lcd.print("To day:");
      break;
    case 2:
      lcd.setCursor(4, 0);
      lcd.print("To dusk:");
      break;
    case 3:
      lcd.setCursor(3, 0);
      lcd.print("To night:");
      break;
    case 4:
      lcd.setCursor(4, 0);
      lcd.print("To off:");
  }
  if (phase != 0)
    hour_min_sec(timeLeft/3600, (timeLeft%3600)/60, timeLeft%60);
  else if (autoMode)
    hour_min_sec(timeLeft/3600, (timeLeft%3600)/60, timeLeft%60);

}

void display() {
  lcd.clear();
  
  switch (displayPos) {
    case 0:
      show_time();
      display_water_temperature(waterTemp);
      break;
    case 1:
      display_led_power();
      break;
  }
    
  waterTemp = getTemperature();
}

void light_fading() {

  // e^(-(x-X_DIFF)^2*2) * (255 - SLOPE*X_DIFF) + SLOPE*x
  
  if (t.hour*60+t.min >= hourDawn*60+minDawn && autoMode) {
    
    if (t.hour*60+t.min >= hourDusk*60+minDusk) {
      if (fading > 0) {
        if (phase != 3)
          timeLeft = duskDuration + 1;
        phase = 3;
        x -= X_DIFF / (double)duskDuration;
      }
      else {
        if (phase != 0)
          timeLeft = (hourDawn+24 - newHour)*3600L + (minDawn - newMinute)*60 - seconds + 1;
        
        phase = 0;
        x = 0;
      }
      
    }
    else {
      if (fading < 255) {
        if (phase != 1)
          timeLeft = dawnDuration + 1;
        phase = 1;
        x += X_DIFF / (double)dawnDuration;
      }
      else {
        if (phase != 2) {
          if (hourDusk < newHour)
            timeLeft = (hourDusk+24 - newHour)*3600L + (minDusk - newMinute + 1)*60 + (seconds - 60) + 1;
          else
            timeLeft = (hourDusk - newHour)*3600L + (minDusk - newMinute + 1)*60 + (seconds - 60) + 1;
        }
        phase = 2;
        x = X_DIFF;
      }
    }
  }
  else {
    if (fading > 0) {
      if (!autoMode) {
        if (phase != 4)
          timeLeft = fastOff + 1;
        phase = 4;
        x -= X_DIFF / (double)fastOff;
      }
      else {
        if (phase != 3)
          timeLeft = duskDuration + 1;
        phase = 3;
        x -= X_DIFF / (double)duskDuration;
      }
    }
    else {
      if (phase != 0)
        timeLeft = (hourDawn - newHour)*3600L + (minDawn - newMinute + 1)*60 + (seconds - 60) + 1;
      
      phase = 0;
      x = 0;
    }
  }
  
  timeLeft--;
  fading = exp(-pow(x-X_DIFF, 2)) * (255 - SLOPE*X_DIFF) + SLOPE*x;
  analogWrite(LEDS, fading);
  
}

void display_water_temperature(float waterTemp) {
  lcd.setCursor(1, 1);
  lcd.print("Water: ");
  lcd.print(temp_units_conversion(waterTemp, true));
  print_degrees();
}

float getTemperature() {
  sensors.requestTemperatures();
  
  float waterTemp1 = sensors.getTempC(thermometer1);
  float waterTemp2 = sensors.getTempC(thermometer2);
  float avgWaterTemp = (waterTemp1 + waterTemp2)/2;
  
  return avgWaterTemp;
}
