/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChartPopup;
import dk.hkj.main.DataSet;
import dk.hkj.main.Support;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.DefaultXYDataset;

public class ChargeChartPanel
implements ActionListener {
    private ChartPanel chartPanel;
    private JRadioButton allVoltageRadioButton;
    private JRadioButton onVoltageRadioButton;
    private JRadioButton offVoltageRadioButton;
    private JComboBox<String> domainAxisComboBox;
    private ButtonGroup VoltageGroup;
    private JCheckBox currentCheckBox;
    private JCheckBox averageCurrentCheckBox;
    private JCheckBox capacityCheckBox;
    private JCheckBox energyCheckBox;
    private JCheckBox temperatureCheckBox;
    private JCheckBox riCheckBox;
    private JCheckBox tceCheckBox;
    private JCheckBox eocCheckBox;
    private JFreeChart chart;
    private DefaultXYDataset datasetVoltage;
    private DefaultXYDataset datasetCurrent;
    private DefaultXYDataset datasetAverageCurrent;
    private DefaultXYDataset datasetCapacity;
    private DefaultXYDataset datasetEnergy;
    private DefaultXYDataset datasetTemperature;
    private DefaultXYDataset datasetRi;
    private XYTextAnnotation timeText;
    private XYTextAnnotation capacityText;
    private XYTextAnnotation energyText;
    private XYLineAnnotation eocLine;
    private XYLineAnnotation cursorLine;
    private XYTextAnnotation copyrightText;
    private double scaleTop = 0.0;
    private double scaleBottom = 0.0;
    private DataSet.DataPoint lastCurrent = Support.dataSet.createDataPoint();
    private DomainAxisUnit dau = DomainAxisUnit.time;
    private ChartPopup chartPopup = null;
    private DataSet.TimeUnit tu = DataSet.TimeUnit.seconds;
    private VoltageShow voltageShow = VoltageShow.all;
    private boolean includeCurrent = false;
    private boolean includeAverageCurrent = false;
    private boolean includeCapacity = false;
    private boolean includeEnergy = false;
    private boolean includeTemperature = false;
    private boolean includeRi = false;
    private boolean includeTCE = false;
    private boolean includeEOC = false;
    private int lastSaveResolution = 1;
    private int lastCustomWidth = 1000;
    private int lastCustomHeight = 500;
    private boolean lastPulsingStatus = false;
    private boolean lastCharging = false;
    private double minRi = 0.0;
    private double maxRi = 200.0;

    private void closePopup() {
        if (this.chartPopup != null) {
            this.chartPopup.close();
            this.chartPopup = null;
        }
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.datasetVoltage = new DefaultXYDataset();
        this.datasetCurrent = new DefaultXYDataset();
        this.datasetAverageCurrent = new DefaultXYDataset();
        this.datasetCapacity = new DefaultXYDataset();
        this.datasetEnergy = new DefaultXYDataset();
        this.datasetTemperature = new DefaultXYDataset();
        this.datasetRi = new DefaultXYDataset();
        this.chart = ChartFactory.createXYLineChart(null, "Time", "Voltage", this.datasetVoltage);
        int w = 850;
        int h = 390;
        this.chartPanel = new ChartPanel(this.chart, w, h, w, h, w, h, true, false, false, false, false, false);
        panel.add(this.chartPanel);
        this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
        ((NumberAxis)this.chart.getXYPlot().getDomainAxis()).setNumberFormatOverride(new DomainFormat());
        if (Support.chartColor != null) {
            this.chart.getPlot().setBackgroundPaint(Support.chartColor);
        }
        if (Support.borderColor != null) {
            this.chart.setBackgroundPaint(Support.borderColor);
        }
        this.timeText = new XYTextAnnotation("", 0.0, 0.0);
        this.capacityText = new XYTextAnnotation("", 0.0, 0.0);
        this.energyText = new XYTextAnnotation("", 0.0, 0.0);
        this.copyrightText = new XYTextAnnotation("", 0.0, 0.0);
        this.timeText.setTextAnchor(TextAnchor.BASELINE_LEFT);
        this.capacityText.setTextAnchor(TextAnchor.BASELINE_LEFT);
        this.energyText.setTextAnchor(TextAnchor.BASELINE_LEFT);
        this.copyrightText.setTextAnchor(TextAnchor.TOP_RIGHT);
        if (Support.textColor != null) {
            this.timeText.setPaint(Support.textColor);
            this.capacityText.setPaint(Support.textColor);
            this.energyText.setPaint(Support.textColor);
            this.copyrightText.setPaint(Support.textColor);
        }
        this.timeText.setFont(this.energyText.getFont().deriveFont(0, 12.0f));
        this.capacityText.setFont(this.energyText.getFont().deriveFont(0, 12.0f));
        this.energyText.setFont(this.energyText.getFont().deriveFont(0, 12.0f));
        this.copyrightText.setFont(this.energyText.getFont().deriveFont(0, 14.0f));
        this.chart.getXYPlot().addAnnotation(this.timeText);
        this.chart.getXYPlot().addAnnotation(this.capacityText);
        this.chart.getXYPlot().addAnnotation(this.energyText);
        this.chart.getXYPlot().addAnnotation(this.copyrightText);
        this.setupAxis(true, 0, this.datasetVoltage, "Voltage", Color.red);
        JPanel userPanel = new JPanel();
        panel.add(userPanel);
        JPanel voltPanel = new JPanel();
        voltPanel.setLayout(new BoxLayout(voltPanel, 3));
        userPanel.add(voltPanel);
        this.VoltageGroup = new ButtonGroup();
        this.offVoltageRadioButton = new JRadioButton("V Off");
        this.offVoltageRadioButton.addActionListener(this);
        this.offVoltageRadioButton.setBorder(BorderFactory.createEmptyBorder());
        this.VoltageGroup.add(this.offVoltageRadioButton);
        voltPanel.add(this.offVoltageRadioButton);
        this.allVoltageRadioButton = new JRadioButton("V All");
        this.allVoltageRadioButton.addActionListener(this);
        this.allVoltageRadioButton.setSelected(true);
        this.allVoltageRadioButton.setBorder(BorderFactory.createEmptyBorder());
        this.VoltageGroup.add(this.allVoltageRadioButton);
        voltPanel.add(this.allVoltageRadioButton);
        this.onVoltageRadioButton = new JRadioButton("V On");
        this.onVoltageRadioButton.addActionListener(this);
        this.onVoltageRadioButton.setBorder(BorderFactory.createEmptyBorder());
        this.VoltageGroup.add(this.onVoltageRadioButton);
        voltPanel.add(this.onVoltageRadioButton);
        userPanel.add(Box.createHorizontalStrut(20));
        this.domainAxisComboBox = new JComboBox();
        userPanel.add(this.domainAxisComboBox);
        this.domainAxisComboBox.addActionListener(this);
        userPanel.add(Box.createHorizontalStrut(20));
        JPanel curvesPanel = new JPanel();
        curvesPanel.setLayout(new GridLayout(2, 3, 1, 1));
        userPanel.add(curvesPanel);
        this.currentCheckBox = new JCheckBox("Current");
        this.currentCheckBox.setSelected(Support.chartOptions.contains("I"));
        this.currentCheckBox.addActionListener(this);
        this.currentCheckBox.setToolTipText("Current, to smooth curve use average checkbox instead");
        curvesPanel.add(this.currentCheckBox);
        this.averageCurrentCheckBox = new JCheckBox("Average current");
        this.averageCurrentCheckBox.setSelected(Support.chartOptions.contains("A"));
        this.averageCurrentCheckBox.addActionListener(this);
        this.averageCurrentCheckBox.setToolTipText("Calculates a rolling average");
        curvesPanel.add(this.averageCurrentCheckBox);
        this.capacityCheckBox = new JCheckBox("Capacity");
        this.capacityCheckBox.setSelected(Support.chartOptions.contains("C"));
        this.capacityCheckBox.addActionListener(this);
        this.capacityCheckBox.setToolTipText("Battery capacity, either from data or calculated");
        curvesPanel.add(this.capacityCheckBox);
        this.energyCheckBox = new JCheckBox("Energy");
        this.energyCheckBox.setSelected(Support.chartOptions.contains("E"));
        this.energyCheckBox.addActionListener(this);
        this.energyCheckBox.setToolTipText("Battery energy, either from data or calculated");
        curvesPanel.add(this.energyCheckBox);
        this.temperatureCheckBox = new JCheckBox("Temperature");
        this.temperatureCheckBox.setSelected(Support.chartOptions.contains("T"));
        this.temperatureCheckBox.setToolTipText("Battery temperature");
        this.temperatureCheckBox.addActionListener(this);
        curvesPanel.add(this.temperatureCheckBox);
        this.riCheckBox = new JCheckBox("IR");
        this.riCheckBox.setSelected(Support.chartOptions.contains("R"));
        this.riCheckBox.setToolTipText("Calculate internal resistance from current on/off in mOhm");
        this.riCheckBox.addActionListener(this);
        curvesPanel.add(this.riCheckBox);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridLayout(2, 1, 1, 1));
        userPanel.add(optionsPanel);
        this.tceCheckBox = new JCheckBox("TCE text");
        this.tceCheckBox.setSelected(Support.chartOptions.contains("X"));
        this.tceCheckBox.addActionListener(this);
        this.tceCheckBox.setToolTipText("Add text with time, capacity and energy to the chart");
        optionsPanel.add(this.tceCheckBox);
        this.eocCheckBox = new JCheckBox("EOC marker");
        this.eocCheckBox.setSelected(Support.chartOptions.contains("M"));
        this.eocCheckBox.addActionListener(this);
        this.eocCheckBox.setToolTipText("Add a yellow line where charging is finished");
        optionsPanel.add(this.eocCheckBox);
        this.modifyChartPanel();
        this.actionPerformed(null);
        this.setup();
        this.updateControls();
        return panel;
    }

    private void modifyChartPanel() {
        JPopupMenu m = this.chartPanel.getPopupMenu();
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            @Override
            public void chartMouseClicked(ChartMouseEvent me) {
                ChargeChartPanel.this.handleChartMouseEvent(true, me);
            }

            @Override
            public void chartMouseMoved(ChartMouseEvent me) {
                ChargeChartPanel.this.handleChartMouseEvent(false, me);
            }
        });
        m.removeAll();
        JMenuItem m1 = new JMenuItem("Copy 500 x 250");
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.copyChart(500, 250);
            }
        });
        m.add(m1);
        JMenuItem m2 = new JMenuItem("Copy 800 x 400");
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.copyChart(800, 400);
            }
        });
        m.add(m2);
        JMenuItem m3 = new JMenuItem("Copy 1200 x 700");
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.copyChart(1200, 700);
            }
        });
        m.add(m3);
        JMenuItem m4 = new JMenuItem("Copy 2000 x 1000");
        m4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.copyChart(2000, 1000);
            }
        });
        m.add(m4);
        JMenuItem m5 = new JMenuItem("Chart color");
        m5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.selectChartColor();
            }
        });
        m.add(m5);
        JMenuItem m6 = new JMenuItem("Border color");
        m6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.selectBorderColor();
            }
        });
        m.add(m6);
        JMenuItem m7 = new JMenuItem("Text color");
        m7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChargeChartPanel.this.selectTextColor();
            }
        });
        m.add(m7);
    }

    private void selectBorderColor() {
        Color newColor = JColorChooser.showDialog(this.chartPanel.getRootPane(), "Choose Border Color", (Color)this.chart.getBackgroundPaint());
        this.chart.setBackgroundPaint(newColor);
        this.chart.setNotify(true);
    }

    private void selectChartColor() {
        Color newColor = JColorChooser.showDialog(this.chartPanel.getRootPane(), "Choose Chart Color", (Color)this.chart.getPlot().getBackgroundPaint());
        this.chart.getPlot().setBackgroundPaint(newColor);
        this.chart.setNotify(true);
    }

    private void selectTextColor() {
        Color newColor = JColorChooser.showDialog(this.chartPanel.getRootPane(), "Choose Text Color inside chart", (Color)this.chart.getPlot().getBackgroundPaint());
        this.timeText.setPaint(newColor);
        this.capacityText.setPaint(newColor);
        this.energyText.setPaint(newColor);
        this.copyrightText.setPaint(newColor);
        this.chart.setNotify(true);
    }

    private void handleChartMouseEvent(Boolean click, ChartMouseEvent me) {
        if (this.cursorLine != null && this.chartPopup == null) {
            this.chart.getXYPlot().removeAnnotation(this.cursorLine);
            this.cursorLine = null;
            this.chart.setNotify(true);
        }
        if (click.booleanValue() || this.chartPopup != null) {
            int i;
            Point2D p = this.chartPanel.translateScreenToJava2D(me.getTrigger().getPoint());
            Rectangle2D plotArea = this.chartPanel.getScreenDataArea();
            XYPlot plot = (XYPlot)this.chart.getPlot();
            double x = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
            PointValues pv = new PointValues();
            if (this.includeRi) {
                i = 0;
                while (i < this.datasetRi.getItemCount(0)) {
                    if (this.datasetRi.getX(0, i).doubleValue() >= x && x >= this.datasetRi.getX(0, 0).doubleValue()) {
                        pv.ri = this.datasetRi.getY(0, i).doubleValue();
                        break;
                    }
                    ++i;
                }
            } else {
                pv.ri = null;
            }
            if (this.includeAverageCurrent) {
                i = 0;
                while (i < this.datasetAverageCurrent.getItemCount(0)) {
                    if (this.datasetAverageCurrent.getX(0, i).doubleValue() >= x && x >= this.datasetAverageCurrent.getX(0, 0).doubleValue()) {
                        pv.avgCurrent = this.datasetAverageCurrent.getY(0, i).doubleValue();
                        break;
                    }
                    ++i;
                }
            } else {
                pv.avgCurrent = null;
            }
            DataSet ds = Support.dataSet;
            block0 : switch (this.dau) {
                case time: {
                    DataSet.DataPoint dp;
                    Iterator<DataSet.DataPoint> iterator = ds.iterator();
                    while (iterator.hasNext()) {
                        pv.dp = dp = iterator.next();
                        if (dp.getTime(this.tu) >= x) break block0;
                    }
                    break;
                }
                case capacity: {
                    DataSet.DataPoint dp;
                    Iterator<DataSet.DataPoint> iterator = ds.iterator();
                    while (iterator.hasNext()) {
                        pv.dp = dp = iterator.next();
                        if (dp.getCapacity() >= x) break block0;
                    }
                    break;
                }
                case energy: {
                    DataSet.DataPoint dp;
                    Iterator<DataSet.DataPoint> iterator = ds.iterator();
                    while (iterator.hasNext()) {
                        pv.dp = dp = iterator.next();
                        if (dp.getEnergy() >= x) break block0;
                    }
                    break;
                }
                case pct0_100: 
                case pct100_0: {
                    DataSet.DataPoint dp;
                    Iterator<DataSet.DataPoint> iterator = ds.iterator();
                    while (iterator.hasNext()) {
                        pv.dp = dp = iterator.next();
                        if (dp.getCapacity() / ds.getMinMaxCapacity().max * 100.0 >= x) break block0;
                    }
                    break;
                }
            }
            if (click.booleanValue() && this.chartPopup == null) {
                JRootPane rp = this.chartPanel.getRootPane();
                Point pp = rp.getLocationOnScreen();
                pp.translate(rp.getWidth(), 0);
                this.chartPopup = new ChartPopup(pp);
            }
            if (this.cursorLine != null) {
                this.chart.getXYPlot().removeAnnotation(this.cursorLine);
            }
            this.cursorLine = new XYLineAnnotation(x, this.scaleBottom, x, this.scaleTop, new BasicStroke(2.0f), Color.CYAN);
            if (this.chartPopup.update(pv)) {
                this.chart.getXYPlot().addAnnotation(this.cursorLine);
                this.chart.setNotify(true);
            } else {
                this.chartPopup = null;
                this.chart.setNotify(true);
            }
        }
    }

    private BufferedImage generateImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        if (Support.currentFilename.toLowerCase().contains("charge")) {
            this.chart.setTitle(Support.currentFilename.replace("-", " ").replace("_", " "));
        } else {
            this.chart.setTitle(String.valueOf(Support.dataSet.guessOperation()) + " " + Support.currentFilename.replace("-", " ").replace("_", " "));
        }
        this.setupAnnotations(h);
        this.setupCopyrightAnnotation(h);
        if (this.cursorLine != null) {
            this.chart.getXYPlot().removeAnnotation(this.cursorLine);
        }
        this.chart.draw(image.createGraphics(), new Rectangle(w, h));
        this.setupAnnotations();
        this.setupCopyrightAnnotation(0);
        this.chart.setTitle("");
        return image;
    }

    private void copyChart(int w, int h) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new TransferableImage(this.generateImage(w, h)), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateControls() {
        this.currentCheckBox.setEnabled(Support.dataSet.isCurrentPresent());
        this.averageCurrentCheckBox.setEnabled(Support.dataSet.isCurrentPresent());
        this.capacityCheckBox.setEnabled(Support.dataSet.isCapacityPresent());
        this.energyCheckBox.setEnabled(Support.dataSet.isEnergyPresent());
        this.temperatureCheckBox.setEnabled(Support.dataSet.isTemperaturePresent());
        this.riCheckBox.setEnabled(Support.dataSet.isCurrentPulsing());
        this.tceCheckBox.setEnabled(!Support.charging);
        this.eocCheckBox.setEnabled(!Support.charging);
        if (this.domainAxisComboBox != null) {
            String s = (String)this.domainAxisComboBox.getSelectedItem();
            this.domainAxisComboBox.removeAllItems();
            this.domainAxisComboBox.addItem(DomainAxisUnit.time.toString());
            if (Support.dataSet.isCapacityPresent()) {
                this.domainAxisComboBox.addItem(DomainAxisUnit.capacity.toString());
            }
            if (Support.dataSet.isEnergyPresent()) {
                this.domainAxisComboBox.addItem(DomainAxisUnit.energy.toString());
            }
            if (Support.dataSet.isCapacityPresent()) {
                this.domainAxisComboBox.addItem(DomainAxisUnit.pct0_100.toString());
                this.domainAxisComboBox.addItem(DomainAxisUnit.pct100_0.toString());
            }
            this.domainAxisComboBox.setSelectedItem(s);
            if (this.domainAxisComboBox.getSelectedItem() == null) {
                this.domainAxisComboBox.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chartPanel.restoreAutoBounds();
        if (this.allVoltageRadioButton.isSelected()) {
            this.voltageShow = VoltageShow.all;
        } else if (this.offVoltageRadioButton.isSelected()) {
            this.voltageShow = VoltageShow.off;
        } else if (this.onVoltageRadioButton.isSelected()) {
            this.voltageShow = VoltageShow.on;
        }
        this.includeCurrent = this.currentCheckBox.isSelected() && Support.dataSet.isCurrentPresent();
        this.includeAverageCurrent = this.averageCurrentCheckBox.isSelected() && Support.dataSet.isCurrentPresent();
        this.includeCapacity = this.capacityCheckBox.isSelected() && Support.dataSet.isCapacityPresent();
        this.includeEnergy = this.energyCheckBox.isSelected() && Support.dataSet.isEnergyPresent();
        this.includeTemperature = this.temperatureCheckBox.isSelected() && Support.dataSet.isTemperaturePresent();
        this.includeRi = this.riCheckBox.isSelected() && Support.dataSet.isCurrentPulsing();
        this.includeTCE = this.tceCheckBox.isSelected() && !Support.charging;
        this.includeEOC = this.eocCheckBox.isSelected() && !Support.charging;
        this.dau = DomainAxisUnit.time;
        String s = (String)this.domainAxisComboBox.getSelectedItem();
        if (s != null) {
            DomainAxisUnit[] domainAxisUnitArray = DomainAxisUnit.values();
            int n = domainAxisUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                DomainAxisUnit d = domainAxisUnitArray[n2];
                if (s.equals(d.name())) {
                    this.dau = d;
                }
                ++n2;
            }
        }
        this.setup();
        this.update(true);
    }

    private void setupAxis(boolean enable, int no, DefaultXYDataset dataset, String name, Color color) {
        if (enable) {
            this.chart.getXYPlot().setDataset(no, dataset);
            this.chart.getXYPlot().setRangeAxis(no, new NumberAxis(name));
            this.chart.getXYPlot().getRangeAxis(no).setAxisLinePaint(color);
            this.chart.getXYPlot().getRangeAxis(no).setTickLabelPaint(color);
            this.chart.getXYPlot().getRangeAxis(no).setTickMarkPaint(color);
            this.chart.getXYPlot().getRangeAxis(no).setLabelPaint(color);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDefaultShapesVisible(false);
            renderer.setSeriesPaint(0, color);
            renderer.setLegendLine(new Rectangle2D.Double(0.0, 0.0, 15.0, 1.0));
            this.chart.getXYPlot().setRenderer(no, renderer);
            this.chart.getXYPlot().mapDatasetToRangeAxis(no, no);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(2);
            ((NumberAxis)this.chart.getXYPlot().getRangeAxis(no)).setNumberFormatOverride(nf);
        } else {
            this.chart.getXYPlot().setRangeAxis(no, null);
        }
    }

    private double roundDown(double value, double step) {
        if (Math.abs(value) > 8.988465674311579E307) {
            return 0.0;
        }
        double v = (double)((long)((value - step - 0.01) / step)) * step;
        return v;
    }

    private double roundUp(double value, double step) {
        if (Math.abs(value) > 8.988465674311579E307) {
            return 1.0;
        }
        double v = (double)((long)((value + step + 0.01) / step)) * step;
        return v;
    }

    private void setScale() {
        DataSet ds = Support.dataSet;
        this.scaleBottom = this.roundDown(ds.getMinMaxVoltage().min, 0.2);
        this.scaleTop = this.roundUp(ds.getMinMaxVoltage().max, 0.2);
        this.chart.getXYPlot().getRangeAxis(0).setRange(this.scaleBottom, this.scaleTop);
        if (this.includeCapacity) {
            this.chart.getXYPlot().getRangeAxis(1).setRange(0.0, this.roundUp(ds.getMinMaxCapacity().max * 1.03, 0.1));
        }
        if (this.includeEnergy) {
            this.chart.getXYPlot().getRangeAxis(2).setRange(0.0, this.roundUp(ds.getMinMaxEnergy().max * 1.07, 0.1));
        }
        if (this.includeTemperature) {
            this.chart.getXYPlot().getRangeAxis(3).setRange(this.roundDown(ds.getMinMaxTemperature().min, 5.0), this.roundUp(ds.getMinMaxTemperature().max, 2.0));
        }
        if (this.includeAverageCurrent) {
            this.chart.getXYPlot().getRangeAxis(4).setRange(0.0, this.roundUp(ds.getMinMaxCurrent().max, 0.2));
            this.chart.getXYPlot().getRangeAxis(4).setVisible(!this.includeCurrent);
        }
        if (this.includeRi) {
            this.chart.getXYPlot().getRangeAxis(5).setRange(this.roundDown(this.minRi, 5.0), this.roundUp(this.maxRi, 5.0));
        }
        if (this.includeCurrent) {
            this.chart.getXYPlot().getRangeAxis(6).setRange(0.0, this.roundUp(ds.getMinMaxCurrent().max, 0.2));
        }
    }

    private void setupCopyrightAnnotation(int chartHeight) {
        this.copyrightText.setText(chartHeight == 0 ? "" : Support.copyright);
        double x = this.chart.getXYPlot().getDomainAxis().getRange().getUpperBound();
        this.copyrightText.setY((this.scaleTop - this.scaleBottom) * 0.99 + this.scaleBottom);
        this.copyrightText.setX(x * 0.99);
    }

    private void setupAnnotations() {
        this.setupAnnotations(420);
    }

    private void setupAnnotations(int chartHeight) {
        if (this.includeTCE && !Support.charging) {
            DataSet ds = Support.dataSet;
            double lineHeight = (this.scaleTop - this.scaleBottom) * 20.0 / (double)chartHeight;
            int line = 1;
            double v = 0.0;
            double x = this.chart.getXYPlot().getDomainAxis().getRange().getLowerBound();
            String s = "";
            this.timeText.setText(" Time: " + Support.formatTime(this.lastCurrent.getTimeStamp() / 1000L));
            this.timeText.setY(this.scaleTop - lineHeight * (double)line);
            this.timeText.setX(x);
            if (ds.isCapacityPresent()) {
                v = ds.getMinMaxCapacity().max;
                if (v < 0.0) {
                    v = 0.0;
                }
                s = " Capacity: " + Support.nf3.format(v) + " Ah";
            }
            this.capacityText.setText(s);
            this.capacityText.setY(this.scaleTop - lineHeight * (double)(line + 1));
            this.capacityText.setX(x);
            s = "";
            if (ds.isEnergyPresent()) {
                v = ds.getMinMaxEnergy().max;
                if (v < 0.0) {
                    v = 0.0;
                }
                s = " Energy: " + Support.nf3.format(v) + " Wh";
            }
            this.energyText.setText(s);
            this.energyText.setY(this.scaleTop - lineHeight * (double)(line + 2));
            this.energyText.setX(x);
        } else {
            this.timeText.setText("");
            this.capacityText.setText("");
            this.energyText.setText("");
        }
    }

    private void setupEOCMarker() {
        if (this.eocLine != null) {
            this.chart.getXYPlot().removeAnnotation(this.eocLine);
            this.eocLine = null;
        }
        if (this.includeEOC && !Support.charging) {
            double x = 0.0;
            switch (this.dau) {
                case time: {
                    switch (this.tu) {
                        case seconds: {
                            x = (double)this.lastCurrent.getTimeStamp() / 1000.0;
                            break;
                        }
                        case minutes: {
                            x = (double)this.lastCurrent.getTimeStamp() / 1000.0 / 60.0;
                            break;
                        }
                        case hours: {
                            x = (double)this.lastCurrent.getTimeStamp() / 1000.0 / 3600.0;
                            break;
                        }
                        case days: {
                            x = (double)this.lastCurrent.getTimeStamp() / 1000.0 / 3600.0 / 24.0;
                        }
                    }
                    break;
                }
                case capacity: {
                    x = this.lastCurrent.getCapacity();
                    break;
                }
                case energy: {
                    x = this.lastCurrent.getEnergy();
                    break;
                }
                case pct0_100: {
                    x = 100.0;
                    break;
                }
                case pct100_0: {
                    x = 100.0;
                }
            }
            this.eocLine = new XYLineAnnotation(x, this.scaleBottom, x, this.scaleTop, new BasicStroke(2.0f), Color.YELLOW);
            this.chart.getXYPlot().addAnnotation(this.eocLine);
        }
    }

    private void setup() {
        this.setupAxis(this.includeCapacity, 1, this.datasetCapacity, "Capacity", Color.blue);
        this.setupAxis(this.includeEnergy, 2, this.datasetEnergy, "Energy", new Color(120, 120, 50));
        this.setupAxis(this.includeTemperature, 3, this.datasetTemperature, "Temperature", Color.magenta);
        this.setupAxis(this.includeAverageCurrent, 4, this.datasetAverageCurrent, "Average current", new Color(0, 156, 0));
        this.setupAxis(this.includeRi, 5, this.datasetRi, "IR", new Color(0, 50, 156));
        this.setupAxis(this.includeCurrent, 6, this.datasetCurrent, "Current", Color.green);
        this.setupAnnotations();
        this.setupEOCMarker();
    }

    private double[][] calculateAverage(double[][] table, int samples) {
        if (table.length == 0) {
            return new double[0][0];
        }
        if (table[0].length <= samples || samples < 2) {
            return table;
        }
        double[][] result = new double[table.length][table[0].length - samples];
        double average = 0.0;
        int input = 0;
        int output = 0;
        int i = 0;
        while (i < samples) {
            average += table[1][input++];
            ++i;
        }
        i = 0;
        while (i < table[0].length - samples) {
            result[0][output] = table[0][input - samples / 2];
            result[1][output] = average / (double)samples;
            average += table[1][input] - table[1][input - samples];
            ++input;
            ++output;
            ++i;
        }
        return result;
    }

    public void update(boolean force) {
        DataSet ds = Support.dataSet;
        this.chart.setNotify(false);
        this.tu = ds.getTimeUnit();
        if (this.lastPulsingStatus != Support.dataSet.isCurrentPulsing() || this.lastCharging != Support.charging) {
            this.setup();
            this.updateControls();
            this.lastPulsingStatus = Support.dataSet.isCurrentPulsing();
            this.lastCharging = Support.charging;
            force = true;
        }
        DataSet.Field domainField = DataSet.Field.timeStamp;
        this.lastCurrent = ds.getLastPoint(0.003);
        if (force || this.chartPanel.isShowing() && ds.isUpdated()) {
            switch (this.dau) {
                case time: {
                    domainField = DataSet.Field.timeStamp;
                    this.chart.getXYPlot().getDomainAxis().setAttributedLabel("Time");
                    break;
                }
                case capacity: {
                    domainField = DataSet.Field.capacity;
                    this.chart.getXYPlot().getDomainAxis().setAttributedLabel("Capacity");
                    break;
                }
                case energy: {
                    domainField = DataSet.Field.energy;
                    this.chart.getXYPlot().getDomainAxis().setAttributedLabel("Energy");
                    break;
                }
                case pct0_100: {
                    domainField = DataSet.Field.capacity;
                    this.chart.getXYPlot().getDomainAxis().setAttributedLabel("Percent of capacity");
                    break;
                }
                case pct100_0: {
                    domainField = DataSet.Field.capacity;
                    this.chart.getXYPlot().getDomainAxis().setAttributedLabel("Percent of capacity");
                }
            }
            this.chart.getXYPlot().getDomainAxis().setAutoRange(true);
            try {
                int i;
                this.setupAnnotations();
                this.setupEOCMarker();
                double[][] volt = ds.getSeries(domainField, DataSet.Field.voltage);
                double[][] current = ds.getSeries(domainField, DataSet.Field.current);
                if (this.dau == DomainAxisUnit.pct0_100 || this.dau == DomainAxisUnit.pct100_0) {
                    int i2 = 0;
                    while (i2 < volt[0].length) {
                        double[] dArray = volt[0];
                        int n = i2;
                        dArray[n] = dArray[n] / (this.lastCurrent.getCapacity() / 100.0);
                        current[0][i2] = volt[0][i2];
                        ++i2;
                    }
                }
                if (this.includeAverageCurrent && current.length > 0 && current[0].length > 0) {
                    int samples = current[0].length / 400;
                    if (samples < 30) {
                        samples = 30;
                    }
                    this.datasetAverageCurrent.addSeries((Comparable)((Object)"Average current"), this.calculateAverage(current, samples));
                } else {
                    this.datasetCurrent.removeSeries((Comparable)((Object)"Average current"));
                }
                if (this.includeRi && current.length > 0 && current[0].length > 50) {
                    double[][] ri = new double[2][current[0].length / 3 + 3];
                    int ii = 0;
                    double calcRi = 0.0;
                    double onCurrent = ds.getMinMaxCurrent().max * 0.95;
                    double offCurrent = ds.getMinMaxCurrent().max * 0.05;
                    boolean isOn = current[1][4] > onCurrent;
                    double miRi = Double.MAX_VALUE;
                    double mxRi = Double.MIN_VALUE;
                    int i3 = 5;
                    while (i3 < current[0].length) {
                        boolean s;
                        boolean bl = s = current[1][i3] > onCurrent;
                        if (s && s != isOn) {
                            double di;
                            double dv;
                            int j = i3 - 1;
                            if (current[1][j] > offCurrent) {
                                --j;
                            }
                            if ((calcRi = Math.abs((dv = volt[1][j] - volt[1][i3]) / (di = current[1][j] - current[1][i3])) * 1000.0) < miRi) {
                                miRi = calcRi;
                            }
                            if (calcRi > mxRi) {
                                mxRi = calcRi;
                            }
                            ri[0][ii] = current[0][i3];
                            ri[1][ii++] = calcRi;
                        }
                        isOn = s;
                        ++i3;
                    }
                    double[][] rix = new double[2][ii];
                    int i4 = 0;
                    while (i4 < ii) {
                        rix[0][i4] = ri[0][i4];
                        rix[1][i4] = ri[1][i4];
                        ++i4;
                    }
                    this.minRi = miRi;
                    this.maxRi = mxRi;
                    this.datasetRi.addSeries((Comparable)((Object)"IR"), this.calculateAverage(rix, rix[0].length / 50));
                } else {
                    this.datasetRi.removeSeries((Comparable)((Object)"IR"));
                }
                if (volt[1].length > 30) {
                    switch (this.voltageShow) {
                        case all: {
                            break;
                        }
                        case on: {
                            double v = 0.0;
                            double lowLimit = ds.getMinMaxCurrent().getRange(0.95);
                            boolean found = false;
                            int i5 = 5;
                            while (i5 < volt[1].length) {
                                if (current[1][i5] > lowLimit) {
                                    v = volt[1][i5];
                                    found = true;
                                    break;
                                }
                                ++i5;
                            }
                            if (!found) break;
                            i5 = 0;
                            while (i5 < volt[1].length) {
                                if (current[1][i5] > lowLimit) {
                                    v = volt[1][i5];
                                }
                                volt[1][i5] = v;
                                ++i5;
                            }
                            break;
                        }
                        case off: {
                            double v = 0.0;
                            double lowLimit = ds.getMinMaxCurrent().getRange(0.2);
                            boolean found = false;
                            int i5 = 5;
                            while (i5 < volt[1].length) {
                                if (current[1][i5] < lowLimit) {
                                    v = volt[1][i5];
                                    found = true;
                                    break;
                                }
                                ++i5;
                            }
                            if (!found) break;
                            i5 = 0;
                            while (i5 < volt[1].length) {
                                if (current[1][i5] < lowLimit) {
                                    v = volt[1][i5];
                                }
                                volt[1][i5] = v;
                                ++i5;
                            }
                            break;
                        }
                    }
                }
                this.datasetVoltage.addSeries((Comparable)((Object)"Voltage"), volt);
                if (this.includeCurrent) {
                    this.datasetCurrent.addSeries((Comparable)((Object)"Current"), current);
                } else {
                    this.datasetCurrent.removeSeries((Comparable)((Object)"Current"));
                }
                if (this.includeCapacity) {
                    double[][] cap = ds.getSeries(domainField, DataSet.Field.capacity);
                    if (this.dau == DomainAxisUnit.pct0_100 || this.dau == DomainAxisUnit.pct100_0) {
                        i = 0;
                        while (i < volt[0].length) {
                            cap[0][i] = volt[0][i];
                            ++i;
                        }
                    }
                    this.datasetCapacity.addSeries((Comparable)((Object)"Capacity"), cap);
                } else {
                    this.datasetCapacity.removeSeries((Comparable)((Object)"Capacity"));
                }
                if (this.includeEnergy) {
                    double[][] ene = ds.getSeries(domainField, DataSet.Field.energy);
                    if (this.dau == DomainAxisUnit.pct0_100 || this.dau == DomainAxisUnit.pct100_0) {
                        i = 0;
                        while (i < volt[0].length) {
                            ene[0][i] = volt[0][i];
                            ++i;
                        }
                    }
                    this.datasetEnergy.addSeries((Comparable)((Object)"Energy"), ene);
                } else {
                    this.datasetEnergy.removeSeries((Comparable)((Object)"Energy"));
                }
                if (this.includeTemperature) {
                    double[][] temp = ds.getSeries(domainField, DataSet.Field.temperature);
                    if (this.dau == DomainAxisUnit.pct0_100 || this.dau == DomainAxisUnit.pct100_0) {
                        i = 0;
                        while (i < volt[0].length) {
                            temp[0][i] = volt[0][i];
                            ++i;
                        }
                    }
                    this.datasetTemperature.addSeries((Comparable)((Object)"Temperature"), temp);
                } else {
                    this.datasetTemperature.removeSeries((Comparable)((Object)"Temperature"));
                }
                this.setScale();
                this.chart.setNotify(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveDirect() {
        this.updateControls();
        this.actionPerformed(null);
        this.setup();
        this.update(true);
        this.saveChart();
    }

    void updateAll() {
        this.closePopup();
        this.updateControls();
        this.actionPerformed(null);
        this.setup();
        this.update(true);
    }

    public void saveChart() {
        JPanel savePanel = new JPanel();
        BoxLayout bl = new BoxLayout(savePanel, 3);
        savePanel.setLayout(bl);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton res1RadioButton = new JRadioButton("500 x 250");
        bg.add(res1RadioButton);
        savePanel.add(res1RadioButton);
        res1RadioButton.setSelected(true);
        JRadioButton res2RadioButton = new JRadioButton("800 x 400");
        bg.add(res2RadioButton);
        savePanel.add(res2RadioButton);
        JRadioButton res3RadioButton = new JRadioButton("1200 x 700");
        bg.add(res3RadioButton);
        savePanel.add(res3RadioButton);
        JRadioButton res4RadioButton = new JRadioButton("2000 x 1000");
        bg.add(res4RadioButton);
        savePanel.add(res4RadioButton);
        JRadioButton res5RadioButton = new JRadioButton("Custom");
        bg.add(res5RadioButton);
        savePanel.add(res5RadioButton);
        switch (this.lastSaveResolution) {
            case 0: {
                res1RadioButton.setSelected(true);
                break;
            }
            case 1: {
                res2RadioButton.setSelected(true);
                break;
            }
            case 2: {
                res3RadioButton.setSelected(true);
                break;
            }
            case 3: {
                res4RadioButton.setSelected(true);
                break;
            }
            case 4: {
                res5RadioButton.setSelected(true);
            }
        }
        JPanel p1 = new JPanel();
        p1.add(new JLabel("W:"));
        JTextField wTextField = new JTextField(5);
        wTextField.setText("" + this.lastCustomWidth);
        p1.add(wTextField);
        savePanel.add(p1);
        JPanel p2 = new JPanel();
        p2.add(new JLabel("H:"));
        JTextField hTextField = new JTextField(5);
        hTextField.setText("" + this.lastCustomHeight);
        p2.add(hTextField);
        savePanel.add(p2);
        JFileChooser fc = new JFileChooser();
        if (Support.defaultFilePath != null) {
            fc.setCurrentDirectory(new File(Support.defaultFilePath));
        }
        fc.setFileFilter(new FileNameExtensionFilter("PNG", "png"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setAccessory(savePanel);
        fc.setSelectedFile(new File(Support.currentFilename));
        if (fc.showDialog(null, "Save chart") == 0) {
            File f = fc.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(String.valueOf(f.getPath()) + ".png");
            }
            if (f.exists() && JOptionPane.showConfirmDialog(null, "File exists, overwrite?", "File exists", 1) != 0) {
                return;
            }
            Support.defaultFilePath = fc.getCurrentDirectory().getPath();
            int w = 0;
            int h = 0;
            if (res1RadioButton.isSelected()) {
                w = 500;
                h = 250;
                this.lastSaveResolution = 0;
            } else if (res2RadioButton.isSelected()) {
                w = 800;
                h = 400;
                this.lastSaveResolution = 1;
            } else if (res3RadioButton.isSelected()) {
                w = 1200;
                h = 700;
                this.lastSaveResolution = 2;
            } else if (res4RadioButton.isSelected()) {
                w = 2000;
                h = 1000;
                this.lastSaveResolution = 3;
            } else if (res5RadioButton.isSelected()) {
                w = Integer.parseInt(wTextField.getText());
                h = Integer.parseInt(hTextField.getText());
                this.lastSaveResolution = 4;
                this.lastCustomWidth = w;
                this.lastCustomHeight = h;
            }
            try {
                ImageIO.write((RenderedImage)this.generateImage(w, h), "png", f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum DomainAxisUnit {
        time,
        capacity,
        energy,
        pct0_100,
        pct100_0;

    }

    class DomainFormat
    extends NumberFormat {
        private DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);

        public DomainFormat() {
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(2);
        }

        @Override
        public StringBuffer format(double arg0, StringBuffer arg1, FieldPosition arg2) {
            switch (ChargeChartPanel.this.dau) {
                case time: {
                    int u = 115;
                    if (ChargeChartPanel.this.tu == DataSet.TimeUnit.seconds) {
                        this.nf.setMaximumFractionDigits(1);
                    } else if (ChargeChartPanel.this.tu == DataSet.TimeUnit.minutes) {
                        u = 109;
                        this.nf.setMaximumFractionDigits(2);
                    } else if (ChargeChartPanel.this.tu == DataSet.TimeUnit.hours) {
                        u = 104;
                        this.nf.setMaximumFractionDigits(2);
                    } else if (ChargeChartPanel.this.tu == DataSet.TimeUnit.days) {
                        u = 100;
                        this.nf.setMaximumFractionDigits(2);
                    }
                    this.nf.format(arg0, arg1, arg2);
                    arg1.append((char)u);
                    break;
                }
                case capacity: {
                    Support.nf3.format(arg0, arg1, arg2);
                    break;
                }
                case energy: {
                    Support.nf3.format(arg0, arg1, arg2);
                    break;
                }
                case pct0_100: {
                    Support.nf.format(arg0, arg1, arg2);
                    arg1.append('%');
                    break;
                }
                case pct100_0: {
                    Support.nf.format(100.0 - arg0, arg1, arg2);
                    arg1.append('%');
                }
            }
            return arg1;
        }

        @Override
        public StringBuffer format(long arg0, StringBuffer arg1, FieldPosition arg2) {
            return arg1;
        }

        @Override
        public Number parse(String arg0, ParsePosition arg1) {
            return null;
        }
    }

    public class PointValues {
        DataSet.DataPoint dp;
        Double ri = null;
        Double avgCurrent = null;
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavor.equals(flavors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static enum VoltageShow {
        off,
        all,
        on;

    }
}

