/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChargeChartPanel;
import dk.hkj.main.DataSet;
import dk.hkj.main.Support;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartPopup {
    private JFrame frame;
    private JLabel indexLabel;
    private JLabel timeLabel;
    private JLabel secondsLabel;
    private JLabel minuteLabel;
    private JLabel currentLabel;
    private JLabel voltageLabel;
    private JLabel capacityLabel;
    private JLabel energyLabel;
    private JLabel temperatureLabel;
    private JLabel percentLabel;
    private JLabel averageCurrentLabel;
    private JLabel irLabel;

    public ChartPopup(Point location) {
        this.createAndShow(location);
    }

    private void createAndShow(Point location) {
        this.frame = new JFrame("Values");
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent arg0) {
                ChartPopup.this.frame = null;
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        JPanel panel = new JPanel();
        this.frame.add(panel);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 10, 10, 10));
        GridLayout layout = new GridLayout(13, 3, 2, 2);
        panel.setLayout(layout);
        this.indexLabel = new JLabel("");
        this.indexLabel.setHorizontalAlignment(0);
        this.timeLabel = new JLabel("");
        this.timeLabel.setHorizontalAlignment(0);
        this.secondsLabel = new JLabel("");
        this.secondsLabel.setHorizontalAlignment(0);
        this.minuteLabel = new JLabel("");
        this.minuteLabel.setHorizontalAlignment(0);
        this.voltageLabel = new JLabel("");
        this.voltageLabel.setHorizontalAlignment(0);
        this.currentLabel = new JLabel("");
        this.currentLabel.setHorizontalAlignment(0);
        this.capacityLabel = new JLabel("");
        this.capacityLabel.setHorizontalAlignment(0);
        this.energyLabel = new JLabel("");
        this.energyLabel.setHorizontalAlignment(0);
        this.temperatureLabel = new JLabel("");
        this.temperatureLabel.setHorizontalAlignment(0);
        this.percentLabel = new JLabel("");
        this.percentLabel.setHorizontalAlignment(0);
        this.averageCurrentLabel = new JLabel("");
        this.averageCurrentLabel.setHorizontalAlignment(0);
        this.irLabel = new JLabel("");
        this.irLabel.setHorizontalAlignment(0);
        panel.add(new JLabel("Index"));
        panel.add(this.indexLabel);
        panel.add(new JLabel(""));
        panel.add(new JLabel("Time"));
        panel.add(this.timeLabel);
        panel.add(new JLabel(""));
        panel.add(new JLabel("Seconds"));
        panel.add(this.secondsLabel);
        panel.add(new JLabel("sec."));
        panel.add(new JLabel("Minutes"));
        panel.add(this.minuteLabel);
        panel.add(new JLabel("min."));
        panel.add(new JLabel("Voltage"));
        panel.add(this.voltageLabel);
        panel.add(new JLabel("Volt"));
        panel.add(new JLabel("Current"));
        panel.add(this.currentLabel);
        panel.add(new JLabel("Ampere"));
        panel.add(new JLabel("Capacity"));
        panel.add(this.capacityLabel);
        panel.add(new JLabel("Amp-hours"));
        panel.add(new JLabel("Energy"));
        panel.add(this.energyLabel);
        panel.add(new JLabel("Watt-hours"));
        panel.add(new JLabel("Temperature"));
        panel.add(this.temperatureLabel);
        panel.add(new JLabel("\ufffdC"));
        panel.add(new JLabel("Percent"));
        panel.add(this.percentLabel);
        panel.add(new JLabel("% capacity"));
        panel.add(new JLabel("Average"));
        panel.add(this.averageCurrentLabel);
        panel.add(new JLabel("A"));
        panel.add(new JLabel("IR"));
        panel.add(this.irLabel);
        panel.add(new JLabel("mOhm"));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChartPopup.this.frame.setVisible(false);
                ChartPopup.this.frame.dispose();
                ChartPopup.this.frame = null;
            }
        });
        panel.add(new JLabel());
        panel.add(closeButton);
        this.frame.pack();
        this.frame.setLocation(location);
        this.frame.setVisible(true);
        this.frame.setAlwaysOnTop(true);
    }

    public void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }

    public boolean update(ChargeChartPanel.PointValues pv) {
        if (this.frame == null) {
            return false;
        }
        DataSet ds = Support.dataSet;
        this.indexLabel.setText(Long.toString(pv.dp.getIndex()));
        this.timeLabel.setText(Support.formatTime(pv.dp.getTimeStamp() / 1000L));
        this.secondsLabel.setText(Support.nf1.format(pv.dp.getSeconds()));
        this.minuteLabel.setText(Support.nf1.format(pv.dp.getMinutes()));
        this.voltageLabel.setText(Support.nf3.format(pv.dp.getVoltage()));
        this.currentLabel.setText(ds.isCurrentPresent() ? Support.nf3.format(pv.dp.getCurrent()) : "");
        this.capacityLabel.setText(ds.isCapacityPresent() ? Support.nf3.format(pv.dp.getCapacity()) : "");
        this.energyLabel.setText(ds.isEnergyPresent() ? Support.nf3.format(pv.dp.getEnergy()) : "");
        this.temperatureLabel.setText(ds.isTemperaturePresent() ? Support.nf1.format(pv.dp.getTemperature()) : "");
        this.percentLabel.setText(ds.isCapacityPresent() ? Support.nf1.format(pv.dp.getCapacity() / ds.getMinMaxCapacity().max * 100.0) : "");
        this.averageCurrentLabel.setText(pv.avgCurrent != null ? Support.nf3.format(pv.avgCurrent) : "");
        this.irLabel.setText(pv.ri != null ? Support.nf1.format(pv.ri) : "");
        return true;
    }
}

