/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.Support;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DataSet
implements Iterable<DataPoint> {
    private boolean updated = false;
    List<DataPoint> list = null;
    private MinMax minMaxVoltage = null;
    private MinMax minMaxCurrent = null;
    private MinMax minMaxCapacity = null;
    private MinMax minMaxEnergy = null;
    private MinMax minMaxTemperature = null;
    private long localTimeOffset = System.currentTimeMillis();
    private boolean indexPresent = false;
    private boolean voltagePresent = false;
    private boolean timeStampPresent = true;
    private boolean currentPresent = true;
    private boolean temperaturePresent = true;
    private boolean capacityPresent = true;
    private boolean energyPresent = true;
    private int currentPulsingCount = 0;
    private List<Field> fields = null;
    private double currentScale = 1.0;
    private double capacityScale = 1.0;
    private boolean temperatureAutoScale = false;
    private boolean checkForSwap = false;
    private static DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);

    static {
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(5);
    }

    public DataSet() {
        this.list = new ArrayList<DataPoint>(1000);
        this.minMaxVoltage = new MinMax();
        this.minMaxCurrent = new MinMax();
        this.minMaxCapacity = new MinMax();
        this.minMaxEnergy = new MinMax();
        this.minMaxTemperature = new MinMax();
        this.clear();
    }

    public synchronized void addPoint(DataPoint dp) {
        if (dp != null) {
            this.minMaxVoltage.value(dp.getVoltage());
            this.minMaxCurrent.value(dp.getCurrent());
            this.minMaxCapacity.value(dp.getCapacity());
            this.minMaxEnergy.value(dp.getEnergy());
            this.minMaxTemperature.value(dp.getTemperature());
            if (dp.getCurrent() > 0.2 && this.list.size() > 0 && this.list.get(this.list.size() - 1).getCurrent() < 0.05) {
                ++this.currentPulsingCount;
            }
            this.list.add(dp);
            this.updated = true;
        }
    }

    public synchronized void addPoint(int index, long time, double voltage, double current, double capacity, double energy, double temperature) {
        this.addPoint(new DataPoint(index, time, voltage, current, capacity, energy, temperature));
    }

    @Override
    public synchronized Iterator<DataPoint> iterator() {
        return new Iterator<DataPoint>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < DataSet.this.list.size();
            }

            @Override
            public DataPoint next() {
                return DataSet.this.list.get(this.pos++);
            }
        };
    }

    public synchronized int size() {
        return this.list.size();
    }

    public boolean isCurrentPulsing() {
        return this.currentPulsingCount > 100;
    }

    public boolean isCurrentPresent() {
        return this.currentPresent;
    }

    public boolean isCapacityPresent() {
        return this.capacityPresent;
    }

    public boolean isEnergyPresent() {
        return this.energyPresent;
    }

    public boolean isTemperaturePresent() {
        return this.temperaturePresent;
    }

    public synchronized boolean isUpdated() {
        boolean u = this.updated;
        this.updated = false;
        return u;
    }

    public synchronized void clear() {
        this.list.clear();
        this.currentPulsingCount = 0;
        this.updated = true;
        this.minMaxVoltage.reset();
        this.minMaxCurrent.reset();
        this.minMaxCapacity.reset();
        this.minMaxEnergy.reset();
        this.minMaxTemperature.reset();
        this.localTimeOffset = System.currentTimeMillis();
        this.indexPresent = true;
        this.voltagePresent = true;
        this.timeStampPresent = true;
        this.temperaturePresent = true;
        this.currentPresent = true;
        this.capacityPresent = true;
        this.energyPresent = true;
    }

    public synchronized DataPoint getLast() {
        if (this.list.size() == 0) {
            return new DataPoint(0, 0L, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return this.list.get(this.list.size() - 1);
    }

    public synchronized DataPoint get(int index) {
        if (index >= this.list.size() || index < 0) {
            System.out.println("Data requiest out of bound: " + index + " valid range: 0 - " + (this.list.size() - 1));
            return new DataPoint(0, 0L, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return this.list.get(index);
    }

    public synchronized DataPoint getAverage(int first, int count) {
        DataPoint sum = new DataPoint();
        count = Math.min(count, this.size() - first);
        int i = 0;
        while (i < count) {
            sum.add(this.get(first + i));
            ++i;
        }
        sum.divide(count);
        return sum;
    }

    public synchronized DataPoint getMin(int first, int count) {
        DataPoint min = new DataPoint();
        count = Math.min(count, this.size() - first);
        min.setMax();
        int i = 0;
        while (i < count) {
            min.min(this.get(first + i));
            ++i;
        }
        return min;
    }

    public synchronized DataPoint getMax(int first, int count) {
        DataPoint max = new DataPoint();
        count = Math.min(count, this.size() - first);
        max.setMin();
        int i = 0;
        while (i < count) {
            max.max(this.get(first + i));
            ++i;
        }
        return max;
    }

    public synchronized DataPoint getSlope(int first, int count) {
        DataPoint sumy = new DataPoint();
        DataPoint sumxy = new DataPoint();
        count = Math.min(count, this.size() - first);
        long sumx = 0L;
        long sumxx = 0L;
        int i = 0;
        while (i < count) {
            DataPoint dp = this.get(i + first);
            sumx += (long)i;
            sumy.add(dp);
            sumxx += (long)(i * i);
            DataPoint dataPoint = sumxy;
            dataPoint.timeStamp = dataPoint.timeStamp + dp.timeStamp * (long)i;
            DataPoint dataPoint2 = sumxy;
            dataPoint2.voltage = dataPoint2.voltage + dp.voltage * (double)i;
            DataPoint dataPoint3 = sumxy;
            dataPoint3.current = dataPoint3.current + dp.current * (double)i;
            DataPoint dataPoint4 = sumxy;
            dataPoint4.capacity = dataPoint4.capacity + dp.capacity * (double)i;
            DataPoint dataPoint5 = sumxy;
            dataPoint5.energy = dataPoint5.energy + dp.energy * (double)i;
            DataPoint dataPoint6 = sumxy;
            dataPoint6.temperature = dataPoint6.temperature + dp.temperature * (double)i;
            ++i;
        }
        DataPoint slopem = new DataPoint();
        slopem.timeStamp = ((long)count * sumxy.timeStamp - sumy.timeStamp * sumx) / ((long)count * sumxx - sumx * sumx);
        slopem.voltage = ((double)count * sumxy.voltage - sumy.voltage * (double)sumx) / (double)((long)count * sumxx - sumx * sumx);
        slopem.current = ((double)count * sumxy.current - sumy.current * (double)sumx) / (double)((long)count * sumxx - sumx * sumx);
        slopem.capacity = ((double)count * sumxy.capacity - sumy.capacity * (double)sumx) / (double)((long)count * sumxx - sumx * sumx);
        slopem.energy = ((double)count * sumxy.energy - sumy.energy * (double)sumx) / (double)((long)count * sumxx - sumx * sumx);
        slopem.temperature = ((double)count * sumxy.temperature - sumy.temperature * (double)sumx) / (double)((long)count * sumxx - sumx * sumx);
        slopem.multiply(count);
        return slopem;
    }

    public synchronized DataPoint getMin() {
        return this.getMin(0, this.size());
    }

    public synchronized DataPoint getMax() {
        return this.getMax(0, this.size());
    }

    public synchronized DataPoint getLastPoint(double minCurrent) {
        if (this.size() == 0) {
            return this.createDataPoint();
        }
        int i = this.size() - 1;
        while (i > 0 && this.get(i - 1).current <= minCurrent) {
            --i;
        }
        return this.get(i);
    }

    public synchronized DataPoint getSpan(int first, int count) {
        DataPoint max = this.getMax(first, count);
        max.sub(this.getMin(first, count));
        return max;
    }

    public synchronized DataPoint getChange(int first, int count) {
        count = Math.min(count, this.size() - first);
        DataPoint last = this.get(first + count - 1).clone();
        last.sub(this.get(first));
        return last;
    }

    public MinMax getMinMaxVoltage() {
        return this.minMaxVoltage;
    }

    public MinMax getMinMaxCurrent() {
        return this.minMaxCurrent;
    }

    public MinMax getMinMaxCapacity() {
        return this.minMaxCapacity;
    }

    public MinMax getMinMaxEnergy() {
        return this.minMaxEnergy;
    }

    public MinMax getMinMaxTemperature() {
        return this.minMaxTemperature;
    }

    public MinMax findMinMaxCurrent(int first, int count) {
        MinMax mm = new MinMax();
        int i = first;
        while (i < first + count) {
            if (i < this.size()) {
                mm.value(this.get(i).current);
            }
            ++i;
        }
        return mm;
    }

    public MinMax findMinMaxVoltage(int first, int count) {
        MinMax mm = new MinMax();
        int i = first;
        while (i < first + count) {
            if (i < this.size()) {
                mm.value(this.get(i).voltage);
            }
            ++i;
        }
        return mm;
    }

    public MinMax findMinMaxTemperature(int first, int count) {
        MinMax mm = new MinMax();
        int i = first;
        while (i < first + count) {
            if (i < this.size()) {
                mm.value(this.get(i).temperature);
            }
            ++i;
        }
        return mm;
    }

    public synchronized double[][] getSeries(Field x, Field y) {
        double[][] data = new double[2][this.size()];
        if (x == Field.timeStamp) {
            TimeUnit t = this.getTimeUnit();
            double f = 1.0;
            if (t == TimeUnit.seconds) {
                f = 1000.0;
            } else if (t == TimeUnit.minutes) {
                f = 60000.0;
            } else if (t == TimeUnit.hours) {
                f = 3600000.0;
            } else if (t == TimeUnit.days) {
                f = 8.64E7;
            }
            int i = 0;
            while (i < this.size()) {
                data[0][i] = this.get(i).getField(x) / f;
                data[1][i] = this.get(i).getField(y);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size()) {
                data[0][i] = this.get(i).getField(x);
                data[1][i] = this.get(i).getField(y);
                ++i;
            }
        }
        return data;
    }

    public void save(String fname) throws IOException {
        File f = new File(fname);
        if (!f.getName().contains(".")) {
            f = new File(String.valueOf(fname) + ".csv");
        }
        FileOutputStream os = new FileOutputStream(f);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        bw.write(String.valueOf(this.getCSVHeader()) + "\r\n");
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            for (DataPoint dp : this) {
                bw.write(dp.toString());
                bw.write("\r\n");
            }
        }
    }

    private int parseHeader(String line, String deli, boolean charge) {
        this.currentScale = 1.0;
        this.capacityScale = 1.0;
        this.temperatureAutoScale = false;
        this.checkForSwap = false;
        this.fields = new ArrayList<Field>();
        this.clear();
        this.indexPresent = false;
        this.voltagePresent = false;
        this.timeStampPresent = false;
        this.currentPresent = false;
        this.temperaturePresent = false;
        this.capacityPresent = false;
        this.energyPresent = false;
        int nn = 0;
        line = line.replaceAll("[\"]", "");
        String[] stringArray = line.split(deli);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Field field = Field.dummy;
            Field[] fieldArray = Field.values();
            int n3 = fieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Field ff = fieldArray[n4];
                if (field == Field.dummy) {
                    boolean found = false;
                    if (s.equalsIgnoreCase(ff.name())) {
                        field = ff;
                        if (ff == Field.current) {
                            ++nn;
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        switch (ff) {
                            case timeStamp: {
                                if (!s.equalsIgnoreCase("Time")) break;
                                field = ff;
                                break;
                            }
                            case voltage: {
                                if (s.toLowerCase().contains("voltage")) {
                                    field = ff;
                                    break;
                                }
                                if (s.equals("LoadV")) {
                                    field = ff;
                                    break;
                                }
                                if (!s.equals("SMSource")) break;
                                this.checkForSwap = true;
                                field = ff;
                                break;
                            }
                            case current: {
                                if (s.toLowerCase().contains("current") && !s.equals("MathAvgCurrent")) {
                                    field = ff;
                                    ++nn;
                                    break;
                                }
                                if (s.toLowerCase().contains("curent")) {
                                    field = ff;
                                    ++nn;
                                    break;
                                }
                                if (s.equals("LoadA") && !charge) {
                                    field = ff;
                                    ++nn;
                                    break;
                                }
                                if (s.equals("PSA") && charge) {
                                    field = ff;
                                    ++nn;
                                    break;
                                }
                                if (!s.equals("SMMeasure")) break;
                                field = ff;
                                this.checkForSwap = true;
                                ++nn;
                                break;
                            }
                            case capacity: {
                                if (s.contains("mAh")) {
                                    field = ff;
                                    this.capacityScale = 0.001;
                                    break;
                                }
                                if (s.equals("LoadAh") && !charge) {
                                    field = ff;
                                    break;
                                }
                                if (s.equals("PSAh") && charge) {
                                    field = ff;
                                    break;
                                }
                                if (!s.equals("SMAh")) break;
                                field = ff;
                                break;
                            }
                            case energy: {
                                if (s.equals("LoadWh") && !charge) {
                                    field = ff;
                                    break;
                                }
                                if (s.equals("PSWh") && charge) {
                                    field = ff;
                                    break;
                                }
                                if (!s.equals("SMWh")) break;
                                field = ff;
                                break;
                            }
                            case temperature: {
                                if (!s.toLowerCase().contains("temp")) break;
                                field = ff;
                                this.temperatureAutoScale = true;
                            }
                        }
                    }
                }
                ++n4;
            }
            if (field == Field.index) {
                this.indexPresent = true;
            }
            if (field == Field.timeStamp) {
                this.timeStampPresent = true;
            }
            if (field == Field.voltage) {
                this.voltagePresent = true;
            }
            if (field == Field.current) {
                this.currentPresent = true;
            }
            if (field == Field.capacity) {
                this.capacityPresent = true;
            }
            if (field == Field.energy) {
                this.energyPresent = true;
            }
            if (field == Field.temperature) {
                this.temperaturePresent = true;
            }
            this.fields.add(field);
            ++n2;
        }
        int i = 0;
        while (i < this.fields.size()) {
            System.out.print(String.valueOf(this.fields.get(i).name()) + ", ");
            ++i;
        }
        System.out.println();
        return nn;
    }

    private int nextFieldIndex(int i, Field ff) {
        int j = i + 1;
        while (j < this.fields.size()) {
            if (this.fields.get(j) == ff) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private void handleMultipleDataSets(int nn, MultipleDataSetDialog mdsd) {
        if (nn > 1) {
            String[] list = new String[nn];
            int setNo = 1;
            int i = 0;
            while (i < nn) {
                list[i] = "" + (i + 1);
                ++i;
            }
            String s = mdsd.askDataSet(list);
            if (s != null) {
                setNo = Integer.parseInt(s);
            }
            int i2 = 0;
            while (i2 < this.fields.size() / nn) {
                Field ff = this.fields.get(i2);
                int n = setNo;
                int j = this.nextFieldIndex(i2, ff);
                if (n != 1) {
                    this.fields.set(i2, Field.dummy);
                }
                --n;
                while (j >= 0) {
                    if (n != 1) {
                        this.fields.set(j, Field.dummy);
                    }
                    --n;
                    j = this.nextFieldIndex(j, ff);
                }
                ++i2;
            }
        }
    }

    private void loadDataSet(BufferedReader br, String deli) throws IOException {
        String line;
        double lastTime = 0.0;
        double capacity = 0.0;
        double energy = 0.0;
        int n = 0;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            if (deli.equals(";")) {
                line = line.replace(',', '.');
            }
            DataPoint dp = new DataPoint();
            String[] s = line.split(deli);
            int i = 0;
            while (i < s.length) {
                dp.setField(this.fields.get(i), s[i]);
                ++i;
            }
            if (!this.indexPresent) {
                dp.setField(Field.index, n++);
            }
            if (!this.timeStampPresent) {
                dp.setField(Field.timeStamp, dp.getIndex());
            }
            if (!this.capacityPresent && this.timeStampPresent && this.currentPresent) {
                dp.setField(Field.capacity, capacity += dp.getCurrent() * (dp.getSeconds() - lastTime) / 3600.0);
            }
            if (!this.energyPresent && this.timeStampPresent && this.currentPresent && this.voltagePresent) {
                dp.setField(Field.energy, energy += dp.getVoltage() * dp.getCurrent() * (dp.getSeconds() - lastTime) / 3600.0);
            }
            lastTime = dp.getSeconds();
            if (dp.getCurrent() > 0.2 && this.list.size() > 0 && this.list.get(this.list.size() - 1).getCurrent() < 0.05) {
                ++this.currentPulsingCount;
            }
            DataPoint dataPoint = dp;
            dataPoint.current = dataPoint.current * this.currentScale;
            DataPoint dataPoint2 = dp;
            dataPoint2.capacity = dataPoint2.capacity * this.capacityScale;
            if (this.temperatureAutoScale && dp.temperature < 1.0) {
                DataPoint dataPoint3 = dp;
                dataPoint3.temperature = dataPoint3.temperature * 100.0;
            }
            if (!dp.isDataValid()) continue;
            this.addPoint(dp);
        }
        if (this.checkForSwap && this.capacityPresent && this.currentPresent) {
            double deltaV;
            double capacityA = 0.0;
            double capacityV = 0.0;
            lastTime = 0.0;
            for (DataPoint dp : this) {
                capacityA += dp.getCurrent() * (dp.getSeconds() - lastTime) / 3600.0;
                capacityV += dp.getVoltage() * (dp.getSeconds() - lastTime) / 3600.0;
                lastTime = dp.getSeconds();
            }
            double deltaA = Math.abs((capacityA - this.minMaxCapacity.max) / capacityA);
            if (deltaA > (deltaV = Math.abs((capacityV - this.minMaxCapacity.max) / capacityV))) {
                this.swapVoltageCurrent();
            }
        }
    }

    public void load(String fname, MultipleDataSetDialog mdsd) throws IOException {
        File f = new File(fname);
        if (!f.getName().contains(".")) {
            f = new File(String.valueOf(fname) + ".csv");
        }
        FileInputStream is = new FileInputStream(f);
        InputStreamReader isr = new InputStreamReader(is);
        try (BufferedReader br = new BufferedReader(isr, 32768);){
            String line = br.readLine();
            String deli = line.contains(";") ? ";" : (line.contains(",") ? "," : (line.contains("\t") ? "\t" : " "));
            int nn = this.parseHeader(line, deli, !fname.toLowerCase().contains("discharge"));
            if (nn > 1) {
                this.handleMultipleDataSets(nn, mdsd);
            }
            this.loadDataSet(br, deli);
            if (this.timeStampPresent && this.currentPresent) {
                this.capacityPresent = true;
            }
            if (this.timeStampPresent && this.currentPresent && this.voltagePresent) {
                this.energyPresent = true;
            }
        }
    }

    public TimeUnit getTimeUnit() {
        long t = this.getLast().getTimeStamp() / 1000L;
        if (t < 600L) {
            return TimeUnit.seconds;
        }
        if (t < 36000L) {
            return TimeUnit.minutes;
        }
        if (t < 864000L) {
            return TimeUnit.hours;
        }
        return TimeUnit.days;
    }

    public DataPoint createDataPoint() {
        return new DataPoint();
    }

    public DataPoint createDataPoint(int index, long timeStamp, double voltage, double current, double capacity, double energy, double temperature) {
        return new DataPoint(index, timeStamp, voltage, current, capacity, energy, temperature);
    }

    public String getCSVHeader() {
        return new DataPoint().csvHeader();
    }

    private void swapVoltageCurrent() {
        this.minMaxVoltage.reset();
        this.minMaxCurrent.reset();
        for (DataPoint dp : this) {
            dp.swapVoltageCurrent();
            this.minMaxVoltage.value(dp.getVoltage());
            this.minMaxCurrent.value(dp.getCurrent());
        }
    }

    public String guessOperation() {
        double currLimit = this.minMaxCurrent.span() * 0.8 + this.minMaxCurrent.min;
        int n = 0;
        for (DataPoint dp : this) {
            if (!(dp.getCurrent() > currLimit)) continue;
            ++n;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i1 = 0;
        int i2 = 0;
        for (DataPoint dp : this) {
            if (!(dp.getCurrent() > currLimit)) continue;
            if (i1 < n / 2) {
                ++i1;
                sum1 += dp.getVoltage();
                continue;
            }
            ++i2;
            sum2 += dp.getVoltage();
        }
        return (sum1 /= (double)i1) > (sum2 /= (double)i2) ? "Discharge" : "Charge";
    }

    public class DataPoint {
        private long localTime;
        private int index;
        private long timeStamp;
        private double voltage;
        private double current;
        private double capacity;
        private double energy;
        private double temperature;
        private boolean validData = false;

        public DataPoint() {
            this.localTime = 0L;
            this.index = 0;
            this.timeStamp = 0L;
            this.voltage = 0.0;
            this.current = 0.0;
            this.capacity = 0.0;
            this.energy = 0.0;
            this.temperature = 0.0;
        }

        public DataPoint(int index, long timeStamp, double voltage, double current, double capacity, double energy, double temperature) {
            this.localTime = System.currentTimeMillis() - DataSet.this.localTimeOffset;
            this.index = index;
            this.timeStamp = timeStamp;
            this.voltage = voltage;
            this.current = current;
            this.capacity = capacity;
            this.energy = energy;
            this.temperature = temperature;
            this.validData = voltage != 0.0 || current != 0.0;
        }

        public boolean isDataValid() {
            return this.validData;
        }

        public DataPoint clone() {
            return new DataPoint(this.index, this.timeStamp, this.voltage, this.current, this.capacity, this.energy, this.temperature);
        }

        public void setField(Field name, double value) {
            switch (name) {
                case localTime: {
                    this.localTime = (long)(value * 1000.0);
                    break;
                }
                case index: {
                    this.index = (int)value;
                    break;
                }
                case timeStamp: {
                    this.timeStamp = (long)(value * 1000.0);
                    break;
                }
                case voltage: {
                    this.voltage = value;
                    this.validData = this.validData || this.voltage != 0.0;
                    break;
                }
                case current: {
                    this.current = value;
                    this.validData = this.validData || this.current != 0.0;
                    break;
                }
                case capacity: {
                    this.capacity = value;
                    break;
                }
                case energy: {
                    this.energy = value;
                    break;
                }
                case temperature: {
                    this.temperature = value;
                    break;
                }
            }
        }

        public void setField(Field name, String value) {
            if (value.trim().length() == 0) {
                return;
            }
            switch (name) {
                case localTime: {
                    this.localTime = (long)(Double.parseDouble(value) * 1000.0);
                    break;
                }
                case index: {
                    this.index = Integer.parseInt(value);
                    break;
                }
                case timeStamp: {
                    if (value.contains(":")) {
                        String[] s = value.split("[:]");
                        switch (s.length) {
                            case 1: {
                                this.timeStamp = Long.parseLong(s[0]) * 1000L;
                                break;
                            }
                            case 2: {
                                this.timeStamp = (Long.parseLong(s[0]) * 60L + Long.parseLong(s[1])) * 1000L;
                                break;
                            }
                            case 3: {
                                this.timeStamp = (Long.parseLong(s[0]) * 3600L + Long.parseLong(s[1]) * 60L + Long.parseLong(s[2])) * 1000L;
                            }
                        }
                        break;
                    }
                    this.timeStamp = (long)(Double.parseDouble(value) * 1000.0);
                    break;
                }
                case voltage: {
                    this.voltage = Math.abs(Double.parseDouble(value));
                    this.validData = this.validData || this.voltage != 0.0;
                    break;
                }
                case current: {
                    this.current = Math.abs(Double.parseDouble(value));
                    this.validData = this.validData || this.current != 0.0;
                    break;
                }
                case capacity: {
                    this.capacity = Math.abs(Double.parseDouble(value));
                    break;
                }
                case energy: {
                    this.energy = Math.abs(Double.parseDouble(value));
                    break;
                }
                case temperature: {
                    this.temperature = Double.parseDouble(value);
                    break;
                }
            }
        }

        public double getField(Field name) {
            switch (name) {
                case localTime: {
                    return this.localTime;
                }
                case index: {
                    return this.index;
                }
                case timeStamp: {
                    return this.timeStamp;
                }
                case voltage: {
                    return this.voltage;
                }
                case current: {
                    return this.current;
                }
                case capacity: {
                    return this.capacity;
                }
                case energy: {
                    return this.energy;
                }
                case temperature: {
                    return this.temperature;
                }
            }
            return 0.0;
        }

        public void setMin() {
            this.localTime = 0L;
            this.index = 0;
            this.timeStamp = Long.MIN_VALUE;
            this.voltage = Double.MIN_VALUE;
            this.current = Double.MIN_VALUE;
            this.capacity = Double.MIN_VALUE;
            this.energy = Double.MIN_VALUE;
            this.temperature = Double.MIN_VALUE;
        }

        public void setMax() {
            this.localTime = Long.MAX_VALUE;
            this.index = Integer.MAX_VALUE;
            this.timeStamp = Long.MAX_VALUE;
            this.voltage = Double.MAX_VALUE;
            this.current = Double.MAX_VALUE;
            this.capacity = Double.MAX_VALUE;
            this.energy = Double.MAX_VALUE;
            this.temperature = Double.MAX_VALUE;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        private String twoDigits(long n) {
            return "" + (char)(n / 10L % 10L + 48L) + (char)(n % 10L + 48L);
        }

        public String getFormattedTime() {
            StringBuilder sb = new StringBuilder();
            long h = Math.abs(this.timeStamp / 1000L);
            sb.append(this.twoDigits(h % 60L));
            sb.insert(0, ':');
            sb.insert(0, this.twoDigits((h /= 60L) % 60L));
            if ((h /= 60L) != 0L) {
                sb.insert(0, ':');
                sb.insert(0, h % 24L);
                if ((h /= 24L) != 0L) {
                    sb.insert(0, "d ");
                    sb.insert(0, h);
                }
            }
            if (this.timeStamp < 0L) {
                sb.insert(0, '-');
            }
            return sb.toString();
        }

        public double getSeconds() {
            return (double)this.timeStamp / 1000.0;
        }

        public double getMinutes() {
            return (double)this.timeStamp / 60000.0;
        }

        public double getHours() {
            return (double)this.timeStamp / 3600000.0;
        }

        public double getDays() {
            return this.getHours() / 24.0;
        }

        public double getTime(TimeUnit tu) {
            switch (tu) {
                case seconds: {
                    return this.getSeconds();
                }
                case minutes: {
                    return this.getMinutes();
                }
                case hours: {
                    return this.getHours();
                }
            }
            return this.getDays();
        }

        public double getCurrent() {
            return this.current;
        }

        public double getVoltage() {
            return this.voltage;
        }

        public double getCapacity() {
            return this.capacity;
        }

        public double getEnergy() {
            return this.energy;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public int getIndex() {
            return this.index;
        }

        public void swapVoltageCurrent() {
            double t = this.voltage;
            this.voltage = this.current;
            this.current = t;
        }

        public void add(DataPoint dp) {
            this.timeStamp += dp.timeStamp;
            this.voltage += dp.voltage;
            this.current += dp.current;
            this.capacity += dp.capacity;
            this.energy += dp.energy;
            this.temperature += dp.temperature;
        }

        public void sub(DataPoint dp) {
            this.timeStamp -= dp.timeStamp;
            this.voltage -= dp.voltage;
            this.current -= dp.current;
            this.capacity -= dp.capacity;
            this.energy -= dp.energy;
            this.temperature -= dp.temperature;
        }

        public void max(DataPoint dp) {
            this.timeStamp = Math.max(this.timeStamp, dp.timeStamp);
            this.voltage = Math.max(this.voltage, dp.voltage);
            this.current = Math.max(this.current, dp.current);
            this.capacity = Math.max(this.capacity, dp.capacity);
            this.energy = Math.max(this.energy, dp.energy);
            this.temperature = Math.max(this.temperature, dp.temperature);
        }

        public void min(DataPoint dp) {
            this.timeStamp = Math.min(this.timeStamp, dp.timeStamp);
            this.voltage = Math.min(this.voltage, dp.voltage);
            this.current = Math.min(this.current, dp.current);
            this.capacity = Math.min(this.capacity, dp.capacity);
            this.energy = Math.min(this.energy, dp.energy);
            this.temperature = Math.min(this.temperature, dp.temperature);
        }

        public void divide(int factor) {
            this.timeStamp = (this.timeStamp + (long)(factor / 2)) / (long)factor;
            this.voltage /= (double)factor;
            this.current /= (double)factor;
            this.capacity /= (double)factor;
            this.energy /= (double)factor;
            this.temperature /= (double)factor;
        }

        public void multiply(int factor) {
            this.timeStamp *= (long)factor;
            this.voltage *= (double)factor;
            this.current *= (double)factor;
            this.capacity *= (double)factor;
            this.energy *= (double)factor;
            this.temperature *= (double)factor;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (DataSet.this.indexPresent) {
                sb.append(this.index);
                sb.append(Support.csvDelimiter);
            }
            sb.append(nf.format((double)this.localTime / 1000.0));
            sb.append(Support.csvDelimiter);
            if (DataSet.this.timeStampPresent) {
                sb.append(this.timeStamp / 1000L);
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.voltagePresent) {
                sb.append(nf.format(this.voltage));
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.currentPresent) {
                sb.append(nf.format(this.current));
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.capacityPresent) {
                sb.append(nf.format(this.capacity));
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.energyPresent) {
                sb.append(nf.format(this.energy));
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.temperaturePresent) {
                sb.append(nf.format(this.temperature));
            }
            return sb.toString().replace('.', Support.csvDecimalPoint);
        }

        public String csvHeader() {
            StringBuilder sb = new StringBuilder();
            if (DataSet.this.indexPresent) {
                sb.append("index");
                sb.append(Support.csvDelimiter);
            }
            sb.append("localTime");
            sb.append(Support.csvDelimiter);
            if (DataSet.this.indexPresent) {
                sb.append("timeStamp");
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.indexPresent) {
                sb.append("voltage");
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.indexPresent) {
                sb.append("current");
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.indexPresent) {
                sb.append("capacity");
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.indexPresent) {
                sb.append("energy");
                sb.append(Support.csvDelimiter);
            }
            if (DataSet.this.indexPresent) {
                sb.append("temperature");
                sb.append(Support.csvDelimiter);
            }
            return sb.toString();
        }
    }

    public static enum Field {
        dummy,
        index,
        localTime,
        timeStamp,
        voltage,
        current,
        capacity,
        energy,
        temperature;

    }

    public static class MinMax {
        double min;
        double max;

        public MinMax() {
            this.reset();
        }

        public void reset() {
            this.min = Double.MAX_VALUE;
            this.max = Double.MIN_VALUE;
        }

        public double span() {
            return this.max - this.min;
        }

        public void value(double v) {
            if (v > this.max) {
                this.max = v;
            }
            if (v < this.min) {
                this.min = v;
            }
        }

        public double getRange(double factor) {
            return this.span() * factor + this.min;
        }
    }

    public static interface MultipleDataSetDialog {
        public String askDataSet(String[] var1);
    }

    static enum TimeUnit {
        seconds,
        minutes,
        hours,
        days;

    }
}

