/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import com.fazecast.jSerialComm.SerialPort;
import dk.hkj.main.DataSet;
import dk.hkj.main.Main;
import dk.hkj.main.PaneInterface;
import dk.hkj.main.SerialInterface;
import dk.hkj.main.Support;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PaneConfig
implements PaneInterface,
FocusListener,
ActionListener,
DataSet.MultipleDataSetDialog {
    private JLabel idLabel;
    private JPanel myPanel;
    private List<Port> portList;
    private JComboBox<Port> portComboBox;
    private JTextField idTextField;
    private JButton disconnectButton;
    private JButton connectButton;
    private JButton loadDataButton;
    private JButton clearDataButton;
    private JTextField batteryNameTextField;
    private JCheckBox logDataCheckBox;
    private JTextField csvDelimiterTextField;
    private JTextField csvDecimalPointTextField;
    private JTextField copyrightTextField;
    private Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneConfig.this.timerUpdate();
        }
    });

    public PaneConfig() {
        this.timer.start();
    }

    @Override
    public String getTitle() {
        return "Configuration";
    }

    @Override
    public JPanel getPanel() {
        this.myPanel = new JPanel();
        BoxLayout bl = new BoxLayout(this.myPanel, 3);
        this.myPanel.setLayout(bl);
        this.idLabel = new JLabel("Charger");
        this.idLabel.setHorizontalAlignment(0);
        this.myPanel.add(Support.centerJustify(this.idLabel));
        JPanel connectPanel = new JPanel();
        FlowLayout fl1 = new FlowLayout();
        fl1.setHgap(30);
        connectPanel.setLayout(fl1);
        this.myPanel.add(connectPanel);
        this.portList = new ArrayList<Port>();
        SerialPort[] serialPortArray = Support.serialInterface.getCommPorts();
        int n = serialPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            SerialPort sp = serialPortArray[n2];
            this.portList.add(new Port(sp.getDescriptivePortName(), sp));
            ++n2;
        }
        this.portList.sort(new Comparator<Port>(){

            @Override
            public int compare(Port o1, Port o2) {
                return o1.port.getSystemPortName().compareTo(o2.port.getSystemPortName());
            }
        });
        this.portList.add(0, new Port("Search", null));
        connectPanel.add(new JLabel("Id"));
        this.idTextField = new JTextField(3);
        if (Support.searchId != null) {
            this.idTextField.setText(Support.searchId);
        }
        connectPanel.add(this.idTextField);
        connectPanel.add(new JLabel("Port"));
        this.portComboBox = new JComboBox<Port>(this.portList.toArray(new Port[0]));
        connectPanel.add(this.portComboBox);
        boolean found = false;
        if (Support.searchCommPort != null && Support.searchCommPort.length() > 2) {
            for (Port p : this.portList) {
                if (!p.name.contains(Support.searchCommPort)) continue;
                this.portComboBox.setSelectedItem(p);
                found = true;
                break;
            }
        }
        String id = this.idTextField.getText().trim();
        if (!found && id.length() == 0) {
            for (Port p : this.portList) {
                if (!p.name.contains("CH340")) continue;
                this.portComboBox.setSelectedItem(p);
                break;
            }
        }
        this.connectButton = new JButton("Connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneConfig.this.connect();
            }
        });
        connectPanel.add(this.connectButton);
        this.disconnectButton = new JButton("Disconnect");
        this.disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneConfig.this.connectButton.setEnabled(true);
                PaneConfig.this.disconnectButton.setEnabled(false);
                Support.serialInterface.close();
            }
        });
        this.disconnectButton.setEnabled(false);
        connectPanel.add(this.disconnectButton);
        JPanel p2 = new JPanel();
        this.myPanel.add(p2);
        p2.add(new JLabel("Battery name"));
        this.batteryNameTextField = new JTextField(20);
        this.batteryNameTextField.setText(Support.batteryName);
        this.batteryNameTextField.addActionListener(this);
        this.batteryNameTextField.addFocusListener(this);
        p2.add(this.batteryNameTextField);
        p2.add(Box.createHorizontalStrut(50));
        this.logDataCheckBox = new JCheckBox("Log data during charge");
        this.logDataCheckBox.setSelected(Support.autoLog);
        this.logDataCheckBox.addActionListener(this);
        p2.add(this.logDataCheckBox);
        JPanel p3 = new JPanel();
        this.myPanel.add(p3);
        p3.add(new JLabel("CSV field delimeter"));
        this.csvDelimiterTextField = new JTextField(4);
        this.csvDelimiterTextField.setText(Support.displayCSVChar(Support.csvDelimiter));
        this.csvDelimiterTextField.setToolTipText("The only useful values are ; , and TAB");
        this.csvDelimiterTextField.addActionListener(this);
        this.csvDelimiterTextField.addFocusListener(this);
        p3.add(this.csvDelimiterTextField);
        p3.add(Box.createHorizontalStrut(30));
        p3.add(new JLabel("CSV decimal point"));
        this.csvDecimalPointTextField = new JTextField(4);
        this.csvDecimalPointTextField.setText(Support.displayCSVChar(Support.csvDecimalPoint));
        this.csvDecimalPointTextField.setToolTipText("The only useful values are , and .");
        this.csvDecimalPointTextField.addActionListener(this);
        this.csvDecimalPointTextField.addFocusListener(this);
        p3.add(this.csvDecimalPointTextField);
        p3.add(Box.createHorizontalStrut(100));
        p3.add(new JLabel("These values are used for saving CSV files, reading will auto detect"));
        JPanel p4 = new JPanel();
        this.myPanel.add(p4);
        p4.add(new JLabel("Copyright"));
        this.copyrightTextField = new JTextField(20);
        this.copyrightTextField.setText(Support.copyright);
        this.copyrightTextField.setToolTipText("Used when saving or copying the chart");
        this.copyrightTextField.addActionListener(this);
        this.copyrightTextField.addFocusListener(this);
        p4.add(this.copyrightTextField);
        JPanel p1 = new JPanel();
        this.myPanel.add(p1);
        this.loadDataButton = new JButton("Load CSV");
        this.loadDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneConfig.this.openFile();
            }
        });
        this.myPanel.add(this.loadDataButton);
        this.myPanel.add(Box.createVerticalStrut(30));
        this.clearDataButton = new JButton("Clear data");
        this.clearDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Support.dataSet.clear();
                Support.currentFilename = "";
            }
        });
        this.myPanel.add(this.clearDataButton);
        this.myPanel.add(Box.createVerticalStrut(30));
        return this.myPanel;
    }

    public void UpdateInputs() {
        Support.batteryName = this.batteryNameTextField.getText();
        Support.autoLog = this.logDataCheckBox.isSelected();
        Support.csvDelimiter = Support.parseCSVChar(this.csvDelimiterTextField.getText());
        Support.csvDecimalPoint = Support.parseCSVChar(this.csvDecimalPointTextField.getText());
        Support.copyright = this.copyrightTextField.getText();
    }

    public void connect() {
        Support.scanningForConnection = true;
        Port port = (Port)this.portComboBox.getSelectedItem();
        this.connectButton.setEnabled(false);
        String portString = null;
        if (port.port != null) {
            portString = port.port.getSystemPortName();
        }
        String id = this.idTextField.getText().trim();
        int idNo = -1;
        if (id.length() > 0) {
            idNo = Integer.parseInt(id);
        }
        Support.serialInterface.open(portString, idNo, new SerialInterface.Callback(){

            @Override
            public void portScanningDone() {
                if (Support.serialInterface.getPort() == null) {
                    PaneConfig.this.connectButton.setEnabled(true);
                } else {
                    PaneConfig.this.disconnectButton.setEnabled(true);
                }
                Support.scanningForConnection = false;
            }
        });
    }

    private void openFile() {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fc.setAcceptAllFileFilterUsed(false);
        if (Support.defaultFilePath != null) {
            fc.setCurrentDirectory(new File(Support.defaultFilePath));
        }
        if (fc.showDialog(this.myPanel, "Load") == 0) {
            try {
                Support.defaultFilePath = fc.getCurrentDirectory().getPath();
                File[] files = fc.getSelectedFiles();
                if (files.length == 1) {
                    Support.dataSet.load(files[0].getPath(), this);
                    String fname = files[0].getName();
                    int i = fname.lastIndexOf(46);
                    if (i > 0) {
                        fname = fname.substring(0, i);
                    }
                    Support.currentFilename = fname;
                } else if (files.length > 1) {
                    int i = 0;
                    while (i < files.length) {
                        Support.dataSet.load(files[i].getPath(), this);
                        String fname = files[i].getName();
                        int j = fname.lastIndexOf(46);
                        if (j > 0) {
                            fname = fname.substring(0, j);
                        }
                        Support.currentFilename = fname;
                        Main.main.saveDirect();
                        ++i;
                    }
                }
                Main.main.updateAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void timerUpdate() {
        this.loadDataButton.setEnabled(!Support.charging);
        this.clearDataButton.setEnabled(!Support.charging && Support.dataSet.size() > 0);
        this.connectButton.setEnabled(!Support.scanningForConnection && !Support.serialInterface.isOpen());
        this.disconnectButton.setEnabled(!Support.scanningForConnection && Support.serialInterface.isOpen());
    }

    @Override
    public void selected() {
        this.timerUpdate();
        this.timer.start();
    }

    @Override
    public void deselected() {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.UpdateInputs();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.UpdateInputs();
    }

    @Override
    public String askDataSet(String[] list) {
        return (String)JOptionPane.showInputDialog(this.myPanel.getRootPane(), "Multiple datasets in file, select one:\n", "CSV file selection", -1, null, list, "1");
    }

    class Port {
        String name;
        SerialPort port;

        Port(String name, SerialPort port) {
            this.name = name;
            this.port = port;
        }

        public String toString() {
            return this.name;
        }
    }
}

