/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.PaneInterface;
import dk.hkj.main.SerialInterface;
import dk.hkj.main.Support;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PaneSetupCalibrate
implements PaneInterface,
ActionListener,
FocusListener {
    private Timer timer = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PaneSetupCalibrate.this.timerUpdate();
        }
    });
    private JLabel voltageLabel;
    private JLabel currentLabel;
    private JLabel inputVoltageLabel;
    private JLabel temperatureLabel;
    private JTextField maxTempTextField;
    private JTextField idTextField;
    private JComboBox<String> tempSensorComboxBox;
    private JButton updateButton;
    private JButton i1Button;
    private JButton i2Button;
    private JButton v1Button;
    private JButton v2Button;
    private JButton enterButton;
    private JTextArea calibrationTextArea;
    private JLabel calLabel;
    private JTextField calValueTextField;
    private JButton endCalButton;
    private JButton factoryButton;
    private JTextField testTextField;
    private JButton testButton;
    private JButton stopButton;
    private JButton saveButton;
    private boolean isInitialized = false;
    private boolean calibrating = false;
    private int idNumber;
    private double maxTemp;
    private double calValue;
    private double testCurrent;
    private boolean parseError = false;
    private Color textFieldBackgroundColor;

    private double parseValue(JTextField tf, double min, double max) {
        if (!tf.isVisible()) {
            return 0.0;
        }
        double v = 0.0;
        try {
            v = Support.parseValue(tf.getText(), false, min, max);
            tf.setBackground(this.textFieldBackgroundColor);
        }
        catch (Exception e) {
            tf.setBackground(Color.red);
            this.parseError = true;
        }
        return v;
    }

    private void timerUpdate() {
        boolean online;
        if (Support.lastValues != null) {
            this.voltageLabel.setText(Support.nf3.format(Support.lastValues.getVoltage()));
            this.currentLabel.setText(Support.nf3.format(Support.lastValues.getCurrent()));
            this.temperatureLabel.setText(Support.nf1.format(Support.lastValues.getTemperature()));
            this.inputVoltageLabel.setText(Support.nf1.format(Support.inputVoltage));
        }
        this.updateButton.setEnabled((online = Support.serialInterface.isOpen()) && !this.parseError);
        this.saveButton.setEnabled(online);
        this.i1Button.setEnabled(online);
        this.i2Button.setEnabled(online);
        this.v1Button.setEnabled(online);
        this.v2Button.setEnabled(online);
        this.enterButton.setEnabled(online && this.calibrating && !this.parseError && this.calValue > 0.0);
        this.endCalButton.setEnabled(online && this.calibrating);
        this.factoryButton.setEnabled(online);
        this.testButton.setEnabled(online && !this.calibrating && !this.parseError && this.testCurrent > 0.0);
        this.stopButton.setEnabled(online);
        if (!this.isInitialized && Support.serialInterface.isOpen()) {
            this.updateSettingsDisplay();
            this.isInitialized = true;
        }
    }

    @Override
    public JPanel getPanel() {
        JPanel panel = new JPanel();
        JPanel p1 = new JPanel();
        panel.add(p1);
        p1.setPreferredSize(new Dimension(1050, 30));
        p1.add(new JLabel("Battery voltage"));
        this.voltageLabel = new JLabel();
        p1.add(this.voltageLabel);
        p1.add(Box.createHorizontalStrut(50));
        p1.add(new JLabel("Battery current"));
        this.currentLabel = new JLabel();
        p1.add(this.currentLabel);
        p1.add(Box.createHorizontalStrut(50));
        p1.add(new JLabel("Battery temperature"));
        this.temperatureLabel = new JLabel();
        p1.add(this.temperatureLabel);
        p1.add(Box.createHorizontalStrut(50));
        p1.add(new JLabel("Input voltage"));
        this.inputVoltageLabel = new JLabel();
        p1.add(this.inputVoltageLabel);
        JPanel p2 = new JPanel();
        panel.add(p2);
        p2.setPreferredSize(new Dimension(1050, 70));
        p2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Settings", 1, 2));
        p2.add(new JLabel("Charger ID number"));
        this.idTextField = new JTextField(4);
        p2.add(this.idTextField);
        this.idTextField.addActionListener(this);
        this.idTextField.addFocusListener(this);
        p2.add(Box.createHorizontalStrut(20));
        p2.add(new JLabel("Maximum battery temperature"));
        this.maxTempTextField = new JTextField(6);
        this.maxTempTextField.addActionListener(this);
        this.maxTempTextField.addFocusListener(this);
        p2.add(this.maxTempTextField);
        p2.add(Box.createHorizontalStrut(20));
        p2.add(new JLabel("Type of temperature sensor"));
        this.tempSensorComboxBox = new JComboBox();
        this.tempSensorComboxBox.addItem("LM34");
        this.tempSensorComboxBox.addItem("LM35");
        this.tempSensorComboxBox.setSelectedIndex(1);
        p2.add(this.tempSensorComboxBox);
        p2.add(Box.createHorizontalStrut(40));
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneSetupCalibrate.this.updateSettings();
            }
        });
        p2.add(this.updateButton);
        JPanel p3 = new JPanel();
        p3.setPreferredSize(new Dimension(1050, 170));
        panel.add(p3);
        p3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Calibration", 1, 2));
        this.calibrationTextArea = new JTextArea(8, 15);
        p3.add(this.calibrationTextArea);
        p3.add(Box.createHorizontalStrut(40));
        JPanel p31 = new JPanel();
        p31.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Start calibration", 1, 2));
        p31.setLayout(new GridLayout(4, 1, 3, 3));
        p3.add(p31);
        this.i1Button = new JButton("Low current (I1)");
        this.i1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneSetupCalibrate.this.setCal(Support.serialInterface.getPort().writeRead("calStart i1;cal?"));
            }
        });
        p31.add(this.i1Button);
        this.i2Button = new JButton("High current (I2)");
        this.i2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneSetupCalibrate.this.setCal(Support.serialInterface.getPort().writeRead("calStart i2;cal?"));
            }
        });
        p31.add(this.i2Button);
        this.v1Button = new JButton("Low voltage (V1)");
        this.v1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneSetupCalibrate.this.setCal(Support.serialInterface.getPort().writeRead("calStart v1;cal?"));
            }
        });
        p31.add(this.v1Button);
        this.v2Button = new JButton("High voltage (V2)");
        this.v2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneSetupCalibrate.this.setCal(Support.serialInterface.getPort().writeRead("calStart v2;cal?"));
            }
        });
        p31.add(this.v2Button);
        p3.add(Box.createHorizontalStrut(40));
        JPanel p32 = new JPanel();
        p32.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Enter measured value", 1, 2));
        p3.add(p32);
        this.calLabel = new JLabel("Item: ");
        p32.add(this.calLabel);
        p32.add(Box.createHorizontalStrut(10));
        this.calValueTextField = new JTextField(8);
        this.calValueTextField.addActionListener(this);
        this.calValueTextField.addFocusListener(this);
        p32.add(this.calValueTextField);
        p32.add(Box.createHorizontalStrut(20));
        this.enterButton = new JButton("Enter value");
        this.enterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("cal " + PaneSetupCalibrate.this.calValue);
                PaneSetupCalibrate.this.updateSettingsDisplay();
            }
        });
        p32.add(this.enterButton);
        p3.add(Box.createHorizontalStrut(50));
        JPanel p33 = new JPanel();
        p33.setLayout(new GridLayout(2, 1, 5, 25));
        p3.add(p33);
        this.endCalButton = new JButton("End calibration");
        this.endCalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("stop");
                PaneSetupCalibrate.this.setCal("");
            }
        });
        p33.add(this.endCalButton);
        this.factoryButton = new JButton("Factory");
        this.factoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("calStart factory");
                PaneSetupCalibrate.this.updateSettingsDisplay();
            }
        });
        p33.add(this.factoryButton);
        JPanel p4 = new JPanel();
        p4.setPreferredSize(new Dimension(1050, 70));
        panel.add(p4);
        p4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Test output current", 1, 2));
        p4.add(new JLabel("Desired test current"));
        this.testTextField = new JTextField(6);
        this.testTextField.addActionListener(this);
        this.testTextField.addFocusListener(this);
        p4.add(this.testTextField);
        p4.add(Box.createHorizontalStrut(50));
        this.testButton = new JButton("Current on");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("setCurrent " + PaneSetupCalibrate.this.testCurrent);
            }
        });
        p4.add(this.testButton);
        p4.add(Box.createHorizontalStrut(50));
        this.stopButton = new JButton("Current off");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("stop");
                PaneSetupCalibrate.this.setCal("");
            }
        });
        p4.add(this.stopButton);
        JPanel p5 = new JPanel();
        p5.setPreferredSize(new Dimension(1050, 60));
        panel.add(p5);
        p5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Save changed settings", 1, 2));
        p5.add(new JLabel("Both settings and calibration will only be remembered if this button is used"));
        p5.add(Box.createHorizontalStrut(350));
        this.saveButton = new JButton("SaveConfig");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Support.serialInterface.getPort().write("SaveConfig");
            }
        });
        p5.add(this.saveButton);
        this.textFieldBackgroundColor = this.testTextField.getBackground();
        return panel;
    }

    private void setCal(String value) {
        String[] s = value.split("[ ]+");
        if (s.length < 2) {
            this.calLabel.setText("Item: ");
            this.calValueTextField.setText("");
            this.calibrating = false;
        } else {
            this.calLabel.setText("Item: " + s[0]);
            this.calValueTextField.setText(s[1]);
            this.calibrating = true;
        }
    }

    private void updateSettings() {
        SerialInterface.SPort sp = Support.serialInterface.getPort();
        sp.write("MaxTemp " + this.maxTemp);
        sp.write("SetId " + this.idNumber);
        sp.write("TempSensor " + (String)this.tempSensorComboxBox.getSelectedItem());
        sp.setId(Integer.parseInt(sp.writeRead("id?")));
        this.updateSettingsDisplay();
    }

    private void updateSettingsDisplay() {
        SerialInterface.SPort sp = Support.serialInterface.getPort();
        this.idTextField.setText(sp.writeRead("id?"));
        this.maxTempTextField.setText(sp.writeRead("MaxTemp?"));
        String s = sp.writeRead("TempSensor?");
        int i = 0;
        while (i < this.tempSensorComboxBox.getItemCount()) {
            if (this.tempSensorComboxBox.getItemAt(i).equalsIgnoreCase(s)) {
                this.tempSensorComboxBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.calibrationTextArea.setText(sp.writeRead("calall?", 4));
    }

    @Override
    public void selected() {
        this.timerUpdate();
        this.timer.start();
    }

    @Override
    public void deselected() {
        this.timer.stop();
        if (this.calibrating) {
            Support.serialInterface.getPort().write("\nstop\nstop");
            this.setCal("");
        }
    }

    @Override
    public String getTitle() {
        return "Setup, test & calibration";
    }

    private void parseInputFields() {
        this.parseError = false;
        this.maxTemp = this.parseValue(this.maxTempTextField, 30.0, 70.0);
        try {
            this.idNumber = Integer.parseInt(this.idTextField.getText());
            if (this.idNumber < 0 || this.idNumber > 255) {
                this.parseError = true;
                this.idTextField.setBackground(Color.red);
            } else {
                this.idTextField.setBackground(this.textFieldBackgroundColor);
            }
        }
        catch (Exception ee) {
            this.parseError = true;
            this.idTextField.setBackground(Color.red);
        }
        this.calValue = this.calibrating ? this.parseValue(this.calValueTextField, 0.0, 4.6) : -1.0;
        this.testCurrent = this.testTextField.getText().trim().length() > 0 ? this.parseValue(this.testTextField, 0.0, 1.5) : -1.0;
        this.timerUpdate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.parseInputFields();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.parseInputFields();
    }
}

