/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import com.fazecast.jSerialComm.SerialPort;

public class SerialInterface {
    private SPort sPort;
    private Callback callback;
    private String comPort = null;
    private int deviceNo = -1;

    static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    SerialInterface() {
    }

    public void open(String comPort, int deviceNo, Callback portScanningDone) {
        this.callback = portScanningDone;
        this.comPort = comPort;
        this.deviceNo = deviceNo;
        ScannerThread scannerThread = new ScannerThread();
        scannerThread.setDaemon(true);
        scannerThread.start();
    }

    public SerialPort[] getCommPorts() {
        return SerialPort.getCommPorts();
    }

    public void close() {
        if (this.sPort != null) {
            this.sPort.write("\rstop\rstop");
            SerialInterface.sleep(50);
            this.sPort.close();
        }
    }

    public boolean isOpen() {
        return this.sPort != null && this.sPort.isOpen();
    }

    public SPort getPort() {
        return this.sPort;
    }

    public static interface Callback {
        public void portScanningDone();
    }

    public class SPort {
        private SerialPort serialPort = null;
        private int id;

        SPort(SerialPort p) {
            this.serialPort = p;
        }

        public synchronized void close() {
            this.serialPort.closePort();
        }

        public synchronized boolean write(String msg) {
            int i;
            if (!this.serialPort.isOpen()) {
                return false;
            }
            byte[] b = (String.valueOf(msg) + "\r").getBytes();
            long time = System.currentTimeMillis();
            for (int n = 0; n < b.length; n += i) {
                i = this.serialPort.writeBytes(b, b.length, n);
                SerialInterface.sleep(1);
                if (i >= 0 && System.currentTimeMillis() - time <= 100L) continue;
                return false;
            }
            return true;
        }

        public synchronized void flush() {
            while (this.serialPort.bytesAvailable() > 0) {
                byte[] c = new byte[100];
                this.serialPort.readBytes(c, 100L);
            }
        }

        public synchronized String read() {
            if (!this.serialPort.isOpen()) {
                return null;
            }
            long time = System.currentTimeMillis();
            StringBuilder s = new StringBuilder();
            byte[] c = new byte[1];
            while (c[0] != 13) {
                int i = this.serialPort.readBytes(c, 1L);
                if (i > 0) {
                    if (c[0] != 10 && c[0] != 13) {
                        s.append((char)c[0]);
                    }
                } else {
                    if (i < 0) {
                        this.serialPort.closePort();
                        return null;
                    }
                    SerialInterface.sleep(1);
                }
                if (System.currentTimeMillis() - time <= 500L) continue;
                return s.toString();
            }
            return s.toString();
        }

        public synchronized String writeRead(String msg) {
            this.flush();
            if (!this.write(msg)) {
                return null;
            }
            return this.read();
        }

        public synchronized String writeRead(String msg, int lines) {
            this.flush();
            if (!this.write(msg)) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < lines) {
                String s = this.read();
                if (s.length() == 0) {
                    s = this.read();
                }
                sb.append(s);
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }

        public boolean isOpen() {
            return this.serialPort != null && this.serialPort.isOpen();
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Charger ");
            sb.append(this.id);
            sb.append(" on ");
            sb.append(this.serialPort.getDescriptivePortName());
            return sb.toString();
        }
    }

    private class ScannerThread
    extends Thread {
        private ScannerThread() {
        }

        void enumSerialPorts() {
            SerialPort p;
            SerialPort[] ports;
            SerialInterface.this.sPort = null;
            if (SerialInterface.this.comPort != null && SerialInterface.this.comPort.length() > 0) {
                ports = new SerialPort[1];
                try {
                    ports[0] = SerialPort.getCommPort(SerialInterface.this.comPort);
                }
                catch (Exception e) {
                    return;
                }
            } else {
                ports = SerialPort.getCommPorts();
            }
            SerialPort[] serialPortArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                p = serialPortArray[n2];
                p.openPort();
                ++n2;
            }
            SerialInterface.sleep(2000);
            serialPortArray = ports;
            n = ports.length;
            n2 = 0;
            while (n2 < n) {
                p = serialPortArray[n2];
                boolean valid = false;
                SPort sp = new SPort(p);
                int nn = 1;
                try {
                    try {
                        if (p.isOpen()) {
                            if (valid) {
                                sp.close();
                            } else {
                                p.setComPortTimeouts(0, 100, 100);
                                String s = sp.writeRead("#0;*idn?");
                                if (s != null && s.startsWith("HKJ,SerialMux,")) {
                                    nn = 8;
                                    s = null;
                                }
                                while (nn > 0 && !valid) {
                                    if (s == null) {
                                        s = sp.writeRead("#" + nn + "*idn?");
                                        --nn;
                                    }
                                    if ((valid = s != null && s.startsWith("HKJ,Charger,")) && p.isOpen()) {
                                        s = sp.writeRead("id?");
                                        if (s != null && s.equals("" + SerialInterface.this.deviceNo)) {
                                            sp.id = Integer.parseInt(s);
                                            SerialInterface.this.sPort = sp;
                                        } else if (s != null && SerialInterface.this.deviceNo < 0) {
                                            sp.id = Integer.parseInt(s);
                                            SerialInterface.this.sPort = sp;
                                        } else {
                                            valid = false;
                                        }
                                    }
                                    s = null;
                                }
                                if (!valid) {
                                    sp.close();
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                finally {
                    if (!valid) {
                        SerialInterface.this.sPort = null;
                    }
                }
                ++n2;
            }
        }

        @Override
        public void run() {
            this.enumSerialPorts();
            if (SerialInterface.this.callback != null) {
                SerialInterface.this.callback.portScanningDone();
            }
        }
    }
}

