/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DataSet;
import dk.hkj.main.SerialInterface;
import dk.hkj.main.Support;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class LoggerThread
extends Thread {
    private int sampleNo = 0;
    private boolean done = false;
    private SerialInterface.SPort sPort = null;
    private WriterThread writerThread;
    private BlockingQueue<DataSet.DataPoint> queue = new ArrayBlockingQueue<DataSet.DataPoint>(1000);

    public LoggerThread() {
        this.setDaemon(true);
        this.setPriority(10);
        this.start();
    }

    void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private DataSet.DataPoint parseEntry(String line) {
        String[] data;
        block3: {
            try {
                data = line.split("[ ,;]+");
                if (data.length >= 7) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        int index = Integer.parseInt(data[0]);
        long timeStamp = Long.parseLong(data[1]);
        double voltage = Double.parseDouble(data[2]);
        double current = Double.parseDouble(data[3]);
        double temperature = Double.parseDouble(data[4]);
        double capacity = Double.parseDouble(data[5]);
        double energy = Double.parseDouble(data[6]);
        return Support.dataSet.createDataPoint(index, timeStamp * 1000L, voltage, current, capacity, energy, temperature);
    }

    private void logStatus() {
        String answer = this.sPort.writeRead("read? " + this.sampleNo).trim();
        if (answer.equals("-")) {
            this.sleep(500);
        } else if (answer.equals("#")) {
            Support.charging = false;
        } else {
            Support.lastTermination = "";
            DataSet.DataPoint dp = this.parseEntry(answer);
            if (dp != null) {
                Support.lastValues = dp;
                Support.dataSet.addPoint(dp);
                if (Support.autoLog) {
                    this.queue.add(dp);
                }
                this.sampleNo = dp.getIndex() + 1;
            }
        }
    }

    private void getStatus() {
        String answer = this.sPort.writeRead("values?");
        DataSet.DataPoint dp = this.parseEntry(answer);
        if (dp != null) {
            Support.lastValues = dp;
        }
        if ((answer = this.sPort.writeRead("term?")) != null) {
            Support.lastTermination = answer;
        }
        if ((answer = this.sPort.writeRead("vin?")) != null) {
            Support.inputVoltage = Double.parseDouble(answer.trim());
        }
        this.sleep(500);
    }

    public synchronized boolean startCharge(String params) {
        this.sampleNo = 0;
        Support.dataSet.clear();
        this.queue.clear();
        Support.currentFilename = "Charge-" + Support.batteryName + "-" + params.replace(' ', '-');
        Support.charging = true;
        Support.serialInterface.getPort().write("Start " + params);
        if (Support.autoLog) {
            this.writerThread = new WriterThread(Support.currentFilename);
        }
        return true;
    }

    public synchronized void stopCharge() {
        if (Support.serialInterface.isOpen()) {
            Support.serialInterface.getPort().write("\nstop\nstop");
        }
        Support.charging = false;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                if (this.sPort == null || !this.sPort.isOpen()) {
                    this.sleep(500);
                    Support.charging = false;
                    this.sPort = Support.serialInterface.getPort();
                    continue;
                }
                if (Support.charging) {
                    this.logStatus();
                    continue;
                }
                this.getStatus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class WriterThread
    extends Thread {
        private File f;

        public WriterThread(String fname) {
            this.setDaemon(true);
            this.setPriority(7);
            String path = Support.defaultFilePath.replace('\\', '/');
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            this.f = new File(String.valueOf(path) + fname + ".csv");
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            FileOutputStream os = null;
            BufferedWriter bw = null;
            try {
                try {
                    os = new FileOutputStream(this.f);
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    bw = new BufferedWriter(osw, 8192);
                    bw.write(String.valueOf(Support.dataSet.getCSVHeader()) + "\r\n");
                    block15: while (true) {
                        if (!Support.charging && LoggerThread.this.queue.size() <= 0) {
                            return;
                        }
                        while (true) {
                            if (LoggerThread.this.queue.size() <= 0) {
                                WriterThread.sleep(50L);
                                continue block15;
                            }
                            DataSet.DataPoint dp = (DataSet.DataPoint)LoggerThread.this.queue.take();
                            bw.write(dp.toString());
                            bw.write("\r\n");
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                } else if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

