/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ErrorPopup;
import dk.hkj.main.PaneCharge;
import dk.hkj.main.PaneConfig;
import dk.hkj.main.PaneInterface;
import dk.hkj.main.PaneSetupCalibrate;
import dk.hkj.main.PaneTable;
import dk.hkj.main.Support;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main {
    static Main main = null;
    private JFrame frame;
    private JTabbedPane tabbedPane = null;
    private PaneInterface[] panes;
    private PaneConfig paneConfig = new PaneConfig();
    private PaneCharge paneCharge = new PaneCharge();
    private PaneTable paneTable = new PaneTable();
    private PaneSetupCalibrate paneSetupCalibrate = new PaneSetupCalibrate();
    private Timer timer;

    private Main() {
        this.panes = new PaneInterface[]{this.paneConfig, this.paneCharge, this.paneTable, this.paneSetupCalibrate};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.createAndShowGUI();
            }
        });
    }

    public Dimension getSize() {
        return this.tabbedPane.getSize();
    }

    private void createAndShowGUI() {
        this.frame = new JFrame("Charger - offline");
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                Support.loggerThread.stopCharge();
                Support.serialInterface.close();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.update();
            }
        });
        this.timer.start();
        Dimension d = new Dimension(1100, 530);
        this.frame.setMinimumSize(d);
        this.frame.setMaximumSize(d);
        this.frame.setPreferredSize(d);
        this.tabbedPane = new JTabbedPane();
        PaneInterface[] paneInterfaceArray = this.panes;
        int n = this.panes.length;
        int n2 = 0;
        while (n2 < n) {
            PaneInterface pi = paneInterfaceArray[n2];
            this.tabbedPane.addTab(pi.getTitle(), pi.getPanel());
            ++n2;
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int pi = Main.this.tabbedPane.getSelectedIndex();
                int i = 0;
                while (i < Main.this.tabbedPane.getTabCount()) {
                    if (i != pi) {
                        Main.this.panes[i].deselected();
                    }
                    ++i;
                }
                Main.this.panes[pi].selected();
            }
        });
        this.frame.add(this.tabbedPane);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
    }

    public void saveDirect() {
        this.paneCharge.saveDirect();
    }

    public void updateAll() {
        this.paneCharge.updateAll();
        this.paneTable.updateAll();
    }

    private void update() {
        if (Support.autoConnect) {
            Support.autoConnect = false;
            this.paneConfig.connect();
        }
        if (Support.autoStart && Support.serialInterface.isOpen()) {
            Support.autoStart = false;
            this.paneCharge.startCharge();
            this.tabbedPane.setSelectedIndex(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Charger");
        if (Support.serialInterface.isOpen()) {
            sb.append(" - open to device #");
            sb.append(Support.serialInterface.getPort().getId());
            if (Support.charging) {
                sb.append(" charging");
            }
        } else {
            sb.append(" - offline");
        }
        if (Support.scanningForConnection) {
            sb.append(" -- SCANNING FOR CONNECTION --");
        }
        if (Support.autoStart) {
            sb.append(" -- Will auto start when connected --");
        }
        this.tabbedPane.setEnabledAt(3, !Support.charging);
        this.frame.setTitle(sb.toString());
    }

    public static void main(String[] args) {
        System.out.println("Starting");
        String field = "";
        try {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                field = arg = arg.trim();
                String[] s = arg.split("[=]");
                if (s.length == 2) {
                    String opt = s[0].trim();
                    String param = s[1].trim();
                    if (opt.equalsIgnoreCase("port")) {
                        Support.searchCommPort = param;
                    } else if (opt.equalsIgnoreCase("name")) {
                        Support.batteryName = param;
                    } else if (opt.equalsIgnoreCase("batteryName")) {
                        Support.batteryName = param;
                    } else if (opt.equalsIgnoreCase("id")) {
                        Support.searchId = param;
                    } else if (opt.equalsIgnoreCase("path")) {
                        if (!new File(param).isDirectory()) {
                            throw new FileNotFoundException("Path not found");
                        }
                        Support.defaultFilePath = param;
                    } else if (opt.equalsIgnoreCase("mode")) {
                        boolean found = false;
                        Support.ChargeMode[] chargeModeArray = Support.ChargeMode.values();
                        int n3 = chargeModeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Support.ChargeMode cm = chargeModeArray[n4];
                            if (param.equals(cm.toString())) {
                                Support.chargeParams.mode = cm;
                                found = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!found) {
                            throw new IllegalArgumentException("Not a valid mode");
                        }
                    } else if (opt.equalsIgnoreCase("voltage")) {
                        Support.chargeParams.voltage = Support.parseValue(param, false, 0.1, 4.5);
                    } else if (opt.equalsIgnoreCase("current")) {
                        Support.chargeParams.current = Support.parseValue(param, false, 0.05, 1.5);
                    } else if (opt.equalsIgnoreCase("minCurrent")) {
                        Support.chargeParams.minCurrent = Support.parseValue(param, false, 0.001, Support.chargeParams.current * 9.0 / 10.0);
                    } else if (opt.equalsIgnoreCase("dv")) {
                        Support.chargeParams.deltaVoltage = Support.parseValue(param, false, 0.001, 0.05);
                    } else if (opt.equalsIgnoreCase("capacity")) {
                        Support.chargeParams.capacity = Support.parseValue(param, false, 0.0, 50.0);
                    } else if (opt.equalsIgnoreCase("time")) {
                        Support.chargeParams.time = (long)Support.parseValue(param, true, 0.0, 36000.0);
                    } else if (opt.equalsIgnoreCase("finalTime")) {
                        Support.chargeParams.finalLoggingTime = (long)Support.parseValue(param, true, 0.0, 36000.0);
                    } else if (opt.equalsIgnoreCase("csvDeli")) {
                        Support.csvDelimiter = Support.parseCSVChar(param);
                    } else if (opt.equalsIgnoreCase("csvPoint")) {
                        Support.csvDecimalPoint = Support.parseCSVChar(param);
                    } else if (opt.equalsIgnoreCase("copyright")) {
                        Support.copyright = param;
                    } else if (opt.equalsIgnoreCase("bgcolor")) {
                        Support.borderColor = Support.parseColor(param);
                    } else if (opt.equalsIgnoreCase("chartcolor")) {
                        Support.chartColor = Support.parseColor(param);
                    } else if (opt.equalsIgnoreCase("textcolor")) {
                        Support.textColor = Support.parseColor(param);
                    } else if (opt.equalsIgnoreCase("chart")) {
                        Support.chartOptions = param;
                    }
                } else if (s.length == 1) {
                    if (arg.equalsIgnoreCase("connect")) {
                        Support.autoConnect = true;
                    } else if (arg.equalsIgnoreCase("start")) {
                        Support.autoConnect = true;
                        Support.autoStart = true;
                    } else if (arg.equalsIgnoreCase("log")) {
                        Support.autoLog = true;
                    }
                }
                ++n2;
            }
            field = "";
            main = new Main();
        }
        catch (Exception e) {
            if (field.length() > 0) {
                new ErrorPopup("Error in parameter: " + field, e);
            }
            new ErrorPopup("Error", e);
        }
    }
}

