/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.ChargeChartPanel;
import dk.hkj.main.PaneInterface;
import dk.hkj.main.Support;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class PaneCharge
implements PaneInterface,
ActionListener {
    private JComboBox<String> modeComboBox;
    private ChargeChartPanel chargeChartPanel;
    private JTextField currentTextField;
    private JTextField voltageTextField;
    private JTextField minCurrentTextField;
    private JTextField deltaVoltageTextField;
    private JTextField capacityTextField;
    private JTextField timeTextField;
    private JTextField finalLoggingTimeTextField;
    private JButton startButton;
    private JButton stopButton;
    private JButton saveChartButton;
    private boolean initDone = false;
    private boolean parseError = false;
    private Color textFieldBackgroundColor;
    private JLabel voltageLabel;
    private JLabel currentLabel;
    private JLabel capacityLabel;
    private JLabel temperatureLabel;
    private JLabel timeLabel;
    private JLabel terminationLabel;
    private Timer timer;

    private void addWithLabel(JPanel panel, String label, JComponent comp, String initialValue, String tooltip) {
        JPanel p = Support.getPanel(1);
        p.setLayout(new BoxLayout(p, 3));
        p.setAlignmentX(0.0f);
        panel.add(p);
        p.setToolTipText(tooltip);
        JLabel l = new JLabel(label);
        l.setAlignmentX(0.0f);
        l.setToolTipText(tooltip);
        p.add(l);
        comp.setToolTipText(tooltip);
        if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).addActionListener(this);
        } else if (comp instanceof JTextField) {
            ((JTextField)comp).setText(initialValue);
            ((JTextField)comp).addActionListener(this);
            ((JTextField)comp).addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    PaneCharge.this.actionPerformed(null);
                }
            });
        }
        p.add(comp);
        comp.setAlignmentX(0.0f);
    }

    private void addWithLabel(JPanel panel, String label, JLabel myLabel, String tooltip) {
        JPanel p = Support.getPanel(1);
        p.setAlignmentX(0.0f);
        panel.add(p);
        p.setToolTipText(tooltip);
        JLabel l = new JLabel(label);
        l.setToolTipText(tooltip);
        p.add(l);
        myLabel.setToolTipText(tooltip);
        p.add(myLabel);
    }

    private void enableFields() {
        if (this.timeTextField == null) {
            return;
        }
        this.voltageTextField.getParent().setVisible(Support.chargeParams.mode == Support.ChargeMode.CCCV || Support.chargeParams.mode == Support.ChargeMode.Voltage || Support.chargeParams.mode == Support.ChargeMode.VoltageTop || Support.chargeParams.mode == Support.ChargeMode.VoltageTime || Support.chargeParams.mode == Support.ChargeMode.CapacityVoltage);
        this.minCurrentTextField.getParent().setVisible(Support.chargeParams.mode == Support.ChargeMode.CCCV || Support.chargeParams.mode == Support.ChargeMode.VoltageTop);
        this.deltaVoltageTextField.getParent().setVisible(Support.chargeParams.mode == Support.ChargeMode.dvdt);
        this.capacityTextField.getParent().setVisible(Support.chargeParams.mode == Support.ChargeMode.Capacity || Support.chargeParams.mode == Support.ChargeMode.CapacityVoltage);
        this.timeTextField.getParent().setVisible(Support.chargeParams.mode == Support.ChargeMode.VoltageTop || Support.chargeParams.mode == Support.ChargeMode.Time || Support.chargeParams.mode == Support.ChargeMode.VoltageTime);
    }

    private double parseValue(JTextField tf, boolean time, double min, double max) {
        if (!tf.isVisible()) {
            return 0.0;
        }
        double v = 0.0;
        try {
            v = Support.parseValue(tf.getText(), time, min, max);
            tf.setBackground(this.textFieldBackgroundColor);
        }
        catch (Exception e) {
            tf.setBackground(Color.red);
            this.parseError = true;
        }
        return v;
    }

    private void parseFields() {
        this.parseError = false;
        Support.chargeParams.current = this.parseValue(this.currentTextField, false, 0.05, 1.5);
        Support.chargeParams.voltage = this.parseValue(this.voltageTextField, false, 0.1, 4.5);
        Support.chargeParams.minCurrent = this.parseValue(this.minCurrentTextField, false, 0.001, Support.chargeParams.current * 9.0 / 10.0);
        Support.chargeParams.deltaVoltage = this.parseValue(this.deltaVoltageTextField, false, 0.001, 0.05);
        Support.chargeParams.capacity = this.parseValue(this.capacityTextField, false, 0.0, 50.0);
        Support.chargeParams.time = (long)this.parseValue(this.timeTextField, true, 0.0, 36000.0);
        Support.chargeParams.finalLoggingTime = (long)this.parseValue(this.finalLoggingTimeTextField, true, 0.0, 36000.0);
        this.startButton.setEnabled(this.canStart());
    }

    private void timerUpdate(boolean force) {
        if (Support.lastValues != null) {
            this.timeLabel.setText(Support.formatTime(Support.lastValues.getTimeStamp() / 1000L));
            this.voltageLabel.setText(Support.nf3.format(Support.lastValues.getVoltage()));
            this.currentLabel.setText(Support.nf3.format(Support.lastValues.getCurrent()));
            this.capacityLabel.setText(Support.nf3.format(Support.lastValues.getCapacity()));
            this.temperatureLabel.setText(Support.nf2.format(Support.lastValues.getTemperature()));
            this.terminationLabel.setText(Support.lastTermination);
        }
        this.chargeChartPanel.update(force);
        this.startButton.setEnabled(this.canStart());
        this.stopButton.setEnabled(Support.charging);
        this.modeComboBox.setEnabled(!Support.charging);
        this.currentTextField.setEnabled(!Support.charging);
        this.voltageTextField.setEnabled(!Support.charging);
        this.minCurrentTextField.setEnabled(!Support.charging);
        this.deltaVoltageTextField.setEnabled(!Support.charging);
        this.capacityTextField.setEnabled(!Support.charging);
        this.timeTextField.setEnabled(!Support.charging);
        this.finalLoggingTimeTextField.setEnabled(!Support.charging);
    }

    @Override
    public JPanel getPanel() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCharge.this.timerUpdate(false);
            }
        });
        JPanel panel = new JPanel();
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BoxLayout(sidePanel, 3));
        sidePanel.setAlignmentX(0.0f);
        sidePanel.setAlignmentY(0.0f);
        panel.add(sidePanel);
        this.timeLabel = new JLabel("");
        this.addWithLabel(sidePanel, "Time:", this.timeLabel, "Time from start of function");
        this.voltageLabel = new JLabel();
        this.addWithLabel(sidePanel, "Voltage:", this.voltageLabel, "Actual battery voltage");
        this.currentLabel = new JLabel();
        this.addWithLabel(sidePanel, "Current:", this.currentLabel, "Actual charge current");
        this.capacityLabel = new JLabel();
        this.addWithLabel(sidePanel, "Capacity:", this.capacityLabel, "Capacity charged into battery");
        this.temperatureLabel = new JLabel();
        this.addWithLabel(sidePanel, "Temperature:", this.temperatureLabel, "Actual temperature on battery");
        this.terminationLabel = new JLabel();
        this.addWithLabel(sidePanel, "Last termination:", this.terminationLabel, "How last function terminated");
        sidePanel.add(Box.createVerticalStrut(5));
        JPanel inputPanel = Support.getPanel(1);
        inputPanel.setAlignmentX(0.0f);
        Dimension dim = new Dimension(160, 250);
        inputPanel.setPreferredSize(dim);
        inputPanel.setMinimumSize(dim);
        inputPanel.setMaximumSize(dim);
        sidePanel.add(inputPanel);
        this.modeComboBox = new JComboBox();
        this.modeComboBox.setMaximumRowCount(20);
        this.modeComboBox.addActionListener(this);
        Support.ChargeMode[] chargeModeArray = Support.ChargeMode.values();
        int n = chargeModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Support.ChargeMode cm = chargeModeArray[n2];
            this.modeComboBox.addItem(cm.toString());
            ++n2;
        }
        this.addWithLabel(inputPanel, "Mode", this.modeComboBox, null, "<html>Charge mode to use:<ul><li>NiMH Standand NiMH with -dv/dt algorithm<li>NiMHV Standard voltage based NiMH charge algorithm<li>NiMHVT Standard voltage based NiMH charge algorithm with top-off<li>LiIon Standard 4.2V LiIon CC/CV charge algorithm<li>LiFePO4 Standard 3.6V LiFePO4 CC/CV charge algorithm<li>dvdt -dv/dt charge algorithm<li>Voltage Charge to voltage measured with current off<li>VoltageTop Charge to voltage measured with current off includes a final top-off<li>CCCV CC/CV charging<br><li>Time Charge for a fixed time<li>Capacity Charge a fixed capacity into battery<li>VoltageTime Charge to a specific voltage for specificed time using CC/CV<li>CapacityVoltage Charge a specified capacity, but terminate if voltage is reached</ul>");
        this.currentTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Current", this.currentTextField, Support.formatFloatInput(Support.chargeParams.current), "Charge current");
        this.voltageTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Voltage", this.voltageTextField, Support.formatFloatInput(Support.chargeParams.voltage), "Terminate at this voltage");
        this.minCurrentTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Min. current", this.minCurrentTextField, Support.formatFloatInput(Support.chargeParams.minCurrent), "Terminate when current drop to this value or use this current as top-off current");
        this.deltaVoltageTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "dv", this.deltaVoltageTextField, Support.formatFloatInput(Support.chargeParams.deltaVoltage), "Terminate when voltage drop this amount, it is a few millivolt");
        this.capacityTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Capacity", this.capacityTextField, Support.formatFloatInput(Support.chargeParams.capacity), "Charge this capacity into the battery");
        this.timeTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Time", this.timeTextField, Support.formatTimeInput(Support.chargeParams.time), "Charge or top-off time");
        this.finalLoggingTimeTextField = new JTextField(10);
        this.addWithLabel(inputPanel, "Final time", this.finalLoggingTimeTextField, Support.formatTimeInput(Support.chargeParams.finalLoggingTime), "Time to log after charging is terminated");
        JPanel p = Support.getPanel(0);
        p.setAlignmentX(0.0f);
        sidePanel.add(p);
        this.startButton = new JButton("Start");
        this.startButton.setAlignmentX(0.0f);
        p.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCharge.this.startCharge();
            }
        });
        p.add(Box.createHorizontalStrut(15));
        this.stopButton = new JButton("Stop");
        this.stopButton.setAlignmentX(0.0f);
        p.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCharge.this.stopCharge();
            }
        });
        sidePanel.add(Box.createVerticalStrut(10));
        this.saveChartButton = new JButton("Save chart");
        this.saveChartButton.setAlignmentX(0.0f);
        this.saveChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneCharge.this.chargeChartPanel.saveChart();
            }
        });
        sidePanel.add(this.saveChartButton);
        this.chargeChartPanel = new ChargeChartPanel();
        panel.add(this.chargeChartPanel.getPanel());
        this.textFieldBackgroundColor = this.timeTextField.getBackground();
        this.initDone = true;
        this.actionPerformed(null);
        return panel;
    }

    public void startCharge() {
        if (!this.canStart()) {
            return;
        }
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        String cmd = "stop";
        switch (Support.chargeParams.mode) {
            case NiMH: {
                cmd = "NiMH " + Support.chargeParams.current;
                break;
            }
            case NiMHV: {
                cmd = "NiMHV " + Support.chargeParams.current;
                break;
            }
            case NiMHVT: {
                cmd = "NiMHVT " + Support.chargeParams.current;
                break;
            }
            case LiIon: {
                cmd = "LiIon " + Support.chargeParams.current;
                break;
            }
            case LiFePO4: {
                cmd = "LiFePO4 " + Support.chargeParams.current;
                break;
            }
            case dvdt: {
                cmd = "DVDT " + Support.chargeParams.current + " " + Support.chargeParams.deltaVoltage;
                break;
            }
            case Voltage: {
                cmd = "VOLTAGE " + Support.chargeParams.current + " " + Support.chargeParams.voltage;
                break;
            }
            case VoltageTop: {
                cmd = "VOLTTOP " + Support.chargeParams.current + " " + Support.chargeParams.voltage + " " + Support.chargeParams.minCurrent + " " + Support.chargeParams.time;
                break;
            }
            case CCCV: {
                cmd = "CCCV " + Support.chargeParams.current + " " + Support.chargeParams.voltage + " " + Support.chargeParams.minCurrent;
                break;
            }
            case Time: {
                cmd = "TIME " + Support.chargeParams.current + " " + Support.chargeParams.time;
                break;
            }
            case Capacity: {
                cmd = "CAPACITY " + Support.chargeParams.current + " " + Support.chargeParams.capacity;
                break;
            }
            case VoltageTime: {
                cmd = "VOLTTIME " + Support.chargeParams.current + " " + Support.chargeParams.voltage + " " + Support.chargeParams.time;
                break;
            }
            case CapacityVoltage: {
                cmd = "CAPVOLT " + Support.chargeParams.current + " " + Support.chargeParams.capacity + " " + Support.chargeParams.voltage + " ";
            }
        }
        Support.serialInterface.getPort().write("FinalTime " + Support.chargeParams.finalLoggingTime);
        Support.loggerThread.startCharge(cmd);
        this.chargeChartPanel.updateControls();
    }

    public boolean canStart() {
        return !this.parseError && !Support.charging && Support.serialInterface.isOpen();
    }

    private void stopCharge() {
        Support.loggerThread.stopCharge();
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.initDone) {
            return;
        }
        String s = (String)this.modeComboBox.getSelectedItem();
        Support.ChargeMode[] chargeModeArray = Support.ChargeMode.values();
        int n = chargeModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Support.ChargeMode cm = chargeModeArray[n2];
            if (s.equals(cm.toString())) {
                Support.chargeParams.mode = cm;
                break;
            }
            ++n2;
        }
        this.enableFields();
        this.parseFields();
    }

    public void saveDirect() {
        this.chargeChartPanel.saveDirect();
    }

    public void updateAll() {
        this.chargeChartPanel.updateAll();
    }

    @Override
    public void selected() {
        this.timer.start();
        this.timerUpdate(true);
        this.chargeChartPanel.updateControls();
        this.chargeChartPanel.update(true);
    }

    @Override
    public void deselected() {
        this.timer.stop();
    }

    @Override
    public String getTitle() {
        return "Charge";
    }
}

