/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DataSet;
import dk.hkj.main.PaneInterface;
import dk.hkj.main.Support;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class PaneTable
implements PaneInterface {
    private Timer updateTimer;
    private int lastRow = 0;
    private JTable table;
    private JPanel myPanel;
    private JRadioButton filter1RadioButton;
    private JRadioButton filter10RadioButton;
    private JRadioButton filter60RadioButton;
    private JRadioButton filter600RadioButton;
    private JRadioButton filter3600RadioButton;
    private JRadioButton filterCustomRadioButton;
    private JTextField filterCustomTextField;
    private JRadioButton firstRadioButton;
    private JRadioButton lastRadioButton;
    private JRadioButton averageRadioButton;
    private JRadioButton minRadioButton;
    private JRadioButton maxRadioButton;
    private JRadioButton spanRadioButton;
    private JRadioButton changeRadioButton;
    private JRadioButton slopeRadioButton;
    private JLabel infoLabel;
    private int reductionFactor = 1;
    private Math mathSamples = Math.first;
    private DataSet.TimeUnit tu;
    private NF currentFormatter = new NF(true, 0);
    private NF capacityFormatter = new NF(true, 1);
    private NF energyFormatter = new NF(true, 1);
    private DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
    private DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
    private MyTableModel dataModel = new MyTableModel();
    MyActionListener setReductionFactor = new MyActionListener();

    @Override
    public JPanel getPanel() {
        this.myPanel = new JPanel();
        this.rightRenderer.setHorizontalAlignment(4);
        this.centerRenderer.setHorizontalAlignment(0);
        this.tu = Support.dataSet.getTimeUnit();
        this.table = new JTable(this.dataModel);
        this.tableChanged();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(800, 460));
        this.myPanel.add(scrollPane);
        this.table.setFillsViewportHeight(true);
        JPanel sidePanel = new JPanel();
        BoxLayout bl1 = new BoxLayout(sidePanel, 3);
        sidePanel.setLayout(bl1);
        this.myPanel.add(sidePanel);
        JPanel filterPanel = new JPanel();
        filterPanel.setAlignmentX(0.5f);
        String tt = "The specified timing is based on one sample each second";
        BoxLayout bl2 = new BoxLayout(filterPanel, 3);
        filterPanel.setLayout(bl2);
        filterPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        filterPanel.setToolTipText(tt);
        sidePanel.add(filterPanel);
        ButtonGroup bgFilter = new ButtonGroup();
        this.filter1RadioButton = new JRadioButton("All data");
        this.filter1RadioButton.setToolTipText(tt);
        bgFilter.add(this.filter1RadioButton);
        this.filter1RadioButton.addActionListener(this.setReductionFactor);
        filterPanel.add(Support.leftJustify(this.filter1RadioButton));
        this.filter10RadioButton = new JRadioButton("Each 10 second");
        this.filter10RadioButton.setToolTipText(tt);
        bgFilter.add(this.filter10RadioButton);
        this.filter10RadioButton.addActionListener(this.setReductionFactor);
        filterPanel.add(Support.leftJustify(this.filter10RadioButton));
        this.filter60RadioButton = new JRadioButton("Each minute");
        this.filter60RadioButton.setToolTipText(tt);
        bgFilter.add(this.filter60RadioButton);
        this.filter60RadioButton.addActionListener(this.setReductionFactor);
        filterPanel.add(Support.leftJustify(this.filter60RadioButton));
        this.filter600RadioButton = new JRadioButton("Each 10 minutes");
        this.filter600RadioButton.setToolTipText(tt);
        bgFilter.add(this.filter600RadioButton);
        this.filter600RadioButton.addActionListener(this.setReductionFactor);
        filterPanel.add(Support.leftJustify(this.filter600RadioButton));
        this.filter3600RadioButton = new JRadioButton("Each hour");
        this.filter3600RadioButton.setToolTipText(tt);
        bgFilter.add(this.filter3600RadioButton);
        this.filter3600RadioButton.addActionListener(this.setReductionFactor);
        filterPanel.add(Support.leftJustify(this.filter3600RadioButton));
        JPanel p10 = new JPanel();
        filterPanel.add(p10);
        p10.setLayout(new FlowLayout(0, 0, 0));
        this.filterCustomRadioButton = new JRadioButton("Custom");
        this.filterCustomRadioButton.setToolTipText(tt);
        bgFilter.add(this.filterCustomRadioButton);
        this.filterCustomRadioButton.addActionListener(this.setReductionFactor);
        p10.add(this.filterCustomRadioButton);
        this.filterCustomTextField = new JTextField(5);
        this.filterCustomTextField.setText("15");
        this.filterCustomTextField.addActionListener(this.setReductionFactor);
        p10.add(this.filterCustomTextField);
        this.filter1RadioButton.setSelected(true);
        sidePanel.add(Box.createVerticalStrut(5));
        JPanel mathPanel = new JPanel();
        mathPanel.setAlignmentX(0.5f);
        BoxLayout bl3 = new BoxLayout(mathPanel, 3);
        mathPanel.setLayout(bl3);
        mathPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        sidePanel.add(mathPanel);
        ButtonGroup bgMMath = new ButtonGroup();
        this.firstRadioButton = new JRadioButton("First value");
        this.firstRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.firstRadioButton);
        mathPanel.add(this.firstRadioButton);
        this.lastRadioButton = new JRadioButton("Last value");
        this.lastRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.lastRadioButton);
        mathPanel.add(this.lastRadioButton);
        this.averageRadioButton = new JRadioButton("Average value");
        this.averageRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.averageRadioButton);
        mathPanel.add(this.averageRadioButton);
        this.minRadioButton = new JRadioButton("Minimum value");
        this.minRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.minRadioButton);
        mathPanel.add(this.minRadioButton);
        this.maxRadioButton = new JRadioButton("Maximum value");
        this.maxRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.maxRadioButton);
        mathPanel.add(this.maxRadioButton);
        this.spanRadioButton = new JRadioButton("Span (max-min)");
        this.spanRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.spanRadioButton);
        mathPanel.add(this.spanRadioButton);
        this.changeRadioButton = new JRadioButton("Change (last-first)");
        this.changeRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.changeRadioButton);
        mathPanel.add(this.changeRadioButton);
        this.slopeRadioButton = new JRadioButton("Slope (LSR)");
        this.slopeRadioButton.addActionListener(this.setReductionFactor);
        bgMMath.add(this.slopeRadioButton);
        mathPanel.add(this.slopeRadioButton);
        this.firstRadioButton.setSelected(true);
        sidePanel.add(Box.createVerticalStrut(5));
        JButton saveButton = new JButton("Save CSV");
        saveButton.setAlignmentX(0.5f);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PaneTable.this.saveFile();
            }
        });
        sidePanel.add(saveButton);
        sidePanel.add(Box.createVerticalStrut(5));
        this.infoLabel = new JLabel();
        this.infoLabel.setAlignmentX(0.5f);
        sidePanel.add(this.infoLabel);
        return this.myPanel;
    }

    @Override
    public void deselected() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
    }

    @Override
    public String getTitle() {
        return "Table";
    }

    private void updateOptions() {
        if (this.filter1RadioButton.isSelected()) {
            this.reductionFactor = 1;
        } else if (this.filter10RadioButton.isSelected()) {
            this.reductionFactor = 10;
        } else if (this.filter60RadioButton.isSelected()) {
            this.reductionFactor = 60;
        } else if (this.filter600RadioButton.isSelected()) {
            this.reductionFactor = 600;
        } else if (this.filter3600RadioButton.isSelected()) {
            this.reductionFactor = 3600;
        } else if (this.filterCustomRadioButton.isSelected()) {
            String s = this.filterCustomTextField.getText().trim();
            int f = 1;
            if (s.endsWith("1")) {
                f = 1;
                s = s.substring(0, s.length() - 1);
            } else if (s.endsWith("m")) {
                f = 60;
                s = s.substring(0, s.length() - 1);
            } else if (s.endsWith("h")) {
                f = 3600;
                s = s.substring(0, s.length() - 1);
            }
            this.reductionFactor = Integer.parseInt(s) * f;
            if (this.reductionFactor < 1) {
                this.reductionFactor = 1;
            }
        } else {
            this.reductionFactor = 1;
        }
        if (this.firstRadioButton.isSelected()) {
            this.mathSamples = Math.first;
        } else if (this.lastRadioButton.isSelected()) {
            this.mathSamples = Math.last;
        } else if (this.averageRadioButton.isSelected()) {
            this.mathSamples = Math.average;
        } else if (this.minRadioButton.isSelected()) {
            this.mathSamples = Math.min;
        } else if (this.maxRadioButton.isSelected()) {
            this.mathSamples = Math.max;
        } else if (this.spanRadioButton.isSelected()) {
            this.mathSamples = Math.span;
        } else if (this.changeRadioButton.isSelected()) {
            this.mathSamples = Math.change;
        } else if (this.slopeRadioButton.isSelected()) {
            this.mathSamples = Math.slope;
        }
        if (this.reductionFactor == 1) {
            this.mathSamples = Math.first;
        }
        this.firstRadioButton.setEnabled(this.reductionFactor > 1);
        this.lastRadioButton.setEnabled(this.reductionFactor > 1);
        this.averageRadioButton.setEnabled(this.reductionFactor > 1);
        this.minRadioButton.setEnabled(this.reductionFactor > 1);
        this.maxRadioButton.setEnabled(this.reductionFactor > 1);
        this.spanRadioButton.setEnabled(this.reductionFactor > 1);
        this.changeRadioButton.setEnabled(this.reductionFactor > 1);
        this.slopeRadioButton.setEnabled(this.reductionFactor > 1);
        this.dataModel.fireTableDataChanged();
    }

    private DataSet.DataPoint getFilteredPoint(int row) {
        switch (this.mathSamples) {
            case first: {
                return Support.dataSet.get(row * this.reductionFactor);
            }
            case last: {
                return Support.dataSet.get(row * this.reductionFactor + this.reductionFactor - 1);
            }
            case average: {
                return Support.dataSet.getAverage(row * this.reductionFactor, this.reductionFactor);
            }
            case min: {
                return Support.dataSet.getMin(row * this.reductionFactor, this.reductionFactor);
            }
            case max: {
                return Support.dataSet.getMax(row * this.reductionFactor, this.reductionFactor);
            }
            case span: {
                return Support.dataSet.getSpan(row * this.reductionFactor, this.reductionFactor);
            }
            case change: {
                return Support.dataSet.getChange(row * this.reductionFactor, this.reductionFactor);
            }
            case slope: {
                return Support.dataSet.getSlope(row * this.reductionFactor, this.reductionFactor);
            }
        }
        return Support.dataSet.get(row * this.reductionFactor);
    }

    private void tableChanged() {
        this.tu = Support.dataSet.getTimeUnit();
        this.dataModel.fireTableStructureChanged();
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(0).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(1).setMinWidth(80);
        this.table.getColumnModel().getColumn(1).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(2).setMinWidth(80);
        this.table.getColumnModel().getColumn(2).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(3).setMinWidth(80);
        this.table.getColumnModel().getColumn(3).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(4).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(5).setMinWidth(80);
        this.table.getColumnModel().getColumn(5).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(6).setMinWidth(80);
        this.table.getColumnModel().getColumn(6).setCellRenderer(this.centerRenderer);
        this.table.getColumnModel().getColumn(7).setMinWidth(50);
        this.table.getColumnModel().getColumn(7).setCellRenderer(this.centerRenderer);
    }

    public void updateAll() {
    }

    private void updateInfo() {
        DataSet.MinMax temp = Support.dataSet.getMinMaxTemperature();
        double maxTemp = Double.MIN_VALUE;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (Support.dataSet.isTemperaturePresent()) {
            sb.append("Temp: " + Support.nf1.format(temp.min) + " .. " + Support.nf1.format(temp.max));
            sb.append("<br>");
            sb.append("Range: " + Support.nf1.format(temp.max - temp.min));
        }
        this.infoLabel.setText(sb.toString());
    }

    private void saveFile() {
        JPanel savePanel = new JPanel();
        BoxLayout bl = new BoxLayout(savePanel, 3);
        savePanel.setLayout(bl);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton allDataRadioButton = new JRadioButton("All");
        bg.add(allDataRadioButton);
        savePanel.add(allDataRadioButton);
        allDataRadioButton.setSelected(true);
        JRadioButton filteredDataRadioButton = new JRadioButton("Filtered");
        bg.add(filteredDataRadioButton);
        savePanel.add(filteredDataRadioButton);
        JFileChooser fc = new JFileChooser();
        if (Support.defaultFilePath != null) {
            fc.setCurrentDirectory(new File(Support.defaultFilePath));
        }
        fc.setFileFilter(new FileNameExtensionFilter("CSV", "csv"));
        fc.setAcceptAllFileFilterUsed(false);
        if (this.reductionFactor != 1) {
            fc.setAccessory(savePanel);
        }
        fc.setSelectedFile(new File(Support.currentFilename));
        if (fc.showDialog(this.myPanel, "Save CSV") == 0) {
            File f = fc.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".csv")) {
                f = new File(String.valueOf(f.getPath()) + ".csv");
            }
            if (f.exists() && JOptionPane.showConfirmDialog(this.myPanel, "File exists, overwrite?", "File exists", 1) != 0) {
                return;
            }
            try {
                Support.defaultFilePath = fc.getCurrentDirectory().getPath();
                if (filteredDataRadioButton.isSelected()) {
                    DataSet filteredDataSet = new DataSet();
                    int i = 0;
                    while (i < (Support.dataSet.size() + this.reductionFactor - 1) / this.reductionFactor) {
                        filteredDataSet.addPoint(this.getFilteredPoint(i));
                        ++i;
                    }
                    filteredDataSet.save(f.getPath());
                } else {
                    Support.dataSet.save(f.getPath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void selected() {
        this.updateOptions();
        this.updateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rows = Support.dataSet.size();
                if (rows != PaneTable.this.lastRow) {
                    if (PaneTable.this.currentFormatter.isMilli() && Support.dataSet.getMinMaxCurrent().max > 0.8) {
                        PaneTable.this.currentFormatter = new NF(false, 3);
                        PaneTable.this.tableChanged();
                    }
                    if (PaneTable.this.capacityFormatter.isMilli() && Support.dataSet.getMinMaxCapacity().max > 0.8) {
                        PaneTable.this.capacityFormatter = new NF(false, 3);
                        PaneTable.this.dataModel.fireTableDataChanged();
                    } else if (PaneTable.this.capacityFormatter.getDecimals() == 4 && Support.dataSet.getMinMaxCapacity().max > 8.0) {
                        PaneTable.this.capacityFormatter = new NF(false, 2);
                        PaneTable.this.tableChanged();
                    }
                    if (PaneTable.this.energyFormatter.isMilli() && Support.dataSet.getMinMaxEnergy().max > 0.8) {
                        PaneTable.this.energyFormatter = new NF(false, 3);
                        PaneTable.this.tableChanged();
                    } else if (PaneTable.this.energyFormatter.getDecimals() == 4 && Support.dataSet.getMinMaxEnergy().max > 8.0) {
                        PaneTable.this.energyFormatter = new NF(false, 2);
                        PaneTable.this.tableChanged();
                    }
                    if (PaneTable.this.tu != Support.dataSet.getTimeUnit()) {
                        PaneTable.this.tableChanged();
                    }
                    if (PaneTable.this.reductionFactor > 1) {
                        PaneTable.this.dataModel.fireTableRowsUpdated(PaneTable.this.lastRow / PaneTable.this.reductionFactor, 2);
                    }
                    PaneTable.this.dataModel.fireTableRowsInserted((PaneTable.this.lastRow + PaneTable.this.reductionFactor - 1) / PaneTable.this.reductionFactor, (rows + PaneTable.this.reductionFactor - 1) / PaneTable.this.reductionFactor);
                    PaneTable.this.lastRow = rows;
                    PaneTable.this.dataModel.clearCache();
                    PaneTable.this.updateInfo();
                }
            }
        });
        this.updateTimer.start();
        this.tableChanged();
    }

    private static enum Math {
        first,
        last,
        average,
        min,
        max,
        span,
        change,
        slope;

    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PaneTable.this.updateOptions();
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        private DataSet.DataPoint ds;
        private int dsRow = -1;

        MyTableModel() {
        }

        public void clearCache() {
            this.dsRow = -1;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Index";
                }
                case 1: {
                    return "Time";
                }
                case 2: {
                    return PaneTable.this.tu.name();
                }
                case 3: {
                    return "Voltage (V)";
                }
                case 4: {
                    return "Current (" + PaneTable.this.currentFormatter.prefix() + "A)";
                }
                case 5: {
                    return "Capacity (" + PaneTable.this.capacityFormatter.prefix() + "Ah)";
                }
                case 6: {
                    return "Energy (" + PaneTable.this.energyFormatter.prefix() + "Wh)";
                }
                case 7: {
                    return "Temp. (\ufffdC)";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return (Support.dataSet.size() + PaneTable.this.reductionFactor - 1) / PaneTable.this.reductionFactor;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row != this.dsRow) {
                this.ds = PaneTable.this.getFilteredPoint(row);
                this.dsRow = row;
            }
            switch (col) {
                case 0: {
                    return PaneTable.this.reductionFactor == 1 ? this.ds.getIndex() : row * PaneTable.this.reductionFactor;
                }
                case 1: {
                    return this.ds.getFormattedTime();
                }
                case 2: {
                    if (PaneTable.this.tu == DataSet.TimeUnit.seconds) {
                        return (int)this.ds.getTime(PaneTable.this.tu);
                    }
                    return Support.nf2.format(this.ds.getTime(PaneTable.this.tu));
                }
                case 3: {
                    return Support.nf3.format(this.ds.getVoltage());
                }
                case 4: {
                    return PaneTable.this.currentFormatter.format(this.ds.getCurrent());
                }
                case 5: {
                    return PaneTable.this.capacityFormatter.format(this.ds.getCapacity());
                }
                case 6: {
                    return PaneTable.this.energyFormatter.format(this.ds.getEnergy());
                }
                case 7: {
                    return Support.nf1.format(this.ds.getTemperature());
                }
            }
            return "";
        }
    }

    private class NF {
        private NumberFormat nf;
        private int decimals;
        private boolean milli;

        NF(boolean milli, int decimals) {
            this.milli = milli;
            this.decimals = decimals;
            this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
            this.nf.setGroupingUsed(false);
            this.nf.setMaximumFractionDigits(decimals);
            this.nf.setMinimumFractionDigits(decimals);
        }

        boolean isMilli() {
            return this.milli;
        }

        int getDecimals() {
            return this.decimals;
        }

        String prefix() {
            if (this.milli) {
                return "m";
            }
            return "";
        }

        String format(double v) {
            if (this.milli) {
                return this.nf.format(v * 1000.0);
            }
            return this.nf.format(v);
        }
    }
}

