/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.main;

import dk.hkj.main.DataSet;
import dk.hkj.main.LoggerThread;
import dk.hkj.main.SerialInterface;
import java.awt.Color;
import java.awt.FlowLayout;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Support {
    public static SerialInterface serialInterface = new SerialInterface();
    public static DataSet dataSet = new DataSet();
    public static DataSet.DataPoint lastValues;
    public static double inputVoltage;
    public static String copyright;
    public static Color chartColor;
    public static Color borderColor;
    public static Color textColor;
    public static ChargeParams chargeParams;
    public static String chartOptions;
    public static String lastTermination;
    public static boolean charging;
    public static LoggerThread loggerThread;
    public static String currentFilename;
    public static String batteryName;
    public static char csvDecimalPoint;
    public static char csvDelimiter;
    public static String searchCommPort;
    public static String searchId;
    public static boolean autoConnect;
    public static boolean autoStart;
    public static boolean autoLog;
    public static boolean scanningForConnection;
    public static String defaultFilePath;
    public static NumberFormat nf;
    public static NumberFormat nf0;
    public static NumberFormat nf1;
    public static NumberFormat nf2;
    public static NumberFormat nf3;

    static {
        copyright = "";
        chartColor = null;
        borderColor = null;
        textColor = null;
        chargeParams = new ChargeParams();
        chartOptions = "ITXM";
        lastTermination = "";
        charging = false;
        loggerThread = new LoggerThread();
        currentFilename = "";
        batteryName = "";
        csvDecimalPoint = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        csvDelimiter = (char)(csvDecimalPoint == ',' ? 59 : 44);
        searchCommPort = null;
        searchId = null;
        autoConnect = false;
        autoStart = false;
        autoLog = false;
        scanningForConnection = false;
        defaultFilePath = Support.getComputerName().equalsIgnoreCase("intel7") ? "D:/Devlop/eclipse/javaWorkspace/Charger" : System.getProperty("user.home");
        nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(0);
        nf0 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf0.setGroupingUsed(false);
        nf0.setMaximumFractionDigits(0);
        nf0.setMinimumFractionDigits(0);
        nf1 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf1.setGroupingUsed(false);
        nf1.setMaximumFractionDigits(1);
        nf1.setMinimumFractionDigits(1);
        nf2 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf2.setGroupingUsed(false);
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf3 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf3.setGroupingUsed(false);
        nf3.setMaximumFractionDigits(3);
        nf3.setMinimumFractionDigits(3);
    }

    public static String formatTime(long time) {
        int s = (int)(time % 60L);
        int m = (int)((time /= 60L) % 60L);
        int h = (int)(time /= 60L);
        StringBuffer sb = new StringBuffer();
        if (h > 0) {
            sb.append(h);
            sb.append(":");
        }
        if (h > 0 || m > 0) {
            if (m < 10) {
                sb.append("0");
            }
            sb.append(m);
            sb.append(":");
        }
        if ((h > 0 || m > 0) && s < 10) {
            sb.append("0");
        }
        sb.append(s);
        return sb.toString();
    }

    public static JComponent leftJustify(JComponent c) {
        Box b = Box.createHorizontalBox();
        b.add(c);
        b.add(Box.createHorizontalGlue());
        return b;
    }

    public static JComponent rightJustify(JComponent c) {
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(c);
        return b;
    }

    public static JComponent centerJustify(JComponent c) {
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(c);
        b.add(Box.createHorizontalGlue());
        return b;
    }

    public static JPanel getPanel(int margin) {
        JPanel p = new JPanel();
        FlowLayout fl = new FlowLayout();
        fl.setHgap(margin);
        fl.setVgap(margin);
        p.setLayout(fl);
        return p;
    }

    public static String displayCSVChar(char ch) {
        switch (ch) {
            case '\t': {
                return "TAB";
            }
            case '\r': {
                return "CR";
            }
            case '\n': {
                return "LF";
            }
            case ' ': {
                return "SPC";
            }
        }
        return ch < ' ' ? "0x" + Integer.toString(ch, 16) : "" + ch;
    }

    static String formatTimeInput(long value) {
        if (value >= 3600L && value % 3600L == 0L) {
            return value / 3600L + "h";
        }
        if (value >= 60L && value % 60L == 0L) {
            return value / 60L + "m";
        }
        return "" + value;
    }

    static String formatFloatInput(double value) {
        if (value < 0.3) {
            return nf.format(value * 1000.0) + "m";
        }
        return nf.format(value);
    }

    public static char parseCSVChar(String s) {
        if ((s = s.trim()).equalsIgnoreCase("TAB")) {
            return '\t';
        }
        if (s.equalsIgnoreCase("CR")) {
            return '\r';
        }
        if (s.equalsIgnoreCase("LF")) {
            return '\n';
        }
        if (s.equalsIgnoreCase("SPC") || s.length() == 0) {
            return ' ';
        }
        if (s.startsWith("0x")) {
            return (char)Integer.parseInt(s.substring(2), 16);
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        return '?';
    }

    public static double parseValue(String str, boolean time, double min, double max) {
        str = str.trim().replace(',', '.');
        double v = 0.0;
        double f = 1.0;
        if (!time && str.endsWith("m")) {
            f = 0.001;
            str = str.substring(0, str.length() - 1);
        } else if (time && str.endsWith("s")) {
            f = 1.0;
            str = str.substring(0, str.length() - 1);
        } else if (time && str.endsWith("m")) {
            f = 60.0;
            str = str.substring(0, str.length() - 1);
        } else if (time && str.endsWith("h")) {
            f = 3600.0;
            str = str.substring(0, str.length() - 1);
        }
        v = Double.parseDouble(str) * f;
        if (v < min || v > max) {
            throw new NumberFormatException("Value out of range, valid range: " + Support.formatFloatInput(min) + " .. " + Support.formatFloatInput(max));
        }
        return v;
    }

    private static String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return "Unknown Computer";
    }

    public static Color parseColor(String param) {
        String[] s = param.split("[ ,]");
        int r = 0;
        int g = 0;
        int b = 0;
        if (s.length == 3) {
            r = Integer.decode(s[0]) & 0xFF;
            g = Integer.decode(s[1]) & 0xFF;
            b = Integer.decode(s[2]) & 0xFF;
        } else {
            long v = Long.decode(param);
            r = (int)(v >> 16) & 0xFF;
            g = (int)(v >> 8) & 0xFF;
            b = (int)v & 0xFF;
        }
        return new Color(r, g, b);
    }

    static enum ChargeMode {
        NiMH,
        NiMHV,
        NiMHVT,
        LiIon,
        LiFePO4,
        dvdt,
        Voltage,
        VoltageTop,
        CCCV,
        Time,
        Capacity,
        VoltageTime,
        CapacityVoltage;

    }

    static class ChargeParams {
        ChargeMode mode = ChargeMode.NiMH;
        double current = 0.5;
        double voltage = 1.5;
        double minCurrent = 0.05;
        double deltaVoltage = 0.003;
        double capacity = 1.0;
        long time = 3600L;
        long finalLoggingTime = 10L;

        ChargeParams() {
        }
    }
}

