
; Define RC5 address of Remote Control

RemoteAddr	EQU	0x1D

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00
NUM_1	EQU	0x01
NUM_2	EQU	0x02
NUM_3	EQU	0x03
NUM_4	EQU	0x04
NUM_5	EQU	0x05
NUM_6	EQU	0x06
NUM_7	EQU	0x07
NUM_8	EQU	0x08
NUM_9	EQU	0x09
NUM_10	EQU	0x0A
NUM_20	EQU	0x0B
STANDBY	EQU	0x0C
MUTE	EQU	0x0D
NUM_E	EQU	0x0E
TEXT	EQU	0x0F

VOL_UP	EQU	0x10
VOL_DN	EQU	0x11
BRI_UP	EQU	0x12
BRI_DN	EQU	0x13
SAT_UP	EQU	0x14
SAT_DN	EQU	0x15
BAS_UP	EQU	0x16
BAS_DN	EQU	0x17
TRE_UP	EQU	0x18
TRE_DN	EQU	0x19
BAL_RI	EQU	0x1A
BAL_LE	EQU	0x1B
CON_UP	EQU	0x1C
CON_DN	EQU	0x1D
HUE_DN	EQU	0x1F

CMD_20	EQU	0x20
CMD_21	EQU	0x21
CMD_22	EQU	0x22
CMD_23	EQU	0x23
CMD_24	EQU	0x24
CMD_25	EQU	0x25
CMD_26	EQU	0x26
CMD_27	EQU 0x27
HUE_UP	EQU	0x27
CMD_28	EQU	0x28
CMD_29	EQU	0x29
CMD_2A	EQU	0x2A
CMD_2B	EQU	0x2B
CMD_2C	EQU	0x2C
CMD_2D	EQU	0x2D
CMD_2E	EQU	0x2E
HELP	EQU	0x2F

PAUSE	EQU	0x30
CMD_31	EQU	0x31
CMD_32	EQU	0x32
CMD_33	EQU	0x33
CMD_34	EQU	0x34
CMD_35	EQU	0x35
CMD_36	EQU	0x36
CMD_37	EQU	0x37
CMD_38	EQU	0x38
CMD_39	EQU	0x39
CMD_3A	EQU	0x3A
CMD_3B	EQU	0x3B
CMD_3C	EQU	0x3C
CMD_3D	EQU	0x3D
CMD_3E	EQU	0x3E
CMD_3F	EQU	0x3F

CMD_40	EQU	0x40
CMD_41	EQU	0x41
CMD_42	EQU	0x42
CMD_43	EQU	0x43
CMD_44	EQU	0x44
CMD_45	EQU	0x45
CMD_46	EQU	0x46
CMD_47	EQU	0x47
PHA_UP	EQU	0x48
PHA_DN	EQU	0x49
CMD_4A	EQU	0x4A
CMD_4B	EQU	0x4B
CMD_4C	EQU	0x4C
SHA_UP	EQU	0x4D
SHA_DN	EQU	0x4E
CMD_4F	EQU	0x4F

CUR_UP	EQU	0x50
CUR_DN	EQU	0x51
ADJUST	EQU	0x52
EXIT	EQU	0x53
ADDR	EQU	0x54
CUR_LE	EQU	0x55
CUR_RI	EQU	0x56
ENTER	EQU	0x57
CMD_58	EQU	0x58
CMD_59	EQU	0x59
CMD_5A	EQU	0x5A
CMD_5B	EQU	0x5B
CMD_5C	EQU	0x5C
FREEZE	EQU	0x5D
CMD_5E	EQU	0x5E
CMD_5F	EQU	0x5F

CMD_60	EQU	0x60
CMD_61	EQU	0x61
CMD_62	EQU	0x62
CMD_63	EQU	0x63
CMD_64	EQU	0x64
CMD_65	EQU	0x65
CMD_66	EQU	0x66
CMD_67	EQU	0x67
CMD_68	EQU	0x68
CMD_69	EQU	0x69
CMD_6A	EQU	0x6A
F1		EQU	0x6B
F2		EQU	0x6C
F3		EQU	0x6D
F4		EQU	0x6E
F5		EQU	0x6F

CMD_70	EQU	0x70
CMD_71	EQU	0x71
CMD_72	EQU	0x72
CMD_73	EQU	0x73
CMD_74	EQU	0x74
CMD_75	EQU	0x75
CMD_76	EQU	0x76
ASTRSK 	EQU	0x77
CMD_78	EQU	0x78
CMD_79	EQU	0x79
CMD_7A	EQU	0x7A
CMD_7B	EQU	0x7B
CMD_7C	EQU	0x7C
CMD_7D	EQU	0x7D
CMD_7E	EQU	0x7E
CMD_7F	EQU	0x7F

;===============================================
; Definition of Functions on the Propeller clock

;Clear second
;SEC_CL		EQU	NUM_0
;Increment second
;SEC_UP		EQU	VOL_UP
;Decrement second
;SEC_DN		EQU	VOL_DN
;Increment minute
;MIN_UP		EQU	BAL_RI
;Decrement minute
;MIN_DN		EQU	BAL_LE
;Increment hour
;HOUR_UP		EQU	CON_UP
;Decrement hour
;HOUR_DN		EQU	CON_DN
;Increment day
;DAY_UP		EQU	BRI_UP
;Decrement day
;DAY_DN		EQU	BRI_DN
;Increment day of week
;WDAY_UP		EQU	SHA_UP
;Decrement day of week
;WDAY_DN		EQU	SHA_DN
;Increment month
;MON_UP		EQU	SAT_UP
;Decrement month
;MON_DN		EQU	SAT_DN
;Increment year
;YEAR_UP		EQU	HUE_UP
;Decrement year
;YEAR_DN		EQU	HUE_DN
;Increment display offset
;INDEX_UP	EQU	PHA_UP
;Decrement display offset
;INDEX_DN	EQU	PHA_DN

;Toggle outer led
;BlueLine	EQU	F1
;Toggle digital time display
;DigiTime	EQU	F2
;Toggle digital date display
;DigiDate	EQU	F3
;Toggle analogue colck's hands
;AnaTime		EQU	F4
;Toggle analogue colck's ticks
;TTicks		EQU	F5
;Toggle dot/arc second hand mode
;TSecMode	EQU PAUSE

;Toggel demo mode
; on 16F886 	  - Scrolling text1 - time - Scrolling text2 - time -
;DemoM		EQU	ASTRSK	;Demo Mode
;Toggle scrolling text mode
;TextMode	EQU	TEXT
;Toggle rotation speed display
;TRotation	EQU ENTER
;Toggle static text mode
;TStaticText	EQU FREEZE
;Toggle day of week and rotation display
;TWDay		EQU EXIT
; Set scrolling speed
;SET_SP		EQU	ADDR

;Mnemonic	Code		; Function						; Funkci

SEC_CL		EQU	0x18	; Clear seconds					; Msodperc trlse
SEC_UP		EQU	0x14	; Seconds up					; Msodperc nvelse
SEC_DN		EQU	0x10	; Seconds down					; Msodperc cskkentse
MIN_UP		EQU	0x15	; Minutes up					; Perc nvelse
MIN_DN		EQU	0x11	; Minutes down					; Perc cskkentse
HOUR_UP		EQU	0x1D	; Hour up						; ra nvelse
HOUR_DN		EQU	0x19	; Hour down						; ra cskkentse
DAY_UP		EQU	0x1E	; Day up						; Nap nvelse
DAY_DN		EQU	0x1A	; Day down						; Nap cskkentse
MON_UP		EQU	0x17	; Month up						; Hnap nvelse
MON_DN		EQU	0x13	; Month down					; Hnap cskkentse
YEAR_UP		EQU	0x1F	; Year up						; v nvelse
YEAR_DN		EQU	0x1B	; Year down						; v cskkentse
CENT_UP		EQU	0x44	; Century up					; vszzad nvelse
CENT_DN		EQU	0x40	; Century down					; vszzad cskkentse

INDEX_UP	EQU	0x2F	; Offset up						; Offszet nvelse
INDEX_DN	EQU	0x2B	; Offset down					; Offszet cskkentse

BRIGHT_ST	EQU	0x27	; Bright setting step 			; Fnyer llts lpse : 1 / 16
BRIGHT_MD	EQU	0x28	; Change brigthness mode		; Fnyer zemmd prgetse
BRIGHT_UP	EQU	0x24	; Actual brigthness up			; Aktulis fnyer nvelse
BRIGHT_DN	EQU	0x20	; Actual brigthness down		; Aktulis fnyer cskkentse

LIGHTLIM_UP	EQU	0x2D	; Light limit up				; Megvilgts hatr nvelse
LIGHTLIM_DN	EQU	0x29	; Light limit down				; Megvilgts hatr cskkentse

TPICT		EQU	0x25	;Picture number up				; Kpszm lptetse felfel
TPICTDN		EQU	0x16	;Picture number down			; Kpszm lptetse lefel

TOuterLine	EQU	0x07	;Toggle outer led				; Kls led llapotvlts
DigitalMode	EQU	0x01	;Change digital mode			; Digitlis kijelzs zemmd vltsa
AnalogueMode	EQU	0x09;Change analog hands displaying	; Analg mutatk lltsa
AnalogueHands	EQU	0x0D;Change analog hands mode		; Analog kijelzs zemmd vltsa
AnalogClk	EQU	0x23	;Toggle analog clock with inner leds; A bels ledeken megjelen ra kijelzs vltsa
						; - overrides other hand settings; - fellbrlja a msik analg kijelzst

DemoM		EQU	0x00	;Demo Mode						; Demo md vltsa
TextMode	EQU	0x04	;Scrolling text					; Mozg szveg zemmd vltsa
TStaticText	EQU 0x08	;Static picture					; Statikus kp zemmd vltsa
TWDayName	EQU 0x05	;Toggle Day of week name		; Ht napja szvegesen
SET_SP		EQU	0x02	;Inc Scroll speed				; Scroll sebessg nvelse
SET_SP_DN	EQU	0x12	;Dec Scroll speed				; Scroll sebessg cskkentse

TLANGUAGE	EQU	0x06	; LANGUAGE						; Nyelv kivlasztsa
TBinMode	EQU	0x0A	; Toggle binary mode			; Binris kijelzs vltsa
TTicks		EQU	0x0E	; Toggle ticks					; raoszts vltsa
TScrollMode	EQU	0x2C	; Change scroll mode			; Scroll zemmd vltsa
TSlideShow	EQU	0x1C	; Toggle slide show mode		; Slide show zemmd vltsa


SAVE0		EQU	0x30	; Save settings 	#0			; Bellts mentse 0. helyre
RESTORE0	EQU	0x38	; Restore settings	#0			; Bellts visszalltsa 0. helyrl
SAVE1		EQU	0x31	; Save settings  	#1			; Bellts mentse 1. helyre
RESTORE1	EQU	0x39	; Restore settings	#1			; Bellts visszalltsa 1. helyrl
SAVE2		EQU	0x32	; Save settings    	#2			; Bellts mentse 2. helyre
RESTORE2	EQU	0x3A	; Restore settings	#2			; Bellts visszalltsa 2. helyrl
SAVE3		EQU	0x33	; Save settings    	#3			; Bellts mentse 3. helyre
RESTORE3	EQU	0x3B	; Restore settings	#3			; Bellts visszalltsa 3. helyrl
SAVE4		EQU	0x34	; Save settings 	#4			; Bellts mentse 4. helyre
RESTORE4	EQU	0x3C	; Restore settings	#4			; Bellts visszalltsa 4. helyrl
SAVE5		EQU	0x35	; Save settings  	#5			; Bellts mentse 5. helyre
RESTORE5	EQU	0x3D	; Restore settings	#5			; Bellts visszalltsa 5. helyrl
SAVE6		EQU	0x36	; Save settings    	#6			; Bellts mentse 6. helyre
RESTORE6	EQU	0x3E	; Restore settings	#6			; Bellts visszalltsa 6. helyrl
SAVE7		EQU	0x37	; Save settings    	#7			; Bellts mentse 7. helyre
RESTORE7	EQU	0x3F	; Restore settings	#7			; Bellts visszalltsa 7. helyrl

;===============================================
; Definition of Functions on the Propeller clock's Base


TINDEX		EQU	CMD_21	; Toggle index					; Index led ki / bekapcsolsa

WIDTH_UP	EQU	CMD_26	; PWM pulse width up			; Impulzus szlessg nvelse
WIDTH_DN	EQU	CMD_22	; PWM pulse width down			; Impulzus szlessg cskkentse

REL_ON		EQU	0x0F	; Relais ON						; Rel kimenet bekapcsolsa
REL_OFF		EQU	0x0B	; Relais OFF					; Rel kimenet kikapcsolsa

ALM_SND		EQU 0x03	; Alarm sound off				; bresztsi hangjelzs kikapcsolsa

POWUPCOIL	EQU	CMD_2E	; Power up coil					; Traf bekapcsolsa
POWDNCOIL	EQU	CMD_2A	; Power down coil				; Traf kikapcsolsa
