{---------------------------------------------------------------}
{   Program  : Hardware testing for IC-Tester card              }
{   Create   : 11:25:41 - 30/09/2000                            }
{   By       : David Setya atmaja - DSA                         }
{   Idea     : Expandable Ic_Tester.BAS program from Internet   }
{              created by : Paul Stenning (1993)                }
{   Revision : 07/10/2000                                       }
{---------------------------------------------------------------}
{   Testing only parallel version type create by me.            }
{   Using any LPT bidirectional port for printer.               }
{---------------------------------------------------------------}
{$M $4000,0,$4000}

USES DOS,CRT;

TYPE
    LPT_Port       = (LPT_1, LPT_2, LPT_3, No_LPT);
    Mode_PPI       = (Port_A, Port_B, Port_C, Port_CW, Port_Hi_Z, PPI_Rst);
    Dec_Port_C     = (Set_Latch_1, Set_Latch_2, Set_Latch_3,
                      Set_Buffer_1, Set_Buffer_2, Set_Buffer_3,
                      Set_Spare, Steady_State);
    Pin_IC         = (Pin_24, Pin_20, Pin_16, Pin_14, User_Pin, Not_Set);

CONST
     CPR           = '(C) Oct 1, 2000, by : David Setya Atmaja (DSA)';
     Ada_Port      : BOOLEAN = FALSE;
     Ada_Card      : BOOLEAN = FALSE;
     Bi_Direct     : BOOLEAN = FALSE;
     Baca_Data     : BOOLEAN = TRUE;
     PC_Port       : ARRAY[0..2] OF WORD =
                     ($03F8,$02F8,$0278);   { 'COM1','COM2','LPT1' }
     DP : ARRAY[LPT_Port] OF WORD = ($3BC, $378, $278, $3BC); { Data Port }
     PC : ARRAY[LPT_Port] OF WORD = ($3BE, $37A, $27A, $3BE); { Control Port }
     PS : ARRAY[LPT_Port] OF WORD = ($3BD, $379, $279, $3BD); { Status Port }
     Port_PPI : ARRAY[Mode_PPI] OF WORD = ($000F,     { Port-A PPI as output port }
                                           $0022,     { Port-B PPI as input port }
                                           $000D,     { Port-C PPI as output port }
                                           $000C,     { Port-CW PPI as output port }
                                           $0004,     { Port-Hi-Z PPI }
                                           $0008);    { Reset PPI }
     Set_Mode_PPI  = $0082;                           { Port-A, Port-C = Output }
                                                      { Port-B = Input, Mode = 0 }
     Set_Dec_Port_C : ARRAY[Dec_Port_C] OF BYTE = ($F8,    { Latch 1 Aktif }
                                                   $F9,    { Latch 2 Aktif }
                                                   $FA,    { Latch 3 Aktif }
                                                   $FB,    { Buffer 1 Aktif }
                                                   $FC,    { Buffer 2 Aktif }
                                                   $FD,    { Buffer 3 Aktif }
                                                   $FE,    { Spare Bit }
                                                   $FF);   { Steady State }
     Tegangan_IC   : ARRAY[Pin_IC] OF BYTE = ($7F,    { Vcc=pin-24, Gnd=pin-12 }
                                              $EF,    { Vcc=pin-22, Gnd=pin-12 }
                                              $DF,    { Vcc=pin-20, Gnd=pin-12 }
                                              $BF,    { Vcc=pin-19, Gnd=pin-12 }
                                              $F7,    { Vcc=pin-24, Gnd=pin-1 }
                                              $FF);   { Vcc=none, Gnd=none, external supply }
     Port_A_PPI    = $03;    { Note that Port-A through Port-CW }
     Port_B_PPI    = $02;    { are inverting to PC0 and PC-1 }
     Port_C_PPI    = $01;
     Port_CW_PPI   = $00;
     Pola_1        = $55;    { Pattern byte 1 }
     Pola_2        = $AA;    { Pattern byte 2 }

VAR
   Pilih,Tombol    : CHAR;
   LPT             : LPT_Port;
   Port_DP         : WORD;
   Port_PC         : WORD;
   Port_PS         : WORD;
   Byte_Read_1     : BYTE;
   Byte_Read_2     : BYTE;
   Byte_Read_3     : BYTE;
   Byte_Send_1     : BYTE;
   Byte_Send_2     : BYTE;
   Byte_Send_3     : BYTE;
   Ulangi          : BYTE;
   Set_Pin_IC      : Pin_IC;

FUNCTION Hex2Str(Angka : WORD) : STRING;
CONST
     HexDigit : ARRAY[0..15] OF CHAR = '0123456789ABCDEF';
VAR
   I : BYTE;
BEGIN
     Hex2Str[0] := #2;
     FOR I := 2 DOWNTO 1 DO
     BEGIN
          Hex2Str[I] := HexDigit[Angka AND $F];
          Angka := Angka SHR 4;
     END;
END;

PROCEDURE Press_A_Key;
BEGIN
     WRITELN;
     WRITELN('Press a key to continue ...');
     REPEAT UNTIL KEYPRESSED;
     Tombol := READKEY;
     IF Tombol = #0 THEN Tombol := READKEY;
     WRITELN;
END;

PROCEDURE Inisialisasi_PPI;
BEGIN
     PORT[PC[LPT]] := Port_PPI[PPI_Rst];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_CW_PPI;
     PORT[DP[LPT]] := Set_Mode_PPI;
     PORT[PC[LPT]] := Port_PPI[Port_CW];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_CW_PPI;
     PORT[DP[LPT]] := Set_Dec_Port_C[Steady_State];
     PORT[PC[LPT]] := Port_PPI[Port_C];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_C_PPI;
END;

PROCEDURE Tulis_Port_A(Data : BYTE);
BEGIN
     PORT[DP[LPT]] := Data;
     PORT[PC[LPT]] := Port_PPI[Port_A];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_A_PPI;
END;

PROCEDURE Tulis_Port_C(Data : BYTE);
BEGIN
     PORT[DP[LPT]] := Data;
     PORT[PC[LPT]] := Port_PPI[Port_C];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_C_PPI;
END;

FUNCTION Baca_Port_B : BYTE;
VAR
   Temp : BYTE;
BEGIN
     PORT[PC[LPT]] := Port_PPI[Port_B];
     Temp := PORT[DP[LPT]];
     PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_B_PPI;
     Baca_Port_B := Temp;
END;

PROCEDURE Tulis_Port_A_3_Byte(Data_1,Data_2,Data_3 : BYTE);
BEGIN
     Tulis_Port_A(Data_1);
     Tulis_Port_C(Set_Dec_Port_C[Set_Latch_1]);
     Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
     Tulis_Port_A(Data_2);
     Tulis_Port_C(Set_Dec_Port_C[Set_Latch_2]);
     Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
     Tulis_Port_A(Data_3);
     Tulis_Port_C(Set_Dec_Port_C[Set_Latch_3]);
     Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
END;

PROCEDURE Cek_Card;
VAR
   Temp : BYTE;
BEGIN
     Ada_Port := FALSE; Ada_Card := FALSE;
     Bi_Direct := FALSE;Byte_Send_1 := Pola_1;
     { Parallel Port Routine }
     FOR LPT := LPT_1 TO LPT_3 DO
     BEGIN
          IF (NOT Ada_Port) OR (NOT Ada_Card) THEN
          BEGIN
               IF PORT[PC[LPT]] <> Set_Dec_Port_C[Steady_State] THEN Ada_Port := TRUE;
               IF Ada_Port THEN
               BEGIN
                    PORT[DP[LPT]] := Byte_Send_1;
                    Temp := PORT[PC[LPT]];
                    PORT[PC[LPT]] := Temp OR $20;     { Cek bi-directional port }
                    IF PORT[DP[LPT]] <> Byte_Send_1 THEN Bi_Direct := TRUE;
                    PORT[PC[LPT]] := Temp;
                    IF Bi_Direct THEN
                    BEGIN
                         IF ((PORT[PS[LPT]] AND $88) = $80) THEN Ada_Card := TRUE   { Cek IC-Tester Card }
                         ELSE Ada_Card := FALSE;      { PS_3 = normal, PS_7 = Inverting }
                    END;                              { When open, PS are all in hi-z }
               END;
          END;
          IF Ada_Port AND Ada_Card THEN      { Normally PS[LPT] = $7F (?) }
          BEGIN
               Port_DP := DP[LPT];
               Port_PC := PC[LPT];
               Port_PS := PS[LPT];
               IF Bi_Direct THEN Inisialisasi_PPI;
          END;
     END;
     IF NOT Bi_Direct THEN
     BEGIN
          WRITELN(#7,'LPT port not a bidirectional port!',#7);
          WRITELN('Can''t continue ...');
          Ada_Port := FALSE;
     END
     ELSE IF NOT Ada_Port THEN WRITELN(#7,'LPT port not found!',#7)
     ELSE IF Ada_Port AND (NOT Ada_Card) THEN
     BEGIN
          WRITELN(#7,'IC-Tester card not connected on the LPT port!',#7);
          WRITELN('The power must be on and the cable are properly mounted.');
          IF ((PORT[PS[LPT]] AND $88) = $00) THEN
          BEGIN
               WRITELN('Please check the power supply for IC-Tester card.');
          END
          ELSE
          BEGIN
               WRITELN('Pin 11th & pin 15th of the LPT connector are the identify bits.');
               WRITELN('Please check the cable, pin connector and part of IC-3.');
          END;
     END;
     IF (NOT Ada_Port) OR (NOT Ada_Card) THEN Press_A_Key;
END;

BEGIN         { Main Routine }
     REPEAT
           TEXTATTR := $7;CLRSCR;
           WRITELN('Hardware Tester for IC-Tester card Ver 1.02');
           WRITELN(CPR);
           WRITELN;
           WRITELN(' ':5,'Performing check for :');
           WRITELN(' ':5,'1. IC-Tester card I/O operation.');
           WRITELN(' ':5,'2. IC-Tester card write option pin select.');
           WRITELN(' ':5,'3. IC-Tester card read option pin select.');
           WRITELN(' ':5,'4. IC-Tester card power select.');
           WRITELN(' ':5,'5. IC-Tester card connectifity.');
           WRITELN;
           WRITE(' ':10,'Choice : ');
           REPEAT
                 Pilih := UPCASE(READKEY);
                 IF NOT (Pilih IN ['1'..'5',#27]) THEN
                 BEGIN
                      IF Pilih = #0 THEN
                      BEGIN
                           Pilih := READKEY;
                           Pilih := ' ';
                      END;
                      WRITE(#7);
                 END
                 ELSE IF Pilih IN ['1'..'5'] THEN WRITELN(Pilih);
           UNTIL Pilih IN ['1'..'5',#27];
           WRITELN;
           CASE Pilih OF
                '1' : BEGIN       { Card reset }
                           WRITELN('This routine do resetting and configuring the hardware.');
                           WRITELN('Perform 10-steps test of the I/O one by one.');
                           WRITELN('Please check the output of the proper bits by tester or logic probe.');
                           WRITELN;
                           IF NOT (Ada_Port AND Ada_Card) THEN Cek_Card;
                           WRITELN('Step-1, resetting the card, check pin-35 PPI, must be logic 1.');
                           WRITELN('If not, check the path of IC-1, IC-13, IC-15.');
                           PORT[PC[LPT]] := Port_PPI[PPI_Rst];
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           PORT[PC[LPT]] := Port_PPI[Port_Hi_Z];
                           WRITELN('Step-2, configuring the PPI, mode-0, port-A and port-C as output port,');
                           WRITELN('port-B as input port. The Control Word data must be ',Hex2Str(Set_Mode_PPI),' Hex,');
                           WRITELN('please check pin-27 to pin-34 PPI.');
                           WRITELN('If not the same, check the path of DP-2 through DP-9 (Data lines).');
                           PORT[DP[LPT]] := Set_Mode_PPI;
                           PORT[PC[LPT]] := Port_PPI[Port_CW];
                           PORT[PC[LPT]] := Port_PPI[Port_Hi_Z]+Port_CW_PPI;
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-3, send a byte (',Hex2Str(Pola_1),' Hex) to port-A PPI,');
                           WRITELN('check pin-4 to pin-1 and pin-40 to pin-37.');
                           WRITELN('If the logic all 0''s or 1''s then step-2 not passed (PPI not configured),');
                           WRITELN('else check path of pin-4 to pin-1 and pin-40 to pin-37 PPI.');
                           Tulis_Port_A(Pola_1);
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-4, send a byte (FF Hex) to port-C PPI,');
                           WRITELN('check pin-14 to pin-17 and pin-13 to pin-10.');
                           WRITELN('If the logic all 0''s or 1''s then step-2 not passed (PPI not configured),');
                           WRITELN('else check path of pin-14 to pin-17 and pin-13 to pin-10 PPI.');
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-5, send a clock to latch data port-A (',Hex2Str(Pola_1),' Hex) by IC-3,');
                           WRITELN('check data Q0 to Q7 IC-3 (pin-2, 5, 19, 6, 16, 9, 15, 12).');
                           WRITELN('If something wrong, check the path of IC-2, IC-3 and IC-13.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Latch_1]);
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-6, read back latch data (',Hex2Str(Pola_1),' Hex) through port-B (Byte 1),');
                           WRITELN('If something wrong, check the path of IC-2, IC-10 and port-B PPI.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_1]);
                           Byte_Read_1 := Baca_Port_B;
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           WRITELN;
                           WRITELN('Data reads from port-B is : ',Hex2Str(Byte_Read_1),' Hex.');
                           IF Byte_Read_1 <> Pola_1 THEN
                              WRITELN(#7,'Byte reads not the same, please check the path again!',#7);
                           Press_A_Key;
                           IF (Tombol <> #27) AND (Byte_Read_1 = Pola_1) THEN
                           BEGIN
                           Tulis_Port_A(Pola_2);
                           WRITELN('Step-7, send a clock to latch data port-A (',Hex2Str(Pola_1),' Hex) by IC-4,');
                           WRITELN('check data Q0 to Q7 IC-4 (pin-2, 5, 19, 6, 16, 9, 15, 12).');
                           WRITELN('If something wrong, check the path of IC-2, IC-4 and IC-13.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Latch_2]);
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-8, read back latch data (',Hex2Str(Pola_2),' Hex) through port-B (Byte 2),');
                           WRITELN('If something wrong, check the path of IC-2, IC-11 and port-B PPI.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_2]);
                           Byte_Read_1 := Baca_Port_B;
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           WRITELN;
                           WRITELN('Data reads from port-B is : ',Hex2Str(Byte_Read_1),' Hex.');
                           IF Byte_Read_1 <> Pola_2 THEN
                              WRITELN(#7,'Byte reads not the same, please check the path again!',#7);
                           Press_A_Key;
                           IF (Tombol <> #27) AND (Byte_Read_1 = Pola_2) THEN
                           BEGIN
                           Tulis_Port_A(Pola_1);
                           WRITELN('Step-9, send a clock to latch data port-A (',Hex2Str(Pola_1),' Hex) by IC-5,');
                           WRITELN('check data Q0 to Q7 IC-5 (pin-2, 5, 19, 6, 16, 9, 15, 12).');
                           WRITELN('If something wrong, check the path of IC-2, IC-5 and IC-13.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Latch_3]);
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           Press_A_Key;
                           IF Tombol <> #27 THEN
                           BEGIN
                           WRITELN('Step-10, read back latch data (',Hex2Str(Pola_1),' Hex) through port-B (Byte 3),');
                           WRITELN('If something wrong, check the path of IC-2, IC-12 and port-B PPI.');
                           Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_3]);
                           Byte_Read_1 := Baca_Port_B;
                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                           WRITELN;
                           WRITELN('Data reads from port-B is : ',Hex2Str(Byte_Read_1),' Hex.');
                           IF Byte_Read_1 <> Pola_1 THEN
                              WRITELN(#7,'Byte reads not the same, please check the path again!',#7);
                           Press_A_Key;
                           END; END; END; END; END; END; END; END; END;
                      END;
                '2' : BEGIN       { Port write test }
                           WRITELN('This routine perform test for writing port-A PPI to IC socket pin data.');
                           WRITELN;
                           IF NOT (Ada_Port AND Ada_Card) THEN Cek_Card;
                           Byte_Send_1 := Pola_1;Tombol := ' ';Ulangi := 1;
                           REPEAT
                                 Tulis_Port_A_3_Byte(Byte_Send_1,Byte_Send_1,Byte_Send_1);
                                 WRITELN('Please check the socket pins 1 through 24,');
                                 WRITELN('the patterns are tripple of ',Hex2Str(Byte_Send_1),' Hex.');
                                 Press_A_Key;
                                 Byte_Send_1 := Pola_2;INC(Ulangi);
                           UNTIL (Ulangi = 3) OR (Tombol = #27);
                           IF Tombol <> #27 THEN
                           BEGIN
                                WRITELN('If the patterns not like that,'+
                                        ' something wrong with the path,');
                                WRITELN('please check : port-A PPI and IC-3 through IC-9 path.',#7);
                                Press_A_Key;
                           END;
                      END;
                '3' : BEGIN       { Port read test }
                           WRITELN('This routine perform 6-steps test to reads IC socket pin data'+
                                   ' from port-B PPI.');
                           WRITELN('Writing test to port-A PPI must be passed before perform this test,');
                           WRITELN('otherwise the data being read are not correct with the send data.');
                           WRITELN('If something wrong, the process will be stopped at the error step.');
                           WRITELN;
                           IF NOT (Ada_Port AND Ada_Card) THEN Cek_Card;
                           Byte_Send_1 := Pola_1;Tombol := ' ';Ulangi := 0;Baca_Data := TRUE;
                           REPEAT
                                 WRITELN('Step-',Hex2Str(1+3*Ulangi),', Writing to port-A PPI byte 1 : '+
                                          Hex2Str(Byte_Send_1),' Hex.');
                                 Tulis_Port_A(Byte_Send_1);
                                 Tulis_Port_C(Set_Dec_Port_C[Set_Latch_1]);
                                 Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                 Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_1]);
                                 Byte_Read_1 := Baca_Port_B;
                                 Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                 WRITELN(' ':9,'Reading from port-B PPI byte 1 : ',Hex2Str(Byte_Read_1),' Hex.');
                                 Press_A_Key;
                                 IF (Byte_Read_1 = Byte_Send_1) AND (Tombol <> #27) THEN
                                 BEGIN
                                      WRITELN('Step-',Hex2Str(2+3*Ulangi),', Writing to port-A PPI byte 2 : '+
                                               Hex2Str(Byte_Send_1),' Hex.');
                                      Tulis_Port_A(Byte_Send_1);
                                      Tulis_Port_C(Set_Dec_Port_C[Set_Latch_2]);
                                      Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                      Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_2]);
                                      Byte_Read_2 := Baca_Port_B;
                                      Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                      WRITELN(' ':9,'Reading from port-B PPI byte 2 : ',Hex2Str(Byte_Read_2),' Hex.');
                                      Press_A_Key;
                                      IF (Byte_Read_2 = Byte_Send_1) AND (Tombol <> #27) THEN
                                      BEGIN
                                           WRITELN('Step-',Hex2Str(3+3*Ulangi),', Writing to port-A PPI byte 3 : '+
                                                   Hex2Str(Byte_Send_1),' Hex.');
                                           Tulis_Port_A(Byte_Send_1);
                                           Tulis_Port_C(Set_Dec_Port_C[Set_Latch_3]);
                                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                           Tulis_Port_C(Set_Dec_Port_C[Set_Buffer_3]);
                                           Byte_Read_3 := Baca_Port_B;
                                           Tulis_Port_C(Set_Dec_Port_C[Steady_State]);
                                           WRITELN(' ':9,'Reading from port-B PPI byte 3 : ',Hex2Str(Byte_Read_3),' Hex.');
                                           Press_A_Key;
                                           IF Byte_Read_3 <> Byte_Send_1 THEN Baca_Data := FALSE;
                                      END
                                      ELSE Baca_Data := FALSE;
                                 END
                                 ELSE Baca_Data := FALSE;
                                 Byte_Send_1 := Pola_2;INC(Ulangi);
                           UNTIL (NOT Baca_Data) OR (Ulangi = 2) OR (Tombol = #27);
                           IF (Tombol <> #27) AND (NOT Baca_Data) THEN
                           BEGIN
                                WRITELN(#7,'Something wrong with the path,');
                                WRITELN('please check : port-B PPI and IC-10 through IC-12 path.',#7);
                                Press_A_Key;
                           END;
                      END;
                '4' : BEGIN       { Power test }
                           WRITELN('This routine perform 5-steps test to gives power to IC socket pin,');
                           WRITELN('covered of 24-pin IC, 20-pin IC, 16-pin IC, 14-pin IC and'+
                                   ' user define pin IC.');
                           WRITELN;
                           IF NOT (Ada_Port AND Ada_Card) THEN Cek_Card;
                           Tombol := ' ';Ulangi := 1;
                           REPEAT
                                 CASE Ulangi OF
                                      1 : BEGIN
                                               WRITELN('Step-1, Powered 24-pin IC,'+
                                                       ' please check pin-24 = +Vcc and pin-12 = Gnd.');
                                               Byte_Send_1 := 0;Byte_Send_2 := 0;Byte_Send_3 := $80;
                                               Set_Pin_IC := Pin_24;
                                          END;
                                      2 : BEGIN
                                               WRITELN('Step-2, Powered 20-pin IC,'+
                                                       ' please check pin-22 = +Vcc and pin-12 = Gnd.');
                                               Byte_Send_1 := 0;Byte_Send_2 := 0;Byte_Send_3 := $20;
                                               Set_Pin_IC := Pin_20;
                                          END;
                                      3 : BEGIN
                                               WRITELN('Step-3, Powered 16-pin IC,'+
                                                       ' please check pin-20 = +Vcc and pin-12 = Gnd.');
                                               Byte_Send_1 := 0;Byte_Send_2 := 0;Byte_Send_3 := $08;
                                               Set_Pin_IC := Pin_16;
                                          END;
                                      4 : BEGIN
                                               WRITELN('Step-4, Powered 14-pin IC,'+
                                                       ' please check pin-19 = +Vcc and pin-12 = Gnd.');
                                               Byte_Send_1 := 0;Byte_Send_2 := 0;Byte_Send_3 := $04;
                                               Set_Pin_IC := Pin_14;
                                          END;
                                      5 : BEGIN
                                               WRITELN('Step-5, Powered User-define pin IC,'+
                                                       ' please check pin-24 = +Vcc and pin-1 = Gnd.');
                                               Byte_Send_1 := 0;Byte_Send_2 := 0;Byte_Send_3 := $80;
                                               Set_Pin_IC := User_Pin;
                                          END;
                                 END;
                                 Tulis_Port_A(Byte_Send_1);
                                 Tulis_Port_C(Set_Dec_Port_C[Set_Latch_1] AND Tegangan_IC[Set_Pin_IC]);
                                 Tulis_Port_C(Set_Dec_Port_C[Steady_State] AND Tegangan_IC[Set_Pin_IC]);
                                 Tulis_Port_A(Byte_Send_2);
                                 Tulis_Port_C(Set_Dec_Port_C[Set_Latch_2] AND Tegangan_IC[Set_Pin_IC]);
                                 Tulis_Port_C(Set_Dec_Port_C[Steady_State] AND Tegangan_IC[Set_Pin_IC]);
                                 Tulis_Port_A(Byte_Send_3);
                                 Tulis_Port_C(Set_Dec_Port_C[Set_Latch_3] AND Tegangan_IC[Set_Pin_IC]);
                                 Tulis_Port_C(Set_Dec_Port_C[Steady_State] AND Tegangan_IC[Set_Pin_IC]);
                                 Press_A_Key;
                                 INC(Ulangi);
                           UNTIL (Ulangi = 6) OR (Tombol = #27);
                           IF Tombol <> #27 THEN
                           BEGIN
                                WRITELN('If the voltage is not like that,'+
                                        ' something wrong with the path,');
                                WRITELN('please check : port-C PPI and IC-14 and output relay connection.',#7);
                                Press_A_Key;
                           END;
                      END;
                '5' : BEGIN       { Hardware connection }
                           WRITELN('This routine perform the last connection between PC and IC-Tester card.');
                           Press_A_Key;
                           IF NOT (Ada_Port AND Ada_Card) THEN Cek_Card;
                           IF Ada_Port AND Ada_Card THEN
                           BEGIN
                                WRITELN('Success!!!');
                                WRITELN('IC-Tester card ready to be used!',#7);
                                WRITELN('IC-Tester card connected to LPT-',Hex2Str(ORD(LPT)),' port no : '+
                                         Hex2Str(HI(Port_DP))+Hex2Str(LO(Port_DP)),' Hex.');
                                Press_A_Key;
                           END;
                      END;
           END;
     UNTIL Pilih = #27;
END.
