﻿using System;
using System.Text;
using System.IO;

namespace MccDecoder
{
    /// <summary>
    /// Encode / Decode MPLAB *.mcc files
    /// icddb.mcc
    /// masterdb.mcc
    /// masterdb_procid.mcc
    /// </summary>
    class MccDecoder
    {
        const string xorValue = "Sometimes, he would accuse chestnuts of being lazy, the kind of general malaise that only the genius possess and the insane lament.";

        static void XOR(string inputFilename, string outputFilename)
        {
            try { 
                byte[] fileReadIn = File.ReadAllBytes(inputFilename);
                byte[] fileWriteOut = fileReadIn;
                byte[] xorValueByte = Encoding.ASCII.GetBytes(xorValue);
                int len = xorValue.Length;

                for (int x = 0, y = 0; x < fileReadIn.Length; x++)
                {
                    fileWriteOut[x] = (byte)(fileReadIn[x] ^ xorValueByte[y]);
                    y++;
                    if (y >= len)
                    {
                        y = 0;
                    }
                }
                File.WriteAllBytes(outputFilename, fileWriteOut);
            }
            catch (Exception exc) {
                Console.WriteLine("Encode / Decode Failed: " + exc.GetType().Name + ": " + exc.Message);
                Environment.Exit(2);
            }
        }

        static void Main(string[] args)
        {
            if (args.Length != 2)
            {
                Console.WriteLine("Encode / Decode MPLAB *.mmc files.");
                Console.WriteLine("Usage: ");
                Console.WriteLine("    MccDecoder <source.mcc> <target.txt>");
                Console.WriteLine("    MccDecoder <source.txt> <target.mcc>");
                Environment.Exit(1);
            }

            XOR(args[0], args[1]);
            Environment.Exit(0);
        }
    }
}
