'              Audio Generatore  Direct Digital Synthesis. (DDS)
'
'rev.0      22/04/07  preliminare
'rev.1      13/06/07  buzzer + check vbatt
'rev.2      23/08/07  flash led + rifiniture
'
'$map
'$sim
'
$regfile = "m48def.DAT"
$crystal = 10000000
$hwstack = 32
$swstack = 16
$framesize = 32
'
'
' Frequency = r24/r25/r26* (xtal freq/cycles in loop)/16777216  (2^24)
' Fincr = frequenza voluta / multiplier
'
Const Cycles         =  9             'DDS cycles loop
Const Multiplier     =  (_xtal/cycles)/2^24
'
Const ledOn          = 1
Const ledOff         = 0
'
'
Const Vref           = 1.1             'A/d internal reference
Const BitAD          = Vref/1024
Const Vlowbatt       = 7.7             'NiMH min. 1,1v * elemento * 7 elementi
Const Kdivider       = 2/(22+2)        'R2/(R1+R2) partitore tensione
Const Lo_batt        = int((Vlowbatt*Kdivider)/BitAD)
'
'
Config Lcd = 16 * 2
'
Config Lcdpin=Pin,E=PortC.1,Rs=PortC.2,Db4=PortB.5,Db5=PortB.4,Db6=PortB.3,Db7=PortB.2
'
Config Adc = Single , Prescaler = Auto , Reference = Internal
'
'
declare sub Scan_Button
declare sub Taston
declare sub Tastoff
declare sub Detasti
declare sub Mostra
declare sub Ril_Run
declare sub Ad_Conv
'
Dim Wave(256)  As Byte at &H100
Dim dummy1     As Word        'lasciare
Dim TmpW       As Word
Dim ADv        As Word
'
Dim Fincr      As Long        'incremento frequenza
Dim TmpL       As Long
'
Dim Singl      As Single      'calcolo frequenza voluta
'
Dim Fdig(5)    As Byte        'array aggiorna freq.
Dim Digit      As Byte
Dim Shape      As Byte        'forma d'onda
Dim Txx1       As Byte        'uso sbr
Dim Txx2       As Byte
Dim Tasti      As Byte        'deposito scansione tasti
Dim Index      As Byte
Dim T_Flash    As Byte        'timer lampeggio led
'
'
'
' PortD.7 (13)  ' out R2R  DAC   msb
' PortD.6 (12)  ' out
' PortD.5 (11)  ' out
' PortD.4 (6)   ' out
' PortD.3 (5)   ' out
' PortD.2 (4)   ' out
' PortD.1 (3)   ' out
' PortD.0 (2)   ' out R2R  DAC   lsb
'
' PortC.7 ( )   'N.A.
' PortC.6 (1)   'reset pin
' PortC.5 (28)  ' out buzzer
' PortC.4 (27)  ' out status led
' PortC.3 (26)  ' inp Run/Stop button
' PortC.2 (25)  ' out R/S display
' PortC.1 (24)  ' out En display
' PortC.0 (23)  ' Adc0 check Vbatt
'
' PortB.7 (10)  'xtal
' PortB.6 (9)   'xtal
' PortB.5 (19)  ' out Db4 display  & scan button
' PortB.4 (18)  ' out Db5 display  & scan button
' PortB.3 (17)  ' out Db6 display  & scan button
' PortB.2 (16)  ' out Db7 display  & scan button
' PortB.1 (15)  ' inp scan button  retutn line
' PortB.0 (14)  ' out   free
'
'
'
Led_F          Alias PortC.4  'status indicator
Buzz           Alias PortC.5
In_Butt        Alias PinB.1   'lettura ritorno scansione tasti
Run_St         Alias PinC.3   'lettura tasto run/stop
'
'
'
'Set data direction of PortB
      DDRB = &B00111101       '   1=out 0=inp
'set data direction of PortC
      DDRC = &B00110110       '   1=out 0=inp
'Set data direction PortD
      DDRD = &B11111111       '   R2R ladder on PORTD
'
      cls
      sound buzz,50,500
      lcd " Gen. Fun. v.2"
      sound buzz,20,5000
      waitms 1000
      Shape = 0                        'sine function
'   set  frequenza iniziale 1000Hz sine
      Fdig(1) = 0                      ' decine migliaia
      Fdig(2) = 1                      ' migliaia
      Fdig(3) = 0                      ' centinaia
      Fdig(4) = 0                      ' decine
      Fdig(5) = 0                      ' unita
'
Rientro:
      sound buzz,100,400
      cursor on blink                 'abilita cursore lcd segnaposto
      call Tastoff                     'tutti tasti rilasciati
      call Ril_Run                     'anche run stop
'
      Index = 1                         'posiz. cursore su decine migliaia
      do
         call Mostra                    'display stato attuale
         call TastOn                    'attende un tasto premuto
         if Run_St = 0 then exit do
'esamina tasti
         if Tasti = 8 then              'roll funzione forma onda
            incr shape
            if shape > 3 then shape = 0
         elseif Tasti = 1 then         'incremento digit
            Digit = Fdig(Index)        'recupera cifra posizione cursore
            incr Digit
            if Digit > 9 then
                sound buzz,80,1000
                Digit = 9               'tiene fisso
            endif
            Fdig(Index) = Digit
'
         elseif Tasti = 2 then        'decremento digit
            Digit = Fdig(Index)
            decr Digit
            if Digit > 128 then
                sound buzz,80,1000
                Digit = 0              ' negativo ?  tiene fisso
            endif
            Fdig(Index) = Digit       'aggiorna cifra
'
         elseif Tasti = 4 then        'scorre cursore su digit
            incr Index
            if Index > 5 then Index = 1
         endif
         call Tastoff                  'attende rilascio tasto
      loop
'
'converte l'array in numero intero
      Fincr = 0
      TmpW = 1
      Txx1 = 5                         'index inizia da unita
      do
         TmpL = Fdig(Txx1) * TmpW      'da * 1  a * 10000
         Fincr = Fincr + TmpL
         TmpW = TmpW * 10              'cambia moltiplicatore
         decr Txx1
      loop until Txx1 = 0
'
      Singl = Fincr / Multiplier       'calcola Fincr
      Fincr = Singl + 0.5              'cint
      call Ril_Run                     'attende rilascio Run_stop
      Led_F = ledOn                    'acceso fisso
      cursor off blink               'toglie cursore display
'
'      locate 1,6
'      lcd hex(fincr)                  'x test
'
      Shape = Shape and 3
      on Shape goto Go_si,Go_sq,Go_tr,Go_sw
'
Go_si:
      restore Sine_table
      rjmp Run_gen
'
Go_sq:
      restore Square_table
      rjmp Run_gen
'
Go_tr:
      restore Triangle_table
      rjmp Run_gen
'
Go_sw:
      restore Sawtooth_table
'
'
Run_gen:
      TmpW = 1
      do
         read Wave(TmpW)                'trasferisce in ram function table
         incr TmpW
      loop until TmpW > 256
      loadadr Wave(1),Z                'ldi  r31,$01    ldi  r30,$00
'
      ldi r29,$00                       'clear accumulator
      ldi r28,$00
      lds r24,{Fincr+0}                 'LSB passa incremento frequenza
      lds r25,{Fincr+1}                 'usa 24 dei 32 bit
      lds r26,{Fincr+2}                 'MSB
Gen:
      add r28, r24                     ' 1 cycle
      adc r29, r25                     ' 1 cycle
      adc r30, r26                     ' 1 cycle
      ld  r0, Z                        ' 2 cycle
!     Out PortD,R0                     ' 1 cycle
      sbic PinC,3                      ' 1         check tasto Run/stop
      rjmp Gen                         ' 2 cycles  totale 9 cicli
      PortD = 127                      ' lascia uscita ad 1/2 scala
      call Ril_Run                    'rilascio run/st
      goto Rientro
'
'End
'
'
'visualizza parametri attuali
Sub Mostra
      cls
      delay
      lcd "Func. "
      if Shape = 0 then
          lcd "Sznuszjel"             'kimen sznuszjel
      elseif Shape = 1 then
          lcd "Ngyszgjel"            'kimen ngyszgjel
      elseif Shape = 2 then
          lcd "Hromszgjel"           'kimen hromszgjel
      elseif Shape = 3 then
          lcd "Frszjel"              'kimen frszjel
      endif
      locate 2,1
      delay
      lcd "Freq. "
      Txx1 = 1                        'index inizia da decine migliaia
      do
            Txx2 = "0" + Fdig(Txx1)   'converte il digit in ascii
            lcd chr(Txx2)
            incr Txx1
      loop until Txx1 > 5            'per tutti i digit
      lcd " Hz"
      Txx1 = Index + 6              'riposiziona cursore su digit da modificare
      locate 2,Txx1                ' N.B. Index inizia da 1
      delay
End sub
'
'
'attende rilascio tasto Run_stop
Sub Ril_Run
      do
         sound buzz,20,3000
      loop until Run_St = 1           'rilascio tasto
End sub
'
'
'esegue scansione tasti ritorna in Txx1 il codice del primo tasto trovato
'N.B.  un  solo tasto per volta deve essere premuto
Sub Scan_Button
      Txx1 = 0                         'valore ritorno
      Txx2 = 32                        'valore iniziale PortC
      do
        shift Txx1,left,1             'fa spazio per nuovo dato
        PortB = Txx2                   'seleziona uscita
        waitms 2
        Txx1.0 = in_Butt               'lettura tasto
        shift Txx2,right,1
      loop until Txx2 = 2             'da PortB.5 a PortB.2
End sub
'
'
'ritorna quando rileva un tasto premuto ritorna subito se premuto Run/stop
Sub  TastOn
         do
           call Detasti
           if Run_St = 0 then exit sub
         loop until Tasti > 0
         sound buzz,80,300
End Sub
'
'
'ritorna quando il tasto e rilasciato
Sub  TastOff
         do
           call Detasti
           sound buzz,20,5000
         loop until Tasti = 0
End Sub
'
'
'esegue debounce tasti & flash led
Sub Detasti
         do
            call  Scan_Button                   'prima scansione
            Tasti = Txx1                        'conserva copia
            call AD_Conv
            waitms 10                           'tempo debounce & flash led
            if T_Flash > 80 then T_Flash = 0    'periodo flash
            if T_Flash > 1 then                 'pulse width 2 cycles
               Led_F = LedOff
            else                                'spegne sempre
               Led_F = LedON
            endif
            incr T_Flash
            call  Scan_Button              'seconda scansione
         loop  until Tasti = Txx1        'finche le due scansioni sono uguali
End sub
'
'
Sub AD_Conv
           start Adc
           waitms 1
           Adv = Getadc(0)
           stop Adc
           if Adv < Lo_batt then
               cls
               delay
               Led_F = ledOn
               lcd "Low battery"
               sound buzz,1000,300
               waitms 50
               sound buzz,100,8000
               led_F = ledOFF
               waitms 200
           endif
End sub
'
'
'
Sine_table:
'
   Data &H80 , &H83 , &H86 , &H89 , &H8C , &H8F , &H92 , &H95
   Data &H98 , &H9C , &H9F , &HA2 , &HA5 , &HA8 , &HAB , &HAE
   Data &HB0 , &HB3 , &HB6 , &HB9 , &HBC , &HBF , &HC1 , &HC4
   Data &HC7 , &HC9 , &HCC , &HCE , &HD1 , &HD3 , &HD5 , &HD8
   Data &HDA , &HDC , &HDE , &HE0 , &HE2 , &HE4 , &HE6 , &HE8
   Data &HEA , &HEC , &HED , &HEF , &HF0 , &HF2 , &HF3 , &HF5
   Data &HF6 , &HF7 , &HF8 , &HF9 , &HFA , &HFB , &HFC , &HFC
   Data &HFD , &HFE , &HFE , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFE , &HFE
   Data &HFD , &HFC , &HFC , &HFB , &HFA , &HF9 , &HF8 , &HF7
   Data &HF6 , &HF5 , &HF3 , &HF2 , &HF0 , &HEF , &HED , &HEC
   Data &HEA , &HE8 , &HE6 , &HE4 , &HE2 , &HE0 , &HDE , &HDC
   Data &HDA , &HD8 , &HD5 , &HD3 , &HD1 , &HCE , &HCC , &HC9
   Data &HC7 , &HC4 , &HC1 , &HBF , &HBC , &HB9 , &HB6 , &HB3
   Data &HB0 , &HAE , &HAB , &HA8 , &HA5 , &HA2 , &H9F , &H9C
   Data &H98 , &H95 , &H92 , &H8F , &H8C , &H89 , &H86 , &H83
   Data &H80 , &H7C , &H79 , &H76 , &H73 , &H70 , &H6D , &H6A
   Data &H67 , &H63 , &H60 , &H5D , &H5A , &H57 , &H54 , &H51
   Data &H4F , &H4C , &H49 , &H46 , &H43 , &H40 , &H3E , &H3B
   Data &H38 , &H36 , &H33 , &H31 , &H2E , &H2C , &H2A , &H27
   Data &H25 , &H23 , &H21 , &H1F , &H1D , &H1B , &H19 , &H17
   Data &H15 , &H13 , &H12 , &H10 , &H0F , &H0D , &H0C , &H0A
   Data &H09 , &H08 , &H07 , &H06 , &H05 , &H04 , &H03 , &H03
   Data &H02 , &H01 , &H01 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H01 , &H01
   Data &H02 , &H03 , &H03 , &H04 , &H05 , &H06 , &H07 , &H08
   Data &H09 , &H0A , &H0C , &H0D , &H0F , &H10 , &H12 , &H13
   Data &H15 , &H17 , &H19 , &H1B , &H1D , &H1F , &H21 , &H23
   Data &H25 , &H27 , &H2A , &H2C , &H2E , &H31 , &H33 , &H36
   Data &H38 , &H3B , &H3E , &H40 , &H43 , &H46 , &H49 , &H4C
   Data &H4F , &H51 , &H54 , &H57 , &H5A , &H5D , &H60 , &H63
   Data &H67 , &H6A , &H6D , &H70 , &H73 , &H76 , &H79 , &H7C
'
'
Square_table:
'
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &H00
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
   Data &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF , &HFF
'
'
Triangle_table:
'
   Data &H00 , &H02 , &H04 , &H06 , &H08 , &H0A , &H0C , &H0E
   Data &H10 , &H12 , &H14 , &H16 , &H18 , &H1A , &H1C , &H1E
   Data &H20 , &H22 , &H24 , &H26 , &H28 , &H2A , &H2C , &H2E
   Data &H30 , &H32 , &H34 , &H36 , &H38 , &H3A , &H3C , &H3E
   Data &H40 , &H42 , &H44 , &H46 , &H48 , &H4A , &H4C , &H4E
   Data &H50 , &H52 , &H54 , &H56 , &H58 , &H5A , &H5C , &H5E
   Data &H60 , &H62 , &H64 , &H66 , &H68 , &H6A , &H6C , &H6E
   Data &H70 , &H72 , &H74 , &H76 , &H78 , &H7A , &H7C , &H7E
   Data &H80 , &H82 , &H84 , &H86 , &H88 , &H8A , &H8C , &H8E
   Data &H90 , &H92 , &H94 , &H96 , &H98 , &H9A , &H9C , &H9E
   Data &HA0 , &HA2 , &HA4 , &HA6 , &HA8 , &HAA , &HAC , &HAE
   Data &HB0 , &HB2 , &HB4 , &HB6 , &HB8 , &HBA , &HBC , &HBE
   Data &HC0 , &HC2 , &HC4 , &HC6 , &HC8 , &HCA , &HCC , &HCE
   Data &HD0 , &HD2 , &HD4 , &HD6 , &HD8 , &HDA , &HDC , &HDE
   Data &HE0 , &HE2 , &HE4 , &HE6 , &HE8 , &HEA , &HEC , &HEE
   Data &HF0 , &HF2 , &HF4 , &HF6 , &HF8 , &HFA , &HFC , &HFE
   Data &HFF , &HFD , &HFB , &HF9 , &HF7 , &HF5 , &HF3 , &HF1
   Data &HEF , &HEF , &HEB , &HE9 , &HE7 , &HE5 , &HE3 , &HE1
   Data &HDF , &HDD , &HDB , &HD9 , &HD7 , &HD5 , &HD3 , &HD1
   Data &HCF , &HCF , &HCB , &HC9 , &HC7 , &HC5 , &HC3 , &HC1
   Data &HBF , &HBD , &HBB , &HB9 , &HB7 , &HB5 , &HB3 , &HB1
   Data &HAF , &HAF , &HAB , &HA9 , &HA7 , &HA5 , &HA3 , &HA1
   Data &H9F , &H9D , &H9B , &H99 , &H97 , &H95 , &H93 , &H91
   Data &H8F , &H8F , &H8B , &H89 , &H87 , &H85 , &H83 , &H81
   Data &H7F , &H7D , &H7B , &H79 , &H77 , &H75 , &H73 , &H71
   Data &H6F , &H6F , &H6B , &H69 , &H67 , &H65 , &H63 , &H61
   Data &H5F , &H5D , &H5B , &H59 , &H57 , &H55 , &H53 , &H51
   Data &H4F , &H4F , &H4B , &H49 , &H47 , &H45 , &H43 , &H41
   Data &H3F , &H3D , &H3B , &H39 , &H37 , &H35 , &H33 , &H31
   Data &H2F , &H2F , &H2B , &H29 , &H27 , &H25 , &H23 , &H21
   Data &H1F , &H1D , &H1B , &H19 , &H17 , &H15 , &H13 , &H11
   Data &H0F , &H0F , &H0B , &H09 , &H07 , &H05 , &H03 , &H01
'
'
Sawtooth_table:
'
Data &H00 , &H01 , &H02 , &H03 , &H04 , &H05 , &H06 , &H07
Data &H08 , &H09 , &H0A , &H0B , &H0C , &H0D , &H0E , &H0F
Data &H10 , &H11 , &H12 , &H13 , &H14 , &H15 , &H16 , &H17
Data &H18 , &H19 , &H1A , &H1B , &H1C , &H1D , &H1E , &H1F
Data &H20 , &H21 , &H22 , &H23 , &H24 , &H25 , &H26 , &H27
Data &H28 , &H29 , &H2A , &H2B , &H2C , &H2D , &H2E , &H2F
Data &H30 , &H31 , &H32 , &H33 , &H34 , &H35 , &H36 , &H37
Data &H38 , &H39 , &H3A , &H3B , &H3C , &H3D , &H3E , &H3F
Data &H40 , &H41 , &H42 , &H43 , &H44 , &H45 , &H46 , &H47
Data &H48 , &H49 , &H4A , &H4B , &H4C , &H4D , &H4E , &H4F
Data &H50 , &H51 , &H52 , &H53 , &H54 , &H55 , &H56 , &H57
Data &H58 , &H59 , &H5A , &H5B , &H5C , &H5D , &H5E , &H5F
Data &H60 , &H61 , &H62 , &H63 , &H64 , &H65 , &H66 , &H67
Data &H68 , &H69 , &H6A , &H6B , &H6C , &H6D , &H6E , &H6F
Data &H70 , &H71 , &H72 , &H73 , &H74 , &H75 , &H76 , &H77
Data &H78 , &H79 , &H7A , &H7B , &H7C , &H7D , &H7E , &H7F
Data &H80 , &H81 , &H82 , &H83 , &H84 , &H85 , &H86 , &H87
Data &H88 , &H89 , &H8A , &H8B , &H8C , &H8D , &H8E , &H8F
Data &H90 , &H91 , &H92 , &H93 , &H94 , &H95 , &H96 , &H97
Data &H98 , &H99 , &H9A , &H9B , &H9C , &H9D , &H9E , &H9F
Data &HA0 , &HA1 , &HA2 , &HA3 , &HA4 , &HA5 , &HA6 , &HA7
Data &HA8 , &HA9 , &HAA , &HAB , &HAC , &HAD , &HAE , &HAF
Data &HB0 , &HB1 , &HB2 , &HB3 , &HB4 , &HB5 , &HB6 , &HB7
Data &HB8 , &HB9 , &HBA , &HBB , &HBC , &HBD , &HBE , &HBF
Data &HC0 , &HC1 , &HC2 , &HC3 , &HC4 , &HC5 , &HC6 , &HC7
Data &HC8 , &HC9 , &HCA , &HCB , &HCC , &HCD , &HCE , &HCF
Data &HD0 , &HD1 , &HD2 , &HD3 , &HD4 , &HD5 , &HD6 , &HD7
Data &HD8 , &HD9 , &HDA , &HDB , &HDC , &HDD , &HDE , &HDF
Data &HE0 , &HE1 , &HE2 , &HE3 , &HE4 , &HE5 , &HE6 , &HE7
Data &HE8 , &HE9 , &HEA , &HEB , &HEC , &HED , &HEE , &HEF
Data &HF0 , &HF1 , &HF2 , &HF3 , &HF4 , &HF5 , &HF6 , &HF7
Data &HF8 , &HF9 , &HFA , &HFB , &HFC , &HFD , &HFE , &HFF
'
'
