/*********************************************************************
 *
 *                Microchip USB C18 Firmware Version 1.0
 *
 *********************************************************************
 * FileName:        main.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the CompanyE for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS ISECONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Rawin Rojvanit       11/19/04    Original.
 ********************************************************************/

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include "system\typedefs.h"                        // Required
#include "system\usb\usb.h"                         // Required
#include "io_cfg.h"                                 // Required
#include "delays.h"

#include "system\usb\usb_compile_time_validation.h" // Optional
#include "user\user.h"                        // Modifiable

/** V A R I A B L E S ********************************************************/
#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void USBTasks(void);


//tblzat az egytag kddal rendelkez gombokhoz
rom	unsigned char tabla1[]=
{	
	0x01, 0x42, 0x00, 0x3E, 0x3C, 0x3A, 0x3B, 0x45,		//00
	0x68, 0x43, 0x41, 0x3F, 0x3D, 0x2B, 0x35, 0x67,

	0x69, 0xE2, 0xE1, 0x88, 0xE0, 0x14, 0x1e, 0x00,		//10
	0x00, 0x00, 0x1D, 0x16, 0x04, 0x1A, 0x1F, 0x00,
	
	0x00, 0x06, 0x1B, 0x07, 0x08, 0x21, 0x20, 0x8C,		//20
	0x6C, 0x2C, 0x19, 0x09, 0x17, 0x15, 0x22, 0x00,

	0x6D, 0x11, 0x05, 0x0B, 0x0A, 0x1C, 0x23, 0x00,		//30
	0x6E, 0x00, 0x10, 0x0D, 0x18, 0x24, 0x25, 0x00,

	0x6F, 0x36, 0x0E, 0x0C, 0x12, 0x27, 0x26, 0x00,		//40
	0x70, 0x37, 0x38, 0x0F, 0x33, 0x13, 0x2D, 0x00,

	0x71, 0x87, 0x34, 0x00, 0x2F, 0x2E, 0x00, 0x72,		//50
	0x39, 0xE5, 0x28, 0x30, 0x00, 0x31, 0x00, 0x73,

	0x00, 0x64, 0x93, 0x92, 0x8A, 0x00, 0x2A, 0x8B,		//60
	0x00, 0x59, 0x89, 0x5C, 0x5F, 0x85, 0x00, 0x00,

	0x62, 0x63, 0x5A, 0x5D, 0x5E, 0x60, 0x29, 0x53,		//70
	0x44, 0x57, 0x5B, 0x56, 0x55, 0x61, 0x47, 0x00,

	0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,		//80
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

//tblzat a kttag scan kddal rendelkez gombokhoz
rom unsigned char tabla2[]=
{
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,		//00
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	
	0x21, 0xE6, 0xFF, 0xFF, 0xE4, 0xB6, 0x2A, 0xFF,		//10
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3,

	0x27, 0xEA, 0xFF, 0xE2, 0xFF, 0xFF, 0xFF, 0xE7,		//20
	0x26, 0xFF, 0xFF, 0x92, 0xFF, 0xFF, 0xFF, 0x65,

	0x25, 0xFF, 0xE9, 0xFF, 0xCD, 0xFF, 0xFF, 0x66,		//30
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,		//40
	0xFF, 0xFF, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,		//50
	0xFF, 0xFF, 0x58, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,		//60
	0xFF, 0x4D, 0xFF, 0x50, 0x4A, 0xFF, 0xFF, 0xFF,

	0x49, 0x4C, 0x51, 0xFF, 0x4F, 0x52, 0xFF, 0xFF,		//70
	0xFF, 0xFF, 0x4E, 0xFF, 0x46, 0x4B, 0x48, 0xFF,
};

rom unsigned char	hatvanytabla[]={1,2,4,8,16,32,64,128};

unsigned char	j, k;
char			usbKi[]={0,0,0,0,0,0,0,0};
unsigned char	kodtabla[32];
unsigned char	usbkod, modifierkey=0, usbszaml=2;


unsigned char i=0;		// szmolja a berkezett biteket
unsigned char parity;	// ideiglenes trol, a parits ellenrzshez kell.
						// Ha nem akarsz paritsellenrzst, akkor ez kompletten kihagyhat a kdbl
unsigned char kodtmp=0;	// ide gyjtjk be a bejv biteket
unsigned char kod=0	;	// ide kerl t a fogads vgn a berkezett kd


unsigned char	ps2be[]={0,0,0,0,0,0,0,0};// ide kerlnek az egyms utn berkezett kdok, hogy feldolgozhatk legyenek
unsigned char	ksz=0;					// szmolja, hogy hny kd rkezett be
unsigned char	sFlag=0;				// egy meg csak egy jelzs, hogy kompletten berkezett egy karakter


void main(void)
{

	InitializeSystem();
	for (i=0;i<32;i++)
		kodtabla[i]=0;

	for(;;)
	{
		USBTasks();				// USB Tasks

		ProcessIO(usbKi);		// See user\user.c & .h

//		kodtabla[
	
		if (PIR2bits.TMR3IF)
		{
			LATCbits.LATC0^=1;			// Ez csak egy ledet villogtat, hogy lssam, fut a program
			PIR2bits.TMR3IF=0;
		}


		if (INTCONbits.INT0IF)			// Ha lefut l volt az rajelvonalon,
		{								// akkor billen be az INT0IF flag
			if ((!i) && (!PORTBbits.RB1))	// ha mg nem volt bejv adat, s ha az adatlb nulla
			{							// akkor a start bit jtt be
				i++;					// nveljk a bitszmll rtkt
				parity=0;				// s nullzzuk a segdregisztereket
				kodtmp=0;
			}
			else	if ((i) && (i<=8))	// ha mr tl vagyunk a start biten, de mg nem rtnk el a paritsbitig
			{
				i++;					// nveljk a bitszmll rtkt
				kodtmp>>=1;				// egyel jobbra toljuk a segdvltoz tartalmt
										// mert elszr az als bit jn az adatvonalon
				if (PORTBbits.RB1)		// ha az adatvonalon 1 jtt
				{	
					kodtmp|=0x80;		// akkor a fels bitet 1-re lltjuk
					parity^=1;			// s a paritst szmol segdregiszter als bitjt ellenttesre fordtjuk
				}
			}
			else	if (i==0x09)		// ha mr elrtnk a paritsbithez
			{
				i++;					// nveljk a bitszmll rtkt
				if (PORTBbits.RB1)		// ha a paritsbit 1, akkor szintn ellenttesre fordtjuk a paritst szmol
					parity^=1;			// regiszter als bitjt
			}
			else if ((i==0x0A) && (PORTBbits.RB1) && (parity))	// ha elrtnk a stop bithez, az adatvonal magas
			{												// s a paritst jelz regiszter als bitje egyes
				parity=i=0;				// nullzzuk a segdvltozkat, hogy a kvetkez karakter fogadsra felkszljnk
				kod=kodtmp;				// a segdregiszterbl tkerl a berkezett kd a kod nev vltozba
				if (kod==0x22)
					LATCbits.LATC2^=1;
			}
		
			INTCONbits.INT0IF=0;		// trljk a megszaktst jelz flaget
			TMR0H=0;					// trljk a Timer0 regisztereit
			TMR0L=0;
			INTCONbits.TMR0IF=0;		// s ha kzben megjelent, akkor trljk a Timer0 megszaktst
		}

		if (INTCONbits.TMR0IF)			// ez azrt kell, hogyha hiba trtnt a fogads sorn,
		{
			ksz=i=parity=0;				// akkor bizonyos id utn nullzzuk az sszes segdregisztert
			INTCONbits.TMR0IF=0;
		}

		if (kod)							// ha nulltl klmbz kd jtt
		{
			ps2be[ksz++]=kod;			// nveljk egyel a berkezett kdok szmlljt, s eltroljuk az j kdt a tmbben
			if (ps2be[0]==0xE0)			// ha a tmb nulladik eleme 0xE0 kt vagy hromtag scan kd vtele van folyamatban
										// teht megnzzk a tmb tovbbi elemeit
			{
				if (ps2be[1]!=0x7E)		// ha a msodik kd nem 0x7E, akkor nzzk a tbbit
				{
					if ((ps2be[1]!=0xF0) && (ksz==2))	// ha a tmb els eleme nem 0xF0, akkor kttag scan kdnak kell rkeznie. Ha a megjbb a msodik is,
					{
						sFlag=1;					// akkor megrkezett az egsz scan kd ==> sFlag rtkt 1-re billentjk
					}
					if ((ps2be[1]==0xF0) && (ksz==3))	// ha a tb els eleme 0xF0, akkor hromtag scan kdnak kell rkezni. Ha megjbb a harmadik is,
					{
						sFlag=1;					// akkor megrkezett egy egsz scan kd ==> sFlag rtket 1-re billentjk
					}
				}
				else						//ha a msodik kd 0x7E, akkor mg vrunk, hogy a Break teljes scan kdja berkezzen
				{
					if (ps2be[4]==0x7E)
						sFlag=1;
				}
												// ha egyik fenti felttel sem teljesl, akkor mg nem rkezett meg az egsz scan kd
												// teht nem csinlunk semmit
			}
			else	 if (ps2be[0]==0xF0)		// ha a tmb nulladik eleme 0xF0
			{
				if (ksz==2)				// akkor mg vrunk egy msodik kdra. Ha az megjtt, 
					sFlag=1;			// akkor sFlag rtkt 1-re billentjk 
			}
			else if (ps2be[0]==0xE1)		// ha a tmb nulladik eleme 0xE1, akkor vagy Break vagy Pause kd vtele van folyamatban
			{
//				if ((ps2be[4]==0x7E) && (ksz==5))	// ha a tmb negyedik eleme 0x7E s a berkezett kdok szma 5, akkor a Break gombot nyomtk le
//					sFlag=1;					// teht bejtt egy egsz scan kd ==> sFlag rtkt 1-re billentjk
				if ((ps2be[5]==0x14) && (ksz==8))	// ha a tmb tdik eleme 0x14 s a berkezett kdk szma 8, akkor a Pause gombot nyomtk le
					sFlag=1;					// teht bejtt egy egsz scan kd ==>sFlag rtkt 1-re billentjk
			}
			else							// ha a nulladik bit nem 0xE0, 0xF0 vagy 0xE1
				sFlag=1;				// akkor egytag scan kd rkezett ==> sFlag rtkt 1-re billentjk

			kod=0;						// kod vltozt minden esetben nullzzuk
		}

// a tovbbiakban a ps2be vltoz tartalmazza a bejtt scan kdot, az alapjn kell kirtkelni a bejtt adatot
// valahogy gy, de ezt most nem kommentezem, mert ezt mindenkinek a sajt programjhoz kell igaztania

		if (sFlag)
		{
			ksz=0;
			switch (ps2be[0])
			{
				case 0xF0:
				{
					usbkod=tabla1[ps2be[1]];
					kodtabla[usbkod>>3]&=~hatvanytabla[usbkod&0x07];
					break;
				}
				case 0xE0:
				{
					switch (ps2be[1])
					{
						case 0xF0:
							usbkod=tabla2[ps2be[2]];
							kodtabla[usbkod>>3]&=~hatvanytabla[usbkod&0x07];
							break;
						case 0x7E:
							usbkod=0x48;
							kodtabla[9]|=0x01;
							break;
						default:
							usbkod=tabla2[ps2be[1]];
							kodtabla[usbkod>>3]|=hatvanytabla[usbkod&0x07];
							break;
					}
					break;
				}
				case 0xFA:
				{
					break;
				}
				case 0xAA:
				{
					break;
				}
				case 0xEE:
				{
					break;
				}
				case 0xFE:
				{
					break;
				}
				case 0x00:
				{
					break;
				}
				case 0xFF:
				{
					break;
				}
				case 0xE1:
				{
					usbkod=0x48;
					kodtabla[0x09]|=0x01;
					break;
				}					
				default:
				{
					usbkod=tabla1[ps2be[0]];
					kodtabla[usbkod>>3]|=hatvanytabla[usbkod&0x07];
					break;
				}
			}

			for (j=0;j<7;j++)
				usbKi[j]=0;

			for (j=0;j<0x1B;j++)
			{
				for (k=0;k<8;k++)
				{
					if (kodtabla[j]&hatvanytabla[k])
					{
						usbKi[usbszaml++]=(j<<3)+k;
					}
				}
			}
			usbszaml=2;
			usbKi[0]=0;
			for (k=0;k<8;k++)
				if ((kodtabla[0x1C]) & (hatvanytabla[k]))
					usbKi[0]|=hatvanytabla[k];
			usbKi[1]=0xF0;
			sFlag=0;
		}


	}//end while
}//end main

/******************************************************************************
 * Function:        static void InitializeSystem(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        InitializeSystem is a centralize initialization routine.
 *                  All required USB initialization routines are called from
 *                  here.
 *
 *                  User application initialization routine should also be
 *                  called from here.                  
 *
 * Note:            None
 *****************************************************************************/
static void InitializeSystem(void)
{
	T0CON=0b10001101;

	T3CON=0b00110001;
	TRISC&=0b00000000;
	LATB=0x00;
	LATC=0;
	ADCON1=0x0F;
	TRISB=0x03;					//RB1 s RB0 bemenet
	INTCON2bits.INTEDG0=0;		//A lefut lre billenjen be a INT0IF flag bit

   
    #if defined(USE_USB_BUS_SENSE_IO)
    tris_usb_bus_sense = INPUT_PIN; // See io_cfg.h
    #endif
    
    #if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
    #endif
    
    mInitializeUSBDriver();         // See usbdrv.h
    
    UserInit();                     // See user.c & .h

}//end InitializeSystem

/******************************************************************************
 * Function:        void USBTasks(void)
 *
 * PreCondition:    InitializeSystem has been called.
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Service loop for USB tasks.
 *
 * Note:            None
 *****************************************************************************/
void USBTasks(void)
{
    /*
     * Servicing Hardware
     */
    USBCheckBusStatus();                    // Must use polling method
    if(UCFGbits.UTEYE!=1)
        USBDriverService();                 // Interrupt or polling method

}// end USBTasks

//configulationǉ܂***********************************************
//#pragma config PLLDIV = 5
#pragma config PLLDIV = 1
#pragma config CPUDIV = OSC1_PLL2
#pragma config USBDIV = 2 

//#pragma config FOSC =HSPLL_HS
#pragma config FOSC =XTPLL_XT
#pragma config FCMEN = OFF 
#pragma config IESO = OFF 

#pragma config PWRT = ON 
#pragma config BOR = ON 
#pragma config BORV = 2 
#pragma config VREGEN = ON 

#pragma config WDT = OFF 
#pragma config WDTPS = 8 

#pragma config MCLRE = ON 
#pragma config LPT1OSC = OFF 
#pragma config PBADEN = OFF 
#pragma config CCP2MX = OFF

#pragma config STVREN = OFF 
#pragma config LVP = OFF 
#pragma config XINST = OFF 
#pragma config DEBUG = ON 

#pragma config CP0 = OFF 
#pragma config CPB = OFF 
#pragma config WRT0 = OFF 
#pragma config WRTB = OFF 
#pragma config EBTR0 = OFF 
#pragma config EBTRB = OFF
/** EOF main.c ***************************************************************/
