/*********************************************************************
 *
 *                Microchip USB C18 Firmware - Mouse Demo
 *
 *********************************************************************
 * FileName:        user_mouse.c
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        C18 2.30.01+
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "CompanyE for its PICmicro(r) Microcontroller is intended and
 * supplied to you, the Company's customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS ISECONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Rawin Rojvanit       11/19/04    Original.
 ********************************************************************/

/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include <usart.h>
#include "system\typedefs.h"

#include "system\usb\usb.h"

#include "io_cfg.h"             // I/O pin mapping
#include "user\user.h"
#include "delays.h"				//yts
#include "string.h"				//yts

/** V A R I A B L E S ********************************************************/
#pragma udata


char buffer[8];
int point,flag;
rom	char pass1[]={'1','2','3','4','5','A','B','C','D','E','F',0};

//** P R I V A T E  P R O T O T Y P E S ***************************************/
void ClearBuffer(void);
void Convert(char);


/** D E C L A R A T I O N S **************************************************/
#pragma code
void UserInit(void)
{
//?}?E?X?E?O?*?e?a?I?3/4?P?d?c???U???1/2B
	TRISAbits.TRISA2 = 1;//RA2 is input for a trigger


	point=0;
	flag=0;
}//end UserInit

/******************************************************************************
 * Function:        void ProcessIO(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function is a place holder for other user routines.
 *                  It is a mixture of both USB and non-USB tasks.
 *
 * Note:            None
 *****************************************************************************/
void ProcessIO(char *usbmutato)
{   

	// User Application USB tasks

/*
	set characters (USB HID codes) in buffers (from buffer[2] to buffer[7])

	set following modiferkey in bufer[0]
	ModiferKeyTable
		0x01 ; L CTRL
		0x02 ; L SHFT
		0x04 ; L ALT
		0x08 ; L GUI
		0x10 ; R CTRL
		0x20 ; R SHFT
		0x40 ; R ALT
		0x80 ; R GUI
*/

 
}//end ProcessIO