/*
 * File:   main.c
 * Author: alexandros
 *
 * Created on 2025. janur 16., 6:56
 */

// Konfigurcis bitek (lltsd be a hardverednek megfelel?en)
#pragma config FOSC = HS // High-Speed Oscillator
#pragma config WDT = OFF // Watchdog Timer off
#pragma config LVP = OFF // Low Voltage Programming off

#include <xc.h>

#define _XTAL_FREQ 8000000  // lltsd be a rendszerrajelet (pl. 8 MHz)

void I2C_Init(const unsigned long c)
{
    TRISB0 = 1;     /* Set SCL (RB0) as input */
    TRISB1 = 1;     /* Set SDA (RB1) as input */
    SSPSTAT = 0x80; /* Slew rate disabled, other bits are cleared */
    SSPCON1 = 0x28; /* Enable SSP port for I2C Master mode */
    SSPCON2 = 0x00; /* Reset SSPCON2 */
    SSPADD = (_XTAL_FREQ / (4 * c)) - 1; /* Set clock speed */
    SSPIE = 1;      /* Enable SSP interrupt */
    SSPIF = 0;      /* Clear SSP interrupt flag */
}

void I2C_Ready()
{
    while (BCLIF); /* Wait if bit collision interrupt flag is set */
    while (SSPSTATbits.BF || (SSPSTATbits.R_nW)); /* Wait for buffer to be free */
    SSPIF = 0;     /* Clear SSP interrupt flag */
}

char I2C_Write(unsigned char data)
{
    SSPBUF = data; /* Load data to SSPBUF */
    I2C_Ready();
    if (ACKSTAT) /* Check acknowledgment */
        return 1;
    else
        return 2;
}

char I2C_Start(char slave_write_address)
{
    SSPCON2bits.SEN = 1; /* Send start condition */
    while (SSPCON2bits.SEN); /* Wait for completion of start condition */
    SSPIF = 0;
    if (!SSPSTATbits.S) /* Check if start condition was detected */
        return 0;       /* Start failed */
    return I2C_Write(slave_write_address); /* Write slave address */
}

char I2C_Stop()
{
    I2C_Ready();
    SSPCON2bits.PEN = 1; /* Send stop condition */
    while (SSPCON2bits.PEN); /* Wait for stop condition to finish */
    SSPIF = 0;
    if (!SSPSTATbits.P) /* Check if stop condition detected */
        return 0;       /* Stop failed */
    return 1;
}

void Master_Example_Send_Char()
{
    I2C_Init(100000); /* Initialize I2C master at 100 kHz */

    char status = I2C_Start(0x01 << 1); /* Start communication with slave address 0x01 (write mode) */
    if (status == 0)
    {
        I2C_Write('a'); /* Send the character 'a' to the slave */
        I2C_Stop();     /* End communication */
    }
    else
    {
        // Handle error (e.g., no acknowledgment from slave)
    }
}

void main(void) {
    while(1){
        Master_Example_Send_Char();
    }
    
    return;
}
