/*
 * File:   main.c
 * Author: alexandros
 *
 * Created on 2025. janur 16., 7:04
 */

// Konfigurcis bitek (lltsd be a hardverednek megfelel?en)
#pragma config FOSC = HS // High-Speed Oscillator
#pragma config WDT = OFF // Watchdog Timer off
#pragma config LVP = OFF // Low Voltage Programming off

#include <xc.h>

#define _XTAL_FREQ 8000000  // lltsd be a rendszerrajelet (pl. 8 MHz)

void I2C_Init_Slave(unsigned char slave_address)
{
    TRISC0 = 0;
    PORTC = 0x00;
    TRISB0 = 1;     /* Set SCL (RB0) as input */
    TRISB1 = 1;     /* Set SDA (RB1) as input */
    SSPSTAT = 0x80; /* Slew rate disabled, other bits cleared */
    SSPCON1 = 0x36; /* Enable SSP port for I2C Slave mode with 7-bit address */
    SSPCON2 = 0x00; /* General call disable */
    SSPADD = slave_address; /* Set the slave address */
    SSPIE = 1;      /* Enable SSP interrupt */
    SSPIF = 0;      /* Clear SSP interrupt flag */
    PEIE = 1;       /* Enable peripheral interrupt */
    GIE = 1;        /* Enable global interrupt */
}

void I2C_Slave_Ready()
{
    while (!SSPIF); /* Wait for an I2C event */
    SSPIF = 0;      /* Clear interrupt flag */
}

char I2C_Slave_Read()
{
    while (!SSPSTATbits.BF); /* Wait until buffer is full */
    return SSPBUF;           /* Read received data */
}

void I2C_Slave_Write(char data)
{
    SSPBUF = data;   /* Write data to buffer */
    while (SSPSTATbits.BF); /* Wait until buffer is empty */
}

void Slave_Example_Receive_Char()
{
    I2C_Init_Slave(0x01); /* Initialize I2C slave with address 0x01 */

    while (1)
    {
        I2C_Slave_Ready(); /* Wait for master communication */

        if (!SSPSTATbits.R_nW) /* Check if master writes to slave */
        {
            char received_data = I2C_Slave_Read(); /* Read data from master */
            if (received_data == 'a') /* Check if the received character is 'a' */
            {
                PORTCbits.RC0 = 1;
            }
        }
    }
}


void main(void) {
    while(1){
        Slave_Example_Receive_Char();
    }
    return;
}
