/*   MOSÓGÉP VEZÉRLŐ TESZTELŐ. 1.MODUL
    SZOTÁK ZOLTÁN 2025.12.09.

    VÍZSZELEPEK, LÚGSZIVATTYÚ:                          
   |--------------|---------|-----------------------------|      ---- KÖZÖS O PONT !                                                
   |        VPW3  |         |   VW3                 DP2   |
   | ~~~|~~~   ---|---   ---|---   ~~~|~~~   ~~~|~~~   ---|---   ~~~~ TRIAK KIMENET
   |    |         |         |         |         |         |
   |  DP2.2     DP2.1     VPW3.1    VPW3.3    VW3.1     VW3.3

    PRESSOSTÁT (PR):                                
    - ALAPHELYZET:      11 - 12 ZÁRT              
    - NORMÁL VÍZSZINT:  11 - 14 ZÁRT              
    - MAGAS VÍZSZINT:   11 - 16 ZÁRT - NEM KELL   

    - KÖZÖS ÉRINTKEZŐ - 11 - PRS2.1
    - 12 - PR2.1
    - 14 - PRS2.2
    - 16 - PR2.2 
 
   - AMENNYIBEN A PROGRAM A LÚGSZIVATTYUT-(DP) INDITJA, A PRESSOSÁT-(PR) AKÁR NYITOTT,AKÁR ZÁRT
     ÁLLAPOTBAN VAN  AZ "MCU" KÉSLELTETETT KIMENETTEL INDUL MAJD A BEÁLLITOTT IDŐ UTÁN
     ÁTVÁLTJA A PRESSOSTÁTOT (PR) ÜRES VIZSZINT ÁLLÁSBA.
  
   - PROGRAM INDULÁSKOR (DP) KB: 10.sec MŰKÖDIK.
   - ŰRES VIZSZINTNÉL (DP) KB: 60.sec MŰKÖDIK.
   - TELJES VIZSZINT (DP) KB: 90.sec - MŰKÖDIK.   
   - 4 PERC UTÁN NEM VÁLT A PRESSOSTÁT (PR), A VEZÉRLŐ HIBAJELZÉST KÜLD,
     "SZŰRŐ TISZTA" HIBAJELZŐ LED BEKAPCSOL, VAGY F03 HIBAKÓD!
 
   - AMENNYIBEN A PROGRAM AZ ELŐ,VAGY FŐ MOSÓ VIZSZELEPEKET-(VW) VAGY (VPW) INDITJA,
     PRESSOSTÁT (PR) ÜRES ÁLLÁSBA VAN AZ "MCU" KÉSLELTETETT KIMENETTEL INDUL, MAJD
     A BEÁLLITOTT IDŐ UTÁN  ÁTVÁLTJA A 
     PRESSOSTÁTOT (PR) TELE VIZSZINT ÁLLÁSBA.
   - VIZFELTÖLTÉS KB:100. -150. sec.
   - 6 PERC UTÁN NEM VÁLT A PRESSOSTÁT (PR), A VEZÉRLŐ HIBAJELZÉST KÜLD,
   "VIZCSAP" HIBAJELZŐ LED VILÁGIT!
  
   -PROGRAM TÖRLÉS:
     VIZLEERESZTÉS ÁLLÁSBAN, (F-NULLÁZÁS) GOMB MEGNYOMÁSA 3.sec.
  
   -TESZTPROGRAM:
     VIZLEERESZTÉS ÁLLÁSBAN, (E-START-STOP) GOMB MEGNYOMÁSA 5.sec. ALATT  4-SZER.

   BEÁLLITÁS:
   - FŐ MOSÓ VIZSZELEP KÉSLELTETÉS:        VWofTimeMs = 70.SOR
   - ELŐMOSÓ VIZSZELEP KÉSLELTETÉS:        VPWofTimeMs = 72.SOR
   - SZIVATTYU KÉSLELTETÉS:                DPofTimeMs = 75.SOR
   - VISSZAPATTANÁSI IDŐ:                  VWdebounceinterval = 90.SOR
                                           VPWdebounceinterval = 93.SOR
                                           DPdebounceinterval = 96.SOR
   - BEKAPCSOLT IMPULZUS IDŐ:              delay = 130.SOR    
   -                                       delay = 159.SOR
   -                                       delay = 189.SOR

 */  

#define VW_STATE_WAITING 0   // FŐ MOSÓ VIZSZELEP BEMENETRE VÁR.
#define VW_STATE_PRESSED 1   // VAN FŐ MOSÓ VIZSZELEP BEMENET.
#define VW_STATE_WAITREL 2   // VÁR A FŐ MOSÓ VIZSZELEP BEMENET MEGSZÜNÉSÉRE.
#define VPW_STATE_WAITING 0  // ELŐ MOSÓ VIZSZELEP BEMENETRE VÁR.
#define VPW_STATE_PRESSED 1  // VAN ELŐMOSÓ VIZSZELEP BEMENET.
#define VPW_STATE_WAITREL 2  // VÁR AZ ELŐMOSÓ VIZSZELEP BEMENET MEGSZÜNÉSÉRE.
#define DP_STATE_WAITING 0   // SZIVATTYÚ BEMENETRE VÁR.
#define DP_STATE_PRESSED 1   // VAN SZIVATTYÚ BEMENET.
#define DP_STATE_WAITREL 2   // VÁR A SZIVATTYÚ BEMENET MEGSZÜNÉSÉRE.

const int VW_VPW_kimenetPin = 8;            // FŐ ÉS ELŐMOSÓ VIZSZELEP KIMENET.
const int VW_bemenetPin = 10;               // FŐMOSÓ VIZSZELEP BEMENET.
const unsigned long VWofTimeMs = 60000UL;   // FŐMOSÓ VIZSZELEP KIKAPCSOLT KIMENETTEL INDUL.
const int VPW_bemenetPin = 11;              // ELŐMOSÓ VIZSZELEP BEMENET.
const unsigned long VPWofTimeMs = 60000UL;  // ELŐMOSÓ VIZSZELEP KIKAPCSOLT KIMENETTEL INDUL.
const int DP_kimenetPin = 4;                // SZIVATTYÚ KIMENET.
const int DP_bemenetPin = 12;               // SZIVATTYU BEMENET.
const unsigned long DPofTimeMs = 60000UL;   // SZIVATTYÚ KIKAPCSOLT KIMENETTEL INDUL.

int VW_bemenetState;
int VW_bemenetStateold = 0;
int VWreading;
int VPW_bemenetState;
int VPW_bemenetStateold = 0;
int VPWreading;
int VW_VPW_kimenetState = 0;
int DP_bemenetState;
int DP_bemenetStateold = 0;
int DP_kimenetState = 0;
int DPreading;

unsigned long VWprevtrig;
const unsigned long VWdebounceinterval = 1000UL;  //FŐMOSÓ VIZSZELEP VISSZAPATTANÁS IDŐ.
unsigned long VWpressTime;
unsigned long VPWprevtrig;
const unsigned long VPWdebounceinterval = 1000UL;  //ELŐMOSÓ VIZSZELEP VISSZAPATTANÁS IDŐ.
unsigned long VPWpressTime;
unsigned long DPprevtrig;
const unsigned long DPdebounceinterval = 1000UL;  //SZIVATTYÚ VISSZAPATTANÁS IDŐ.
unsigned long DPpressTime;

void setup() {
  pinMode(VW_VPW_kimenetPin, OUTPUT);
  pinMode(DP_kimenetPin, OUTPUT);
  pinMode(VW_bemenetPin, INPUT);
  pinMode(VPW_bemenetPin, INPUT);
  pinMode(DP_bemenetPin, INPUT);
  DP_bemenetState = DP_STATE_WAITING;
  VW_bemenetState = VW_STATE_WAITING;
  VPW_bemenetState = VPW_STATE_WAITING;
}

void loop() {
  DPreading = digitalRead(DP_bemenetPin);
  if (DPreading != DP_bemenetStateold) {
    DPprevtrig = millis();
  }
  if (millis() - DPprevtrig > DPdebounceinterval) {
    DP_bemenetState = DPreading;
  }
  switch (DP_bemenetState) {
    case DP_STATE_WAITING:                     // VÁRAKOZÁS SZIVATTYÚ BEMENETRE.
      if (digitalRead(DP_bemenetPin) == HIGH)  // HA A SZIVATTYU BEMENET MEGÉRKEZIK ,
      {
        digitalWrite(DP_kimenetPin, LOW);     // A SZIVATTYÚ KIMENET A BEÁLLÍTOTT
        DPpressTime = millis();               // KÉSLELTETÉSSEL ELINDUL.
        DP_bemenetState = DP_STATE_PRESSED;
      }
      break;
    case DP_STATE_PRESSED:                         // FOLYAMATOS SZIVATTYÚ BEMENET.
      if ((millis() - DPpressTime) > DPofTimeMs) {
        digitalWrite(DP_kimenetPin, HIGH);         // KÉSLELTETÉS UTÁN,
        delay(1000);                               // A KIMENET BEKAPCSOL
        digitalWrite(DP_kimenetPin, LOW);          // MAJD A BEÁLLÍTOTT IDŐ,
        DP_bemenetState = DP_STATE_WAITREL;        // ELTELTÉVEL KIKAPCSOL.
      }
      break;
    case DP_STATE_WAITREL:                         // VÁRAKOZIK A SZIVATTYÚ BEMENET
      if (digitalRead(DP_bemenetPin) == LOW)       // MEGSZÜNÉSÉRE.
        DP_bemenetState = DP_STATE_WAITING;        // HA ÚJRA VAN BEMENET,
      break;                                       // A FOLYAMAT MEGISMÉTLŐDIK.
  }
  VWreading = digitalRead(VW_bemenetPin);
  if (VWreading != VW_bemenetStateold) {
    VWprevtrig = millis();
  }
  if (millis() - VWprevtrig > VWdebounceinterval) {
    VW_bemenetState = VWreading;
  }
  switch (VW_bemenetState) {
    case VW_STATE_WAITING:                     // VÁRAKOZÁS A FŐMOSÓ VIZSZELEP BEMENETRE.
      if (digitalRead(VW_bemenetPin) == HIGH)  // HA A FŐMOSÓ VIZSZELEP BEMENET MEGÉRKEZIK ,
      {
        digitalWrite(VW_VPW_kimenetPin, LOW);  // FŐ ÉS ELŐMOSÓ VIZSZELEP KIMENET,
        VWpressTime = millis();                // BEÁLLÍTOTT KÉSLELTETÉSSEL ELINDUL.
        VW_bemenetState = VW_STATE_PRESSED;
      }
      break;
    case VW_STATE_PRESSED:                          // FOLYAMATOS FŐMOSÓ VIZSZELEP BEMENET.
      if ((millis() - VWpressTime) > VWofTimeMs) {
        digitalWrite(VW_VPW_kimenetPin, HIGH);      // KÉSLELTETÉS UTÁN,
        delay(1000);                                // A KIMENET BEKAPCSOL,
        digitalWrite(VW_VPW_kimenetPin, LOW);       // MAJD A BEÁLLÍTOTT IDŐ 
        VW_bemenetState = VW_STATE_WAITREL;         // ELTELTÉVEL KIKAPCSOL.
      }
      break;
    case VW_STATE_WAITREL:                         // VÁRAKOZIK A FŐMOSÓ VIZSZELEP 
      if (digitalRead(VW_bemenetPin) == LOW)       // BEMENET MEGSZÜNÉSÉRE.
        VW_bemenetState = VW_STATE_WAITING;        // HA ÚJRA VAN BEMENET,
      break;                                       // A FOLYAMAT MEGISMÉTLŐDIK.
  }
  VPWreading = digitalRead(VPW_bemenetPin);
  if (VPWreading != VPW_bemenetStateold) {
    VPWprevtrig = millis();
  }
  if (millis() - VPWprevtrig > VPWdebounceinterval) {
    VPW_bemenetState = VPWreading;
  }

  switch (VPW_bemenetState) {
    case VPW_STATE_WAITING:                     // VÁRAKOZÁS AZ ELŐMOSÓ VIZSZELEP BEMENETRE
      if (digitalRead(VPW_bemenetPin) == HIGH)  // HA AZ ELŐMOSÓ VIZSZELEP BEMENET MEGÉRKEZIK ,
      {
        digitalWrite(VW_VPW_kimenetPin, LOW);  // A FŐ ÉS ELŐMOSÓ VIZSZELEP KIMENET ,
        VPWpressTime = millis();               // BEÁLLITOTT KÉSLELTETÉSSEL ELINDUL.
        VPW_bemenetState = VPW_STATE_PRESSED;
      }
      break;
    case VPW_STATE_PRESSED:                           // FOLYAMATOS ELŐMOSÓ VIZSZELEP BEMENET.
      if ((millis() - VPWpressTime) > VPWofTimeMs) {
        digitalWrite(VW_VPW_kimenetPin, HIGH);        // KÉSLELTETÉS UTÁN
        delay(1000);                                  // A KIMENET BEKAPCSOL,
        digitalWrite(VW_VPW_kimenetPin, LOW);         // MAJD A BEÁLLÍTOTT IDŐ
        VPW_bemenetState = VPW_STATE_WAITREL;         // ELTELTÉVEL KIKAPCSOL.
      }
      break;
    case VPW_STATE_WAITREL:                    // VÁRAKOZIK A FŐMOSÓ VIZSZELEP
      if (digitalRead(VPW_bemenetPin) == LOW)  // BEMENET MEGSZÜNÉSÉRE.
        VPW_bemenetState = VPW_STATE_WAITING;  // HA ÚJRA VAN BEMENET,
      break;                                   // A FOLYAMAT MEGISMÉTLŐDIK.
  }
}
