/* MOSÓGÉP VEZÉRLŐ TESZTELŐ. 3. MODUL
  - SZOTÁK ZOLTÁN 2025.12.19.
* MOTOR:
   - AZ ELEKTRONIKA ÉRZÉKELI ÉS KIJELZI A MOTOR FORDULATSZÁMÁT-RPM.
BEÁLLITOTT LIMIT FÖLÖTT AZ AJÓZÁR KIMENETÉT MEGSZAKÍTJA,EZZEL A PROGRAMKAPCSOLÓ
     MEGSZAKÍTJA A PROGRAMOT, AJTÓZÁR HIBÁT JELEZ, ÉS A KIJELZŐN  A
     "MOTOR OK" FELIRAT VILLOG ,HANGJELZÉSSEL VÁLTAKOZVA.
- AMENNYIBEN AZ AJTÓZÁR BEKAPCSOL ÉS HA EZ IDŐ ALATT NEM LÉPI ÁT AZ RPM LIMITET,
     AKKOR AZ AJTÓZÁR TRIAC KIKAPCSOLÁS PILLANATÁBAN A KIJELZŐN "TESZT OK" FELIRAT
     VILLOG, HANGJELZÉSSEL VÁLTAKOZVA.
* AJTÓZÁR:
   - KÉT FAJTA DSS KIMENETI KONFIGURÁCIÓ VAN KIVEZETVE.
DSS3.1-3 * DSS3.1-3 = PTC TRIAC OUT - AJTÓZÁR - 1.
     DSS3.2-2 * DSS3.2-5 = PTC COM       - AJTÓZÁR - 3.
     DSS3.3-1 * DSS3.2-4 = DDS OUT       - AJTÓZÁR - 2.
     
  -BEÁLLÍTÁSOK:
     RPM KÜSZÖB:                     KUSZOBERTEK_RPM = 65.SOR
     MAX. RPM KIJELZÉS:              MAX_JUMP_RPM = 66.SOR
     AKTIVÁLÁS KÉSLELTETÉS IDŐ:      DELAY_MS = 68.SOR     
     DSS KIMENET MEGSZAKITÁS IDŐ:    D4_HIGH_MS = 71.SOR
     KIJELZŐ-BUZZER  AKTIV IDŐ:      DISPLAY_OK_MS = 72.SOR
     DSS TRIAC VISSZAPATTANÁS IDŐ:   DEBOUNCE_DELAY_MS = 86.SOR
     KIJELZŐ-BUZZER VÁLTÁS IDŐ:      isBlinkOn = 241.SOR
                                     -NÖVELÉS:(activeTimeElapsed % 1000) < 500;
                                     -CSÖKKENTÉS:(activeTimeElapsed % 4000) < 2000;
                                     -ASSZIMETRIKUS:(activeTimeElapsed % 2000) < 1800;
                                      PL:ÖSSZ-2 SEC, FELIRAT-1,8 SEC, BUZZER-0,2 SEC.
     KIJELZŐ FELSŐ FELIRAT:          topText = 242.SOR
     KIJELZŐ ALSÓ FELIRAT:           display.println("OK"); =251 .SOR
                                     -MIND A KÉT FELSŐ FELIRAT ESETÉN EZ JELENIK MEG
     */

#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <math.h>
#include <stdlib.h>

void pulseIncrementer();
// KIJELZŐ BEÁLLÍTÁS
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
// RPM MÉRÉS BEÁLLÍTÁS
const byte interruptPin = 2;
const int IMPULZUSOK_PER_FORDULAT = 1;
const unsigned long MINTAVETELI_IDO_MS = 500;
volatile long pulseCount = 0;
unsigned long lastSampleTime = 0;

// SZOVTVERES SIMITÁS
const int SAMPLE_COUNT = 4;
float rpmHistory[SAMPLE_COUNT];
int rpmHistoryIndex = 0;
float smoothed_RPM = 0.0;

// VEZÉRLÉS BEÁLLÍTÁSOK
const int DP_kimenetPin = 4;
const int BUZZER_PIN = 10;
const int D12_INPUT_PIN = 12;

const float KUSZOBERTEK_RPM = 900.0;        // RPM-LIMIT
const float MAX_JUMP_RPM = 4000.0;          // MAX.RPM.KIJELZÉS

const unsigned long DELAY_MS = 5000;        // AKTIVÁLÁSI KÉSLELTETÉS
unsigned long limitStartTime = 0;
// KÜLÖNÁLLÓ IDŐZÍTÉSEK
const unsigned long D4_HIGH_MS = 15000;      // DSS-MEGSZAKITÁSI IDŐ
const unsigned long DISPLAY_OK_MS = 15000;  // KIJELZŐ-BUZZER AKTIV IDŐ
// ÁLLAPOTOK
#define STATE_WAITING 0
#define STATE_ACTIVE 1
int currentState = STATE_WAITING;

// AKTIV ESEMÉNY
#define ACTIVE_TYPE_MOTOR_OK 0
#define ACTIVE_TYPE_TESZT_OK 1
int activeEventType = ACTIVE_TYPE_MOTOR_OK;
// IDŐZÍTŐ VÁLTOZÓK
unsigned long activationTime = 0;

// D12 DEBOUNCE ÉS FELTÉTEL KÖVETÉS
const unsigned long DEBOUNCE_DELAY_MS = 200;  // DSS-TRIAC VISSZAPATTANÁSI IDŐ
unsigned long D12_lastDebounceTime = 0;
int D12_lastReading = LOW;
int D12_buttonState = LOW;
int D12_previousDebouncedState = LOW;
bool D12_is_monitoring = false;
bool D12_rpm_violated = false;

void readAndDebounceD12() {
  int reading = digitalRead(D12_INPUT_PIN);
  if (reading != D12_lastReading) {
    D12_lastDebounceTime = millis();
  }
  if ((millis() - D12_lastDebounceTime) > DEBOUNCE_DELAY_MS) {
    if (reading != D12_buttonState) {
      D12_buttonState = reading;
    }
  }
  D12_lastReading = reading;
}

void setup() {
  Serial.begin(115200);
  if (!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
    for (;;);
  }
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0, 0);
  display.println("RPM Meres...");
  display.display();
  pinMode(interruptPin, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(interruptPin), pulseIncrementer, FALLING);

  pinMode(DP_kimenetPin, OUTPUT);
  digitalWrite(DP_kimenetPin, LOW);
  pinMode(BUZZER_PIN, OUTPUT);
  digitalWrite(BUZZER_PIN, LOW);

  pinMode(D12_INPUT_PIN, INPUT);
  lastSampleTime = millis();
}

void loop() {
  unsigned long aktualisIdo = millis();
  readAndDebounceD12();
  if (D12_buttonState == HIGH && D12_previousDebouncedState == LOW) {
    D12_is_monitoring = true;
    D12_rpm_violated = false;
  }

  if (D12_buttonState == LOW && D12_previousDebouncedState == HIGH) {
    if (D12_is_monitoring && !D12_rpm_violated) {
        activationTime = aktualisIdo;
        currentState = STATE_ACTIVE;
        activeEventType = ACTIVE_TYPE_TESZT_OK;
    }
    D12_is_monitoring = false;
  }

  if (D12_is_monitoring && D12_buttonState == HIGH) {
    if (smoothed_RPM >= KUSZOBERTEK_RPM) {
      D12_rpm_violated = true;
    }
  }
  D12_previousDebouncedState = D12_buttonState;

  if (aktualisIdo - lastSampleTime >= MINTAVETELI_IDO_MS) {
    noInterrupts();
    long currentPulses = pulseCount;
    pulseCount = 0;
    interrupts();
    float rpm = (float)currentPulses * 120.0;

    float rpmDifference = abs(rpm - smoothed_RPM);
    if (rpmDifference < MAX_JUMP_RPM || smoothed_RPM == 0) {
      rpmHistory[rpmHistoryIndex] = rpm;
      rpmHistoryIndex = (rpmHistoryIndex + 1) % SAMPLE_COUNT;
    }

    float totalRPM = 0.0;
    for (int i = 0; i < SAMPLE_COUNT; i++) {
      totalRPM += rpmHistory[i];
    }
    smoothed_RPM = totalRPM / SAMPLE_COUNT;
    int rounded_RPM = (int)(round(smoothed_RPM / 50.0) * 50);

    switch (currentState) {
      case STATE_WAITING:
        digitalWrite(BUZZER_PIN, LOW);
        if (rpm >= KUSZOBERTEK_RPM) {
          if (limitStartTime == 0) limitStartTime = aktualisIdo;
          if (aktualisIdo - limitStartTime >= DELAY_MS) {
            digitalWrite(DP_kimenetPin, HIGH);
            activationTime = aktualisIdo;
            limitStartTime = 0;
            currentState = STATE_ACTIVE;
            activeEventType = ACTIVE_TYPE_MOTOR_OK;
          }
        } else {
          limitStartTime = 0;
        }
        break;

      case STATE_ACTIVE:
        if (activeEventType == ACTIVE_TYPE_MOTOR_OK) {
          if (digitalRead(DP_kimenetPin) == HIGH) {
            if (aktualisIdo - activationTime >= D4_HIGH_MS) {
              digitalWrite(DP_kimenetPin, LOW);
              activationTime = aktualisIdo;    
            }
          } else {
            if (aktualisIdo - activationTime >= DISPLAY_OK_MS) {
              // --- RESET RÉSZ KEZDETE ---
              currentState = STATE_WAITING;
              for (int i = 0; i < SAMPLE_COUNT; i++) rpmHistory[i] = 0; 
              smoothed_RPM = 0;
              limitStartTime = 0;
              pulseCount = 0; 
              // --- RESET RÉSZ VÉGE ---
            }
          }
        } else {
          digitalWrite(DP_kimenetPin, LOW);
          if (aktualisIdo - activationTime >= DISPLAY_OK_MS) {
            // --- RESET RÉSZ KEZDETE ---
            currentState = STATE_WAITING;
            digitalWrite(BUZZER_PIN, LOW);
            for (int i = 0; i < SAMPLE_COUNT; i++) rpmHistory[i] = 0;
            smoothed_RPM = 0;
            limitStartTime = 0;
            pulseCount = 0;
            // --- RESET RÉSZ VÉGE ---
          }
        }
        break;
    }

    display.clearDisplay();
    bool showNotification = false;
    if (currentState == STATE_ACTIVE) {
        if (activeEventType == ACTIVE_TYPE_TESZT_OK) showNotification = true;
        else if (activeEventType == ACTIVE_TYPE_MOTOR_OK && digitalRead(DP_kimenetPin) == LOW) showNotification = true;
    }

    if (!showNotification) {
      display.setTextSize(4);
      display.setCursor(0, 0);
      display.print(rounded_RPM);
      display.setTextSize(2);
      display.setCursor(0, 40);
      display.print("RPM");
    } else {
      unsigned long activeTimeElapsed = aktualisIdo - activationTime;
      bool isBlinkOn = (activeTimeElapsed % 2000) < 1000;           // KIJELZŐ-BUZZER VÁLTÁS IDŐ
      const char* topText = (activeEventType == ACTIVE_TYPE_MOTOR_OK) ? "MOTOR" : "TESZT";
      if (isBlinkOn) {
        digitalWrite(BUZZER_PIN, LOW);
        display.setTextSize(4);
        display.setTextColor(SSD1306_WHITE);
        display.setCursor(0, 0);
        display.println(topText);
        display.setTextSize(4);
        display.setCursor(45, 32);
        display.println("OK");
      } else {
        digitalWrite(BUZZER_PIN, HIGH);
      }
    }
    display.display();
    lastSampleTime = aktualisIdo;
  }
}

void pulseIncrementer() {
  pulseCount++;
}
