LIST P=18F4550, F=INHX32
#include <P18F4550.INC>

__CONFIG  _CONFIG1L,  _PLLDIV_6_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
__CONFIG  _CONFIG1H,  _FOSC_ECPLLIO_EC_1H & _FCMEM_OFF_1H & _IESO_OFF_1H
__CONFIG  _CONFIG2L,  _PWRT_OFF_2L & _BOR_SOFT_2L & _BORV_2_2L & _VREGEN_ON_2L
__CONFIG  _CONFIG2H,  _WDT_OFF_2H
__CONFIG  _CONFIG3H,  _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H
__CONFIG  _CONFIG4L,  _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L & _XINST_OFF_4L & _DEBUG_ON_4L

UDATA
; megszaktnl regisztermentshez
WregTemp        RES     1   ; W regiszter mentshez
StatusTemp      RES     1   ; STATUS regiszter mentshez

AktTask         RES     1   ; ppen ez a task fut (0, 1, 2)

Task1Status     RES     1   ; Status regiszter
Task1W          RES     1   ; W reg mentshez
Task1Stack      RES     1   ; Stack pointer

Task2Status     RES     1   ; Status regiszter
Task2W          RES     1   ; W reg mentshez
Task2Stack      RES     1   ; Stack pointer

Task3Status     RES     1   ; Status regiszter
Task3W          RES     1   ; W reg mentshez
Task3Stack      RES     1   ; Stack pointer

Task4Status     RES     1   ; Status regiszter
Task4W          RES     1   ; W reg mentshez
Task4Stack      RES     1   ; Stack pointer

Task1Delay      RES     1   ; 1.task vrakozsi cikl. szmllja
Task2Delay      RES     1   ; 2.task vrakozsi cikl. szmllja
Task3Delay      RES     1   ; 3.task vrakozsi cikl. szmllja

;==============================================================================
; Reset vector
RESET_VECTOR    CODE    0x0000
                goto    Main

;==============================================================================
; magas priorits megszakts vector
HI_INT_VECTOR   CODE    0x0008
                retfie  FAST

;==============================================================================
; alacsony priorits megszakits vector
LOW_INT_VECTOR  CODE    0x0018
                bra     LowInt

;==============================================================================
                CODE
; alacsony priorits megszakits rutin
LowInt          movff   STATUS, StatusTemp      ; STATUS regiszter mentse
                movwf   WregTemp                ; W regiszter mentse
                btfss   INTCON, TMR0IF
                bra     UserInt                 ; ha nem TMR0 vltotta ki akkor UserInt

                bcf     INTCON, TMR0IF

                ; Task1 az aktiv ?
                movf    AktTask, W
                bnz     AktTask2
                ; igen, Task1 llapotnak mentse
                incf    AktTask, f
                movff   WregTemp, Task1W
                movff   StatusTemp, Task1Status
                movff   STKPTR, Task1Stack
                ; Task2 llapotnak visszallitsa
                movff   Task2Stack, STKPTR
                movf    Task2W, W
                movff   Task2Status, STATUS
                retfie

AktTask2        addlw   -1
                bnz     AktTask3
                ; Task2 llapotnak mentse
                incf    AktTask, f
                movff   WregTemp, Task2W
                movff   StatusTemp, Task2Status
                movff   STKPTR, Task2Stack
                ; Task3 llapotnak visszallitsa
                movff   Task3Stack, STKPTR
                movf    Task3W, W
                movff   Task3Status, STATUS
                retfie

AktTask3        addlw   -1
                bnz     AktTask4
                ; Task3 llapotnak mentse
                incf    AktTask, f
                movff   WregTemp, Task3W
                movff   StatusTemp, Task3Status
                movff   STKPTR, Task3Stack
                ; Task4 llapotnak visszallitsa
                movff   Task4Stack, STKPTR
                movf    Task4W, W
                movff   Task4Status, STATUS
                retfie

AktTask4        ; Task4 llapotnak mentse
                clrf    AktTask
                movff   WregTemp, Task4W
                movff   StatusTemp, Task4Status
                movff   STKPTR, Task4Stack
                ; Task1 llapotnak visszallitsa
                movff   Task1Stack, STKPTR
                movf    Task1W, W
                movff   Task1Status, STATUS
                retfie

;==============================================================================
; fprogram kezdete
Main
                ; Task1 kezdparamtereinek bellitsa
                movlw   .0
                movwf   STKPTR
                movwf   Task1Stack
                movlw   low Task1
                movwf   TOS
                movlw   high Task1
                movwf   TOSH
                 
                ; Task2 kezdparamtereinek bellitsa
                movlw   .8
                movwf   STKPTR
                movwf   Task2Stack
                movlw   low Task2
                movwf   TOS
                movlw   high Task2
                movwf   TOSH

                ; Task3 kezdparamtereinek bellitsa
                movlw   .16
                movwf   STKPTR
                movwf   Task3Stack
                movlw   low Task3
                movwf   TOS
                movlw   high Task3
                movwf   TOSH

                ; Task4 kezdparamtereinek bellitsa
                movlw   .24
                movwf   STKPTR
                movwf   Task4Stack
                movlw   low Task4
                movwf   TOS
                movlw   high Task4
                movwf   TOSH

                ;--------------------------------------------------------------
                ; Timer0 irq bellts
                movlw   B'11000000'               ; 8 bites, 1:2
                movwf   T0CON
                bsf     INTCON, TMR0IE            ; megsz. eng.
                bcf     INTCON2, TMR0IP           ; alacsony priorits
                bsf     RCON, IPEN                ; ketts szint megszakts eng.

                bsf     INTCON, GIEH              ; globlis irq eng.
                bsf     INTCON, GIEL              ; perifria irq eng.

                clrf    AktTask
                clrf    STKPTR
                goto    Task1                     ; indulhat is az 1.taszk

;==============================================================================
UserInt

; ide lehet berni a sajt megszaktskiszolgl programokat

                movf    WregTemp, W             ; W regiszter visszalltsa
                movff   StatusTemp, STATUS      ; STATUS regiszter visszalltsa
                retfie

;==============================================================================
Wait            nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                addlw  -1
                bnz    Wait
                return

;==============================================================================
Task1           bcf    TRISB, 0
Task1_0         movlw  0
                movwf  Task1Delay
Task1_1         movlw  0xFF
                call   Wait
                decfsz Task1Delay, f
                bra    Task1_1
                btg    LATB, 0
                bra    Task1_0

;==============================================================================
Task2           bcf    TRISB, 1
Task2_0         movlw  0
                movwf  Task2Delay
Task2_1         movlw  0xE4
                call   Wait
                decfsz Task2Delay, f
                bra    Task2_1
                btg    LATB, 1
                bra    Task2_0

;==============================================================================
Task3           bcf    TRISB, 2
Task3_0         movlw  0
                movwf  Task3Delay
Task3_1         movlw  0xC9
                call   Wait
                decfsz Task3Delay, f
                bra    Task3_1
                btg    LATB, 2
                bra    Task3_0

;==============================================================================
Task4           
                movlw   .77                       ; 9600 bit/sec
                movwf   SPBRG

                movlw   B'00100000'               ; tvitel eng, aszinkron, BRGH = low speed
                movwf   TXSTA
                bcf     TRISC, 6                  ; TX lb kimenet

                movlw   B'10010000'               ; soros port eng, 8 bites md, vtel eng
                movwf   RCSTA

Task4_0         btfss   PIR1, RCIF
                bra     Task4_1
                incf    RCREG, W
                movwf   TXREG
Task4_1         clrf    TMR0L                     ; taszkvltsra biztatjuk
                bsf     INTCON, TMR0IF
                bra     Task4_0

END
