;**************************************
;egy stepper motor vezrlse pic16f84a
;JELFELDOLGOZS 6,8uSEC (147KHz)
;felfutl feldolgozsa  2,4uSEC 
;;*************************************
list p=16f84a
include "p16f84a.inc"
 CLC MACRO
	BCF STATUS,0
 ENDM
 SEC MACRO
	BSF STATUS,0
ENDM
 JC macro adat0	;ugrs ha C bit magas
 	btfsc 3,0 
 	goto adat0 
 	endm
 JNC macro adat1	;ugrs ha C bit alacsony
 	btfss 3,0 
 	goto adat1 
 	endm
 JZ macro adat2	;ugrs ha Z bit magas
 	btfsc 3,2
 	goto adat2 
 	endm
 JNZ macro adat3	;ugrs ha Z bit alacsony
 	btfss 3,2
 	goto adat3
 	endm
TAX	MACRO
	MOVWF	XR
	ENDM
PHW MACRO			;W REGISZTER S STTUSZREGISZTER VEREMBE
	MOVWF	W_REG
	SWAPF	STATUS,W
	MOVWF	STATUS_REG
	ENDM
PLW	MACRO			;STTUSZREGISZTER S W REGISZTER VEREMBL
	SWAPF STATUS_REG,W
	MOVWF	STATUS
	SWAPF	W_REG,F
	SWAPF	W_REG,W
	ENDM
STATUS_REG 	EQU 0X0C	;0X4F-IG
W_REG		EQU	0X0D
T0HI			EQU	0X0E	;TIMER FELSBYTE
STEPH		EQU	0X0F	;LPS HELYZET
OFSET		EQU	0X10	;LPSTPUSHOZ ELTOLS
FLAG			EQU	0X11	;
					;0.BIT 	0=NORMAL RAM
					;		1=60% RAM
					;1.BIT	0=NORMAL RAM
					;		1=200% RAM(FLLPS)
org 0000
CALL	INIT
GOTO	PRG
nop;
nop;
MOVWF	W_REG	;W MENTSE
SWAPF	STATUS,W	;STATUS MENTSE
MOVWF	STATUS_REG
BTFSS INTCON,1		;BPORT ADAT??
GOTO	TIM0			;UGRS.HA NEM
BCF	INTCON,1		;B PORT BIT TRLSE
CLRF	T0HI			;IDZT TRLSE
BCF	FLAG,0		;EZT JELEZZK IS
BCF	PORTB,4		;RAM 100%
CALL	LPS
GOTO	VEGE
TIM0:
BCF	INTCON,2		;TIMER BIT TRLSE
BTFSS FLAG,0
INCF	T0HI			;SZMLL NVELSE	
VEGE:	
	SWAPF STATUS_REG,W
	MOVWF	STATUS
	SWAPF	W_REG,F
	SWAPF	W_REG,W
	RETFIE
;
;
;
INIT:
BCF	STATUS,RP0	;ALS MEMRIA LAP
CLRF	PORTA		;PORTOK TRLSE
CLRF	PORTB;	
BSF	STATUS,RP0	;ADATIRNY BELLTSA
MOVLW 0X30		;
MOVWF TRISA		;MINDEN BIT KIMENET
;CLRF	TRISB		;EZT TRLNI
MOVLW 0XCF
MOVWF TRISB		;
BCF	OPTION_REG,5	;TIMER0 ENGEDLYEZSE
BCF	OPTION_REG,3	;ELOSZT TIMERHEZ RENDELVE	:256
BCF	STATUS,RP0	;ALS MEMRIALAP
BSF	INTCON,5		;TIMER MEGSZ. ENG.
BSF	INTCON,4		;PORTB 0.BIT MEGSZ. ENG.
BSF	INTCON,7		;MEGSZAKTSOK ENG.
CLRF	T0HI			;IDZT NULLZS
MOVFW PORTB		;LPSTPUS MEGHATROZS
ANDLW 0X0C
BCF	STATUS,0		;CLC
MOVWF OFSET		;SEGDREGISZTERBE
RRF	OFSET
RRF OFSET
MOVFW OFSET
CALL ADAT1
MOVWF	OFSET
RETURN
;
;
;
PRG:
;BSF 0X0B,1
MOVLW 0X26
BSF STATUS,0	;SEC
SUBWF T0HI,W	;ELTELT MR 0.5 SEC??
JNC	PRG		;UGRS HA NEM
BTFSC FLAG,0	;MR TARTRAMON VAN??
GOTO	PRG
BSF	PORTB,4	;RAM 60%-ON
BSF	FLAG,0	;S A JELZSE
;BCF	PORTB,5	;200% RAM KIKAPCS
GOTO PRG
;
;
LPS:
MOVLW	0X01
BTFSC	PORTB,1	;IRNY 1 -EL NVELSE
MOVLW	0XFF
ADDWF	STEPH,F
MOVFW	STEPH
ANDLW	0X07
ADDWF	OFSET,W
CALL		ADAT	;helyzetnek megfelel adat beolv.
MOVWF	PORTA
MOVF		OFSET,F
JZ A01
MOVLW	0X08
SUBWF	OFSET,W
JNZ		FLLPS
BSF		PORTB,5	;RAM200%
A01:
RETURN
FLLPS:
BTFSS	STEPH,0	;UGRS HA ALACSONY
GOTO		LO
BSF		PORTB,5	;RAM 200%
RETURN
LO:
BCF		PORTB,5	;RAM 100%
RETURN

;
ADAT:ADDWF 	PCL,F		;szmtott goto ugrs
	RETLW	0X0E			;NORMAL *** LPSEK JAVTVA INVERZEK !!!****
	RETLW	0X0B
	RETLW	0X0D
	RETLW	0X07
	RETLW	0X0E	
	RETLW	0X0B
	RETLW	0X0D
	RETLW	0X07

	RETLW	0X05	;ERS NORMAL
	RETLW	0X06
	RETLW	0x0A
	RETLW	0X09
	RETLW	0X05
	RETLW	0X06
	RETLW	0x0A
	RETLW	0X09

	RETLW	0X0E	;FLLPS
	RETLW	0X0A
	RETLW	0X0B
	RETLW	0X09
	RETLW	0X0D
	RETLW	0X05
	RETLW	0X07
	RETLW	0X06

ADAT1:ADDWF 	PCL,F
	RETLW	0X00
	RETLW	0X08
	RETLW	0X10
	RETLW	0X00

end
