;****************************************************************
;* HEARTBEAT MONITOR - HeMon	Master of the Blutbahn !!!!	*
;* BY KEITH WILSON		by Iris Kistler			*
;* VERSION 1							*
;****************************************************************

	list p=16f84,r=hex	;microcontroller & base

	include	"reg16c84.inc"	;register memory mapping file
	include "hemon.inc"	;heartbeat definitions


;****************************************************************
;global variables
;****************************************************************
count		equ	0x0c		;general purpose counter
display3	equ	0x0d		;data for 7-segment display 100's
display2	equ	0x0e		;data for 7-segemnt display 10's
display1	equ	0x0f		;data for 7-segment display 1's
beatlsb		equ	0x10		;heartbeat counter,lsb
beatmsb		equ	0x11		;heartbeat counter,msb
aargb0		equ	0x12		;dividend,lsb
aargb1		equ	0x13		;dividend,msb
bargb0		equ	0x14		;divisor,lsb
bargb1		equ	0x15		;divisor,msb
remb0		equ	0x16		;remainder,lsb
remb1		equ	0x17		;remainder,msb
timera		equ	0x18		;general purpose timer
timerb		equ	0x19		;general purpose timer
timerc		equ	0x1a		;general purpose timer
timerd		equ	0x1b		;general purpose timer

;****************************************************************
;reset vector
;****************************************************************
reset:	org	0x00			;reset vector address	
	goto	start			;start program execution
	

start:	org 	0x06			;start of program
	goto	Initialisation


;****************************************************************
; LED DISPLAY DECODER FROM BINARY TO 7-SEGMENT
;****************************************************************
LedDecoder:
	addwf	pcl,f								;W   DISPLAY
	retlw	LED_SEGa|LED_SEGb|LED_SEGc|LED_SEGd|LED_SEGe|LED_SEGf		;0 - "0"
	retlw	LED_SEGb|LED_SEGc						;1 - "1"
	retlw	LED_SEGa|LED_SEGb|LED_SEGd|LED_SEGe|LED_SEGg			;2 - "2"
	retlw	LED_SEGa|LED_SEGb|LED_SEGc|LED_SEGd|LED_SEGg			;3 - "3"
	retlw	LED_SEGb|LED_SEGc|LED_SEGf|LED_SEGg				;4 - "4"
	retlw	LED_SEGa|LED_SEGc|LED_SEGd|LED_SEGf|LED_SEGg			;5 - "5"
	retlw	LED_SEGa|LED_SEGc|LED_SEGd|LED_SEGe|LED_SEGf|LED_SEGg		;6 - "6"
	retlw	LED_SEGa|LED_SEGb|LED_SEGc					;7 - "7"
	retlw	LED_SEGa|LED_SEGb|LED_SEGc|LED_SEGd|LED_SEGe|LED_SEGf|LED_SEGg	;8 - "8"
	retlw	LED_SEGa|LED_SEGb|LED_SEGc|LED_SEGd|LED_SEGf|LED_SEGg		;9 - "9"
	retlw	LED_BLANK							;10- " "

;****************************************************************
;Name		: Initialisation
;Description	: system initialisation and mainloop
;Inputs		: none
;Outputs	: none
;****************************************************************
Initialisation:

;system initialisation

;port A and port B initialisation

	bcf	status,rp1		;select bank1 register
	bsf	status,rp0

	movlw	PORTA_CONFIG1		;porta configuration
	movwf	trisa			
	movlw	PORTB_CONFIG1		;portb configuration
	movwf	trisb

	bcf	status,rp0		;select bank0 registers

	movlw	0x00			;disable all displays
	movwf	porta			

;****************************************************************
;Name		: Mainloop
;Description	: measure and display heartbeat
;Inputs		: none
;Outputs	: none
;****************************************************************
Mainloop:
	call	Heartbeat		;measure heartbeat
	call	Convert			;convert to bpm
	call	Display			;show on display

	goto	Mainloop		;endless loop

;****************************************************************
;Name		: Heartbeat
;Description	: measures the time between two heartbeat signals.
;		: Triggered on rising-edge of signal, then measures
;		: amount of milli-seconds before next rising-edge. 
;Inputs		: none
;Outputs	: beatlsb,beatmsb = length between two heartbeats
;		: in milli-seconds
;****************************************************************
Heartbeat:
	btfss	porta,HEARTBEAT_SENSOR	;wait until signal goes high
	goto	Heartbeat	
	call	Delay150		;wait 150msec - wait until signal has gone low

	clrf	beatmsb			;preset beat registers with 150msec
	movlw	0x96
	movwf	beatlsb
	
HL1:	call	Delay1			;wait 1msec
	incf	beatlsb,w		;increment beatlsb by 1msec
	movwf	beatlsb
	btfsc	status,z		;lsb rollover? 
	incf	beatmsb,f		;yes -increment msb
	btfss	porta,HEARTBEAT_SENSOR	;keep looping till signal goes back high
	goto	HL1	

	return		

;****************************************************************
;Name		: Convert
;Description	: convert the measured heartbeat from milliseconds
;		: to beats-per-minute. (maybe there's a quicker way!)
;Inputs		: beatlsb, beatmsb
;Outputs	: display1,display2,display3 = contain hearbeat
;		: in bcd format
;****************************************************************
Convert:
	;calculate bpm = 60000/beat (lsb and msb)
	
	;Make dividend 60000 == 0xEA60
	movlw	0xea		;msb
	movwf	aargb1
	movlw	0x60		;lsb
	movwf	aargb0	

	;Get measured heartbeat values, as divisor
	movf	beatmsb,w	;msb
	movwf	bargb1
	movf	beatlsb,w	;lsb
	movwf	bargb0

	clrf	remb0		;initialise remainder registers
	clrf	remb1

	; do an unsigned 16-bit by 16-bit division
	movlw	0x10
	movwf	count

Lu16:	rlf	aargb1,w
	rlf	remb0,f
	rlf	remb1,f
	movf	bargb0,w
	subwf	remb0,f
	movf	bargb1,w
	btfss	status,c
	incfsz	bargb1,w
	subwf	remb1,f	
	btfsc	status,c
	goto	uok16
	movf	bargb0,w
	addwf	remb0,f
	movf	bargb1,w
	btfsc	status,c
	incfsz	bargb1,w
	addwf	remb1,f
	bcf	status,c

uok16:	rlf	aargb0,f
	rlf	aargb1,f	
	decfsz	count,f
	goto	Lu16

	;convert the lsb result of the previous division to unpacked bcd
	movlw	0x08			;an 8-bit division
	movwf	count

	movlw	0x0a			;divide the previous lsb result by 10
	movwf	bargb0
	clrf	remb0			;initialise remainder

Lu8:	rlf	aargb0,w
	rlf	remb0,f
	movf	bargb0,w
	subwf	remb0,f	
	btfsc	status,c
	goto 	uok8
	addwf	remb0,f
	bcf	status,c
uok8:	rlf	aargb0,f
	decfsz	count,f
	goto	Lu8	

	movlw	0x0a			;3rd bcd digit - 100's is blank(if not changed further down code!)
	movwf	display3		
	
	movf	remb0,w
	movwf	display1		;1st bcd digit - 1's
	
	movf	aargb0,w		
	movwf	display2		;2nd bcd digit - 10's(if not changed further down code!)
	
	sublw	0x09			;is the quotient >=10?
	bnc	$+2			;yes -quotient is >=10, so divide by 10 again!
	return				;go back

	movlw	0x08			;an 8-bit division
	movwf	count
	
	movlw	0x0a			;divide the previous lsb result by 10
	movwf	bargb0
	clrf	remb0			;initialise remainder

Lu81:	rlf	aargb0,w
	rlf	remb0,f
	movf	bargb0,w
	subwf	remb0,f	
	btfsc	status,c
	goto 	uok81
	addwf	remb0,f
	bcf	status,c
uok81:	rlf	aargb0,f
	decfsz	count,f
	goto	Lu81
	
	movf	remb0,w
	movwf	display2		;2nd bcd digit - 10's
	
	movf	aargb0,w
	movwf	display3		;3rd bcd digit - 100's

	return				;go back

;****************************************************************
;Name		: Display
;Description	: updates display with current measurement
;Inputs		: display1 - 7-segment display 1's
;		: display2 - 7-segment display 10's
;		: display3 - 7-segment display 100's
;Outputs	: none
;****************************************************************
Display: 
	movf	display1,w		;convert bcd to 7-segment
	call	LedDecoder
	movwf	display1

	movf	display2,w
	call	LedDecoder
	movwf	display2

	movf	display3,w
	call	LedDecoder
	movwf	display3

	movlw	0x4			;update display for a little while
	movwf	timerc

DL2:	movlw	0xff
	movwf	timerd

DL1:	clrf	porta
	bsf	porta,LED_DIGIT1
	movf	display1,w
	movwf	portb
	call	Delay1

	clrf	porta
	bsf	porta,LED_DIGIT2
	movf	display2,w
	movwf	portb
	call	Delay1

	clrf	porta
	bsf	porta,LED_DIGIT3
	movf	display3,w
	movwf	portb
	call	Delay1
	clrf	porta

	decfsz	timerd,f
	goto	DL1
	decfsz	timerc,f
	goto	DL2


	return				;go back

;****************************************************************
;Name		: Delay
;Description	: causes a delay of 1msec
;Inputs		: none
;Outputs	: none
;****************************************************************
Delay1:	
	movlw	0x02			;number of wait states
	movwf	timerb	
L2:	
	movlw	0xa5			;number of wait states
	movwf	timera
L3:	decfsz	timera,f
	goto	L3
	decfsz	timerb,f
	goto	L2
	
	return				;go back


;****************************************************************
;Name		: Delay
;Description	: causes a delay of 150msec
;Inputs		: none
;Outputs	: none
;****************************************************************
Delay150:	
	movlw	0xc3			;number of wait states
	movwf	timerb	
L4:	
	movlw	0xff			;number of wait states
	movwf	timera
L5:	decfsz	timera,f
	goto	L5
	decfsz	timerb,f
	goto	L4
	
	return				;go back



	end
