
	list		p=16f917		; list directive to define processor
	#include	<P16F917.inc>		; processor specific variable definitions
	
	__CONFIG    _CP_OFF & _CPD_OFF  & _DEBUG_OFF & _FCMEN_OFF & _IESO_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _FCMEN_OFF & _IESO_OFF & _BOD_OFF


	CBLOCK	0x20
	Counter
	Pointer
	helpreg
	LCD_TEMP_0
	LCD_TEMP_1
	FLAG
	FLAG1
	W_TEMP
	S_TEMP
	TEMP_0
	TEMP_1
	TEMP_2
	AD_TEMP_0
	AD_TEMP_1
	NYG_TEMP_0
	NYG_TEMP_1
	SEG_TIM_0
	TMR0_SEG
	BCD_H
	BCD_M
	BCD_L
	BCD_S
	BIN_H
	BIN_L
	UP_TIME			;fel irny mozgs ideje
	DO_TIME			;le irny
	SI_TIME			;sznet a kvetkez mozgsig
	COUNT_BE_L		;belltott lyukszm
	COUNT_BE_H
	COUNT_KI_L		;aktulis lyukszm
	COUNT_KI_H
	AD_L
	AD_H
	PRELL_TIM
	NYG_HELYI
	NYG_COUNT
	NYG_COUNT_E
	RELAY_COUNT
	RE_TIMER
	ENDC
	
;h'50' tl LCD 1. sora
;h'64' tl LCD 2. sora

	#DEFINE	EN			PORTB,4
	#DEFINE	RW			PORTD,7
	#DEFINE	RS			PORTB,5

	#DEFINE	RELAY_UP	PORTA,3
	#DEFINE	RELAY_DOWN	PORTA,4
	
	#DEFINE	NYG_START	PORTD,0
	#DEFINE	NYG_STOP	PORTD,1
	#DEFINE	NYG_SAVE	PORTC,7

	#DEFINE	NYG_D		PORTC,4
	#DEFINE	NYG_E		PORTC,5
	#DEFINE	NYG_F		PORTC,6
	#DEFINE	NYG_G		TRISC,3
	#DEFINE	NYG_H		TRISC,2
	#DEFINE	NYG_J		TRISC,1
	#DEFINE	NYG_K		TRISC,0

	#DEFINE	MATRIX_0	FLAG,0		;
	#DEFINE	START		FLAG,1		;
	#DEFINE	NYG_STA_E	FLAG,2		;
	#DEFINE	NYG_STO_E	FLAG,3		;
	#DEFINE	NYG_SAV_E	FLAG,4		;
	#DEFINE	PRELL		FLAG,5		;
	#DEFINE	PRELL_A		FLAG,6		;
	#DEFINE	HELYI_ERT	FLAG,7		;

	#DEFINE	STOP		FLAG1,0
	#DEFINE	NYG_SE_E	FLAG1,1
	#DEFINE	LOW_SAVE	FLAG1,2		;mr el lett mentve az adat, mgegyszer nem kell megprblni

wait_some	MACRO
	nop
	nop
	nop
	ENDM

kirak	MACRO
	BCF		PORTB,0
	BTFSC	LCD_TEMP_1,0
	BSF		PORTB,0
	BCF		PORTB,1
	BTFSC	LCD_TEMP_1,1
	BSF		PORTB,1
	BCF		PORTB,2
	BTFSC	LCD_TEMP_1,2
	BSF		PORTB,2
	BCF		PORTB,3
	BTFSC	LCD_TEMP_1,3
	BSF		PORTB,3
	ENDM


	ORG	0x00
	NOP
	GOTO	INIC
INTERRUPT
	ORG	0x04
	MOVWF	W_TEMP
	MOVF	STATUS,W
	MOVWF	S_TEMP
	BCF		INTCON,T0IF
	INCF	TMR0_SEG,F
	MOVLW	d'6'
	XORWF	TMR0_SEG,W
	BTFSS	STATUS,Z
	GOTO	INT_1
	CLRF	TMR0_SEG
	CALL	AD_CONV			;potik beolvassa
	BCF		RELAY_UP
	BTFSS	START			;van-e jel kiads
	GOTO	INT_1
	CALL	SWITCH			;rel kapcsolgats
INT_1
	BTFSS	PRELL_A			;pergsmentests idztse
	GOTO	INT_VEGE	
	INCF	PRELL_TIM,F
	MOVLW	d'2'
	XORWF	PRELL_TIM,W
	BTFSS	STATUS,Z
	GOTO	INT_VEGE
	BSF		PRELL			;letelt,lehet jra olvasni
	BCF		PRELL_A
	CLRF	PRELL_TIM

INT_VEGE

	MOVF	S_TEMP,W
	MOVWF	STATUS
	MOVF	W_TEMP,W
	RETFIE
INIC
	BCF	STATUS,RP0				;BANK_0
	BCF	STATUS,RP1
	MOVLW	b'10100000'
	MOVWF	INTCON
	CLRF	T1CON
	CLRF	T2CON
	CLRF	RCSTA
	CLRF	TMR0
	CLRF	SSPCON
	MOVLW	b'10000001'
	MOVWF	ADCON0
	CLRF	CCP1CON
	CLRF	CCP2CON

	BSF		STATUS,RP0			;BANK_1
	MOVLW	b'10000110'
	MOVWF	OPTION_REG
	CLRF	PIE1
	CLRF	PIE2
	CLRF	PCON
	MOVLW	b'01110001'		;8MHz-es bels oszcilltor
	MOVWF	OSCCON
	CLRF	OSCTUNE
	CLRF	WPUB
	CLRF	IOCB
	CLRF	TXSTA
	MOVLW	b'01000000'
	MOVWF	ADCON1
	MOVLW	b'00000111'
	MOVWF	ANSEL
	MOVLW	b'00000111'
	MOVWF	CMCON0
	CLRF	CMCON1
	CLRF	SSPSTAT
	CLRF	VRCON
	MOVLW	b'00000111'
	MOVWF	TRISA
	MOVLW	b'00000000'
	MOVWF	TRISB
	MOVLW	b'11111111'
	MOVWF	TRISC
	MOVLW	b'00000011'
	MOVWF	TRISD
	MOVLW	b'00000000'
	MOVWF	TRISE

	BCF		STATUS,RP0		;BANK_2
	BSF		STATUS,RP1
	CLRF	LCDPS
	CLRF	LCDCON
	CLRF	LVDCON

	BSF		STATUS,RP0		;BANK_3
	CLRF	EECON1

	BCF		STATUS,RP0
	BCF		STATUS,RP1

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC
	CLRF	PORTD
	CLRF	PORTE
	BSF		RELAY_UP
	CLRF	FLAG
	CLRF	FLAG1
	CLRF	TMR0_SEG
	CLRF	PRELL_TIM
	CLRF	AD_TEMP_0
	CLRF	AD_TEMP_1
	CLRF	NYG_HELYI
	
	MOVLW	d'40'	
	MOVWF	UP_TIME
	MOVLW	d'50'
	MOVWF	DO_TIME
	MOVLW	d'30'
	MOVWF	SI_TIME
	MOVLW	d'5'
	MOVWF	COUNT_BE_H
	MOVLW	d'124'
	MOVWF	COUNT_BE_L
	MOVLW	d'4'
	MOVWF	COUNT_KI_H
	MOVLW	d'214'
	MOVWF	COUNT_KI_L
;	GOTO	ERTEKEL
;	CALL	AD_CONV
;	GOTO	MAIN
;-------------------------------------------------------------------------------
; Init LCD
;-------------------------------------------------------------------------------
INIC_LCD
	bcf		RW
	bcf		EN
	bcf		RS
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY
	call	DELAY

	movlw   b'00101000'	; 28h, 4 bit interface set
	call    LCDPUTCMD	
	movlw   0x06		; 06h, Entry mode set: increment
	call    LCDPUTCMD
	movlw   b'00001100'	; 0dh, Display on, cursor/blink off
	call    LCDPUTCMD
	movlw   0x10		; 10h, Display/cursor shift: cursor
	call    LCDPUTCMD
	movlw   0x01		; 01h, Display clear
	call    LCDPUTCMD
 
	CALL	LCD_1
	CALL	LCD_2

;-------------------------------------------------------------------------------
; MAIN
;-------------------------------------------------------------------------------
MAIN
	CALL	NYG_MATRIX
;	CALL	NYOMOGOMB
	NOP
	NOP
	GOTO	MAIN

;-------------------------------------------------------------------------------
NYOMOGOMB
	BTFSS	NYG_START
	GOTO	NY_START
	BTFSS	NYG_STOP
	GOTO	NY_STOP
	BTFSS	NYG_SAVE
	GOTO	NY_SAVE
	GOTO	NYG_VEGE
NY_START
	BTFSC	START
	GOTO	NYG_VEGE
	BTFSC	STOP
	GOTO	NYG_VEGE
	BSF		START
	BSF		RELAY_DOWN
	MOVF	DO_TIME,W
	MOVWF	RE_TIMER
	MOVF	COUNT_BE_L,W
	MOVWF	COUNT_KI_L
	MOVF	COUNT_BE_H,W
	MOVWF	COUNT_KI_H
	CLRF	RELAY_COUNT
;	RETURN
	GOTO	LCD_2
NY_STOP
	BTFSS	START
	GOTO	NYG_VEGE
	BSF		STOP
	GOTO	NYG_VEGE
NY_SAVE
	GOTO	NYG_VEGE
NYG_VEGE
	RETURN
;============N Y O M O G O M B  M A T R I X=========
NYG_MATRIX
	BTFSC	PRELL_A
	RETURN
	CLRF	NYG_COUNT
	BSF		STATUS,RP0
	MOVLW	b'11111110'
	MOVWF	TRISC
	BCF		STATUS,RP0
	BCF		PORTC,0

READ_MATRIX
	INCF	NYG_COUNT,F
	BTFSS	NYG_F
	GOTO	NYG_MAT_0
	INCF	NYG_COUNT,F
	BTFSS	NYG_E
	GOTO	NYG_MAT_0
	INCF	NYG_COUNT,F
	BTFSS	NYG_D
	GOTO	NYG_MAT_0
	MOVLW	d'12'
	XORWF	NYG_COUNT,W
	BTFSC	STATUS,Z
	GOTO	NYG_MAT_ZERO
	BSF		STATUS,RP0
	BSF		STATUS,C
	RLF		TRISC,F
	BCF		STATUS,RP0
	CLRF	PORTC
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO	READ_MATRIX
NYG_MAT_0
	BSF		STATUS,RP0
	MOVLW	h'FF'
	MOVWF	TRISC
	BCF		STATUS,RP0
	BTFSC	MATRIX_0
	RETURN
	BTFSC	PRELL
	GOTO	NY_MAT_1

	BCF		PRELL				;meg lett nyomva egy gomb, pergsmentests indul
	BSF		PRELL_A
	CLRF	PRELL_TIM
	MOVFW	NYG_COUNT
	MOVWF	NYG_COUNT_E
	RETURN
NY_MAT_1						;lejrt az id, meg van-e mg nyomva a gomb
	BCF		PRELL
	MOVFW	NYG_COUNT
	XORWF	NYG_COUNT_E,W
	BTFSC	STATUS,Z
	GOTO	NYG_MAT_2
	BSF		MATRIX_0			;ms gomb van megnyomva
	RETURN	
NYG_MAT_2
	BSF		MATRIX_0			;mg mindig meg van nyomva, vgrehajthat a parancs
	GOTO	NYG_FELDOL
NYG_MAT_ZERO
	BCF		MATRIX_0
	BSF		STATUS,RP0
	MOVLW	h'FF'
	MOVWF	TRISC
	BCF		STATUS,RP0
	RETURN
NYG_FELDOL
;	MOVFW	NYG_COUNT
;	MOVWF	COUNT_BE_L
;	CLRF	COUNT_BE_H
;	GOTO	LCD_2
;	RETURN


	MOVLW	d'11'
	XORWF	NYG_COUNT,W
	BTFSS	STATUS,Z
	GOTO	NYG_DEK_0
	CLRF	NYG_COUNT
	GOTO	NYG_FELD
NYG_DEK_0
	MOVLW	d'10'
	XORWF	NYG_COUNT,W
	BTFSS	STATUS,Z
	GOTO	NYG_DEK_1
	CLRF	COUNT_BE_L
	CLRF	COUNT_BE_H
	CLRF	NYG_HELYI
	BCF		HELYI_ERT
	GOTO	LCD_2
	RETURN
NYG_DEK_1
	MOVLW	d'12'
	XORWF	NYG_COUNT,W
	BTFSS	STATUS,Z
	GOTO	NYG_FELD
	RETURN
NYG_FELD
	INCF	NYG_HELYI,F
	MOVLW	d'5'
	XORWF	NYG_HELYI,W
	BTFSS	STATUS,Z
	GOTO	NYG_FEL_0
	DECF	NYG_HELYI,F
	RETURN
NYG_FEL_0
	BTFSC	HELYI_ERT
	GOTO	NYG_FEL_1
	BSF		HELYI_ERT
	MOVFW	NYG_COUNT
	MOVWF	COUNT_BE_L
	CLRF	COUNT_BE_H
	GOTO	LCD_2
;	RETURN
NYG_FEL_1
;	BCF		INTCON,GIE					;10-vel szorzs, plussz az egyes helyi rtk hozzadsa
	BCF		STATUS,C
	RLF		COUNT_BE_L,F
	RLF		COUNT_BE_H,F
	MOVFW	COUNT_BE_L
	MOVWF	NYG_TEMP_0
	MOVFW	COUNT_BE_H
	MOVWF	NYG_TEMP_1	
	BCF		STATUS,C
	RLF		COUNT_BE_L,F
	RLF		COUNT_BE_H,F
	BCF		STATUS,C
	RLF		COUNT_BE_L,F
	RLF		COUNT_BE_H,F
	MOVFW	NYG_TEMP_0
	ADDWF	COUNT_BE_L,F
	BTFSC	STATUS,C
	INCF	COUNT_BE_H,F
	MOVFW	NYG_TEMP_1
	ADDWF	COUNT_BE_H,F	
	MOVFW	NYG_COUNT
	ADDWF	COUNT_BE_L,F
	BTFSC	STATUS,C
	INCF	COUNT_BE_H,F
;	BSF		INTCON,GIE
	GOTO	LCD_2

;	RETURN
	
;===================================================

DELAY    
	movlw   d'165'		; 100us ksleltets
	movwf   SEG_TIM_0
Kesl1
	decfsz  SEG_TIM_0,F
	goto    Kesl1
	return
;===================================================
;	LCD control subroutines
;===================================================

LCDBUSY	
;	RETURN
	bsf		STATUS, RP0
	movlw	b'00001111'		; PORTB=output
	movwf	TRISB
	bcf		STATUS, RP0
	bcf		RS				; set LCD to command mode
	bsf		RW				; Setup to read busy flag
	bsf		EN				; LCD_E line high
	movf	PORTB, w		; read busy flag
	MOVWF	LCD_TEMP_1
	SWAPF	LCD_TEMP_1,W
	andlw	b'10000000'
	movwf	helpreg
	bcf		EN				; LCD_E line low
	wait_some
	bsf		EN
	wait_some
	bcf		EN
	btfsc	helpreg, 7
	goto	LCDBUSY		; Go back until busy flag is released

LCDNOTBUSY
	bcf		RW
	bsf		STATUS, RP0
	CLRF	TRISB
	bcf		STATUS, RP0
	return
			
LCDPUTCHAR
	movwf	LCD_TEMP_0
	call	LCDBUSY
	bcf		RW
	bsf		RS
	bsf		EN
	movf	LCD_TEMP_0, w
	andlw	b'11110000'
	MOVWF	LCD_TEMP_1
	SWAPF	LCD_TEMP_1,F
	kirak
	bcf		EN
	wait_some
	bsf		EN
	MOVFW	LCD_TEMP_0
	andlw	b'00001111'
	MOVWF	LCD_TEMP_1
	kirak	
	bcf		EN
	return

LCDPUTCMD
	movwf	LCD_TEMP_0
	call	LCDBUSY
	movf	LCD_TEMP_0, w
	andlw	b'11110000'
	MOVWF	LCD_TEMP_1
	SWAPF	LCD_TEMP_1,F
	kirak
	bcf		RW
	bcf		RS
	bsf		EN
	wait_some
	bcf		EN
	wait_some
	bsf		EN
	MOVFW	LCD_TEMP_0
	andlw	b'00001111'
	MOVWF	LCD_TEMP_1
	kirak
	bcf		EN
	return


;===================================================

;-------------L C D      K E Z E L  S-------------
LCD_1
;1. SOR						;ebbe a sorba rja ki bemenetet
	MOVLW	h'50'
	MOVWF	LCD_TEMP_0
	movlw	d'16'	
	movwf	Counter
	clrf	Pointer
Start1
	CALL	LCD1_SOR
	MOVWF	LCD_TEMP_1
	MOVFW	LCD_TEMP_0
	MOVWF	FSR
	MOVFW	LCD_TEMP_1
	MOVWF	INDF
	INCF	LCD_TEMP_0,F
	incf	Pointer,F
	decfsz	Counter,F
	GOTO	Start1


	CLRF	BIN_H			;le id BCD v konvertlsa s elmetse
	MOVF	DO_TIME,W
	MOVWF	BIN_L
	CALL	BIN_BCD
	MOVFW	BCD_M
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'50'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_S
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'52'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF

	CLRF	BIN_H			;fel id BCD v konvertlsa s elmetse
	MOVFW	UP_TIME
	MOVWF	BIN_L
	CALL	BIN_BCD
	MOVFW	BCD_M
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'56'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_S
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'58'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF

	CLRF	BIN_H			;sznet id BCD v konvertlsa s elmetse
	MOVFW	SI_TIME
	MOVWF	BIN_L
	CALL	BIN_BCD
	MOVFW	BCD_M
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'5C'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_S
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVLW	h'5E'
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF

	movlw   b'10000000'		;els sor kikldse az LCD-re
	call    LCDPUTCMD

	MOVLW	d'16'	
	movwf	Counter
	MOVLW	h'50'
	MOVWF	Pointer

Start11
	MOVFW	Pointer
	MOVWF	FSR
	MOVFW	INDF
	call    LCDPUTCHAR
	incf	Pointer,F
	decfsz	Counter,F
	GOTO	Start11
	RETURN
;2. SOR
LCD_2	
;	RETURN		
	MOVLW	h'64'
	MOVWF	LCD_TEMP_0
	movlw	d'16'	
	movwf	Counter
	clrf	Pointer
Start2
	CALL	LCD2_SOR
	MOVWF	LCD_TEMP_1
	MOVFW	LCD_TEMP_0
	MOVWF	FSR
	MOVFW	LCD_TEMP_1
	MOVWF	INDF
	INCF	LCD_TEMP_0,F
	incf	Pointer,F
	decfsz	Counter,F
	GOTO	Start2

	MOVFW	COUNT_BE_H			;megadott lyukszm BCD-v alaktsa
	MOVWF	BIN_H
	MOVFW	COUNT_BE_L
	MOVWF	BIN_L
	CALL	BIN_BCD
	MOVLW	h'66'
	MOVWF	LCD_TEMP_1
	CALL	BETOLT_LCD2

	MOVFW	COUNT_KI_H			;htralev lyukszm BCD-v alaktsa
	MOVWF	BIN_H
	MOVFW	COUNT_KI_L
	MOVWF	BIN_L
	CALL	BIN_BCD
	MOVLW	h'6E'
	MOVWF	LCD_TEMP_1
	CALL	BETOLT_LCD2

	MOVLW	b'11000000'			;kikldi a memribl az LCd-re a karaktereket
	call    LCDPUTCMD

	MOVLW	d'16'	
	movwf	Counter
	MOVLW	h'64'
	MOVWF	Pointer

Start22
	MOVFW	Pointer
	MOVWF	FSR
	MOVFW	INDF
	call    LCDPUTCHAR
	incf	Pointer,F
	decfsz	Counter,F
	GOTO	Start22
	RETURN

BETOLT_LCD2							;a memriba feltlti a LCD karaktereket
	MOVFW	BCD_H
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	MOVFW	LCD_TEMP_1
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_L
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	INCF	LCD_TEMP_1,F
	MOVFW	LCD_TEMP_1
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_M
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	INCF	LCD_TEMP_1,F
	MOVFW	LCD_TEMP_1
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	MOVFW	BCD_S
	MOVWF	LCD_TEMP_0
	CALL	UGRO
	MOVWF	LCD_TEMP_0
	INCF	LCD_TEMP_1,F
	MOVFW	LCD_TEMP_1
	MOVWF	FSR
	MOVFW	LCD_TEMP_0
	MOVWF	INDF
	RETURN


;------------BIN to BCD szubrutin--------------
BIN_BCD
	MOVFW	BIN_L
	MOVWF	TEMP_1
	MOVFW	BIN_H
	MOVWF	TEMP_2
	CLRF	BCD_H
	CLRF	BCD_M
	CLRF	BCD_L
	CLRF	BCD_S
gethau_loop
	movlw	b'00000011'
	INCF	BCD_H,F
	SUBWF	TEMP_2,F
	BTFSS	STATUS,C
	GOTO	GETHAU_1
	movlw	b'11101000'
	SUBWF	TEMP_1,F
	BTFSC	STATUS,C
	GOTO	gethau_loop
	movlw	d'1'
	SUBWF	TEMP_2,F
	BTFSC	STATUS,C
	GOTO	gethau_loop
	DECF	BCD_H,F	
	movlw	b'11101000'
	ADDWF	TEMP_1,F
	movlw	b'00000100'
	ADDWF	TEMP_2,F
	GOTO	gethnds_loop
GETHAU_1
	movlw	b'00000011'
	ADDWF	TEMP_2,F
	DECF	BCD_H,F
gethnds_loop
	MOVLW	.100
	INCF	BCD_L,F
	SUBWF	TEMP_1,F
	BTFSC	STATUS,C
	GOTO	gethnds_loop
	movlw	d'1'
	SUBWF	TEMP_2,F
	BTFSC	STATUS,C
	GOTO	gethnds_loop

	DECF	BCD_L,F
	movlw	d'100'
	ADDWF	TEMP_1,F
	CLRF	TEMP_2
gettens_loop
	MOVLW	.10
	INCF	BCD_M,f
	SUBWF	TEMP_1,F
	BTFSC	STATUS,C
	GOTO 	gettens_loop
	MOVLW	d'10'
	ADDWF	TEMP_1,F
	DECF	BCD_M,F
deltens_loop
	MOVFW	TEMP_1
	MOVWF	BCD_S
	RETURN
;------------------ A D  C O N V E R S I O N ----------------
AD_CONV
	MOVLW	b'10001001'
	MOVWF	ADCON0
	MOVLW	d'17'		;a le id felbontsnak lltsa
	MOVWF	AD_TEMP_1
	BTFSC	START
	RETURN
	CALL	AD_BE
	BSF		START		;ez itt a prblgats miatt szletett
;	MOVLW	d'112'
;	MOVWF	AD_L
;	MOVLW	d'2'
;	MOVWF	AD_H
;	CALL	ERTEKEL
;	RETURN

;	MOVF	AD_TEMP_0,W
;	MOVWF	DO_TIME

;	MOVLW	d'3'
;	ADDWF	DO_TIME,W
	MOVF	AD_L,W
	MOVWF	COUNT_KI_L
	MOVF	AD_H,W
	MOVWF	COUNT_KI_H
	GOTO	LCD_2
		


	MOVLW	b'10001001'
	MOVWF	ADCON0
	MOVLW	d'20'		;a le id felbontsnak lltsa
	MOVWF	AD_TEMP_1
	CALL	AD_BE
	MOVFW	AD_TEMP_0
	MOVWF	DO_TIME
	MOVLW	d'3'
	ADDWF	DO_TIME,F

	MOVLW	b'10000001'
	MOVWF	ADCON0
	MOVLW	d'40'		;a fel id felbontsnak lltsa
	MOVWF	AD_TEMP_1
	CALL	AD_BE
	MOVFW	AD_TEMP_0
	MOVWF	UP_TIME
	MOVLW	d'5'
	ADDWF	UP_TIME,F

	MOVLW	b'10000101'
	MOVWF	ADCON0
	MOVLW	d'30'		;a kvetkez vgs kzti id
	MOVWF	AD_TEMP_1
	CALL	AD_BE
	MOVFW	AD_TEMP_0
	MOVWF	SI_TIME
	MOVLW	d'4'
	ADDWF	SI_TIME,F
;	CLRF	ADCON0
	GOTO	LCD_1

AD_BE

	NOP
	NOP
	NOP
	BSF		ADCON0,GO_DONE
	NOP
	NOP
	NOP
	BTFSC	ADCON0,GO_DONE
	GOTO	$-1
	MOVF	ADRESH,W 
	MOVWF	AD_H		
	BSF		STATUS,RP0
	MOVF	ADRESL,W 
	BCF		STATUS,RP0
	MOVWF	AD_L
;	BCF		ADCON0,ADON
ERTEKEL
	RETURN
	CLRF	AD_TEMP_0
ERT_1
	INCF	AD_TEMP_0,F
	MOVF	AD_TEMP_1,W
	BCF		STATUS,C
	SUBWF	AD_L,F
	BTFSC	STATUS,C
	GOTO	ERT_1
	MOVLW	d'1'
	BCF		STATUS,C
	SUBWF	AD_H,F
	BTFSC	STATUS,C
	GOTO	ERT_1
	DECF	AD_TEMP_0,F
;	GOTO	ERTEKEL
	RETURN




	org 0X500
LCD1_SOR
	MOVLW	d'5'
	MOVWF	PCLATH
	MOVFW	Pointer
	ADDWF	PCL,F
	dt	" . s   . s   . s"
LCD2_SOR
	MOVLW	d'5'
	MOVWF	PCLATH
	MOVFW	Pointer
	ADDWF	PCL,F
	dt	"                "
UGRO
	MOVLW	d'5'
	MOVWF	PCLATH
	MOVFW	LCD_TEMP_0
	addwf	PCL,F
	dt	"0123456789 +-"
SWITCH
	MOVLW	d'5'
	MOVWF	PCLATH
	MOVF	RELAY_COUNT,W
	ADDWF	PCL,F
	GOTO	PERIOD_0
	GOTO	PERIOD_1
	GOTO	PERIOD_2
	GOTO	PERIOD_3

PERIOD_0
	DECFSZ	RE_TIMER,F			;lefele
	RETURN
	BCF		RELAY_DOWN
	INCF	RELAY_COUNT,F
	MOVLW	d'1'
	MOVWF	RE_TIMER
	RETURN
PERIOD_1		
	DECFSZ	RE_TIMER,F			;sznet
	RETURN
	INCF	RELAY_COUNT,F
	MOVF	UP_TIME,W
	MOVWF	RE_TIMER
	BSF		RELAY_UP
	RETURN
PERIOD_2
	DECFSZ	RE_TIMER,F			;felfele
	RETURN
	BCF		RELAY_UP
	BTFSC	STOP
	GOTO	PERIOD_2_0
	MOVF	SI_TIME,W
	MOVWF	RE_TIMER
	INCF	RELAY_COUNT,F

	MOVLW	d'1'
	SUBWF	COUNT_KI_L,F
	BTFSC	STATUS,C
	GOTO	PERIOD_2_1
	MOVLW	d'1'
	SUBWF	COUNT_KI_H,F
	BTFSC	STATUS,C
	GOTO	PERIOD_2_2
PERIOD_2_1
	CLRW
	XORWF	COUNT_KI_L,W
	BTFSS	STATUS,Z
	GOTO	PERIOD_2_2
	CLRW
	XORWF	COUNT_KI_H,W
	BTFSS	STATUS,Z
	GOTO	PERIOD_2_2
PERIOD_2_0
	BCF		STOP
	BCF		START
PERIOD_2_2
	GOTO	LCD_2	
PERIOD_3
	BTFSC	STOP						;sznet a kvetkez peridusig
	GOTO	PERIOD_2_0
	DECFSZ	RE_TIMER,F
	RETURN
	BSF		RELAY_DOWN
	CLRF	RELAY_COUNT
	MOVF	DO_TIME,W
	MOVWF	RE_TIMER
	RETURN
	END

;--------------E E P R O M , R E A D , W R I T E--------------




