;
;**********************************************************************
;                                                                     *
;    FD-1 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:	    25Cxx.ASM                                         *
;    Dtum:         2000.11.15.                                       *
;    Verziszm:    V1.2                                              *
;    #5                                                               *
;                                                                     *
;    Szerz:        Szeg Jnos                                       *
;    Cg neve:      jpesti Mszaki Szakkzpiskola                   *
;    E-mail:	    szego@umszki.hu                                   *
;                                                                     * 
;**********************************************************************
;                                                                     *
;    25LC160 SPI EEPROM KEZEL PROGRAM                                *
;    ---------------------------------                                *
;    Az EEPROM SCK, SI, SO vonalait az SPI port kezeli.               *
;    Az EEPROM kivlasztst - a /CS jellel - az RA1 vonal vgzi.     *
;                                                                     *
;**********************************************************************
;
	list      p=16F877            
	#include <p16F877.inc>         
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _LVP_OFF
;
;----------------------------------------------------------------------
#define		CS	PORTA,1		
;----------------------------------------------------------------------
; PIC16F877 kivezetsek
;
; PORTA:   1 - CS, aktv L szint EEPROM kivlaszt jel 
;
; PORTC:   3 - CLK, EEPROM SCK kivezetsre
;          4 - SDI, EEPROM SO kivezetsre
;          5 - SDO, EEPROM SI kivezetsre
;----------------------------------------------------------------------
; EEPROM utastskdok
;
READ		equ	B'00000011'	; EEPROM olvass
WRITE		equ	B'00000010'	; EEPROM rs
WRDI_		equ	B'00000100'	; EEPROM rst tiltja
WREN_		equ	B'00000110'	; EEPROM rst engedlyezi
RDSR		equ	B'00000101'	; EEPROM sttusz regiszter olvass
WRSR		equ	B'00000001'	; EEPROM sttusz regiszter rs
;----------------------------------------------------------------------
Timer1		equ	0x20
Timer2		equ	0x21
Rxdata		equ	0x22		; SPI kimeneti adat
Txdata		equ	0x23		; SPI bemeneti adat
EE_Addr_Lo	equ	0x24		; EEPROM cm tmeneti trol, LO
EE_Addr_Hi	equ	0x25		; EEPROM cm tmeneti trol, HI
EE_Data		equ	0x26		; EEPROM adat tmeneti trol
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAMOK ----------------------------
;----------------------------------------------------------------------
		org     0x000          	; reset vektor
		nop			; MPLAB-ICD miatt
;----------------------------------------------------------------------
; Port konfigurls
;
Start		bcf	STATUS,RP0	
		bcf	STATUS,RP1	; bank0 kivlaszts
		movlw	2
		movwf	PORTA		; SPI EEPROM nincs kivlasztva
		clrf	PORTC		; EEPROM vonalak inaktvak
		bsf	STATUS,RP0	; bank1 kivlaszts
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		movlw	B'11111101'    	; RA1 kimenet
		movwf	TRISA
		movlw	B'11010111'	; RC3, RC5 kimenet
		movwf	TRISC
		clrf	TRISD		; RD0..7 kimenet
;----------------------------------------------------------------------
; SPI inicializls
;
		clrf	PIE1		; a perifria megszaktsok tiltsa 
		clrf	INTCON		; 
		movlw	B'01001000'	; SMP=0, CKE=1
		movwf	SSPSTAT		 
		bcf	STATUS,RP0	; bank0 kivlaszts
		movlw	B'00100010'	; SPI master, Fosc/64, CKP=0
		movwf	SSPCON		; SSPEN=1, soros port engedlyezs
;----------------------------------------------------------------------
; Egy bjt rsa az EEPROM-ba
;
		call	WR_Enable	; EEPROM rs engedlyezse
		movlw	0x24		; EEPROM cm betltse
		movwf	EE_Addr_Lo	 
		movlw	0x01		
		movwf	EE_Addr_Hi	
		movlw	0x36		; adat az EEPROM szmra
		movwf	EE_Data	
		call	EE_Write	; EEPROM rs
		bsf	CS		; CS=1 -> EEPROM nidzts indul
Rd_Busy		call	Delay		; 1ms vrakozs
		call	Status_Rd	; EEPROM sttusz beolvass
		btfsc	Rxdata,0	; EEPROM ready jel vizsglata
		goto	Rd_Busy		; ha WIP=1, rs mg nem ksz
;----------------------------------------------------------------------
; Adott kezdcmtlegy lap rsa az EEPROM-ba
; Kezd lapcm 25LC160 esetn xxxxxxx0000, bjtok szma maximum 16
;
		call	WR_Enable	; EEPROM rs engedlyezse
		movlw	0x30		; EEPROM cm betltse
		movwf	EE_Addr_Lo	 
		movlw	0x00		
		movwf	EE_Addr_Hi	
		movlw	0x00		; adat az EEPROM szmra
		movwf	EE_Data	
		call	EE_Write	; EEPROM rs
		movlw	0x11
		call	Output		; 2. bjt rsa
		movlw	0x22
		call	Output		; 3. bjt rsa
		movlw	0x33
		call	Output		; 4. bjt rsa
		movlw	0x44
		call	Output		; 5. bjt rsa
		movlw	0x55
		call	Output		; 6. bjt rsa
		movlw	0x66
		call	Output		; 7. bjt rsa
		movlw	0x77
		call	Output		; 8. bjt rsa
		movlw	0x88
		call	Output		; 9. bjt rsa
		movlw	0x99
		call	Output		; 10. bjt rsa
		movlw	0xAA
		call	Output		; 11. bjt rsa
		movlw	0xBB
		call	Output		; 12. bjt rsa
		movlw	0xCC
		call	Output		; 13. bjt rsa
		movlw	0xDD
		call	Output		; 14. bjt rsa
		movlw	0xEE
		call	Output		; 15. bjt rsa
		movlw	0xF0
		call	Output		; 16. bjt rsa
		bsf	CS		; CS=1 -> EEPROM nidzts indul
Rd_Busy_1	call	Delay		; 1ms vrakozs
		call	Status_Rd	; EEPROM sttusz beolvass
		btfsc	Rxdata,0	; EEPROM ready jel vizsglata
		goto	Rd_Busy_1	; ha WIP=1, rs mg nem ksz
;----------------------------------------------------------------------
; Egy bjt olvass az EEPROM-bl
;
		movlw	0x34		; EEPROM cm betltse
		movwf	EE_Addr_Lo	 
		movlw	0x00		
		movwf	EE_Addr_Hi	
		call	EE_Read		; EEPROM olvass
		movf	Rxdata,0	; EEPROM adat -> W
		movwf	PORTD		; kiirats a LED soron
;
Stop		goto	Stop		; vrakozs resetre
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- SZUBRUTINOK ----------------------------
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
Delay		clrf	Timer1		; 1ms ksleltets
		movlw	5
		movwf	Timer2
Delay1		nop
		decfsz	Timer1,1
		goto	Delay1
		decfsz	Timer2,1
		goto	Delay1
		return
;----------------------------------------------------------------------
WR_Enable	bcf	STATUS,RP0	; bank0 kivlaszts 
		bcf	CS		; EEPROM kivlaszts
		movlw	WREN_		; rs engedlyezs utastskdja
		call	Output		; kiklds az SPI porton
		bsf	CS		; EEPROM inaktv
		return
;----------------------------------------------------------------------
Status_Rd	bcf	CS		; EEPROM kivlaszts
		movlw	RDSR		; sttusz reg. olvass kd kiklds
		call	Output		
		movlw	0x00		; "dummy" adat kiklds
		call	Output		; sttusz regiszter olvass
		bsf	CS		; EEPROM inaktv
		return
;----------------------------------------------------------------------
Output		movwf	SSPBUF		; betlts az SPI shift regiszterbe	
Loop		bsf	STATUS,RP0	; bank1 kivlaszts
		btfss	SSPSTAT,BF	; ads/vtel ksz?
		goto	Loop		; mg nem
;----------------------------------------------------------------------
		bcf	STATUS,RP0	; bank0 kivlaszts
		movf	SSPBUF,0	; 
		movwf	Rxdata		; a vett adat az Rxdata regiszterbe
		return			; kerl
;----------------------------------------------------------------------
EE_Write	bcf	STATUS,RP0	; bank0 kivlaszts
		bcf	CS		; EEPROM kivlaszts
		nop
		movlw	WRITE		; rs utastskdja
		call	Output		;
		movf	EE_Addr_Hi,0	; EEPROM cm HI kiklds
		call	Output		;
		movf	EE_Addr_Lo,0	; EEPROM cm LO kiklds
		call	Output		;
		movf	EE_Data,0	; programozand adat
		call	Output		;
		return
;----------------------------------------------------------------------
EE_Read		bcf	STATUS,RP0	; bank0 kivlaszts
		bcf	CS	 	; EEPROM kivlaszts
		movlw	READ		; olvass kd kiklds
		call	Output		;
		movf	EE_Addr_Hi,0	; EEPROM cm HI kiklds
		call	Output		;
		movf	EE_Addr_Lo,0	; EEPROM cm LO kiklds
		call	Output		;
		movlw	0x00		; "dummy" adat kiklds
		call	Output		; EEPROM adat az Rxdata regiszterben
		bsf	CS	 	; olvass lezrs
		return
;----------------------------------------------------------------------		
		end

