/****************************************************************************
* AVR 2004 Design Contest
* Entry No. A3757
* main.c
*
* PB0 - iButton pin
*
*****************************************************************************/

#include <avr/io.h>
#include <avr/delay.h>
#include <avr/eeprom.h>
#include "iButton.h"

unsigned char SR_NO[8];	
	
void main(void)
{
	DDRB |= 0x01; 	// PB0 configured as output
	PORTB &= 0xFD; 	
	delay_us(3000);
	eeprom_write_byte(1,'1');
	
	eeprom_write_byte(2,OWReset());
	eeprom_write_byte(3,OWReadROM(SR_NO));
	eeprom_write_byte(4,'-');
	
	for (int i = 0; i < 8; i++) 
	eeprom_write_byte(5+i,SR_NO[i]);

	while(1)
	{}
}
