;********************************************************
;
;                  LED flash control 2
;
;                                 Device : PIC16F84A
;                                 Clock  : 4MHz
;                                 Author : Seiichi Inoue
;********************************************************

        list            p=pic16f84a
        include         p16f84a.inc
        __config _hs_osc & _wdt_off & _pwrte_on & _cp_off
        errorlevel      -302    ;Eliminate bank warning

;****************  Label Definition  ********************
        cblock  h'0c'
loop_cnt                        ;Loop counter for LED cnt
led_data0                       ;LED data 0
led_data1                       ;LED data 1
led01                           ;LED 01 pattern
led10                           ;LED 10 pattern
led11                           ;LED 11 pattern
port_work                       ;LED data save area
counter                         ;Software timer counter
ptn_save                        ;Pattern number save area
ptn_counter                     ;Pattern counter
w_save                          ;W register save area
s_save                          ;STATUS regi save area
        endc

ra0     equ     00              ;RA0 bit
ra1     equ     01              ;RA1 bit
ra2     equ     02              ;RA2 bit

;**************** Speed control data ********************
speed   equ     1               ;100ms (+1=50ms)

;*************  Brightness control data  ****************
led1    equ     b'11111110'     ;(01) almost dim
led2    equ     b'11111010'     ;(10) less bright
led3    equ     b'11110000'     ;(11) bright

;*************  Pattern Data Definition  ****************
; 1 bright  1 less bright  0 almost dim  0 dim
; 1         0              1             0

;******  Pattern 0  ******
p000    equ     b'00000000'
p001    equ     b'00000000'

p010    equ     b'10000001'
p011    equ     b'10000001'

p020    equ     b'11000011'
p021    equ     b'01000010'

p030    equ     b'01100110'
p031    equ     b'10100101'

p040    equ     b'00111100'
p041    equ     b'01011010'

p050    equ     b'00011000'
p051    equ     b'00111100'

p060    equ     b'00111100'
p061    equ     b'00100100'

p070    equ     b'01100110'
p071    equ     b'01011010'

p080    equ     b'11000011'
p081    equ     b'10100101'

p090    equ     b'10000001'
p091    equ     b'01000010'

p0a0    equ     b'00000000'
p0a1    equ     b'10000001'

;******  Pattern 1  ******
p100    equ     b'00000000'
p101    equ     b'00000000'

p110    equ     b'00000001'
p111    equ     b'00000001'

p120    equ     b'00000011'
p121    equ     b'00000010'

p130    equ     b'00000110'
p131    equ     b'00000101'

p140    equ     b'00001100'
p141    equ     b'00001010'

p150    equ     b'00011000'
p151    equ     b'00010100'

p160    equ     b'00110000'
p161    equ     b'00101000'

p170    equ     b'01100000'
p171    equ     b'01010000'

p180    equ     b'11000000'
p181    equ     b'10100000'

p190    equ     b'10000000'
p191    equ     b'01000000'

p1a0    equ     b'00000000'
p1a1    equ     b'10000000'

;******  Pattern 2  ******
p200    equ     b'00000000'
p201    equ     b'00000000'

p210    equ     b'10000000'
p211    equ     b'10000000'

p220    equ     b'11000000'
p221    equ     b'01000000'

p230    equ     b'01100000'
p231    equ     b'10100000'

p240    equ     b'00110000'
p241    equ     b'01010000'

p250    equ     b'00011000'
p251    equ     b'00101000'

p260    equ     b'00001100'
p261    equ     b'00010100'

p270    equ     b'00000110'
p271    equ     b'00001010'

p280    equ     b'00000011'
p281    equ     b'00000101'

p290    equ     b'00000001'
p291    equ     b'00000010'

p2a0    equ     b'00000000'
p2a1    equ     b'00000001'

;****************  Program Start  ***********************
        org     0               ;Reset Vector
        goto    init
        org     4               ;Interrupt Vector
        goto    int

;******************  Initial Process  *******************
init
;*** Set Port mode
        bsf     status,rp0      ;Change to Bank1
        movlw   b'00000111'     ;RA2-0:IN mode
        movwf   trisa           ;Set TRISA reg
        movlw   b'00000000'     ;RB7-0:OUT mode
        movwf   trisb           ;Set TRISB reg

;*** Set Option reg
        movlw   b'10000111'     ;RBPU=OFF,PSA=0,PS=1:256
        movwf   option_reg      ;Set OPTION_REG
        bcf     status,rp0      ;Change to Bank0

;*** Set work area
        clrf    led_data0       ;Clear LED data0
        clrf    led_data1       ;Clear LED data1
        movlw   led1            ;Read 01 pattern
        movwf   led01           ;Set  01 pattern
        movlw   led2            ;Read 10 pattern
        movwf   led10           ;Set  10 pattern
        movlw   led3            ;Read 11 pattern
        movwf   led11           ;Set  11 pattern
        clrf    port_work       ;Clear LED data save area
        movlw   speed           ;Read speed data
        addlw   d'1'            ;+1 addition
        movwf   counter         ;Set counter
        movlw   d'1'            ;Set pattern data
        movwf   ptn_save        ;Set pattern 0
        clrf    ptn_counter     ;Clear pattern counter

;*** Set TMR0 reg
        movlw   d'61'           ;256-50ms/0.256ms = 61
        movwf   tmr0            ;Set 50msec to TMR0
        movlw   b'10100000'     ;GIE=1,TOIE=1
        movwf   intcon          ;Interruption enable

;****************  LED control Process ******************
loop
        movlw   d'4'            ;Set loop counter data
        movwf   loop_cnt        ;Set loop counter
loop1
        movlw   d'1'            ;Set check data
        subwf   loop_cnt,w      ;Check exec times
        btfss   status,z        ;Counter = 1 ?
        goto    next2           ;No.
        goto    process4        ;Jump to Process4
next2
        movlw   d'2'            ;Set check data
        subwf   loop_cnt,w      ;Check exec times
        btfss   status,z        ;Counter = 2 ?
        goto    next3           ;No.
        goto    process3        ;Jump to Process3
next3
        movlw   d'3'            ;Set check data
        subwf   loop_cnt,w      ;Check exec times
        btfss   status,z        ;Counter = 3 ?
        goto    next4           ;No.
        goto    process2        ;Jump to Process2
next4
        movlw   d'4'            ;Set check data
        subwf   loop_cnt,w      ;Check exec times
        btfss   status,z        ;Counter = 4 ?
        goto    loop            ;No. illegal
        goto    process1        ;Jump to Process1

led_cont
        movfw   port_work       ;Read PORT WORK data
        movwf   portb           ;Set PORTB
next
        decfsz  loop_cnt,f      ;Count down
        goto    loop1           ;Next Process
        goto    loop            ;Next Period

process1
;****************** bit0 for process1 *******************
        btfss   led_data0,0     ;1x ?
        goto    p10_0x          ;No.
        btfss   led_data1,0     ;11 ?
        goto    p10_10          ;Jump to 10 process
        goto    p10_11          ;Jump to 11 process
p10_0x
        btfsc   led_data1,0     ;01 ?
        goto    p10_01          ;Jump to 01 process

p10_00
        goto    p10_set         ;LED off

p10_01
        btfss   led01,0         ;Data = 1 ?
        goto    p10_clear       ;No.
        goto    p10_set         ;Yes.

p10_10
        btfss   led10,0         ;Data = 1 ?
        goto    p10_clear       ;No.
        goto    p10_set         ;Yes.

p10_11
        btfss   led11,0         ;Data = 1 ?
        goto    p10_clear       ;No.

p10_set
        bsf     port_work,0     ;Set bit0
        goto    bit1_process1
p10_clear
        bcf     port_work,0     ;Clear bit0

bit1_process1
;****************** bit1 for process1 *******************
        btfss   led_data0,1     ;1x ?
        goto    p11_0x          ;No.
        btfss   led_data1,1     ;11 ?
        goto    p11_10          ;Jump to 10 process
        goto    p11_11          ;Jump to 11 process
p11_0x
        btfsc   led_data1,1     ;01 ?
        goto    p11_01          ;Jump to 01 process

p11_00
        goto    p11_set         ;LED off

p11_01
        btfss   led01,0         ;Data = 1 ?
        goto    p11_clear       ;No.
        goto    p11_set         ;Yes.

p11_10
        btfss   led10,0         ;Data = 1 ?
        goto    p11_clear       ;No.
        goto    p11_set         ;Yes.

p11_11
        btfss   led11,0         ;Data = 1 ?
        goto    p11_clear       ;No.

p11_set
        bsf     port_work,1     ;Set bit1
        goto    bit2_process1
p11_clear
        bcf     port_work,1     ;Clear bit1

bit2_process1
;****************** bit2 for process1 *******************
        btfss   led_data0,2     ;1x ?
        goto    p12_0x          ;No.
        btfss   led_data1,2     ;11 ?
        goto    p12_10          ;Jump to 10 process
        goto    p12_11          ;Jump to 11 process
p12_0x
        btfsc   led_data1,2     ;01 ?
        goto    p12_01          ;Jump to 01 process

p12_00
        goto    p12_set         ;LED off

p12_01
        btfss   led01,0         ;Data = 1 ?
        goto    p12_clear       ;No.
        goto    p12_set         ;Yes.

p12_10
        btfss   led10,0         ;Data = 1 ?
        goto    p12_clear       ;No.
        goto    p12_set         ;Yes.

p12_11
        btfss   led11,0         ;Data = 1 ?
        goto    p12_clear       ;No.

p12_set
        bsf     port_work,2     ;Set bit2
        goto    bit3_process1
p12_clear
        bcf     port_work,2     ;Clear bit2

bit3_process1
;****************** bit3 for process1 *******************
        btfss   led_data0,3     ;1x ?
        goto    p13_0x          ;No.
        btfss   led_data1,3     ;11 ?
        goto    p13_10          ;Jump to 10 process
        goto    p13_11          ;Jump to 11 process
p13_0x
        btfsc   led_data1,3     ;01 ?
        goto    p13_01          ;Jump to 01 process

p13_00
        goto    p13_set         ;LED off

p13_01
        btfss   led01,0         ;Data = 1 ?
        goto    p13_clear       ;No.
        goto    p13_set         ;Yes.

p13_10
        btfss   led10,0         ;Data = 1 ?
        goto    p13_clear       ;No.
        goto    p13_set         ;Yes.

p13_11
        btfss   led11,0         ;Data = 1 ?
        goto    p13_clear       ;No.

p13_set
        bsf     port_work,3     ;Set bit3
        goto    bit4_process1
p13_clear
        bcf     port_work,3     ;Clear bit3

bit4_process1
;****************** bit4 for process1 *******************
        btfss   led_data0,4     ;1x ?
        goto    p14_0x          ;No.
        btfss   led_data1,4     ;11 ?
        goto    p14_10          ;Jump to 10 process
        goto    p14_11          ;Jump to 11 process
p14_0x
        btfsc   led_data1,4     ;01 ?
        goto    p14_01          ;Jump to 01 process

p14_00
        goto    p14_set         ;LED off

p14_01
        btfss   led01,0         ;Data = 1 ?
        goto    p14_clear       ;No.
        goto    p14_set         ;Yes.

p14_10
        btfss   led10,0         ;Data = 1 ?
        goto    p14_clear       ;No.
        goto    p14_set         ;Yes.

p14_11
        btfss   led11,0         ;Data = 1 ?
        goto    p14_clear       ;No.

p14_set
        bsf     port_work,4     ;Set bit4
        goto    bit5_process1
p14_clear
        bcf     port_work,4     ;Clear bit4

bit5_process1
;****************** bit5 for process1 *******************
        btfss   led_data0,5     ;1x ?
        goto    p15_0x          ;No.
        btfss   led_data1,5     ;11 ?
        goto    p15_10          ;Jump to 10 process
        goto    p15_11          ;Jump to 11 process
p15_0x
        btfsc   led_data1,5     ;01 ?
        goto    p15_01          ;Jump to 01 process

p15_00
        goto    p15_set         ;LED off

p15_01
        btfss   led01,0         ;Data = 1 ?
        goto    p15_clear       ;No.
        goto    p15_set         ;Yes.

p15_10
        btfss   led10,0         ;Data = 1 ?
        goto    p15_clear       ;No.
        goto    p15_set         ;Yes.

p15_11
        btfss   led11,0         ;Data = 1 ?
        goto    p15_clear       ;No.

p15_set
        bsf     port_work,5     ;Set bit5
        goto    bit6_process1
p15_clear
        bcf     port_work,5     ;Clear bit5

bit6_process1
;****************** bit6 for process1 *******************
        btfss   led_data0,6     ;1x ?
        goto    p16_0x          ;No.
        btfss   led_data1,6     ;11 ?
        goto    p16_10          ;Jump to 10 process
        goto    p16_11          ;Jump to 11 process
p16_0x
        btfsc   led_data1,6     ;01 ?
        goto    p16_01          ;Jump to 01 process

p16_00
        goto    p16_set         ;LED off

p16_01
        btfss   led01,0         ;Data = 1 ?
        goto    p16_clear       ;No.
        goto    p16_set         ;Yes.

p16_10
        btfss   led10,0         ;Data = 1 ?
        goto    p16_clear       ;No.
        goto    p16_set         ;Yes.

p16_11
        btfss   led11,0         ;Data = 1 ?
        goto    p16_clear       ;No.

p16_set
        bsf     port_work,6     ;Set bit6
        goto    bit7_process1
p16_clear
        bcf     port_work,6     ;Clear bit6

bit7_process1
;****************** bit7 for process1 *******************
        btfss   led_data0,7     ;1x ?
        goto    p17_0x          ;No.
        btfss   led_data1,7     ;11 ?
        goto    p17_10          ;Jump to 10 process
        goto    p17_11          ;Jump to 11 process
p17_0x
        btfsc   led_data1,7     ;01 ?
        goto    p17_01          ;Jump to 01 process

p17_00
        goto    p7_set          ;LED off

p17_01
        btfss   led01,0         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p17_10
        btfss   led10,0         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p17_11
        btfss   led11,0         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

process2
;****************** bit0 for process2 *******************
        btfss   led_data0,0     ;1x ?
        goto    p20_0x          ;No.
        btfss   led_data1,0     ;11 ?
        goto    p20_10          ;Jump to 10 process
        goto    p20_11          ;Jump to 11 process
p20_0x
        btfsc   led_data1,0     ;01 ?
        goto    p20_01          ;Jump to 01 process

p20_00
        goto    p20_set         ;LED off

p20_01
        btfss   led01,1         ;Data = 1 ?
        goto    p20_clear       ;No.
        goto    p20_set         ;Yes.

p20_10
        btfss   led10,1         ;Data = 1 ?
        goto    p20_clear       ;No.
        goto    p20_set         ;Yes.

p20_11
        btfss   led11,1         ;Data = 1 ?
        goto    p20_clear       ;No.

p20_set
        bsf     port_work,0     ;Set bit0
        goto    bit1_process2
p20_clear
        bcf     port_work,0     ;Clear bit0

bit1_process2
;****************** bit1 for process2 *******************
        btfss   led_data0,1     ;1x ?
        goto    p21_0x          ;No.
        btfss   led_data1,1     ;11 ?
        goto    p21_10          ;Jump to 10 process
        goto    p21_11          ;Jump to 11 process
p21_0x
        btfsc   led_data1,1     ;01 ?
        goto    p21_01          ;Jump to 01 process

p21_00
        goto    p21_set         ;LED off

p21_01
        btfss   led01,1         ;Data = 1 ?
        goto    p21_clear       ;No.
        goto    p21_set         ;Yes.

p21_10
        btfss   led10,1         ;Data = 1 ?
        goto    p21_clear       ;No.
        goto    p21_set         ;Yes.

p21_11
        btfss   led11,1         ;Data = 1 ?
        goto    p21_clear       ;No.

p21_set
        bsf     port_work,1     ;Set bit1
        goto    bit2_process2
p21_clear
        bcf     port_work,1     ;Clear bit1

bit2_process2
;****************** bit2 for process2 *******************
        btfss   led_data0,2     ;1x ?
        goto    p22_0x          ;No.
        btfss   led_data1,2     ;11 ?
        goto    p22_10          ;Jump to 10 process
        goto    p22_11          ;Jump to 11 process
p22_0x
        btfsc   led_data1,2     ;01 ?
        goto    p22_01          ;Jump to 01 process

p22_00
        goto    p22_set         ;LED off

p22_01
        btfss   led01,1         ;Data = 1 ?
        goto    p22_clear       ;No.
        goto    p22_set         ;Yes.

p22_10
        btfss   led10,1         ;Data = 1 ?
        goto    p22_clear       ;No.
        goto    p22_set         ;Yes.

p22_11
        btfss   led11,1         ;Data = 1 ?
        goto    p22_clear       ;No.

p22_set
        bsf     port_work,2     ;Set bit2
        goto    bit3_process2
p22_clear
        bcf     port_work,2     ;Clear bit2

bit3_process2
;****************** bit3 for process2 *******************
        btfss   led_data0,3     ;1x ?
        goto    p23_0x          ;No.
        btfss   led_data1,3     ;11 ?
        goto    p23_10          ;Jump to 10 process
        goto    p23_11          ;Jump to 11 process
p23_0x
        btfsc   led_data1,3     ;01 ?
        goto    p23_01          ;Jump to 01 process

p23_00
        goto    p23_set         ;LED off

p23_01
        btfss   led01,1         ;Data = 1 ?
        goto    p23_clear       ;No.
        goto    p23_set         ;Yes.

p23_10
        btfss   led10,1         ;Data = 1 ?
        goto    p23_clear       ;No.
        goto    p23_set         ;Yes.

p23_11
        btfss   led11,1         ;Data = 1 ?
        goto    p23_clear       ;No.

p23_set
        bsf     port_work,3     ;Set bit3
        goto    bit4_process2
p23_clear
        bcf     port_work,3     ;Clear bit3

bit4_process2
;****************** bit4 for process2 *******************
        btfss   led_data0,4     ;1x ?
        goto    p24_0x          ;No.
        btfss   led_data1,4     ;11 ?
        goto    p24_10          ;Jump to 10 process
        goto    p24_11          ;Jump to 11 process
p24_0x
        btfsc   led_data1,4     ;01 ?
        goto    p24_01          ;Jump to 01 process

p24_00
        goto    p24_set         ;LED off

p24_01
        btfss   led01,1         ;Data = 1 ?
        goto    p24_clear       ;No.
        goto    p24_set         ;Yes.

p24_10
        btfss   led10,1         ;Data = 1 ?
        goto    p24_clear       ;No.
        goto    p24_set         ;Yes.

p24_11
        btfss   led11,1         ;Data = 1 ?
        goto    p24_clear       ;No.

p24_set
        bsf     port_work,4     ;Set bit4
        goto    bit5_process2
p24_clear
        bcf     port_work,4     ;Clear bit4

bit5_process2
;****************** bit5 for process2 *******************
        btfss   led_data0,5     ;1x ?
        goto    p25_0x          ;No.
        btfss   led_data1,5     ;11 ?
        goto    p25_10          ;Jump to 10 process
        goto    p25_11          ;Jump to 11 process
p25_0x
        btfsc   led_data1,5     ;01 ?
        goto    p25_01          ;Jump to 01 process

p25_00
        goto    p25_set         ;LED off

p25_01
        btfss   led01,1         ;Data = 1 ?
        goto    p25_clear       ;No.
        goto    p25_set         ;Yes.

p25_10
        btfss   led10,1         ;Data = 1 ?
        goto    p25_clear       ;No.
        goto    p25_set         ;Yes.

p25_11
        btfss   led11,1         ;Data = 1 ?
        goto    p25_clear       ;No.

p25_set
        bsf     port_work,5     ;Set bit5
        goto    bit6_process2
p25_clear
        bcf     port_work,5     ;Clear bit5

bit6_process2
;****************** bit6 for process2 *******************
        btfss   led_data0,6     ;1x ?
        goto    p26_0x          ;No.
        btfss   led_data1,6     ;11 ?
        goto    p26_10          ;Jump to 10 process
        goto    p26_11          ;Jump to 11 process
p26_0x
        btfsc   led_data1,6     ;01 ?
        goto    p26_01          ;Jump to 01 process

p26_00
        goto    p26_set         ;LED off
p26_01
        btfss   led01,1         ;Data = 1 ?
        goto    p26_clear       ;No.
        goto    p26_set         ;Yes.

p26_10
        btfss   led10,1         ;Data = 1 ?
        goto    p26_clear       ;No.
        goto    p26_set         ;Yes.

p26_11
        btfss   led11,1         ;Data = 1 ?
        goto    p26_clear       ;No.

p26_set
        bsf     port_work,6     ;Set bit6
        goto    bit7_process2
p26_clear
        bcf     port_work,6     ;Clear bit6

bit7_process2
;****************** bit7 for process2 *******************
        btfss   led_data0,7     ;1x ?
        goto    p27_0x          ;No.
        btfss   led_data1,7     ;11 ?
        goto    p27_10          ;Jump to 10 process
        goto    p27_11          ;Jump to 11 process
p27_0x
        btfsc   led_data1,7     ;01 ?
        goto    p27_01          ;Jump to 01 process

p27_00
        goto    p7_set          ;LED off

p27_01
        btfss   led01,1         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p27_10
        btfss   led10,1         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p27_11
        btfss   led11,1         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

process3
;****************** bit0 for process3 *******************
        btfss   led_data0,0     ;1x ?
        goto    p30_0x          ;No.
        btfss   led_data1,0     ;11 ?
        goto    p30_10          ;Jump to 10 process
        goto    p30_11          ;Jump to 11 process
p30_0x
        btfsc   led_data1,0     ;01 ?
        goto    p30_01          ;Jump to 01 process

p30_00
        goto    p30_set         ;LED off

p30_01
        btfss   led01,2         ;Data = 1 ?
        goto    p30_clear       ;No.
        goto    p30_set         ;Yes.

p30_10
        btfss   led10,2         ;Data = 1 ?
        goto    p30_clear       ;No.
        goto    p30_set         ;Yes.

p30_11
        btfss   led11,2         ;Data = 1 ?
        goto    p30_clear       ;No.

p30_set
        bsf     port_work,0     ;Set bit0
        goto    bit1_process3
p30_clear
        bcf     port_work,0     ;Clear bit0

bit1_process3
;****************** bit1 for process3 *******************
        btfss   led_data0,1     ;1x ?
        goto    p31_0x          ;No.
        btfss   led_data1,1     ;11 ?
        goto    p31_10          ;Jump to 10 process
        goto    p31_11          ;Jump to 11 process
p31_0x
        btfsc   led_data1,1     ;01 ?
        goto    p31_01          ;Jump to 01 process

p31_00
        goto    p31_set         ;LED off

p31_01
        btfss   led01,2         ;Data = 1 ?
        goto    p31_clear       ;No.
        goto    p31_set         ;Yes.

p31_10
        btfss   led10,2         ;Data = 1 ?
        goto    p31_clear       ;No.
        goto    p31_set         ;Yes.

p31_11
        btfss   led11,2         ;Data = 1 ?
        goto    p31_clear       ;No.

p31_set
        bsf     port_work,1     ;Set bit1
        goto    bit2_process3
p31_clear
        bcf     port_work,1     ;Clear bit1

bit2_process3
;****************** bit2 for process3 *******************
        btfss   led_data0,2     ;1x ?
        goto    p32_0x          ;No.
        btfss   led_data1,2     ;11 ?
        goto    p32_10          ;Jump to 10 process
        goto    p32_11          ;Jump to 11 process
p32_0x
        btfsc   led_data1,2     ;01 ?
        goto    p32_01          ;Jump to 01 process

p32_00
        goto    p32_set         ;LED off

p32_01
        btfss   led01,2         ;Data = 1 ?
        goto    p32_clear       ;No.
        goto    p32_set         ;Yes.

p32_10
        btfss   led10,2         ;Data = 1 ?
        goto    p32_clear       ;No.
        goto    p32_set         ;Yes.

p32_11
        btfss   led11,2         ;Data = 1 ?
        goto    p32_clear       ;No.

p32_set
        bsf     port_work,2     ;Set bit2
        goto    bit3_process3
p32_clear
        bcf     port_work,2     ;Clear bit2

bit3_process3
;****************** bit3 for process3 *******************
        btfss   led_data0,3     ;1x ?
        goto    p33_0x          ;No.
        btfss   led_data1,3     ;11 ?
        goto    p33_10          ;Jump to 10 process
        goto    p33_11          ;Jump to 11 process
p33_0x
        btfsc   led_data1,3     ;01 ?
        goto    p33_01          ;Jump to 01 process

p33_00
        goto    p33_set         ;LED off

p33_01
        btfss   led01,2         ;Data = 1 ?
        goto    p33_clear       ;No.
        goto    p33_set         ;Yes.

p33_10
        btfss   led10,2         ;Data = 1 ?
        goto    p33_clear       ;No.
        goto    p33_set         ;Yes.

p33_11
        btfss   led11,2         ;Data = 1 ?
        goto    p33_clear       ;No.

p33_set
        bsf     port_work,3     ;Set bit3
        goto    bit4_process3
p33_clear
        bcf     port_work,3     ;Clear bit3

bit4_process3
;****************** bit4 for process3 *******************
        btfss   led_data0,4     ;1x ?
        goto    p34_0x          ;No.
        btfss   led_data1,4     ;11 ?
        goto    p34_10          ;Jump to 10 process
        goto    p34_11          ;Jump to 11 process
p34_0x
        btfsc   led_data1,4     ;01 ?
        goto    p34_01          ;Jump to 01 process

p34_00
        goto    p34_set         ;LED off

p34_01
        btfss   led01,2         ;Data = 1 ?
        goto    p34_clear       ;No.
        goto    p34_set         ;Yes.

p34_10
        btfss   led10,2         ;Data = 1 ?
        goto    p34_clear       ;No.
        goto    p34_set         ;Yes.

p34_11
        btfss   led11,2         ;Data = 1 ?
        goto    p34_clear       ;No.

p34_set
        bsf     port_work,4     ;Set bit4
        goto    bit5_process3
p34_clear
        bcf     port_work,4     ;Clear bit4

bit5_process3
;****************** bit5 for process3 *******************
        btfss   led_data0,5     ;1x ?
        goto    p35_0x          ;No.
        btfss   led_data1,5     ;11 ?
        goto    p35_10          ;Jump to 10 process
        goto    p35_11          ;Jump to 11 process
p35_0x
        btfsc   led_data1,5     ;01 ?
        goto    p35_01          ;Jump to 01 process

p35_00
        goto    p35_set         ;LED off

p35_01
        btfss   led01,2         ;Data = 1 ?
        goto    p35_clear       ;No.
        goto    p35_set         ;Yes.

p35_10
        btfss   led10,2         ;Data = 1 ?
        goto    p35_clear       ;No.
        goto    p35_set         ;Yes.

p35_11
        btfss   led11,2         ;Data = 1 ?
        goto    p35_clear       ;No.

p35_set
        bsf     port_work,5     ;Set bit5
        goto    bit6_process3
p35_clear
        bcf     port_work,5     ;Clear bit5

bit6_process3
;****************** bit6 for process3 *******************
        btfss   led_data0,6     ;1x ?
        goto    p36_0x          ;No.
        btfss   led_data1,6     ;11 ?
        goto    p36_10          ;Jump to 10 process
        goto    p36_11          ;Jump to 11 process
p36_0x
        btfsc   led_data1,6     ;01 ?
        goto    p36_01          ;Jump to 01 process

p36_00
        goto    p36_set         ;LED off

p36_01
        btfss   led01,2         ;Data = 1 ?
        goto    p36_clear       ;No.
        goto    p36_set         ;Yes.

p36_10
        btfss   led10,2         ;Data = 1 ?
        goto    p36_clear       ;No.
        goto    p36_set         ;Yes.

p36_11
        btfss   led11,2         ;Data = 1 ?
        goto    p36_clear       ;No.

p36_set
        bsf     port_work,6     ;Set bit6
        goto    bit7_process3
p36_clear
        bcf     port_work,6     ;Clear bit6

bit7_process3
;****************** bit7 for process3 *******************
        btfss   led_data0,7     ;1x ?
        goto    p37_0x          ;No.
        btfss   led_data1,7     ;11 ?
        goto    p37_10          ;Jump to 10 process
        goto    p37_11          ;Jump to 11 process
p37_0x
        btfsc   led_data1,7     ;01 ?
        goto    p37_01          ;Jump to 01 process

p37_00
        goto    p7_set          ;LED off
p37_01
        btfss   led01,2         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p37_10
        btfss   led10,2         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p37_11
        btfss   led11,2         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

process4
;****************** bit0 for process4 *******************
        btfss   led_data0,0     ;1x ?
        goto    p40_0x          ;No.
        btfss   led_data1,0     ;11 ?
        goto    p40_10          ;Jump to 10 process
        goto    p40_11          ;Jump to 11 process
p40_0x
        btfsc   led_data1,0     ;01 ?
        goto    p40_01          ;Jump to 01 process

p40_00
        goto    p40_set         ;LED off

p40_01
        btfss   led01,3         ;Data = 1 ?
        goto    p40_clear       ;No.
        goto    p40_set         ;Yes.

p40_10
        btfss   led10,3         ;Data = 1 ?
        goto    p40_clear       ;No.
        goto    p40_set         ;Yes.

p40_11
        btfss   led11,3         ;Data = 1 ?
        goto    p40_clear       ;No.

p40_set
        bsf     port_work,0     ;Set bit0
        goto    bit1_process4
p40_clear
        bcf     port_work,0     ;Clear bit0

bit1_process4
;****************** bit1 for process4 *******************
        btfss   led_data0,1     ;1x ?
        goto    p41_0x          ;No.
        btfss   led_data1,1     ;11 ?
        goto    p41_10          ;Jump to 10 process
        goto    p41_11          ;Jump to 11 process
p41_0x
        btfsc   led_data1,1     ;01 ?
        goto    p41_01          ;Jump to 01 process

p41_00
        goto    p41_set         ;LED off

p41_01
        btfss   led01,3         ;Data = 1 ?
        goto    p41_clear       ;No.
        goto    p41_set         ;Yes.

p41_10
        btfss   led10,3         ;Data = 1 ?
        goto    p41_clear       ;No.
        goto    p41_set         ;Yes.

p41_11
        btfss   led11,3         ;Data = 1 ?
        goto    p41_clear       ;No.

p41_set
        bsf     port_work,1     ;Set bit1
        goto    bit2_process4
p41_clear
        bcf     port_work,1     ;Clear bit1

bit2_process4
;****************** bit2 for process4 *******************
        btfss   led_data0,2     ;1x ?
        goto    p42_0x          ;No.
        btfss   led_data1,2     ;11 ?
        goto    p42_10          ;Jump to 10 process
        goto    p42_11          ;Jump to 11 process
p42_0x
        btfsc   led_data1,2     ;01 ?
        goto    p42_01          ;Jump to 01 process

p42_00
        goto    p42_set         ;LED off

p42_01
        btfss   led01,3         ;Data = 1 ?
        goto    p42_clear       ;No.
        goto    p42_set         ;Yes.

p42_10
        btfss   led10,3         ;Data = 1 ?
        goto    p42_clear       ;No.
        goto    p42_set         ;Yes.

p42_11
        btfss   led11,3         ;Data = 1 ?
        goto    p42_clear       ;No.

p42_set
        bsf     port_work,2     ;Set bit2
        goto    bit3_process4
p42_clear
        bcf     port_work,2     ;Clear bit2

bit3_process4
;****************** bit3 for process4 *******************
        btfss   led_data0,3     ;1x ?
        goto    p43_0x          ;No.
        btfss   led_data1,3     ;11 ?
        goto    p43_10          ;Jump to 10 process
        goto    p43_11          ;Jump to 11 process
p43_0x
        btfsc   led_data1,3     ;01 ?
        goto    p43_01          ;Jump to 01 process

p43_00
        goto    p43_set         ;LED off

p43_01
        btfss   led01,3         ;Data = 1 ?
        goto    p43_clear       ;No.
        goto    p43_set         ;Yes.

p43_10
        btfss   led10,3         ;Data = 1 ?
        goto    p43_clear       ;No.
        goto    p43_set         ;Yes.

p43_11
        btfss   led11,3         ;Data = 1 ?
        goto    p43_clear       ;No.

p43_set
        bsf     port_work,3     ;Set bit3
        goto    bit4_process4
p43_clear
        bcf     port_work,3     ;Clear bit3

bit4_process4
;****************** bit4 for process4 *******************
        btfss   led_data0,4     ;1x ?
        goto    p44_0x          ;No.
        btfss   led_data1,4     ;11 ?
        goto    p44_10          ;Jump to 10 process
        goto    p44_11          ;Jump to 11 process
p44_0x
        btfsc   led_data1,4     ;01 ?
        goto    p44_01          ;Jump to 01 process

p44_00
        goto    p44_set         ;LED off

p44_01
        btfss   led01,3         ;Data = 1 ?
        goto    p44_clear       ;No.
        goto    p44_set         ;Yes.

p44_10
        btfss   led10,3         ;Data = 1 ?
        goto    p44_clear       ;No.
        goto    p44_set         ;Yes.

p44_11
        btfss   led11,3         ;Data = 1 ?
        goto    p44_clear       ;No.

p44_set
        bsf     port_work,4     ;Set bit4
        goto    bit5_process4
p44_clear
        bcf     port_work,4     ;Clear bit4

bit5_process4
;****************** bit5 for process4 *******************
        btfss   led_data0,5     ;1x ?
        goto    p45_0x          ;No.
        btfss   led_data1,5     ;11 ?
        goto    p45_10          ;Jump to 10 process
        goto    p45_11          ;Jump to 11 process
p45_0x
        btfsc   led_data1,5     ;01 ?
        goto    p45_01          ;Jump to 01 process

p45_00
        goto    p45_set         ;LED off

p45_01
        btfss   led01,3         ;Data = 1 ?
        goto    p45_clear       ;No.
        goto    p45_set         ;Yes.

p45_10
        btfss   led10,3         ;Data = 1 ?
        goto    p45_clear       ;No.
        goto    p45_set         ;Yes.

p45_11
        btfss   led11,3         ;Data = 1 ?
        goto    p45_clear       ;No.

p45_set
        bsf     port_work,5     ;Set bit5
        goto    bit6_process4
p45_clear
        bcf     port_work,5     ;Clear bit5

bit6_process4
;****************** bit6 for process4 *******************
        btfss   led_data0,6     ;1x ?
        goto    p46_0x          ;No.
        btfss   led_data1,6     ;11 ?
        goto    p46_10          ;Jump to 10 process
        goto    p46_11          ;Jump to 11 process
p46_0x
        btfsc   led_data1,6     ;01 ?
        goto    p46_01          ;Jump to 01 process

p46_00
        goto    p46_set         ;LED off

p46_01
        btfss   led01,3         ;Data = 1 ?
        goto    p46_clear       ;No.
        goto    p46_set         ;Yes.

p46_10
        btfss   led10,3         ;Data = 1 ?
        goto    p46_clear       ;No.
        goto    p46_set         ;Yes.

p46_11
        btfss   led11,3         ;Data = 1 ?
        goto    p46_clear       ;No.

p46_set
        bsf     port_work,6     ;Set bit6
        goto    bit7_process4
p46_clear
        bcf     port_work,6     ;Clear bit6

bit7_process4
;****************** bit7 for process4 *******************
        btfss   led_data0,7     ;1x ?
        goto    p47_0x          ;No.
        btfss   led_data1,7     ;11 ?
        goto    p47_10          ;Jump to 10 process
        goto    p47_11          ;Jump to 11 process
p47_0x
        btfsc   led_data1,7     ;01 ?
        goto    p47_01          ;Jump to 01 process

p47_00
        goto    p7_set          ;LED off

p47_01
        btfss   led01,3         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p47_10
        btfss   led10,3         ;Data = 1 ?
        goto    p7_clear        ;No.
        goto    p7_set          ;Yes.

p47_11
        btfss   led11,3         ;Data = 1 ?
        goto    p7_clear        ;No.

p7_set
        bsf     port_work,7     ;Set bit7
        goto    led_cont
p7_clear
        bcf     port_work,7     ;Clear bit7
        goto    led_cont

int
;**********  Interruption process beginning *************
        movwf   w_save          ;Save W register
        movfw   status          ;Read STATUS reg
        movwf   s_save          ;Save STATUS reg
        btfsc   intcon,t0if     ;Time out interruption ?
        goto    timer_int       ;Jump to Time-out
        goto    init            ;Reset(Illegal interrupt)

int_end
;************  END of interruption process **************
        movfw   s_save          ;Read saved STATUS reg
        movwf   status          ;Recover STATUS reg
        swapf   w_save,f        ;Read saved W register
        swapf   w_save,w        ;Recover W register
        retfie

timer_int
;*****  Timer interruption process (50ms interval) ******
        bcf     intcon,t0if     ;Clear timer int flag
        movlw   d'61'           ;Set timer value
        movwf   tmr0            ;TMR0 = 50ms

;******************  Key Scan Process *******************
        btfsc   porta,ra0       ;RA0 ON(Low lebel) ?
        goto    key0            ;No.
        movlw   d'2'            ;Set pattern 1 data
        goto    key2            ;Pattern exec
key0
        btfsc   porta,ra1       ;RA1 ON ?
        goto    key1            ;No.
        movlw   d'1'            ;Set pattern 0 data
        goto    key2            ;Pattern exec
key1
        btfsc   porta,ra2       ;RA2 ON ?
        goto    key3            ;No.
        movlw   d'3'            ;Set pattern 2 data
key2
        movwf   ptn_save        ;Save pattern
key3
        decfsz  counter,f       ;Count out ?
        goto    int_end         ;Next Period

;*****************  Pattern Process *********************
        movlw   speed           ;Read speed data
        addlw   d'1'            ;+1 addition
        movwf   counter         ;Set counter
        movlw   d'1'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfsc   status,z        ;Pattern 0 ?
        goto    ptn0            ;Jump to pattern 0
        movlw   d'2'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfsc   status,z        ;Pattern 1 ?
        goto    ptn1            ;Jump to pattern 1
        movlw   d'3'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfsc   status,z        ;Pattern 2 ?
        goto    ptn2            ;Jump to pattern 2

ptn0
;*********************  Pattren 0 ***********************
        movlw   d'1'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfss   status,z        ;Same ?
ptn0_clear
        clrf    ptn_counter     ;Clear pattern counter
ptn0_head
        movlw   d'1'            ;Set pattern number
        movwf   ptn_save        ;Save pattern number
        movfw   ptn_counter     ;Read pattern counter
        btfsc   status,z        ;Counter = 0 ?
        goto    ptn0_0          ;Yes
        movlw   d'1'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 1 ?
        goto    ptn0_1          ;Yes
        movlw   d'2'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 2 ?
        goto    ptn0_2          ;Yes
        movlw   d'3'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 3 ?
        goto    ptn0_3          ;Yes
        movlw   d'4'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 4 ?
        goto    ptn0_4          ;Yes
        movlw   d'5'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 5 ?
        goto    ptn0_5          ;Yes
        movlw   d'6'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 6 ?
        goto    ptn0_6          ;Yes
        movlw   d'7'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 7 ?
        goto    ptn0_7          ;Yes
        movlw   d'8'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 8 ?
        goto    ptn0_8          ;Yes
        movlw   d'9'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 9 ?
        goto    ptn0_9          ;Yes
        movlw   d'10'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 10 ?
        goto    ptn0_10         ;Yes
        goto    ptn0_clear      ;Repeat

ptn0_0
        clrf    led_data0
        clrf    led_data1
        goto    p_countup       ;Jump to count up
ptn0_1
        movlw   p010            ;Set 1st upper data
        movwf   led_data0
        movlw   p011            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_2
        movlw   p020            ;Set 1st upper data
        movwf   led_data0
        movlw   p021            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_3
        movlw   p030            ;Set 1st upper data
        movwf   led_data0
        movlw   p031            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_4
        movlw   p040            ;Set 1st upper data
        movwf   led_data0
        movlw   p041            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_5
        movlw   p050            ;Set 1st upper data
        movwf   led_data0
        movlw   p051            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_6
        movlw   p060            ;Set 1st upper data
        movwf   led_data0
        movlw   p061            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_7
        movlw   p070            ;Set 1st upper data
        movwf   led_data0
        movlw   p071            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_8
        movlw   p080            ;Set 1st upper data
        movwf   led_data0
        movlw   p081            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_9
        movlw   p090            ;Set 1st upper data
        movwf   led_data0
        movlw   p091            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn0_10
        movlw   p0a0            ;Set 1st upper data
        movwf   led_data0
        movlw   p0a1            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up

ptn1
;*********************  Pattren 1 ***********************
        movlw   d'2'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfss   status,z        ;Same ?
ptn1_clear
        clrf    ptn_counter     ;Clear pattern counter
ptn1_head
        movlw   d'2'            ;Set pattern number
        movwf   ptn_save        ;Save pattern number
        movfw   ptn_counter     ;Read pattern counter
        btfsc   status,z        ;Counter = 0 ?
        goto    ptn1_0          ;Yes
        movlw   d'1'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 1 ?
        goto    ptn1_1          ;Yes
        movlw   d'2'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 2 ?
        goto    ptn1_2          ;Yes
        movlw   d'3'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 3 ?
        goto    ptn1_3          ;Yes
        movlw   d'4'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 4 ?
        goto    ptn1_4          ;Yes
        movlw   d'5'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 5 ?
        goto    ptn1_5          ;Yes
        movlw   d'6'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 6 ?
        goto    ptn1_6          ;Yes
        movlw   d'7'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 7 ?
        goto    ptn1_7          ;Yes
        movlw   d'8'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 8 ?
        goto    ptn1_8          ;Yes
        movlw   d'9'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 9 ?
        goto    ptn1_9          ;Yes
        movlw   d'10'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 10 ?
        goto    ptn1_10         ;Yes
        goto    ptn1_clear      ;Repeat

ptn1_0
        clrf    led_data0
        clrf    led_data1
        goto    p_countup       ;Jump to count up
ptn1_1
        movlw   p110            ;Set 1st upper data
        movwf   led_data0
        movlw   p111            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_2
        movlw   p120            ;Set 1st upper data
        movwf   led_data0
        movlw   p121            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_3
        movlw   p130            ;Set 1st upper data
        movwf   led_data0
        movlw   p131            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_4
        movlw   p140            ;Set 1st upper data
        movwf   led_data0
        movlw   p141            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_5
        movlw   p150            ;Set 1st upper data
        movwf   led_data0
        movlw   p151            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_6
        movlw   p160            ;Set 1st upper data
        movwf   led_data0
        movlw   p161            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_7
        movlw   p170            ;Set 1st upper data
        movwf   led_data0
        movlw   p171            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_8
        movlw   p180            ;Set 1st upper data
        movwf   led_data0
        movlw   p181            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_9
        movlw   p190            ;Set 1st upper data
        movwf   led_data0
        movlw   p191            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn1_10
        movlw   p1a0            ;Set 1st upper data
        movwf   led_data0
        movlw   p1a1            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up

ptn2
;*********************  Pattren 2 ***********************
        movlw   d'3'            ;Set pattern number
        subwf   ptn_save,w      ;Check pattern number
        btfss   status,z        ;Same ?
ptn2_clear
        clrf    ptn_counter     ;Clear pattern counter
ptn2_head
        movlw   d'3'            ;Set pattern number
        movwf   ptn_save        ;Save pattern number
        movfw   ptn_counter     ;Read pattern counter
        btfsc   status,z        ;Counter = 0 ?
        goto    ptn2_0          ;Yes
        movlw   d'1'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 1 ?
        goto    ptn2_1          ;Yes
        movlw   d'2'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 2 ?
        goto    ptn2_2          ;Yes
        movlw   d'3'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 3 ?
        goto    ptn2_3          ;Yes
        movlw   d'4'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 4 ?
        goto    ptn2_4          ;Yes
        movlw   d'5'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 5 ?
        goto    ptn2_5          ;Yes
        movlw   d'6'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 6 ?
        goto    ptn2_6          ;Yes
        movlw   d'7'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 7 ?
        goto    ptn2_7          ;Yes
        movlw   d'8'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 8 ?
        goto    ptn2_8          ;Yes
        movlw   d'9'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 9 ?
        goto    ptn2_9          ;Yes
        movlw   d'10'            ;Set check data
        subwf   ptn_counter,w   ;Check counter
        btfsc   status,z        ;Counter = 10 ?
        goto    ptn2_10         ;Yes
        goto    ptn2_clear      ;Repeat

ptn2_0
        clrf    led_data0
        clrf    led_data1
        goto    p_countup       ;Jump to count up
ptn2_1
        movlw   p210            ;Set 1st upper data
        movwf   led_data0
        movlw   p211            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_2
        movlw   p220            ;Set 1st upper data
        movwf   led_data0
        movlw   p221            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_3
        movlw   p230            ;Set 1st upper data
        movwf   led_data0
        movlw   p231            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_4
        movlw   p240            ;Set 1st upper data
        movwf   led_data0
        movlw   p241            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_5
        movlw   p250            ;Set 1st upper data
        movwf   led_data0
        movlw   p251            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_6
        movlw   p260            ;Set 1st upper data
        movwf   led_data0
        movlw   p261            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_7
        movlw   p270            ;Set 1st upper data
        movwf   led_data0
        movlw   p271            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_8
        movlw   p280            ;Set 1st upper data
        movwf   led_data0
        movlw   p281            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_9
        movlw   p290            ;Set 1st upper data
        movwf   led_data0
        movlw   p291            ;Set 1st lower data
        movwf   led_data1
        goto    p_countup       ;Jump to count up
ptn2_10
        movlw   p2a0            ;Set 1st upper data
        movwf   led_data0
        movlw   p2a1            ;Set 1st lower data
        movwf   led_data1

p_countup
        incf    ptn_counter,f   ;pattern counter count up
        goto    int_end         ;Next Period

;********************************************************
;          END of LED flash control 2 process
;********************************************************

        end
