LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

#define         LcdRefresh PrgStatus,0 ;ha 1, akkor a kijelzt frissteni kell

GLOBAL          PrgNameWrite, PrgNameWrite2, ADNumLcd

EXTERN          PrgStatus
EXTERN          PrgBanks, ADVal, ADMsgPtr, ADBanks, ADChns
EXTERN          CurPos, WriteChar, Num, WriteTableStr
EXTERN          WriteByte1, WriteByte2, WriteByte3    ; 1 bjtos eljel nlkl
EXTERN          WriteShort1, WriteShort2, WriteShort3 ; 1 bjtos eljeles
EXTERN          WriteWord3, WriteWord4, WriteWord5    ; 2 bjtos eljel nlkl
EXTERN          WriteInt3, WriteInt4, WriteInt5       ; 2 bjtos eljeles

UDATA_ACS
  ADNumLcd      RES     1    ; programkirsnl ehhez a potenciomterhez szma
  Temp          RES     1    ; tmeneti trolshoz

CODE

;==============================================================================
; LCD re egy A/D-hez tartoz zenet nevt s paramtereit
; be: W - A/D talakt szma (0..7)
PrgNameWrite    movwf   ADNumLcd
                lfsrw   1, ADMsgPtr, ADNumLcd
                movff   POSTINC1, TBLPTRL
                movff   POSTDEC1, TBLPTRH
                tblrd   *+
                tblrd   *+
                tblrd   *+
                bcf     STATUS, C
                rlcf    TABLAT, W                 ; zenet adatainak hossza
                tblrd   *+
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f

; ha nem kell a programmemria tblzat cmt kiszmtani itt indulhat
PrgNameWrite2   movlw    .16
                movwf   CurPos

PrgNameLoop     tblrd   *+

                movf    TABLAT, W
                bz      LcdEnd                    ; #0 karakter a szveg vge

                movf    TABLAT, W
                addlw   0x10
                bc      LcdCmd

                movf    TABLAT, W
                call    WriteChar
                bra     PrgNameLoop

; bank nevnek kirsa a fels sorba
LcdEnd          ltblptr PrgBanks
                lfsrb   1, ADBanks, ADNumLcd
                bcf     STATUS, C
                rlcf    INDF1, W
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f
                tblrd   *+
                movf    TABLAT, W
                tblrd   *+
                movff   TABLAT, TBLPTRH
                movwf   TBLPTRL
                
; TBLPTR = kivlaszott bank szvege
                tblrd   *
                rlcf    TABLAT, W
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f
                
                clrf    CurPos
                call    WriteTableStr
                bsf     LcdRefresh
                return

; vezrlkarakter (F0..FF -> 00..0F) szerinti elgazs
LcdCmd          bcf     STATUS, C
                movff   PCL, Temp
                rlcf    WREG, W
                addwf   PCL, f
                bra     LcdMF0                    ; potenciomter szma
                bra     LcdMF1                    ; csatorna szma
                bra     LcdMF2                    ; A/D eredmny eljel nlkli 7 bites (0..127)
                bra     LcdMF3                    ; A/D eredmny eljeles 7 bites (-64..63)
                bra     LcdMF4                    ; A/D eredmny eljel nlkli 14 bites (0..16383)
                bra     LcdMF5                    ; A/D eredmny eljeles 14 bites (-8192..8191)
                bra     LcdMF6                    ; A/D eredmny ktllapot (off, on)
; ezek a parancskdok jelenleg nincsenek hasznlva, nem csinl semmit (hurok elejre vissza)
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; potenciomter szma
LcdMF0          movf    ADNumLcd, W
                addlw   '1'
                call    WriteChar
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; csatorna szm
LcdMF1          lfsrb   1, ADChns, ADNumLcd
                incf    INDF1, W
                call    WriteByte2
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; A/D eredmny eljel nlkli 7 bites (0..127)
LcdMF2          lfsrw   1, ADVal, ADNumLcd
                movff   POSTINC1, Temp             ; lo
                rrcf    INDF1, W                   ; hi
                rrcf    Temp, f
                rrcf    INDF1, W                   ; hi
                rrcf    WREG, W
                rrcf    Temp, f
                bcf     STATUS, C
                rrcf    Temp, W
                call    WriteByte3
                bra     PrgNameLoop
                
;------------------------------------------------------------------------------
; A/D eredmny eljeles 7 bites (-64..63)
LcdMF3          lfsrw   1, ADVal, ADNumLcd
                movff   POSTINC1, Temp             ; lo
                rrcf    INDF1, W                   ; hi
                rrcf    Temp, f
                rrcf    INDF1, W                   ; hi
                rrcf    WREG, W
                rrcf    Temp, f
                bcf     STATUS, C
                rrcf    Temp, W
                addlw   -.64
                call    WriteShort2
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; A/D eredmny eljel nlkli 14 bites (0..16383)
LcdMF4          lfsrw   1, ADVal, ADNumLcd
                swapf   INDF1, W
                andlw   0xF0
                movwf   Num
                swapf   POSTINC1, W
                andlw   0x0F
                movwf   Num + 1
                swapf   INDF1, W
                andlw   0xF0
                iorwf   Num + 1, f
                call    WriteWord5
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; A/D eredmny eljeles 14 bites (-8192..8191)
LcdMF5          lfsrw   1, ADVal, ADNumLcd
                swapf   INDF1, W
                andlw   0xF0
                movwf   Num
                swapf   POSTINC1, W
                andlw   0x0F
                movwf   Num + 1
                swapf   INDF1, W
                andlw   0xF0
                iorwf   Num + 1, f
                movlw   HIGH .8192
                subwf   Num + 1, f
                call    WriteInt4
                bra     PrgNameLoop

;------------------------------------------------------------------------------
; A/D eredmny ktllapot (off, on)
; On/Off szveg rdik ki az A/D rtk legnagyobb helyirtltl fggen
LcdMF6          lfsrw   1, ADVal, ADNumLcd
                btfsc   PREINC1, 1
                bra     LcdMF6on
                movlw   'o'
                call    WriteChar
                movlw   'f'
                call    WriteChar
                movlw   'f'
                call    WriteChar
                bra     PrgNameLoop

LcdMF6on        movlw   ' '
                call    WriteChar
                movlw   'o'
                call    WriteChar
                movlw   'n'
                call    WriteChar
                bra     PrgNameLoop

END
