LIST P=18F4550, F=INHX32
#include <P18F4550.INC>

GLOBAL  FifoInit           ; Fifo inicialilsa
GLOBAL  FifoWrite          ; Fifo-ba egy byte bersa W-bl, ha tele van C=1 el jelzi
GLOBAL  FifoRead           ; Fifo-bl egy byte olvassa W-be, ha res C=1 el jelzi
GLOBAL  FifoLength         ; ennyi elem van ppen benne
GLOBAL  FifoFree           ; ennyi szabad hely van pp benne

UDATA_ACS
  FifoStart     RES  1     ; Ez mondja meg hogy a tmbben hol tallhat a cs eleje
  FifoLength    RES  1     ; Ennyi elem van most benne
  FifoFree      RES  1     ; Ennyi hely van mg benne
  FifoTemp      RES  1     ; tmeneti tr

FifoBank        UDATA  0x0300
  FifoArray     RES  .128  ; 128 bjt hossz a kimeneti puffer
  FifoSize      EQU  .128  ; Puffer mrete

                CODE
;-----------------------------------------------------------------
; Fifo inicialilsa
FifoInit        clrf    FifoStart                 ; eleje = 0
                clrf    FifoLength                ; hossza = 0
                movlw   FifoSize
                movwf   FifoFree                  ; sazabad hely = teljes mret
                return

;-----------------------------------------------------------------
; egy bjt rsa FIFO trolba
; ha tele van C = 1 visszatr rtkkel jelzi
FifoWrite       movwf   FifoTemp
                movf    FifoFree, W
                bsf     STATUS, C                 ; megtelet ?
                btfsc   STATUS, Z
                return                            ; igen megtelt -> C = 1

                lfsr    2, FifoArray
                movf    FifoStart, W
                addwf   FSR2L, f
                movff   FifoTemp, INDF2           ; adat a tmbbe
                incf    FifoLength, f             ; cshoszz nvelse
                decf    FifoFree, f               ; szabad hely cskkentse
                movf    FifoStart, f
                addlw   -1
                andlw   FifoSize - 1
                movwf   FifoStart                 ; cs eleje htra 1-el
                bcf     STATUS, C                 ; rendben jelzs
                return

;-----------------------------------------------------------------
; egy bjt olvassa Fifo trolbl
; olvasott bjt -> W
; ha res -> C = 1
FifoRead        movf    FifoLength, W
                bsf     STATUS, C
                btfsc   STATUS, Z                 ; res ?
                return                            ; igen res -> C = 1

                lfsr    2, FifoArray
                movf    FifoStart, W
                addwf   FifoLength, W             ; eleje + hossz
                andlw   FifoSize - 1              ; krbejrs miatt
                addwf   FSR2L, f
                decf    FifoLength, f             ; rvidteni
                incf    FifoFree, f               ; szabad hely szmt nvelni
                movf    INDF2, W                  ; kivett adat
                bcf     STATUS, C                 ; rendben
                return
;-----------------------------------------------------------------
END
