LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

#define         LcdRefresh PrgStatus,0 ; ha 1, akkor a kijelzt frissteni kell
#define         SysExMode  PrgStatus,1 ; ha 1, akkor Sysex mdban vagyunk
#define         Save       PrgStatus,2 ; ha 1, akkor sszellts mentse szksges

; billentyzet mtrix
#define         KeybCol    PORTD                  ; 8 mtrix oszlop
#define         KeybRow1   PORTC, 0               ; potenciomter szelektl gombok
#define         KeybRow2   PORTC, 1               ; programvlaszt funkcik gombjai
#define         KeybRow3   PORTC, 2               ; jelenleg nincs hasznlva
#define         KeybRow1Tr TRISC, 0               ; adat irny
#define         KeybRow2Tr TRISC, 1               ; adat irny
#define         KeybRow3Tr TRISC, 2               ; adat irny

; billentyzet kiosztsa
bPrgMinus       EQU  1     ; Prg- gomb
bPrgPlus        EQU  2     ; Prg+ gomb
bChnMinus       EQU  3     ; Chn- gomb
bChnPlus        EQU  4     ; Chn+ gomb
bSystemReset    EQU  5     ; System Reset gomb
bBankSel        EQU  6     ; Bank Select gomb
bPresetMinus    EQU  7     ; Preset- gomb
bPresetPlus     EQU  8     ; Preset+ gomb

GLOBAL          KeybInit, KeybPolling, PresetNum
GLOBAL          ADBanks, ADPrgs, ADChns

EXTERN          SaveData, SavePresetNum
EXTERN          PrgStatus
EXTERN          PrgBanks, ADMsgPtr, ADMsgSens, ADVal

; String interface
EXTERN          CurPos, WriteChar, WriteTableStr, ClearLine, LcdString, Num
EXTERN          WriteByte1, WriteByte2, WriteByte3    ; 1 bjtos eljel nlkl
EXTERN          WriteShort1, WriteShort2, WriteShort3 ; 1 bjtos eljeles
EXTERN          WriteWord3, WriteWord4, WriteWord5    ; 2 bjtos eljel nlkl
EXTERN          WriteInt3, WriteInt4, WriteInt5       ; 2 bjtos eljeles

EXTERN          PrgNameWrite, PrgNameWrite2

EXTERN          FifoFree, UsartTx

PresetSize      EQU     .10  ; ennyi programsszelltst hasznlhatunk

UDATA_ACS
  ADSelect      RES     1    ; aktulisan kivlasztott potenciomter szma
  BankSelect    RES     1    ; kivlasztott potenciomterhez tartoz bank
  PrgSelect     RES     1    ; kivlasztott potenciomterhez tartoz program szma
  PresetNum     RES     1    ; aktulis Preset szma (0..9)
  Buttons       RES     1    ; billentyzetmtrix aktulis sora
  ButtonsPressd RES     1    ; lenyomott nyomgomb kdja
  Count         RES     1    ; ciklusszmll
  ADNumLcd      RES     1    ; programkirsnl ehhez a potenciomterhez szma

Programs        UDATA   0x0260
  ADBanks       RES     8    ; potenciomterekhez hozzrendelt bankok szma
  ADPrgs        RES     8    ; potenciomterekhez hozzrendelt programok szma
  ADChns        RES     8    ; potenciomterekhez hozzrendelt csatornk szma

CODE

;==============================================================================
; nyolc program feltltse adat EEPROM-bl Preset rtkt PresetNum tartalmazza
PresetLoad      btfsc   Save
                return                            ; ha ments folyik, akkor kilpnk
                
                movf    PresetNum, W
                mullw   .24
                movf    PRODL, W
                addlw   SaveData
                movwf   EEADR

; bankok feltltse
                lfsr    1, ADBanks
                movlw   8
                movwf   Count
PLoad1          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movff   EEDATA, POSTINC1
                incf    EEADR, f
                decfsz  Count, f
                bra     PLoad1

; programok feltltse
                lfsr    1, ADPrgs
                movlw   8
                movwf   Count
PLoad2          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movff   EEDATA, POSTINC1
                incf    EEADR, f
                decfsz  Count, f
                bra     PLoad2

; csatornk feltltse
                lfsr    1, ADChns
                movlw   8
                movwf   Count
PLoad3          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movff   EEDATA, POSTINC1
                incf    EEADR, f
                decfsz  Count, f
                bra     PLoad3

; programmutatk feltltse
                movff   ADSelect, Count
                clrf    ADSelect
LoadPtrsLoop    rcall   MsgPtrLoad
                incf    ADSelect, f
                movf    ADSelect, W
                addlw   -8
                btfss   STATUS, Z
                bra     LoadPtrsLoop
				movff   Count, ADSelect
               
                return
                
;==============================================================================
; ADSelect ltal kivlasztott zenet mutatjnak betltse
MsgPtrLoad      ltblptr PrgBanks                  ; Bank pointer tmb
                lfsrb   1, ADBanks, ADSelect
                bcf     STATUS, C
                rlcf    INDF1, W                  ; bank szma
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f

                TBLRD   *+
                movf    TABLAT, W
                TBLRD   *+
                movff   TABLAT, TBLPTRH
                movwf   TBLPTRL
                
                lfsrb   1, ADPrgs, ADSelect
                bcf     STATUS, C
                rlcf    INDF1, W                  ; program szma
                addlw   2
                addwf   TBLPTRL
                btfsc   STATUS, C
                incf    TBLPTRH, f

                lfsrw   1, ADMsgPtr, ADSelect

                tblrd   *+
                movf    TABLAT, W
                movwf   POSTINC1
                tblrd   *+
                movff   TABLAT, POSTINC1
                movff   TABLAT, TBLPTRH
                movwf   TBLPTRL

                lfsrw   1, ADMsgSens, ADSelect
                tblrd   *+
                movff   TABLAT, POSTINC1
                tblrd   *+
                movff   TABLAT, POSTINC1

                return
                
;==============================================================================
; billentyzet inicializlsa + belltsok betltse EEPROM-ban troltak alapjn
KeybInit        bcf     Save
                movlw   SavePresetNum
                movwf   EEADR
                bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movff   EEDATA, PresetNum         ; PresetNum
                rcall   PresetLoad
                clrf    ADSelect                  ; kovlasztott potenciomter = 0 (1.)
                lfsr    1, ADBanks
                movff   INDF1, BankSelect         ; kivlasztott bank
                lfsr    1, ADPrgs
                movff   INDF1, PrgSelect          ; kivlasztott program
                clrf    Buttons
                clrf    ButtonsPressd
                return

;==============================================================================
; Billentyzet lekrdezse, feldolgozsa Polling mdszerrel
KeybPolling     bcf     KeybRow1Tr                ; kimenet legyen
                bcf     KeybRow1                  ; alacsony logikai szint
                nop
                comf    KeybCol, W                ; sor visszaolvassa s neglsa
                movwf   Buttons
                bsf     KeybRow1                  ; magas logikai szint
                bsf     KeybRow1Tr                ; bemenet legyen
                bz      KeybPrg                   ; ha nincs lenyomva semmi

;------------------------------------------------------------------------------
; potenciomter kivlaszt gombok lekrdezse, ADSelect belltsa
                movlw   .16
                movwf   CurPos
                movf    ADSelect, W
                btfsc   Buttons, 7
                movlw   7
                btfsc   Buttons, 6
                movlw   6
                btfsc   Buttons, 5
                movlw   5
                btfsc   Buttons, 4
                movlw   4
                btfsc   Buttons, 3
                movlw   3
                btfsc   Buttons, 2
                movlw   2
                btfsc   Buttons, 1
                movlw   1
                btfsc   Buttons, 0
                movlw   0
                movwf   ADSelect                  ; ez lett kivlasztva

; kivlasztott potenciomter bankjnak s programjnak kiolvassa
                lfsrb   1, ADBanks, ADSelect
                movff   INDF1, BankSelect         ; Aktulisan kivlasztott bank szma
                lfsrb   1, ADPrgs, ADSelect
                movff   INDF1, PrgSelect          ; Aktulisan kivlasztott program szma

                call    PrgNameWrite              ; nevt kirni

                return

;------------------------------------------------------------------------------
; programvlaszt gombok lekrdezse
KeybPrg         btfsc   Save
                return

; Buttons 8 bitje = lenyomott gombok
                bcf     KeybRow2Tr                ; kimenet
                bcf     KeybRow2                  ; 2. sor
                nop
                comf    KeybCol, W                ; sor visszaolvassa s neglsa
                movwf   Buttons                   
                bsf     KeybRow2
                bsf     KeybRow2Tr
 
                bz      KeybNo                    ; egyik gomb sincs lenyomva

; ha le van nyomva, BottonsPressd -be eltrolni hogy melyik
                btfsc   Buttons, 0
                movlw   bPrgMinus
                btfsc   Buttons, 1
                movlw   bPrgPlus
                btfsc   Buttons, 2
                movlw   bChnMinus
                btfsc   Buttons, 3
                movlw   bChnPlus
                btfsc   Buttons, 4
                movlw   bSystemReset
                btfsc   Buttons, 5
                movlw   bBankSel
                btfsc   Buttons, 6
                movlw   bPresetMinus
                btfsc   Buttons, 7
                movlw   bPresetPlus
                movwf   ButtonsPressd             ; lenyomott gomb kdja
                return                            ; majd felengedskor lekezeljk

;------------------------------------------------------------------------------
; nincs lenyomva 1 billenty sem, de lehet hogy most lett felengedve
KeybNo          movf    ButtonsPressd, W
                btfsc   STATUS, Z                 ; elzleg volt ?
                return                            ; akkor sem -> kilpnk

                clrf    ButtonsPressd
                addlw   -1
                bz      KbPrgMinus                ; 'Program-' most felengedve
                addlw   -1
                bz      KbPrgPlus                 ; 'Program+' most felengedve
                addlw   -1
                bz      KbChnMinus                ; 'Chn-' most felengedve
                addlw   -1
                bz      KbChnPlus                 ; 'Chn+' most felengedve
                addlw   -1
                bz      KbSystemReset             ; 'System Reset' most felengedve
                addlw   -1
                bz      KbBankSel                 ; 'Bank Select' most felengedve
                addlw   -1
                bz      KbPresetMinus             ; 'Preset-' most felengedve
                addlw   -1
                bz      KbPresetPlus              ; 'Preset+' most felengedve

                return

;------------------------------------------------------------------------------
; program lptets lefel
KbPrgMinus      tstfsz  PrgSelect                 ; skip ha Program == 0
                decf    PrgSelect, f              ; Program cskkentse
                bra     KbPrgEnd                  ; ugyanaz a vge mint program+ -nl

;------------------------------------------------------------------------------
; program lptets felfel
KbPrgPlus       ltblptr PrgBanks                  ; Bank pointer tmb
                bcf     STATUS, C
                rlcf    BankSelect, W             ; kivlasztott potenciomter bank szma
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f

; kivlasztott bank mutatja -> TBLPTR
                TBLRD   *+
                movf    TABLAT, W
                TBLRD   *+
                movff   TABLAT, TBLPTRH
                movwf   TBLPTRL
                
; ha kivlaszott bank programjainak szma <> PrgSelect + 1 -> PrgSelect++
                TBLRD   *+                        ; kivlasztott bank programjainak szma
                incf    PrgSelect, W
                cpfseq  TABLAT
                incf    PrgSelect, f

; kivlasztott program eltrolsa
KbPrgEnd        lfsrb   1, ADBanks, ADSelect
                movff   BankSelect, INDF1
                lfsrb   1, ADPrgs, ADSelect
                movff   PrgSelect, INDF1
                bsf     Save

; jonnan kivlasztott program betltse s nevnek kirsa
                rcall   MsgPtrLoad
                movf    ADSelect, W
                call    PrgNameWrite
                return

;------------------------------------------------------------------------------
; csatorna lptets lefel
KbChnMinus      lfsrb   1, ADChns, ADSelect
                tstfsz  INDF1                     ; 0 ?
                decf    INDF1, f                  ; nem -> csatorna--
                movf    ADSelect, W
                call    PrgNameWrite              ; nv kirsa
                bsf     Save                      ; menteni
                return

;------------------------------------------------------------------------------
; csatorna lptets felfel
KbChnPlus       lfsrb   1, ADChns, ADSelect
                movlw   .15
                subwf   INDF1, W                  ; 15 ?
                btfss   STATUS, Z
                incf    INDF1, f                  ; nem -> csatorna++
                movf    ADSelect, W
                call    PrgNameWrite              ; LCD-re kirni
                bsf     Save                      ; menteni
                return

;------------------------------------------------------------------------------
; Peset Minus gomb felengedse esetn elz belltscsoport vlasztsa
KbPresetMinus   movf    PresetNum, W
                bz      $ + 6                     ; 0 -> nem cskkentjk
                decf    PresetNum, f
                rcall   PresetLoad
                bra     PresetWrite

;------------------------------------------------------------------------------
; Peset Plus gomb felengedse esetn kvetkez belltscsoport vlasztsa
KbPresetPlus    movf    PresetNum, W
                sublw   PresetSize - 1
                bz      $ + 6                     ; mr az utols -> nem nveljk
                incf    PresetNum, f
                rcall   PresetLoad
                bra     PresetWrite

;------------------------------------------------------------------------------
; System Reset gomb felengedse esetn control reset zenet az sszes csatornra
KbSystemReset   btfsc   SysExMode
                return                            ; SysEx mdban nem kldnk semmit
                movlw   4
                cpfsgt  FifoFree
                return                            ; nincs elg hely a Fifoban

                movlw   0xFF
                call    UsartTx                   ; aktulis bjt kldse soros porton
                
                bsf     INTCON, GIE               ; Irq tilts feloldsa

                clrf    CurPos
                call    ClearLine                 ; els sort letrlni
                ltblptr SysResetText
                call    WriteTableStr             ; msodik sorba "  System Reset  "
                bsf     LcdRefresh
                return

;------------------------------------------------------------------------------
; Bank Select gomb felengedse esetn
KbBankSel       ltblptr PrgBanks                  ; Bank pointer tmb
                tblrd   *

; program szm nullzsa hogy a msik bankbl ellrl induljunk
                clrf    PrgSelect

                incf    BankSelect, f             ; bank megnvelse

; ha elrtk az utols bankot, akkor kinullzzuk (krbejrunk)
                movf    TABLAT, W
                cpfslt  BankSelect
                clrf    BankSelect

; TBLPTR = kivlasztott bank mutatja
                bcf     STATUS, C
                rlcf    BankSelect, W
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f
                tblrd   *+
                movf    TABLAT, W
                tblrd   *+
                movff   TABLAT, TBLPTRH
                movwf   TBLPTRL
                
; TBLPTR = kivlaszott bank szvege
                tblrd   *
                rlcf    TABLAT, W
                addlw   2
                addwf   TBLPTRL, f
                btfsc   STATUS, C
                incf    TBLPTRH, f
                
; kurzorpoz = 0, els sorba bank neve, msodik sor trls
                clrf    CurPos
                call    WriteTableStr
                call    ClearLine
                bsf     LcdRefresh
                return

;------------------------------------------------------------------------------
; LCD kijelzre kirni az aktulis Preset szmt
PresetWrite     clrf    CurPos
                ltblptr PresetText
                call    WriteTableStr
                incf    PresetNum, W
                call    WriteByte2
                bsf     Save
                call    ClearLine
                bsf     LcdRefresh
; kivlasztott potenciomter bankjnak s programjnak kiolvassa
                lfsrb   1, ADBanks, ADSelect
                movff   INDF1, BankSelect         ; Aktulisan kivlasztott bank szma
                lfsrb   1, ADPrgs, ADSelect
                movff   INDF1, PrgSelect          ; Aktulisan kivlasztott program szma
                return

;==============================================================================
PresetText      db      "Preset Change ", 0
SysResetText    db      "  System Reset  ", 0

;==============================================================================

END
