LIST P=18F4550, F=INHX32
#include <P18F4550.INC>

#define         LcdData PORTB
#define         LcdDtTr TRISB
#define         LcdRs   PORTB,4
#define         LcdRsTr TRISB,4
#define         LcdRw   PORTB,5
#define         LcdRwTr TRISB,5
#define         LcdE    PORTA,4
#define         LcdETr  TRISA,4

#define         LcdRefresh PrgStatus,0 ; ha 1, akkor a kijelzt frissteni kell

GLOBAL          LcdInit, StringToLcd
EXTERN          CurPos, WriteChar, WriteTableStr
EXTERN          Delayusec, Delaymsec
EXTERN          LcdString, PrgStatus

; LCD Modul parancsok
  DISP_ON       EQU     0x00C      ; kijelzs be
  DISP_ON_C     EQU     0x00E      ; kijelzs be, kurzor be
  DISP_ON_B     EQU     0x00F      ; kijelzs be, kurzor be, villog kurzor
  DISP_OFF      EQU     0x008      ; kijelzs ki
  CLR_DISP      EQU     0x001      ; kperny trls
  ENTRY_INC     EQU     0x006      ;
  ENTRY_INC_S   EQU     0x007      ;
  ENTRY_DEC     EQU     0x004      ;
  ENTRY_DEC_S   EQU     0x005      ;
  DD_RAM_ADDR   EQU     0x080      ; als 7 bit adja meg a cmet
  DD_RAM_UL     EQU     0x080      ; bal fels sarla az LCD-nek

UDATA_ACS
  Count         RES     1          ; szmll
  Char          RES     1          ; aktulis karakter trolsra
  Temp          RES     1          ; tmeneti trolshoz

CODE

;==============================================================================
; adatport irnyt Lcd-re trtn rsra lltjuk
LcdTrisWrite    macro
                movlw   0xF0
                andwf   LcdDtTr, f
endm

;==============================================================================
; adatport irnyt Lcd-rl val olvassra lltjuk
LcdTrisRead     macro
                movlw   0x0F
                iorwf   LcdDtTr, f
endm

;==============================================================================
; 4 bites adat rsa LCD-re (bekapcsolskori inicializlshoz)
LcdDataWrite4
                movlw   0xF0
                andwf   LcdData, f
                movf    Char, W
                andlw   0x0F
                iorwf   LcdData, f
                bsf     LcdE
                nop
                nop
                nop
                bcf     LcdE
                return

;==============================================================================
; 8 bites adat rsa LCD-re
LcdDataWrite8
                movlw   0xF0
                andwf   LcdData, f
                swapf   Char, W
                andlw   0x0F
                iorwf   LcdData, f  ;fels 4 bit
                nop
                nop
                bsf     LcdE
                nop
                nop
                nop
                bcf     LcdE

                movlw   0xF0
                andwf   LcdData, f
                movf    Char, W
                andlw   0x0F
                iorwf   LcdData, f  ;als 4 bit
                nop
                nop
                bsf     LcdE
                nop
                nop
                nop
                bcf     LcdE

                return

;==============================================================================
; vrakozs arra hogy az LCD kijelz adatot tudjon fogadni
LcdWaitBusy
                LcdTrisRead
Loop            bcf     LcdRs
                bsf     LcdRw
                nop
                nop
                nop
                bsf     LcdE
                nop
                nop
                nop
                swapf   LcdData, W
                bcf     LcdE
                andlw   0xF0
                movwf   Temp
                nop
                nop
                nop
                bsf     LcdE
                nop
                nop
                nop
                movf    LcdData, W
                bcf     LcdE
                andlw   0x0F
                iorwf   Temp, f                
                bcf     LcdRw
                btfsc   Temp, 7
                bra     Loop
                LcdTrisWrite
                return

;==============================================================================
; LCD inicialilsa
LcdInit         bcf     LcdRsTr       ; RS  = 0
                bcf     LcdRwTr       ; R/W = 0
                bcf     LcdETr        ; E   = 0
                LcdTrisWrite          ; Lcd adatlabakra men lbak kimenetek
;------------------------------------- 1
                movlw   .100
                call    Delaymsec
                bcf     LcdRs
                bcf     LcdRw
                movlw   B'0011'
                movwf   Char
                rcall   LcdDataWrite4

;------------------------------------- 2
                movlw   .5
                call    Delaymsec

                movlw   B'0011'
                movwf   Char
                rcall   LcdDataWrite4

;------------------------------------- 3
                movlw   .100
                call    Delayusec

                movlw   B'0011'
                movwf   Char
                rcall   LcdDataWrite4

;------------------------------------- 4
                movlw   .100
                call    Delayusec

                movlw   B'0010'
                movwf   Char
                rcall   LcdDataWrite4

;-------------------------------------
                movlw   B'00101011'   ; 4 bites, tbbsoros
                rcall   LcdSendCmd    ; parancs klds
                movlw   DISP_ON
                rcall   LcdSendCmd    ; kijelzs be
                movlw   CLR_DISP
                rcall   LcdSendCmd    ; kperny trls
                movlw   ENTRY_INC
                rcall   LcdSendCmd    ; kurzor automatikus lptetse
                movlw   DD_RAM_ADDR
                rcall   LcdSendCmd    ; bal fels sarokba menni
                return

;==============================================================================
; egy karakter kikldse az LCD kijelzre
LcdSendChar     movwf   Char
                rcall   LcdWaitBusy                
                bcf     LcdRw
                bsf     LcdRs
                rcall   LcdDataWrite8
                return

;==============================================================================
; egy parancs kikldse az LCD kijelzre
LcdSendCmd      movwf   Char
                rcall   LcdWaitBusy                
                bcf     LcdRw
                bcf     LcdRs
                rcall   LcdDataWrite8
                return
;==============================================================================
; 32 bjtos LcdString-ben tallhat szveg tvitele az LCD kijelzre
StringToLcd     bcf     LcdRefresh
                lfsr    0, LcdString
                movlw   DD_RAM_UL
                rcall   LcdSendCmd
                movlw   .16
                movwf   Count
Sor1Loop        movf    POSTINC0, W
                rcall   LcdSendChar
                decfsz  Count
                bra     Sor1Loop

                movlw   DD_RAM_ADDR + 0x40
                rcall   LcdSendCmd
            
                movlw   .16
                movwf   Count
Sor2Loop        movf    POSTINC0, W
                rcall   LcdSendChar
                decfsz  Count
                bra     Sor2Loop

                return


;==============================================================================
END
