LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

#define         SysExMode  PrgStatus,1 ; ha 1, akkor Sysex mdban vagyunk

GLOBAL          UsartInit, UsartRxIrq, UsartTxIrq, UsartTx
EXTERN          FifoInit, FifoWrite, FifoRead
EXTERN          FifoLength, FifoFree, PrgStatus
EXTERN          CurPos, WriteTableStr

  BaudRate      EQU    .95         ; 31250 bit/sec az UART sebesseg (48MHz)

UDATA_ACS
  AktStatus     RES     1          ; milyen sttuszbjtot kldtnk utoljra

  RxData        RES     1          ; RX-en vett byte
  RxPuff        RES     3          ; vett zenet 3 bjtos tmeneti trolja
  RxCount       RES     1          ; zenet bjt szmllja (0,1,2)
  RxSize        RES     1          ; ppen vtel alatt lev zenet hossza (1,2,3)

  Fsr2Tmp       RES     2          ; adat memria muata mentshez
  TblPtrTmp     RES     2          ; program memria mutat mentshez
  CurPosTmp     RES     1          ; kurzor pozci mentshez
  

CODE
;==============================================================================
; soros port belltsai
UsartInit       clrf    AktStatus
                call    FifoInit

                movlw   1
                movwf   RxCount
                movwf   RxSize
                bcf     SysExMode

                movlw   B'00100100'               ; tvitel eng, aszinkron, BRGH = high speed
                movwf   TXSTA
                movlw   BaudRate                  ; 31250 bit/sec
                movwf   SPBRG
                bcf     TRISC, 6                  ; TX lb kimenet

                movlw   B'10010000'               ; soros port eng, 8bites md, vtel eng
                movwf   RCSTA

                bcf     IPR1, TXIP                ; Tx irq alacsony priorits

                bsf     IPR1, RCIP                ; RX irq magas priorits
                bsf     PIE1, RCIE                ; RX irq eng.

                return

;==============================================================================
; soros port ads megszakts kiszolgls
UsartTxIrq
                call    FifoRead
                bc      UsartStop                 ; ha res ads stop
                movwf   TXREG
                return

UsartStop
                bcf     PIE1, TXIE                ; TX irq tilts
                return

;==============================================================================
; egy bjt kldse soros porton, ha a port foglalt akkor FIFO regiszterbe rja az adatot
; be: W = kldend bjt
UsartTx         btfss   WREG, 7                   ; sttuszbjt ?
                bra     TxSend2                   ; nem, ezrt biztosan adni kell
                addlw   -0xFE                     ; activsense ? (FE)
                bz      TxSend1                   ; igen
                addlw   0xFE
                cpfseq  AktStatus                 ; == utols sttuszbjtal ?
                bra     $ + 4                     ; nem
                return                            ; igen -> nem kell kldeni
                movwf   AktStatus                 ; mostantl ez az aktulis sttusz
                bra     TxSend2
                
TxSend1         addlw   0xFE

TxSend2         btfsc   PIR1, TXIF                ; Usart reg res ?
                bra     TxSendStart               ; igen

                call    FifoWrite                 ; mr csak a Fifo-ba fr
                bsf     PIE1, TXIE                ; TX irq eng.
                return

TxSendStart     movwf   TXREG
                return

;==============================================================================
; soros port vtel megszakts kiszolgls
UsartRxIrq      btfsc   RCSTA, FERR               ; keret hiba ?
                return                            ; igen
                btfsc   RCSTA, OERR               ; tlfutsi hiba ?
                return                            ; igen

                movf    RCREG, W
                movwf   RxData                    ; rkezett byte
                btfss   SysExMode                 ; Sysex mdban vagyunk ?
                bra     NoSysExRx                 ; nem
                addlw   -0xF7                     ; Sysex md vge ?
                btfss   STATUS, Z
                bra     RxStatus1b                ; nem
                bcf     SysExMode                 ; Sysex md kikapcs

                fsrs    2, Fsr2Tmp                
                tblptrs TblPtrTmp
                movff   CurPos, CurPosTmp
                clrf    CurPos                    ; kurzorpozci mentse
                ltblptr SysExOffText
                call    WriteTableStr             ; Lcd-re kirni
                movff   CurPosTmp, CurPos         ; kurzorpozci visszalltsa
                fsrl    2, Fsr2Tmp                
                tblptrl TblPtrTmp

                bra     RxStatus1b                ; 1 bjtos zenet kirsa

; nem Sysex mdban vagyunk
NoSysExRx
                btfsc   RxData, 7                 ; sttuszbjt ?
                bra     RxStatus                  ; igen

                decf    RxCount, W
                btfsc   STATUS, Z
                movff   RxData, RxPuff + 1
                addlw   -1
                btfsc   STATUS, Z
                movff   RxData, RxPuff + 2
                
                decf    RxSize, W
                cpfseq  RxCount                   ; zenet vge ?
                bra     RxNoEnd                   ; nem

; Puffer tartalmt kikldi a soros kimenetre
RxPuffSend      fsrs    2, Fsr2Tmp

                movf    RxPuff, W
                rcall   UsartTx                   ; 1. bjt
                movlw   1
                subwf   RxSize, W
                bz      RxPuffSendEnd             ; csak 1 bj hossz az zenet

                movf    RxPuff + 1, W
                rcall   UsartTx                   ; 2. bjt
                movlw   2
                subwf   RxSize, W
                bz      RxPuffSendEnd             ; csak 2 bjt hossz az zenet

                movf    RxPuff + 2, W
                rcall   UsartTx                   ; 3. bjt

RxPuffSendEnd   fsrl    2, Fsr2Tmp
                movlw   1
                movwf   RxCount
                return

RxNoEnd         incf    RxCount, f
                return

; sttuszbjt jtt
RxStatus        addlw   0x10
                btfsc   STATUS, C
                bra     RxStatusNcs               ; >F0
                addlw   0x30
                btfsc   STATUS, C
                bra     RxStatus2b                ; >C0

; 3 bjtos zenet
RxStatus3b      movlw   1
                movwf   RxCount
                movlw   3
                movwf   RxSize                    ; aktulis zenet hossza = 3
                movff   RxData, RxPuff
                return
                
; 2 bjtos zenet
RxStatus2b      movlw   1
                movwf   RxCount
                movlw   2
                movwf   RxSize                    ; aktulis zenet hossza = 2
                movff   RxData, RxPuff
                return

;1 bjtos zenet
RxStatus1b      movf    RxData, W
                fsrs    2, Fsr2Tmp                ;FSR2 mentse
                rcall   UsartTx                   ;rgtn a kimenetre kldeni
                fsrl    2, Fsr2Tmp                ;FSR2 visszalltsa
                return
       
; nem csatorna zenet (F0..FF)
RxStatusNcs     btfsc   STATUS, Z
                bra     RxStatusSeBe              ;F0
                addlw   -1
                btfsc   STATUS, Z
                bra     RxStatus2b                ;F1
                addlw   -1
                btfsc   STATUS, Z
                bra     RxStatus3b                ;F2
                addlw   -.12
                btfsc   STATUS, Z
                return                            ;FE
                bra     RxStatus1b
                
; Sysex be
RxStatusSeBe
                bcf     SysExMode

                fsrs    2, Fsr2Tmp
                tblptrs TblPtrTmp
                movff   CurPos, CurPosTmp
                clrf    CurPos                    ; kurzorpozci mentse
                ltblptr SysExOnText
                call    WriteTableStr             ; Lcd-re kirni
                movff   CurPosTmp, CurPos         ; kurzorpozci visszalltsa
                fsrl    2, Fsr2Tmp
                tblptrl TblPtrTmp

                bra     RxStatus1b
          
SysExOnText     db      " SyEx Mode On   ", 0
SysExOffText    db      " SyEx Mode Off  ", 0

END
