LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

#define         LcdRefresh PrgStatus,0 ; ha 1, akkor a kijelzt frissteni kell
#define         SysExMode  PrgStatus,1 ; ha 1, akkor Sysex mdban vagyunk

GLOBAL          ADInit, ADPolling
GLOBAL          ADMsgPtr, ADMsgSens, ADVal

EXTERN          PrgStatus
EXTERN          PrgBanks, PrgNameWrite2, ADChns, ADNumLcd
EXTERN          FifoFree, UsartTx

UDATA_ACS
  ADNum         RES     1                         ; aktulis A/D csatorna (0..7)
  ADAbsDelta    RES     2
  Count         RES     1
  Temp          RES     1

ADArrays        UDATA   0x0220
  ADVal         RES     .16
  ADMsgVal      RES     .16
  ADMsgSens     RES     .16
  ADMsgPtr      RES     .16

CODE

;==============================================================================
ADInit          movlw   B'00000111'
                movwf   ADCON1                    ; VREF=tp, AN0-AN7 A/D be
                movlw   B'10111110'               ; jobbra igazit, Acq Time = 20
                movwf   ADCON2                    ; clock = Fosc/64

                clrf    ADNum
                lfsr    0, ADVal
                lfsr    1, ADMsgVal

ADInitLoop     
                bcf     STATUS, C
                rlcf    ADNum, W
                rlcf    WREG, W
                movwf   ADCON0
                bsf     ADCON0, ADON
                bsf     ADCON0, GO

                btfsc   ADCON0, DONE              ; befejezte az A/D talaktst ?
                bra     $ - 2
                
                movff   ADRESL, POSTINC0
                movff   ADRESH, POSTINC0
                movff   ADRESL, POSTINC1
                movff   ADRESH, POSTINC1
               
                incf    ADNum, f
                movlw   8
                cpfseq  ADNum
                bra     ADInitLoop

                clrf    ADNum
                clrf    ADCON0
                bsf     ADCON0, ADON
                bsf     ADCON0, GO
                return

;==============================================================================
ADPolling       btfsc   ADCON0, DONE              ; befejezte az A/D talaktst ?
                return                            ; nem
                btfsc   SysExMode                 ; sysex md ?
                return                            ; igen -> nem kldnk sajt zenetet

; aktulis rtk elmentse ADVal tmbbe
                lfsrw   1, ADVal, ADNum
                movff   ADRESL, POSTINC1
                movff   ADRESH, POSTINC1

; utols zenetkor mennyi volt az A/D rtke ?
                lfsrw   1, ADMsgVal, ADNum

                movff   POSTINC1, ADAbsDelta
                movff   POSTDEC1, ADAbsDelta + 1

; ADAbsDelta = rgi A/D - aktulis A/D
                movf    ADRESL, W
                subwf   ADAbsDelta, f
                movf    ADRESH, W
                subwfb  ADAbsDelta + 1, f

                bnn     ADPDeltaPoz               ; pozitv klnbsg

; negatv klnbsgnl eljelfordts
                comf    ADAbsDelta + 1, f
                negf    ADAbsDelta
                btfsc   STATUS, C
                incf    ADAbsDelta + 1
                
ADPDeltaPoz     lfsrw   1, ADMsgSens, ADNum       ; rzkenysg tmb megcmzse

; ADAbsDelta = vltozs - rzkenysg
                movf    POSTINC1, W
                subwf   ADAbsDelta, f
                movf    INDF1, W
                subwfb  ADAbsDelta + 1, f

                bn      ADNext                    ; rzkenysg alatti vltozs

;------------------------------------------------------------------------------
; zenet kldse
                lfsrw   1, ADMsgPtr, ADNum

                movff   POSTINC1, TBLPTRL
                movff   POSTDEC1, TBLPTRH
                tblrd   *+
                tblrd   *+

                tblrd   *+
                movf    TABLAT, W
                addlw   6
                cpfsgt  FifoFree
                bra     ADNext                    ; nincs elg hely a Fifoban

                movff   TABLAT, Count
                tblrd   *+

                bcf     INTCON, GIE               ; Irq tilts, Fifo hasznlat miatt

;------------------------------------------------------------------------------
; zenetbjt tpus szerinti elgazs
ADMsgLoop       tblrd   *+
                bcf     STATUS, C
                movf    PCL, W
                rlcf    TABLAT, W
                tblrd   *+
                addwf   PCL, f
                bra     ADMsgDT0
                bra     ADMsgDT1
                bra     ADMsgDT2
                bra     ADMsgDT3
                bra     ADMsgDT4
                bra     ADMsgDT5
                bra     ADMsgDT6
                bra     ADMsgDT7
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0
                bra     ADMsgDT0

;------------------------------------------------------------------------------
; simn az rtket elkldeni
ADMsgDT0        movf    TABLAT, W
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
; + csatornaszm
ADMsgDT1        lfsrb   1, ADChns, ADNum
                movf    TABLAT, W
                addwf   INDF1, W
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
; eljel nlkli 7 bites
ADMsgDT2        movff   ADRESL, Temp
                rrcf    ADRESH, W
                rrcf    Temp, f
                rrcf    ADRESH, W
                rrcf    WREG, W
                rrcf    Temp, f
                bcf     STATUS, C
                rrcf    Temp, W
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
; eljeles 7 bites hi, -64..63 hi (0..511 -> 0x3F, 512..1023 -> 0x40
ADMsgDT3        movlw   3F
                btfsc   ADRESH, 1
                movlw   40
                bra     ADMsgSendByte
; eljeles 7 bites lo, -64..63 lo
ADMsgDT4        rrcf    ADRESH, W
                rrcf    ADRESL, W
                bcf     STATUS, C
                rrcf    WREG, W
                bcf     STATUS, C
                rrcf    WREG, W
                addlw   40
                andlw   7F
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
; 14 bites hi
ADMsgDT5        movff   ADRESL, Temp
                rrcf    ADRESH, W
                rrcf    Temp, f
                rrcf    WREG, W
                rrcf    Temp, f
                bcf     STATUS, C
                rrcf    Temp, W
                bra     ADMsgSendByte
; 14 bites lo
ADMsgDT6        swapf   ADRESL, W
                andlw   070
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
; kapcsol jelleg
ADMsgDT7        clrf    ADRESL
                btfsc   ADRESH, 1
                bra     ADMsgDT7on
                movlw   HIGH .256
                movwf   ADRESH
                movlw   0
                bra     ADMsgSendByte
ADMsgDT7on
                movlw   HIGH .768
                movwf   ADRESH
                movlw   .64
                bra     ADMsgSendByte

;------------------------------------------------------------------------------
ADMsgSendByte   call    UsartTx                   ; bjt kldse soros porton
                decfsz  Count
                bra     ADMsgLoop

                bsf     INTCON, GIE               ; Irq tilts feloldsa

; elkldtt zenethez tartoz A/D eltrolsa
                lfsrw   1, ADMsgVal, ADNum
                movff   ADRESL, POSTINC1
                movff   ADRESH, POSTINC1

; elkldtt zenet megjelentse
                movff   ADNum, ADNumLcd
                call    PrgNameWrite2
              
;------------------------------------------------------------------------------
; kvetkez A/D csatorna, konverzi start
ADNext          incf    ADNum, f
                bcf     ADNum, 3                  ; csak 0..7 lehet
                bcf     STATUS, C
                rlcf    ADNum, W
                rlcf    WREG, W
                movwf   ADCON0
                bsf     ADCON0, ADON
                bsf     ADCON0, GO
                
                return

END
