LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

__CONFIG  _CONFIG1L,  _PLLDIV_5_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
__CONFIG  _CONFIG1H,  _FOSC_HSPLL_HS_1H & _FCMEM_OFF_1H & _IESO_OFF_1H
__CONFIG  _CONFIG2L,  _PWRT_OFF_2L & _BOR_SOFT_2L & _BORV_2_2L & _VREGEN_ON_2L
__CONFIG  _CONFIG2H,  _WDT_OFF_2H
__CONFIG  _CONFIG3H,  _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H
__CONFIG  _CONFIG4L,  _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L & _XINST_OFF_4L & _DEBUG_ON_4L

ActSens         EQU     0xFE           ; ezt a bjtot kell kldeni Activ Sens zenetknt
ActSensTime     EQU     .115           ; ilyen srsggel kldjk (300ms)

#define         LcdRefresh PrgStatus,0 ; 1-re lltsval jelezzk hogy a LCD-t frissteni kell
#define         SysExMode  PrgStatus,1 ; ha 1 akkor Sysex mdban vagyunk
#define         Save       PrgStatus,2 ; ha 1 akkor bellts mentse mdban vagyunk
#define         ADKeyb     PrgStatus,3 ; az A/D s a bill. lekrdezsnek vltsra

GLOBAL          Delayusec  ; mikroszekundumos vrakozs, id W-ben
GLOBAL          Delaymsec  ; milliszekundumos vrakozs, id W-ben
GLOBAL          PrgStatus  ; program llapot bitek

EXTERN          UsartInit, UsartRxIrq, UsartTx, UsartTxIrq
EXTERN          LcdInit, StringToLcd

EXTERN          KeybInit, KeybPolling    ; billentyzet
EXTERN          ADInit, ADPolling        ; A/D 
EXTERN          PresetNum, SaveData, SavePresetNum
EXTERN          ADBanks, ADPrgs, ADChns  ;bellts mentshez

; String interface
EXTERN          ClrScr, CurPos, WriteChar, WriteTableStr, ClearLine, LcdString, Num
EXTERN          WriteByte1, WriteByte2, WriteByte3    ; 1 bjtos eljel nlkl
EXTERN          WriteShort1, WriteShort2, WriteShort3 ; 1 bjtos eljeles
EXTERN          WriteWord3, WriteWord4, WriteWord5    ; 2 bjtos eljel nlkl
EXTERN          WriteInt3, WriteInt4, WriteInt5       ; 2 bjtos eljeles

UDATA_ACS
; megszaktnl regisztermentshez
WregTemp        RES     1   ; W regiszter mentshez
StatusTemp      RES     1   ; STATUS regiszter mentshez
BsrTemp         RES     1   ; BSR regiszter mentshez

; ltalnos vltozl
Delay           RES     2   ; idztshez szmll
PrgStatus       RES     1   ; jelzbiteket tartalmaz
Count           RES     1   ; Mentsnl hasznlt szmll
ActSensCount    RES     1   ; itt szmlljuk hogy mikor kell Actv Sens-t kldeni
TimerPhase      RES     1   ; 0 -> Keybord Irq, 1..8 -> AD Irq

;==============================================================================
; Reset vector
RESET_VECTOR    CODE    0x0000
                goto    Main

;==============================================================================
; magas priorits megszakts vector
HI_INT_VECTOR   CODE    0x0008

                call    UsartRxIrq
                retfie  FAST

;==============================================================================
; alacsony priorits megszakits vector
LOW_INT_VECTOR  CODE    0x0018
                bra     LowInt

;==============================================================================
                CODE
; alacsony priorits megszakits rutin
LowInt          movff   STATUS, StatusTemp      ; STATUS regiszter mentse
                movff   WREG, WregTemp          ; W regiszter mentse
                movff   BSR, BsrTemp            ; BSR regiszter mentse

;------------------------------------------------------------------------------
                btfss   PIE1, TXIE
                bra     TxIrqEnd                ; tiltva van TX irq
                btfss   PIR1, TXIF              ; TX megszakts ?
                bra     TxIrqEnd                ; nem
                call    UsartTxIrq
TxIrqEnd

;------------------------------------------------------------------------------
                btfss   INTCON, TMR0IF          ; Timer0 Irq ?
                bra     TimerIrqEnd             ; nem

                movf    TimerPhase, W
                btfss   STATUS, Z               ; skip ha == 0
                call    ADPolling               ; ha TimerPhase != 0 -> ADIrq
                
                movf    TimerPhase, W
                btfsc   STATUS, Z               ; skip ha <> 0
                call    KeybPolling             ; ha ADKeyb = 1 -> KeybIrq

; ha alulcsordul akkor 8-rl kezdjk jra
                movlw   8
                decf    TimerPhase, f
                btfss   STATUS, C
                movwf   TimerPhase

; aktv Sens zenet kldse
                decf    ActSensCount, f
                bnz     NoSendActSens
                movlw   ActSens
                call    UsartTx
                movlw   ActSensTime
                movwf   ActSensCount
NoSendActSens

                btg     ADKeyb              
                bcf     INTCON, TMR0IF
                
                nop
TimerIrqEnd

;------------------------------------------------------------------------------
                movff   BsrTemp, BSR            ; BSR visszalltsa
                movff   WregTemp, WREG          ; W  visszalltsa
                movff   StatusTemp, STATUS      ; STATUS visszalltsa
                retfie

;==============================================================================
; fprogram kezdete
Main            call    Init

; fprogram hurok eleje
MainLoop        btfsc   LcdRefresh                ; kell kijelzt frissteni ?
                call    StringToLcd               ; igen
                btfsc   Save                      ; kell menteni ?
                call    PresetSave                ; igen
                bra     MainLoop                  ; vissza a hurok elejre

;==============================================================================
; szksges perifrik s memriaterletek belltsa
Init            bcf     INTCON, GIEH              ; magas irq tilts
                bcf     INTCON, GIEL              ; alacsony irq tilts

                movlw   0x07
                movwf   ADCON1                    ; AN0..AN7: analg, AN8..AN12 digitlis

                clrf    PrgStatus                 ; PrgStatus = 0
                clrf    TimerPhase                ; fzis = 0

                call    LcdInit                   ; LCD kijelz bekapcs
                call    ADInit                    ; A/D csatornk
                call    UsartInit                 ; soros port
                call    KeybInit                  ; billentyzet
                
                bsf     RCON, IPEN                ; ketts szint megszakts eng.

;------------------------------------------------------------------------------
; Timer0 irq bellts
                movlw   B'11000110'               ; 8bites, 1:128
                movwf   T0CON
                bcf     INTCON2, TMR0IP           ; alacsony priorits
                bsf     INTCON, TMR0IE            ; megsz. eng.


                bsf     INTCON, GIEH              ; magas irq eng.
                bsf     INTCON, GIEL              ; alacsony irq eng.

;------------------------------------------------------------------------------
; szoveg kiirasa '   Midi mixer   '
                clrf    CurPos
                ltblptr StartString
                call    WriteTableStr
                bsf     LcdRefresh
                       ;"0123456789ABCDEF"
StartString     da      "   Midi Mixer   "
                da      "  version v1.0  ", 0
                return

;==============================================================================
; 1..256 mikroszekundumos vrakozs
; id = W mikroszekundum, tvoli call hvssal teljesen pontos idztst ad 40MHz-en
Delayusec       movwf   Delay
                nop
                bra     $ + 10
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                nop
                decfsz  Delay
                bnz     Delayusec + 6
                return

;==============================================================================
; 1..256 miliszekundumos vrakozs
; id = W miliszekundum, tvoli call hvssal teljesen pontos idztst ad 40MHz-en
Delaymsec       movwf   Delay + 1
                nop
                nop
                nop
                nop
                movlw   .249
                bra     $ + 4
                movlw   .250
                rcall   Delayusec
                movlw   .250
                rcall   Delayusec
                movlw   .250
                rcall   Delayusec
                movlw   .249
                rcall   Delayusec
                nop
                nop
                nop
                decfsz  Delay + 1
                bnz     Delaymsec + .14
                return

;==============================================================================
; belltsok adat EEPROM-ba trtn elmentse
PresetSave      movlw   SavePresetNum
                movwf   EEADR
                bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movf    PresetNum, W
                cpfseq  EEDATA                    ; csak akkor rjuk t ha klnbz
                rcall   EeWrite
                
                movf    PresetNum, W
                mullw   .24
                movf    PRODL, W
                addlw   SaveData
                movwf   EEADR

;------------------------------------------------------------------------------
; bankok mentse
                lfsr    0, ADBanks
                movlw   8
                movwf   Count
PSave1          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movf    POSTINC0, W
                cpfseq  EEDATA                    ; csak akkor rjuk t ha klnbz
                rcall   EeWrite
                incf    EEADR, f
                decfsz  Count, f
                bra     PSave1

;------------------------------------------------------------------------------
; programok mentse
                lfsr    0, ADPrgs
                movlw   8
                movwf   Count
PSave2          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movf    POSTINC0, W
                cpfseq  EEDATA
                rcall   EeWrite
                incf    EEADR, f
                decfsz  Count, f
                bra     PSave2

;------------------------------------------------------------------------------
; csatornk mentse
                lfsr    0, ADChns
                movlw   8
                movwf   Count
PSave3          bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, RD
                movf    POSTINC0, W
                cpfseq  EEDATA
                rcall   EeWrite
                incf    EEADR, f
                decfsz  Count, f
                bra     PSave3
                
                bcf     Save
                return

;==============================================================================
; egy bjt rsa adat EEPROM-ba (adat = W, cm = EEADR)
EeWrite         movwf   EEDATA
                bcf     EECON1, EEPGD
                bcf     EECON1, CFGS
                bsf     EECON1, WREN
                bcf     INTCON, GIE
                movlw   55h
                movwf   EECON2                    ; rsi szekvencia 55h
                movlw   0AAh ;
                movwf   EECON2                    ; rsi szekvencia 0AAh
                bsf     EECON1, WR
                btfsc   EECON1, WR
                bra     $-2                       ; megvrjuk mg vgzett
                bsf     INTCON, GIE
                bcf     EECON1, WREN
                return

END
