LIST P=18F4550, F=INHX32
#include <P18F4550.INC>
#include "macro.inc"

GLOBAL          CurPos, LcdString, Num
GLOBAL          ClrScr, WriteChar
GLOBAL          WriteByte1, WriteByte2, WriteByte3    ; 1 bjtos eljel nlkl
GLOBAL          WriteShort1, WriteShort2, WriteShort3 ; 1 bjtos eljeles
GLOBAL          WriteWord3, WriteWord4, WriteWord5    ; 2 bjtos eljel nlkl
GLOBAL          WriteInt3, WriteInt4, WriteInt5       ; 2 bjtos eljeles
GLOBAL          WriteTableStr, ClearLine

UDATA_ACS
  CurPos        RES  1     ; kurzor pozcija
  Char          RES  1     ; aktulis karakter
  Ptr           RES  1     ; karakter mutat

  Num           RES  2     ; szm -> karakter talaktshoz
  WTemp         RES  1
  StrStatus     RES  1

#define         ZeroSw  StrStatus, 0
#define         NegSw   StrStatus, 1

LcdArrays       UDATA   0x0200
  LcdString     RES     .32   ;
  LcdLenght     EQU     .32   ; Puffer merete
  LcdPtrMask    EQU     LcdLenght - 1

CODE

;==============================================================================
ClrScr          lfsr    2, LcdString
                movlw   .32
                movwf   CurPos
                movlw   ' '
ClrScrLoop      movwf   POSTINC2
                decfsz  CurPos, f
                bra     ClrScrLoop
                return

;==============================================================================
WriteChar       movwf   Char
                lfsrb   2, LcdString, CurPos
                movff   Char, INDF2
                incf    CurPos, f
                bcf     CurPos, 5                 ; kurzorpoz krbejr
                return

;==============================================================================
WriteByte1;     WriteByte  1, '0', ' ', WriteChar
                return
;==============================================================================
WriteByte2      WriteByte  2, '0', ' ', WriteChar
                return
;==============================================================================
WriteByte3      WriteByte  3, ' ', ' ', WriteChar
                return
;==============================================================================
WriteShort1;    WriteByte  1, ' ', '-', WriteChar
                return
;==============================================================================
WriteShort2     WriteByte  2, ' ', '-', WriteChar
                return
;==============================================================================
WriteShort3     WriteByte  3, ' ', '-', WriteChar
                return
;==============================================================================
WriteWord3;     WriteWord  3, ' ', ' ', WriteChar
                return
;==============================================================================
WriteWord4      WriteWord  4, ' ', ' ', WriteChar
                return
;==============================================================================
WriteWord5      WriteWord  5, ' ', ' ', WriteChar
                return
;==============================================================================
WriteInt3;      WriteWord  3, ' ', '-', WriteChar
                return
;==============================================================================
WriteInt4       WriteWord  4, ' ', '-', WriteChar
                return
;==============================================================================
WriteInt5       WriteWord  5, ' ', '-', WriteChar
                return
;==============================================================================
; program terleten tallhat szveget r LcdString-be
; szveg kezdete a programmemriban : TBLPTR
; szveg vge jelzs : #0 karakter
WriteTableStr   lfsrb   2, LcdString, CurPos
WTScikl         tblrd   *+
                movf    TABLAT, W
                btfsc   STATUS, Z
                return
                incf    CurPos, f
                movwf   POSTINC2
                bra     WTScikl

;==============================================================================
; egy sornyi szkz kirsa
ClearLine       movlw   .16
                movwf   WTemp
                movlw   ' '
                call    WriteChar
                decfsz  WTemp, f
                bra     ClearLine + 4
                return

;==============================================================================
END
