;==============================================================================
; programmemria mutat feltltse konstans rtkkel
; paramterek :
; - Addr : adatmemria cme (konstans)
ltblptr macro Addr
                movlw   LOW Addr
                movwf   TBLPTRL
                movlw   HIGH Addr
                movwf   TBLPTRH
endm

;==============================================================================
; programmemria mutat mentse egy 16 bites vltozba
; paramterek :
; - tw : 16 bites vltoz, ahov a ments trtnjen
tblptrs macro tw
                movff   TBLPTRL, tw
                movff   TBLPTRH, tw + 1
endm
;==============================================================================
; programmemria mutat betltse egy 16 bites vltozbl
; paramterek :
; - tw : 16 bites vltoz, ahol a betltend mutat tallhat
tblptrl macro tw
                movff   tw, TBLPTRL
                movff   tw + 1, TBLPTRH
endm

;==============================================================================
; adatmemria mutat belltsa egy bjtokat tartalmaz tmb, index-edik elemre
; paramterek :
; - FszNum = {0, 1, 2} : melyik adatmutatt lltsa be
; - ArrayStart : tmb kezdcme (konstans)
; - index : 8 bites vltoz, amelyik az indexet tartalmazza
; megj: a tmbnek egy lapon bell kell lennie
lfsrb  macro FsrNum, ArrayStart, index
if FsrNum == 0
                lfsr    0, ArrayStart
                movf    index, W
                addwf   FSR0L, f
endif
if FsrNum == 1
                lfsr    1, ArrayStart
                movf    index, W
                addwf   FSR1L, f
endif
if FsrNum == 2
                lfsr    2, ArrayStart
                movf    index, W
                addwf   FSR2L, f
endif
endm

;==============================================================================
; adatmemria mutat belltsa egy szavakat tartalmaz tmb, index-edik elemre
; paramterek :
; - FszNum = {0, 1, 2} : melyik adatmutatt lltsa be
; - ArrayStart : tmb kezdcme (konstans)
; - index : 8 bites vltoz, amelyik az indexet tartalmazza
; megj: a tmbnek egy lapon bell kell lennie
lfsrw  macro FsrNum, ArrayStart, index
if FsrNum == 0
                lfsr    0, ArrayStart
                bcf     STATUS, C
                rlcf    index, W
                addwf   FSR0L, f
endif
if FsrNum == 1
                lfsr    1, ArrayStart
                bcf     STATUS, C
                rlcf    index, W
                addwf   FSR1L, f
endif
if FsrNum == 2
                lfsr    2, ArrayStart
                bcf     STATUS, C
                rlcf    index, W
                addwf   FSR2L, f
endif
endm

;==============================================================================
; adatmemria mutat mentse egy 16 bites vltozba
; paramterek :
; - FszNum = {0, 1, 2} : melyik adatmutatt lltsa be
; - fw : 16 bites vltoz, ahov a ments trtnjen
fsrs  macro FsrNum, fw
if FsrNum == 0
                movff   FSR0L, fw
                movff   FSR0H, fw + 1
endif
if FsrNum == 1
                movff   FSR1L, fw
                movff   FSR1H, fw + 1
endif
if FsrNum == 2
                movff   FSR2L, fw
                movff   FSR2H, fw + 1
endif
endm

;==============================================================================
; adatmemria mutat betltse egy 16 bites vltozbl
; paramterek :
; - FszNum = {0, 1, 2} : melyik adatmutatt lltsa be
; - fw : 16 bites vltoz, ahol a betltend mutat tallhat
fsrl  macro FsrNum, fw
if FsrNum == 0
                movff   fw, FSR0L
                movff   fw + 1, FSR0H
endif
if FsrNum == 1
                movff   fw, FSR1L
                movff   fw + 1, FSR1H
endif
if FsrNum == 2
                movff   fw, FSR2L
                movff   fw + 1, FSR2H
endif
endm

;==============================================================================
; W-ben tallhat 8 bites binris szmot karakteress alaktja
; kpes eljel nlkli s eljeles szmok talaktsra is
; ha a szm nem fr el 'he' karakterhelyen, az elejt csonkolja
; a makro hivatkozs helyn szksges vltozk:
; - Num : tmeneti tr a szm trolshoz
; - WTemp : tmeneti tr W regiszter trolshoz
; - ZeroSw : egy bit trolhely a kezd nullk eltntetshez (csak ha ZeroChar != '0')
; - NegSw : egy bit trolhely az eljel trolshoz (csak ha NegChar == '-')
; paramterek :
; - he = {1, 2, 3} : ennyi szmjeggyel rja ki
; - ZeroChar : szm elejn elfordul nullkat mivel helyettestse
; - NegChar : ha '-' akkor eljeles szmknt rja ki
; - WriteProc : karakterkir eljrs cme

WriteByte  macro  he, ZeroChar, NegChar, WriteProc
LOCAL  l100loop, l100end, l10loop, l10end
LOCAL  n100, n10, n1

                movwf   Num
; eljeles szm esetn
if NegChar == '-'
LOCAL Plus
                bcf     NegSw                     ; pozitv szm
                btfss   Num, 7                    ; pozitv ?
                bra     Plus                      ; igen
                negf    Num
                bsf     NegSw                     ; negatv szm
Plus
endif

if ZeroChar != '0'
                bcf     ZeroSw
endif

if NegChar == '-' & ZeroChar == '0'
                movlw   NegChar
                btfss   NegSw
                movlw   ' '
                rcall   WriteProc
endif

; szzasok
if he >= 3
                movlw   '0'
                movwf   WTemp
endif
l100loop        movlw   .100
                subwf   Num, f
                bnc     l100end
if he >= 3
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n100
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n100
    endif
                bsf     ZeroSw
  endif
endif
                bra     l100loop
                
l100end         movlw   .100
                addwf   Num, f

if he >= 3
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
  endif
endif

; tizesek
if he >= 2
                movlw   '0'
                movwf   WTemp
endif
l10loop         movlw   .10
                subwf   Num, f
                bnc     l10end
if he >= 2
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n10
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n10
    endif
                bsf     ZeroSw
  endif
endif
                bra     l10loop
                
l10end          movlw   .10
                addwf   Num, f
if he >= 1
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
  endif
endif

if NegChar == '-'
                btfsc   ZeroSw
                bra     n1
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
n1
endif
; egyesek
                movlw   '0'
                addwf   Num, W
                rcall   WriteProc
endm

;==============================================================================
; Num vltozban lev 16 bites binris szmot karakteress alaktja
; kpes eljel nlkli s eljeles szmok talaktsra is
; ha a szm nem fr el 'he' karakterhelyen, az elejt csonkolja
; a makro hivatkozs helyn szksges vltozk:
; - Num : vltoz a 16 bites szm trolshoz, az talaktand szmot is ide kell tenni
; - WTemp : tmeneti tr W regiszter trolshoz
; - ZeroSw : egy bit trolhely a kezd nullk eltntetshez (csak ha ZeroChar != '0')
; - NegSw : egy bit trolhely az eljel trolshoz (csak ha NegChar == '-')
; paramterek :
; - he = {3, 4, 5} : ennyi szmjeggyel rja ki
; - ZeroChar : szm elejn elfordul nullkat mivel helyettestse
; - NegChar : ha '-' akkor eljeles szmknt rja ki
; - WriteProc : karakterkir eljrs

WriteWord  macro  he, ZeroChar, NegChar, WriteProc
LOCAL  l10000loop, l10000end, l1000loop, l1000end, l100loop, l100end, l10loop, l10end
LOCAL  n10000, n1000, n100, n10, n1

; eljeles szm esetn
if NegChar == '-'
LOCAL Plus
                bcf     NegSw                     ; pozitv szm
                btfss   Num + 1, 7                ; pozitv ?
                bra     Plus                      ; igen

                comf    Num + 1, f
                negf    Num
                btfsc   STATUS, C
                incf    Num + 1, f
                bsf     NegSw                     ; negatv szm
Plus
endif

if ZeroChar != '0'
                bcf     ZeroSw
endif

; ha eljeles s kezdnullk is vannak, akkor eljel kirsa
if NegChar == '-' & ZeroChar == '0'
                movlw   NegChar                   ; negatv szmnl ezt
                btfss   NegSw
                movlw   ' '                       ; pozitv szmnl ezt
                rcall   WriteProc
endif

; tzezresek
if he >= 5
                movlw   '0'
                movwf   WTemp
endif
l10000loop      movlw   LOW .10000
                subwf   Num, f
                movlw   HIGH .10000
                subwfb  Num + 1, f
                bnc     l10000end
if he >= 5
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n10000
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n10000
    endif
                bsf     ZeroSw
  endif
endif
                bra     l10000loop
                
l10000end       movlw   LOW .10000
                addwf   Num, f
                movlw   HIGH .10000
                addwfc  Num + 1, f

if he >= 5
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
  endif
endif

; ezresek
if he >= 4
                movlw   '0'
                movwf   WTemp
endif
l1000loop       movlw   LOW .1000
                subwf   Num, f
                movlw   HIGH .1000
                subwfb  Num + 1, f
                bnc     l1000end
if he >= 4
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n1000
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n1000
    endif
                bsf     ZeroSw
  endif
endif
                bra     l1000loop
                
l1000end        movlw   LOW .1000
                addwf   Num, f
                movlw   HIGH .1000
                addwfc  Num + 1, f

if he >= 4
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
  endif
endif

; szzasok
if he >= 3
                movlw   '0'
                movwf   WTemp
endif
l100loop        movlw   LOW .100
                subwf   Num, f
                movlw   HIGH .100
                subwfb  Num + 1, f
                bnc     l100end
if he >= 3
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n100
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n100
    endif
                bsf     ZeroSw
  endif
endif
                bra     l100loop
                
l100end         movlw   LOW .100
                addwf   Num, f
                movlw   HIGH .100
                addwfc  Num + 1, f

if he >= 3
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
  endif
endif

; tizesek
if he >= 2
                movlw   '0'
                movwf   WTemp
endif
l10loop         movlw   .10
                subwf   Num, f
                bnc     l10end
if he >= 2
                incf    WTemp, f
  if ZeroChar != '0'
    if NegChar == '-'
                btfsc   ZeroSw
                bra     n10
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
    n10
    endif
                bsf     ZeroSw
  endif
endif
                bra     l10loop
                
l10end          movlw   .10
                addwf   Num, f

if he >= 1
  if ZeroChar != '0'
                movf    WTemp, W
                btfss   ZeroSw
                movlw   ZeroChar
                rcall   WriteProc
  else
                movf    WTemp, W
                rcall   WriteProc
endif
endif

if NegChar == '-'
                btfsc   ZeroSw
                bra     n1
                movlw   ' '
                btfsc   NegSw
                movlw   NegChar
                rcall   WriteProc
n1
endif
                movlw   '0'
                addwf   Num, W
                rcall   WriteProc
endm
